/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.data;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.hadoop.io.Text;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.expression.Expression;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam;
import org.locationtech.geomesa.accumulo.tools.data.AccumuloCompactCommand$;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.index.id.IdIndex$;
import org.locationtech.geomesa.index.index.z3.Z3Index$;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.locationtech.geomesa.utils.uuid.Z3UuidGenerator$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001\u0002\u0011\"\u00019BQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013\u0005\u0003\t\u0003\u0004E\u0001\u0001\u0006I!\u0011\u0005\b\u000b\u0002\u0011\r\u0011\"\u0011G\u0011\u001d\u0011)\u0001\u0001Q\u0001\n\u001dCqAa\u0002\u0001\t\u0003\nYpB\u0003YC!\u0005\u0011LB\u0003!C!\u0005!\fC\u0003<\u0011\u0011\u0005\u0011M\u0002\u0003c\u0011\u0001\u0019\u0007\"B\u001e\u000b\t\u0003a\u0007bB8\u000b\u0001\u0004%\t\u0001\u001d\u0005\bi*\u0001\r\u0011\"\u0001v\u0011\u0019Y(\u0002)Q\u0005c\"Y\u0011Q\u0004\u0006A\u0002\u0003\u0007I\u0011AA\u0010\u0011-\t\tD\u0003a\u0001\u0002\u0004%\t!a\r\t\u0017\u0005]\"\u00021A\u0001B\u0003&\u0011\u0011\u0005\u0005\f\u0003OQ\u0001\u0019!a\u0001\n\u0003\ty\u0002C\u0006\u0002d)\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0004bCA5\u0015\u0001\u0007\t\u0011)Q\u0005\u0003CA\u0011\"a\u001e\u000b\u0001\u0004%\t!!\u001f\t\u0013\u0005\u0005%\u00021A\u0005\u0002\u0005\r\u0005\u0002CAD\u0015\u0001\u0006K!a\u001f\u0007\r\u0005\r\u0006\u0002AAS\u0011)\ti\u000b\u0007B\u0001B\u0003%\u0011q\u0016\u0005\u000b\u0003\u0013D\"\u0011!Q\u0001\n\u0005-\u0007BCAm1\t\u0005\t\u0015!\u0003\u0002\\\"Q\u00111\u001e\r\u0003\u0002\u0003\u0006I!a7\t\rmBB\u0011AAw\u0011\u001d\tI\u0010\u0007C!\u0003wDq!!@\t\t\u0013\tyP\u0001\fBG\u000e,X.\u001e7p\u0007>l\u0007/Y2u\u0007>lW.\u00198e\u0015\t\u00113%\u0001\u0003eCR\f'B\u0001\u0013&\u0003\u0015!xn\u001c7t\u0015\t1s%\u0001\u0005bG\u000e,X.\u001e7p\u0015\tA\u0013&A\u0004hK>lWm]1\u000b\u0005)Z\u0013\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001ys\u0007\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005!A.\u00198h\u0015\u0005!\u0014\u0001\u00026bm\u0006L!AN\u0019\u0003\r=\u0013'.Z2u!\tA\u0014(D\u0001$\u0013\tQ4E\u0001\rBG\u000e,X.\u001e7p\t\u0006$\u0018m\u0015;pe\u0016\u001cu.\\7b]\u0012\fa\u0001P5oSRtD#A\u001f\u0011\u0005y\u0002Q\"A\u0011\u0002\t9\fW.Z\u000b\u0002\u0003B\u0011\u0001GQ\u0005\u0003\u0007F\u0012aa\u0015;sS:<\u0017!\u00028b[\u0016\u0004\u0013A\u00029be\u0006l7/F\u0001H!\tA%B\u0004\u0002J\u000f9\u0011!j\u0016\b\u0003\u0017Zs!\u0001T+\u000f\u00055#fB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\tV&\u0001\u0004=e>|GOP\u0005\u0002Y%\u0011!fK\u0005\u0003Q%J!AJ\u0014\n\u0005\u0011*\u0013B\u0001\u0012$\u0003Y\t5mY;nk2|7i\\7qC\u000e$8i\\7nC:$\u0007C\u0001 \t'\tA1\f\u0005\u0002]?6\tQLC\u0001_\u0003\u0015\u00198-\u00197b\u0013\t\u0001WL\u0001\u0004B]f\u0014VM\u001a\u000b\u00023\ni1i\\7qC\u000e$\b+\u0019:b[N\u001cBAC.eSB\u0011QmZ\u0007\u0002M*\u0011AeJ\u0005\u0003Q\u001a\u0014QCU3rk&\u0014X\r\u001a+za\u0016t\u0015-\\3QCJ\fW\u000e\u0005\u00029U&\u00111n\t\u0002\u0018\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,\u0007+\u0019:b[N$\u0012!\u001c\t\u0003]*i\u0011\u0001C\u0001\bi\"\u0014X-\u00193t+\u0005\t\bC\u0001\u0019s\u0013\t\u0019\u0018GA\u0004J]R,w-\u001a:\u0002\u0017QD'/Z1eg~#S-\u001d\u000b\u0003mf\u0004\"\u0001X<\n\u0005al&\u0001B+oSRDqA_\u0007\u0002\u0002\u0003\u0007\u0011/A\u0002yIE\n\u0001\u0002\u001e5sK\u0006$7\u000f\t\u0015\u000b\u001du\fy!!\u0005\u0002\u0018\u0005e\u0001c\u0001@\u0002\f5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011A\u00036d_6l\u0017M\u001c3fe*!\u0011QAA\u0004\u0003\u0015\u0011W-^:u\u0015\t\tI!A\u0002d_6L1!!\u0004\u0000\u0005%\u0001\u0016M]1nKR,'/A\u0003oC6,7\u000f\f\u0002\u0002\u0014\u0005\u0012\u0011QC\u0001\n[5\"\bN]3bIN\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\u0012\u00111D\u0001+\u001dVl'-\u001a:!_\u001a\u0004#/\u00198hKN\u0004Co\u001c\u0011d_6\u0004\u0018m\u0019;!g&lW\u000f\u001c;b]\u0016|Wo\u001d7z\u0003\u00111'o\\7\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\tIV\u0014\u0018\r^5p]*\u0019\u00111F/\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u00020\u0005\u0015\"\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u0011\u0019\u0014x.\\0%KF$2A^A\u001b\u0011!Q\b#!AA\u0002\u0005\u0005\u0012!\u00024s_6\u0004\u0003FD\t~\u0003\u001f\tY$a\u0006\u0002B\u0005\u0015\u0013q\t\u0017\u0003\u0003{\t#!a\u0010\u0002\r5jcM]8nC\t\t\u0019%AA\u0005\u0011><\b\u0005\\8oO\u0002\nwm\u001c\u0011u_\u0002\u001aw.\u001c9bGR\u0004C-\u0019;bY\u0001\u0012\u0017m]3eA=t\u0007\u0005\u001e5fA\u0011,g-Y;mi\u0002\"\u0017\r^3!CR$(/\u001b2vi\u0016d\u0003E]3mCRLg/\u001a\u0011u_\u0002\u001aWO\u001d:f]R\u0004C/[7f]\u0001*ef\u001a\u0018!OE\u0002C-Y=(Y\u0001:#\u0007I<fK.\u001c\b%\u00198eAE\u0002\u0003n\\;sO1\u0002S\r^2\u0002\u0013\r|gN^3si\u0016\u00148EAA%!\u0011\tY%!\u0018\u000f\t\u00055\u0013q\u000b\b\u0005\u0003\u001f\n\u0019FD\u0002M\u0003#J!\u0001J\u0014\n\u0007\u0005Uc-A\u0003vi&d7/\u0003\u0003\u0002Z\u0005m\u0013a\u0005)be\u0006lW\r^3s\u0007>tg/\u001a:uKJ\u001c(bAA+M&!\u0011qLA1\u0005E!UO]1uS>t7i\u001c8wKJ$XM\u001d\u0006\u0005\u00033\nY&\u0001\u0007ekJ\fG/[8o?\u0012*\u0017\u000fF\u0002w\u0003OB\u0001B_\n\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\nIV\u0014\u0018\r^5p]\u0002Bc\u0002F?\u0002\u0010\u00055\u0014qCA:\u0003\u000b\n9\u0005\f\u0002\u0002p\u0005\u0012\u0011\u0011O\u0001\u000b[5\"WO]1uS>t\u0017EAA;\u0003\u0005\u0015\u0011)\\8v]R\u0004sN\u001a\u0011uS6,\u0007\u0005^8!G>l\u0007/Y2uA\u0011\fG/\u0019\u0017!E\u0006\u001cX\r\u001a\u0011p]\u0002\"\b.\u001a\u0011eK\u001a\fW\u000f\u001c;!I\u0006$X\rI1uiJL'-\u001e;fY\u0001\u0012X\r\\1uSZ,\u0007\u0005^8!O5jcM]8nO9\u0002SIL4/A\u001d\n\u0004\u0005Z1zO1\u0002sE\r\u0011xK\u0016\\7\u000fI1oI\u0002\n\u0004\u0005[8ve\u001eb\u0003%\u001a;d\u0003\u0015Q8'\u00133t+\t\tY\bE\u0002]\u0003{J1!a ^\u0005\u001d\u0011un\u001c7fC:\f\u0011B_\u001aJIN|F%Z9\u0015\u0007Y\f)\t\u0003\u0005{-\u0005\u0005\t\u0019AA>\u0003\u0019Q8'\u00133tA!Rq#`A\b\u0003\u0017\u000b9\"!%-\u0005\u00055\u0015EAAH\u0003AiSF_\u001a.M\u0016\fG/\u001e:f[%$7/\t\u0002\u0002\u0014\u0006\t\taV5mY\u0002zg\u000e\\=!G>l\u0007/Y2uA%#\u0005E]3d_J$7\u000f\t;iCR\u00043m\u001c:sKN\u0004xN\u001c3!o&$\b\u000e\t;iK\u0002\"\u0018.\\3!a\u0016\u0014\u0018n\u001c3-A\t\f7/\u001a3!_:\u0004c-Z1ukJ,7\u000f\t2fS:<\u0007e\u001e:jiR,g\u000eI<ji\"\u0004C\u000f[3!5N2U-\u0019;ve\u0016LEmR3oKJ\fGo\u001c:)\u000f)\t9*!(\u0002 B\u0019a0!'\n\u0007\u0005muP\u0001\u0006QCJ\fW.\u001a;feN\f!cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0006\u0012\u0011\u0011U\u00018\u0013:\u001c'/Z7f]R\fG\u000e\\=!G>l\u0007/Y2uAQ\f'\r\\3tA\u0019|'\u000fI1!\u000f\u0016|W*Z:bA\u0019,\u0017\r^;sK\u0002\"\u0018\u0010]3\u0003\u001fI\u000bgnZ3D_6\u0004\u0018m\u0019;j_:\u001cB\u0001G\u0018\u0002(B\u0019\u0001'!+\n\u0007\u0005-\u0016G\u0001\u0005Sk:t\u0017M\u00197f\u0003\ry\u0007o\u001d\t\u0005\u0003c\u000b)-\u0004\u0002\u00024*!\u0011QWA\\\u0003\u0015\tG-\\5o\u0015\u0011\tI,a/\u0002\r\rd\u0017.\u001a8u\u0015\u0011\ti,a0\u0002\t\r|'/\u001a\u0006\u0004M\u0005\u0005'bAAbW\u00051\u0011\r]1dQ\u0016LA!a2\u00024\nyA+\u00192mK>\u0003XM]1uS>t7/A\u0003uC\ndW\r\u0005\u0003\u0002N\u0006Ug\u0002BAh\u0003#\u0004\"aT/\n\u0007\u0005MW,\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0007\u0006]'bAAj;\u0006)1\u000f^1siB!\u0011Q\\At\u001b\t\tyN\u0003\u0003\u0002b\u0006\r\u0018AA5p\u0015\u0011\t)/!1\u0002\r!\fGm\\8q\u0013\u0011\tI/a8\u0003\tQ+\u0007\u0010^\u0001\u0004K:$GCCAx\u0003c\f\u00190!>\u0002xB\u0011a\u000e\u0007\u0005\b\u0003[k\u0002\u0019AAX\u0011\u001d\tI-\ba\u0001\u0003\u0017Dq!!7\u001e\u0001\u0004\tY\u000eC\u0004\u0002lv\u0001\r!a7\u0002\u0007I,h\u000eF\u0001w\u0003-\u0011xn\u001e+p'R\u0014\u0018N\\4\u0015\t\u0005-'\u0011\u0001\u0005\b\u0005\u0007y\u0002\u0019AAn\u0003\r\u0011xn^\u0001\ba\u0006\u0014\u0018-\\:!\u0003\u001d)\u00070Z2vi\u0016\u0004")
public class AccumuloCompactCommand
implements AccumuloDataStoreCommand {
    private final String name;
    private final CompactParams params;

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand.connection$(this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    @Override
    public CompactParams params() {
        return this.params;
    }

    public void execute() {
        this.withDataStore((Function1 & Serializable)ds -> {
            AccumuloCompactCommand.$anonfun$execute$1(this, ds);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$execute$3(long start$1, Duration d) {
        return start$1 + d.toMillis();
    }

    private static final String toString$1(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC).toString();
    }

    private static final boolean compareStart$1(Text s, int offset$1, short max$1) {
        return s == null || s.getLength() < offset$1 + 2 || ByteArrays$.MODULE$.readShort(s.getBytes(), offset$1) <= max$1;
    }

    private static final boolean compareEnd$1(Text e, int offset$1, short min$1) {
        return e == null || e.getLength() < offset$1 + 2 || ByteArrays$.MODULE$.readShort(e.getBytes(), offset$1) >= min$1;
    }

    public static final /* synthetic */ boolean $anonfun$execute$9(int offset$1, short max$1, short min$1, Seq x0$1) {
        SeqOps seqOps;
        Seq seq = x0$1;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Text s = (Text)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Text e = (Text)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            return AccumuloCompactCommand.compareStart$1(s, offset$1, max$1) && AccumuloCompactCommand.compareEnd$1(e, offset$1, min$1);
        }
        throw new MatchError((Object)seq);
    }

    private static final boolean compareStart$2(Text s, int offset$2, short max$2) {
        return s == null || s.getLength() < offset$2 + 3 || Z3UuidGenerator$.MODULE$.timeBin(s.getBytes(), offset$2) <= max$2;
    }

    private static final boolean compareEnd$2(Text e, int offset$2, short min$2) {
        return e == null || e.getLength() < offset$2 + 3 || Z3UuidGenerator$.MODULE$.timeBin(e.getBytes(), offset$2) >= min$2;
    }

    public static final /* synthetic */ boolean $anonfun$execute$11(int offset$2, short max$2, short min$2, Seq x0$2) {
        SeqOps seqOps;
        Seq seq = x0$2;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Text s = (Text)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Text e = (Text)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            return AccumuloCompactCommand.compareStart$2(s, offset$2, max$2) && AccumuloCompactCommand.compareEnd$2(e, offset$2, min$2);
        }
        throw new MatchError((Object)seq);
    }

    private static final boolean compareStart$3(Text s, int offset$2, short max$2) {
        boolean bl;
        if (s == null) {
            return true;
        }
        try {
            String uuidString = new String(s.getBytes(), offset$2, s.getLength() - offset$2, StandardCharsets.UTF_8);
            UUID uuid = UUID.fromString(uuidString);
            bl = Z3UuidGenerator$.MODULE$.timeBin(ByteArrays$.MODULE$.toBytes(uuid.getMostSignificantBits()), Z3UuidGenerator$.MODULE$.timeBin$default$2()) <= max$2;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                bl = true;
            }
            throw throwable;
        }
        return bl;
    }

    private static final boolean compareEnd$3(Text e, int offset$2, short min$2) {
        boolean bl;
        if (e == null) {
            return true;
        }
        try {
            String uuidString = new String(e.getBytes(), offset$2, e.getLength() - offset$2, StandardCharsets.UTF_8);
            UUID uuid = UUID.fromString(uuidString);
            bl = Z3UuidGenerator$.MODULE$.timeBin(ByteArrays$.MODULE$.toBytes(uuid.getMostSignificantBits()), Z3UuidGenerator$.MODULE$.timeBin$default$2()) >= min$2;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                bl = true;
            }
            throw throwable;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$execute$13(int offset$2, short max$2, short min$2, Seq x0$3) {
        SeqOps seqOps;
        Seq seq = x0$3;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Text s = (Text)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Text e = (Text)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            return AccumuloCompactCommand.compareStart$3(s, offset$2, max$2) && AccumuloCompactCommand.compareEnd$3(e, offset$2, min$2);
        }
        throw new MatchError((Object)seq);
    }

    private final Function1 filterSplits$1(GeoMesaFeatureIndex index, Option z3Bins$1, SimpleFeatureType sft$1) {
        Tuple2 tuple2;
        boolean bl = false;
        Some some = null;
        Option option = z3Bins$1;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Tuple2 tuple22 = (Tuple2)some.value();
            if (tuple22 != null) {
                short min = BoxesRunTime.unboxToShort((Object)tuple22._1());
                short max = BoxesRunTime.unboxToShort((Object)tuple22._2());
                String string = index.name();
                String string2 = Z3Index$.MODULE$.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    int offset = index.keySpace().sharding().length() + index.keySpace().sharing().length;
                    return (Function1 & Serializable)iter -> iter.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AccumuloCompactCommand.$anonfun$execute$9(offset, max, min, x0$1)));
                }
            }
        }
        if (bl && (tuple2 = (Tuple2)some.value()) != null) {
            short min = BoxesRunTime.unboxToShort((Object)tuple2._1());
            short max = BoxesRunTime.unboxToShort((Object)tuple2._2());
            if (this.params().z3Ids()) {
                String string = index.name();
                String string3 = IdIndex$.MODULE$.name();
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    int offset;
                    int n = offset = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1)) ? 1 : 0;
                    if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isUuidEncoded$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1))) {
                        return (Function1 & Serializable)iter -> iter.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AccumuloCompactCommand.$anonfun$execute$11(offset, max, min, x0$2)));
                    }
                    return (Function1 & Serializable)iter -> iter.filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)AccumuloCompactCommand.$anonfun$execute$13(offset, max, min, x0$3)));
                }
            }
        }
        return (Function1 & Serializable)iter -> iter;
    }

    public static final /* synthetic */ boolean $anonfun$execute$19(byte prefix$1, Seq x0$3) {
        SeqOps seqOps;
        Seq seq = x0$3;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Text s = (Text)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Text e = (Text)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            return !(s != null && ByteArrays$.MODULE$.UnsignedByteOrdering().compare((Object)BoxesRunTime.boxToByte((byte)s.getBytes()[0]), (Object)BoxesRunTime.boxToByte((byte)prefix$1)) > 0 || e != null && ByteArrays$.MODULE$.UnsignedByteOrdering().compare((Object)BoxesRunTime.boxToByte((byte)e.getBytes()[0]), (Object)BoxesRunTime.boxToByte((byte)prefix$1)) < 0);
        }
        throw new MatchError((Object)seq);
    }

    public static final /* synthetic */ void $anonfun$execute$22(ExecutorService executor$1, TableOperations ops$1, String table$1, IntRef count$1, Seq x0$4) {
        SeqOps seqOps;
        Seq seq = x0$4;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Text s = (Text)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Text e = (Text)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            executor$1.submit(new RangeCompaction(ops$1, table$1, s, e));
            ++count$1.elem;
            return;
        }
        throw new MatchError((Object)seq);
    }

    public static final /* synthetic */ void $anonfun$execute$16(TableOperations ops$1, ExecutorService executor$1, SimpleFeatureType sft$1, Function1 filtering$1, String table) {
        BoxedUnit boxedUnit;
        List tableSplits = ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ops$1.listSplits(table)).asScala()).toList();
        IntRef count = IntRef.create((int)0);
        if (tableSplits.isEmpty()) {
            executor$1.submit(new RangeCompaction(ops$1, table, null, null));
            ++count.elem;
        } else {
            Iterator iterator;
            Iterator middle;
            Iterator head = package$.MODULE$.Iterator().single((Object)new .colon.colon(null, (List)new .colon.colon((Object)((Text)tableSplits.head()), (List)Nil$.MODULE$)));
            Iterator last = package$.MODULE$.Iterator().single((Object)new .colon.colon((Object)((Text)tableSplits.last()), (List)new .colon.colon(null, (List)Nil$.MODULE$)));
            Iterator iterator2 = middle = tableSplits.lengthCompare(1) == 0 ? package$.MODULE$.Iterator().empty() : tableSplits.sliding(2);
            if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1))) {
                Object object;
                byte[] byArray = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1));
                if (byArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)byArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) != 0) {
                    throw new MatchError((Object)byArray);
                }
                byte prefix = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                byte prefix2 = prefix;
                iterator = head.$plus$plus((Function0 & Serializable)() -> middle).$plus$plus((Function0 & Serializable)() -> last).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)AccumuloCompactCommand.$anonfun$execute$19(prefix2, x0$3)));
            } else {
                iterator = head.$plus$plus((Function0 & Serializable)() -> middle).$plus$plus((Function0 & Serializable)() -> last);
            }
            Iterator splits = iterator;
            ((IterableOnceOps)filtering$1.apply((Object)splits)).foreach((Function1 & Serializable)x0$4 -> {
                AccumuloCompactCommand.$anonfun$execute$22(executor$1, ops$1, table, count, x0$4);
                return BoxedUnit.UNIT;
            });
        }
        if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.user().underlying().info("Found {} splits for table {}", new Object[]{BoxesRunTime.boxToInteger((int)count.elem), table});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$execute$15(AccumuloCompactCommand $this, Option filter$1, TableOperations ops$1, ExecutorService executor$1, SimpleFeatureType sft$1, Option z3Bins$1, GeoMesaFeatureIndex index) {
        Function1 filtering = $this.filterSplits$1(index, z3Bins$1, sft$1);
        index.getTablesForQuery(filter$1).foreach((Function1 & Serializable)table -> {
            AccumuloCompactCommand.$anonfun$execute$16(ops$1, executor$1, sft$1, filtering, table);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$execute$1(AccumuloCompactCommand $this, AccumuloDataStore ds) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        SimpleFeatureType sft = ds.getSchema($this.params().featureName());
        if (sft == null) {
            throw new ParameterException(new java.lang.StringBuilder(42).append("Schema '").append($this.params().featureName()).append("' does not exist in the data store").toString());
        }
        long start = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(Predef$.MODULE$.Integer2int($this.params().threads()));
        TableOperations ops = ds.connector().tableOperations();
        StringBuilder msg = new StringBuilder(new java.lang.StringBuilder(59).append("Starting incremental compaction using ").append($this.params().threads()).append(" simultaneous threads").toString());
        Option interval = Option$.MODULE$.apply((Object)$this.params().from()).map((Function1 & Serializable)from -> {
            long now = System.currentTimeMillis();
            long start = now - from.toMillis();
            long end = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)$this.params().duration()).map((Function1 & Serializable)d -> BoxesRunTime.boxToLong((long)AccumuloCompactCommand.$anonfun$execute$3(start, d))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now));
            msg.append(new java.lang.StringBuilder(7).append(" from ").append(AccumuloCompactCommand.toString$1(start)).append("/").append(AccumuloCompactCommand.toString$1(end)).toString());
            return new Tuple2.mcJJ.sp(start, end);
        });
        Option z3Bins = interval.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long s = tuple2._1$mcJ$sp();
                long e = tuple2._2$mcJ$sp();
                Function1 toBin = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
                return new Tuple2((Object)BoxesRunTime.boxToShort((short)((BinnedTime)toBin.apply((Object)BoxesRunTime.boxToLong((long)s))).bin()), (Object)BoxesRunTime.boxToShort((short)((BinnedTime)toBin.apply((Object)BoxesRunTime.boxToLong((long)e))).bin()));
            }
            throw new MatchError((Object)tuple2);
        });
        Option filter = interval.flatMap((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                long s = tuple2._1$mcJ$sp();
                long e = tuple2._2$mcJ$sp();
                return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).map((Function1 & Serializable)dtg -> org.locationtech.geomesa.filter.package$.MODULE$.ff().between((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().property(dtg), (Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().literal((Object)new Date(s)), (Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().literal((Object)new Date(e))));
            }
            throw new MatchError((Object)tuple2);
        });
        if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.user().underlying().info(msg.toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ds.manager().indices(sft, ds.manager().indices$default$2()).foreach((Function1 & Serializable)index -> {
            AccumuloCompactCommand.$anonfun$execute$15($this, filter, ops, executor, sft, z3Bins, index);
            return BoxedUnit.UNIT;
        });
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.user().underlying().info("Compactions complete in {}", (Object)TextTools$.MODULE$.getTime(start));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public AccumuloCompactCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        AccumuloDataStoreCommand.$init$(this);
        this.name = "compact";
        this.params = new CompactParams();
    }

    @Parameters(commandDescription="Incrementally compact tables for a GeoMesa feature type")
    public static class CompactParams
    implements RequiredTypeNameParam,
    AccumuloDataStoreParams {
        @Parameter(names={"--threads"}, description="Number of ranges to compact simultaneously")
        private Integer threads;
        @Parameter(names={"--from"}, description="How long ago to compact data, based on the default date attribute, relative to current time. E.g. '1 day', '2 weeks and 1 hour', etc", converter=ParameterConverters.DurationConverter.class)
        private Duration from;
        @Parameter(names={"--duration"}, description="Amount of time to compact data, based on the default date attribute, relative to '--from'. E.g. '1 day', '2 weeks and 1 hour', etc", converter=ParameterConverters.DurationConverter.class)
        private Duration duration;
        @Parameter(names={"--z3-feature-ids"}, description="Will only compact ID records that correspond with the time period, based on features being written with the Z3FeatureIdGenerator")
        private boolean z3Ids;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public Duration from() {
            return this.from;
        }

        public void from_$eq(Duration x$1) {
            this.from = x$1;
        }

        public Duration duration() {
            return this.duration;
        }

        public void duration_$eq(Duration x$1) {
            this.duration = x$1;
        }

        public boolean z3Ids() {
            return this.z3Ids;
        }

        public void z3Ids_$eq(boolean x$1) {
            this.z3Ids = x$1;
        }

        public CompactParams() {
            RequiredTypeNameParam.$init$((RequiredTypeNameParam)this);
            ZookeepersParam.$init$(this);
            InstanceNameParams.$init$(this);
            PasswordParams.$init$((PasswordParams)this);
            CredentialsParams.$init$((CredentialsParams)this);
            KerberosParams.$init$((KerberosParams)this);
            AccumuloConnectionParams.$init$(this);
            CatalogParam.$init$((CatalogParam)this);
            this.threads = BoxesRunTime.boxToInteger((int)4);
            this.z3Ids = false;
        }
    }

    public static class RangeCompaction
    implements Runnable {
        private final TableOperations ops;
        private final String table;
        private final Text start;
        private final Text end;

        @Override
        public void run() {
            BoxedUnit boxedUnit;
            if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                package.Command$.MODULE$.user().underlying().info("Starting compaction of {} [ {} :: {} ]", new Object[]{this.table, AccumuloCompactCommand$.MODULE$.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$rowToString(this.start), AccumuloCompactCommand$.MODULE$.org$locationtech$geomesa$accumulo$tools$data$AccumuloCompactCommand$$rowToString(this.end)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.ops.compact(this.table, this.start, this.end, false, true);
        }

        public RangeCompaction(TableOperations ops, String table, Text start, Text end) {
            this.ops = ops;
            this.table = table;
            this.start = start;
            this.end = end;
        }
    }
}

