/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.stats;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.geotools.api.data.DataStore;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.accumulo.audit.AccumuloAuditReader;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam;
import org.locationtech.geomesa.accumulo.tools.stats.AccumuloQueryAuditCommand$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.audit.AuditWriter$;
import org.locationtech.geomesa.index.audit.AuditedEvent;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.text.DateParsing$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t%g\u0001\u0002\u001a4\u0001\u0001CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001C\u0002\u0013\u0005#\u000b\u0003\u0004W\u0001\u0001\u0006Ia\u0015\u0005\b/\u0002\u0011\r\u0011\"\u0011Y\u0011\u001d\u0011y\u000b\u0001Q\u0001\neCqA!-\u0001\t\u0003\u0012\u0019\fC\u0004\u00036\u0002!IAa.\b\u000b)\u001c\u0004\u0012A6\u0007\u000bI\u001a\u0004\u0012\u00017\t\u000b5KA\u0011A:\t\u000fQL!\u0019!C\u0007k\"1\u00110\u0003Q\u0001\u000eYDqA_\u0005C\u0002\u0013%!\u000b\u0003\u0004|\u0013\u0001\u0006Ia\u0015\u0005\by&\u0011\r\u0011\"\u0003~\u0011\u001d\t)\"\u0003Q\u0001\nyDq!a\u0006\n\t\u0013\tIB\u0002\u0004\u0002D%\u0001\u0011Q\t\u0005\u0007\u001bJ!\t!a\u0016\t\u0017\u0005u#\u00031AA\u0002\u0013\u0005\u0011q\f\u0005\f\u0003[\u0012\u0002\u0019!a\u0001\n\u0003\ty\u0007C\u0006\u0002|I\u0001\r\u0011!Q!\n\u0005\u0005\u0004bCAb%\u0001\u0007\t\u0019!C\u0001\u0003?B1\"!2\u0013\u0001\u0004\u0005\r\u0011\"\u0001\u0002H\"Y\u00111\u001a\nA\u0002\u0003\u0005\u000b\u0015BA1\u0011%\tiN\u0005a\u0001\n\u0003\ty\u000eC\u0005\u0002pJ\u0001\r\u0011\"\u0001\u0002r\"A\u0011Q\u001f\n!B\u0013\t\t\u000fC\u0006\u0003\"I\u0001\r\u00111A\u0005\u0002\t\r\u0002b\u0003B\u0019%\u0001\u0007\t\u0019!C\u0001\u0005gA1Ba\u000e\u0013\u0001\u0004\u0005\t\u0015)\u0003\u0003&\u00191!1B\u0005\u0001\u0005\u001bAa!\u0014\u0011\u0005\u0002\tU\u0001b\u0002B\fA\u0011\u0005#\u0011\u0004\u0004\n\u00057J\u0001\u0013aI\u0005\u0005;BqAa\u0018$\r\u0003\u0011\t\u0007C\u0004\u0003j\r2\tAa\u001b\u0007\r\t=\u0014\u0002\u0002B9\u0011\u0019ie\u0005\"\u0001\u0003v!I!\u0011\u0010\u0014C\u0002\u0013%!1\u0010\u0005\t\u0005\u00073\u0003\u0015!\u0003\u0003~!I!Q\u0011\u0014C\u0002\u0013%!q\u0011\u0005\t\u0005;3\u0003\u0015!\u0003\u0003\n\"9!q\f\u0014\u0005B\t\u0005\u0004b\u0002B5M\u0011\u0005#q\u0014\u0004\u0007\u0005GKAA!*\t\r5sC\u0011\u0001BT\u0011\u001d\u0011yF\fC!\u0005CBqA!\u001b/\t\u0003\u0012YKA\rBG\u000e,X.\u001e7p#V,'/_!vI&$8i\\7nC:$'B\u0001\u001b6\u0003\u0015\u0019H/\u0019;t\u0015\t1t'A\u0003u_>d7O\u0003\u00029s\u0005A\u0011mY2v[VdwN\u0003\u0002;w\u00059q-Z8nKN\f'B\u0001\u001f>\u00031awnY1uS>tG/Z2i\u0015\u0005q\u0014aA8sO\u000e\u00011c\u0001\u0001B\u0013B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005Y\u0006twMC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%AB(cU\u0016\u001cG\u000f\u0005\u0002K\u00176\tQ'\u0003\u0002Mk\tA\u0012iY2v[Vdw\u000eR1uCN#xN]3D_6l\u0017M\u001c3\u0002\rqJg.\u001b;?)\u0005y\u0005C\u0001)\u0001\u001b\u0005\u0019\u0014\u0001\u00028b[\u0016,\u0012a\u0015\t\u0003\u0005RK!!V\"\u0003\rM#(/\u001b8h\u0003\u0015q\u0017-\\3!\u0003\u0019\u0001\u0018M]1ngV\t\u0011\f\u0005\u0002[%9\u00111\f\u0003\b\u00039&t!!\u00185\u000f\u0005y;gBA0g\u001d\t\u0001WM\u0004\u0002bI6\t!M\u0003\u0002d\u007f\u00051AH]8pizJ\u0011AP\u0005\u0003yuJ!AO\u001e\n\u0005aJ\u0014B\u0001\u001c8\u0013\t!T'A\rBG\u000e,X.\u001e7p#V,'/_!vI&$8i\\7nC:$\u0007C\u0001)\n'\tIQ\u000e\u0005\u0002oc6\tqNC\u0001q\u0003\u0015\u00198-\u00197b\u0013\t\u0011xN\u0001\u0004B]f\u0014VM\u001a\u000b\u0002W\u0006q1)\u001d7EKN\u001c'/\u001b9uS>tW#\u0001<\u0010\u0003]\f\u0013\u0001_\u0001\u0002\u0002\u000e\u000bF\n\t9sK\u0012L7-\u0019;fAQ|\u0007EZ5mi\u0016\u0014\b\u0005\\8hA\u0015tGO]5fg:\u00023k\u00195f[\u0006\u0004\u0013n\u001d\u001e!kN,'OO*ue&tw\r\f4jYR,'OO*ue&tw\r\f5j]R\u001c(h\u0015;sS:<'H[:p]v\"(/^3-[\u0016$\u0018\rZ1uCj\u001aFO]5oOjR7o\u001c8>iJ,X\rL:uCJ$(\bR1uK2*g\u000e\u001a\u001eECR,G\u0006\u001d7b]RKW.Z'jY2L7O\u000f'p]\u001ed3oY1o)&lW-T5mY&\u001c(\bT8oO2B\u0017\u000e^:;\u0019>tw-A\bDc2$Um]2sSB$\u0018n\u001c8!\u0003\u0011\u0019\u0006/Z2\u0002\u000bM\u0003Xm\u0019\u0011\u0002\u0007M3G/F\u0001\u007f!\ry\u0018\u0011C\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u000511/[7qY\u0016TA!a\u0002\u0002\n\u00059a-Z1ukJ,'\u0002BA\u0006\u0003\u001b\t1!\u00199j\u0015\r\ty!P\u0001\tO\u0016|Go\\8mg&!\u00111CA\u0001\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\u0005'\u001a$\b%A\u0005u_\u001a+\u0017\r^;sKR!\u00111DA\u0011!\ry\u0018QD\u0005\u0005\u0003?\t\tAA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\b\u0003G\t\u0002\u0019AA\u0013\u0003\u0015)g/\u001a8u!\u0011\t9#!\u0010\u000f\t\u0005%\u0012q\u0007\b\u0005\u0003W\t\tDD\u0002_\u0003[I1!a\f:\u0003\u0015Ig\u000eZ3y\u0013\u0011\t\u0019$!\u000e\u0002\u000b\u0005,H-\u001b;\u000b\u0007\u0005=\u0012(\u0003\u0003\u0002:\u0005m\u0012\u0001D!vI&$X\rZ#wK:$(\u0002BA\u001a\u0003kIA!a\u0010\u0002B\tQ\u0011+^3ss\u00163XM\u001c;\u000b\t\u0005e\u00121\b\u0002\u0019\u0003\u000e\u001cW/\\;m_F+XM]=Bk\u0012LG\u000fU1sC6\u001c8C\u0002\nn\u0003\u000f\ni\u0005E\u0002K\u0003\u0013J1!a\u00136\u0005]\t5mY;nk2|G)\u0019;b'R|'/\u001a)be\u0006l7\u000f\u0005\u0003\u0002P\u0005MSBAA)\u0015\t1\u0014(\u0003\u0003\u0002V\u0005E#!\u0006*fcVL'/\u001a3UsB,g*Y7f!\u0006\u0014\u0018-\u001c\u000b\u0003\u00033\u00022!a\u0017\u0013\u001b\u0005I\u0011!B:uCJ$XCAA1!\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$bAA4\u000b\u0006!Q\u000f^5m\u0013\u0011\tY'!\u001a\u0003\t\u0011\u000bG/Z\u0001\ngR\f'\u000f^0%KF$B!!\u001d\u0002xA\u0019a.a\u001d\n\u0007\u0005UtN\u0001\u0003V]&$\b\"CA=+\u0005\u0005\t\u0019AA1\u0003\rAH%M\u0001\u0007gR\f'\u000f\u001e\u0011)\u001fY\ty(a%\u0002\u0016\u0006}\u0015\u0011UAS\u0003O\u0003B!!!\u0002\u00106\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)\u0001\u0006kG>lW.\u00198eKJTA!!#\u0002\f\u0006)!-Z;ti*\u0011\u0011QR\u0001\u0004G>l\u0017\u0002BAI\u0003\u0007\u0013\u0011\u0002U1sC6,G/\u001a:\u0002\u000b9\fW.Z:-\t\u0005]\u00151T\u0011\u0003\u00033\u000b!!\f2\"\u0005\u0005u\u0015aB\u0017.E\u0016<\u0017N\\\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0002$\u0006\u0001Fj\\<fe\u0002\u0012w.\u001e8eA!Jgn\u00197vg&4X-\u000b\u0011p]\u0002\"\b.\u001a\u0011eCR,\u0007e\u001c4!Y><\u0007%\u001a8ue&,7\u000f\t;pAI,G/\u001e:oY\u0001Jg\u000eI%T\u001f\u0002Bd\u0007M\u0019!M>\u0014X.\u0019;\u0002\u0013\r|gN^3si\u0016\u00148EAAU!\u0011\tY+!0\u000f\t\u00055\u0016q\u0017\b\u0005\u0003_\u000b\u0019LD\u0002_\u0003cK!AN\u001d\n\t\u0005U\u0016\u0011K\u0001\u0006kRLGn]\u0005\u0005\u0003s\u000bY,A\nQCJ\fW.\u001a;fe\u000e{gN^3si\u0016\u00148O\u0003\u0003\u00026\u0006E\u0013\u0002BA`\u0003\u0003\u0014Q\u0002R1uK\u000e{gN^3si\u0016\u0014(\u0002BA]\u0003w\u000b1!\u001a8e\u0003\u001d)g\u000eZ0%KF$B!!\u001d\u0002J\"I\u0011\u0011\u0010\r\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\u0005K:$\u0007\u0005K\b\u001a\u0003\u007f\n\u0019*a4\u0002 \u0006e\u0017QUATY\u0011\t\t.!6\"\u0005\u0005M\u0017AA\u0017fC\t\t9.A\u0003.[\u0015tG-\t\u0002\u0002\\\u0006\u0001V\u000b\u001d9fe\u0002\u0012w.\u001e8eA!*\u0007p\u00197vg&4X-\u000b\u0011p]\u0002\"\b.\u001a\u0011eCR,\u0007e\u001c4!Y><\u0007%\u001a8ue&,7\u000f\t;pAI,G/\u001e:oY\u0001Jg\u000eI%T\u001f\u0002Bd\u0007M\u0019!M>\u0014X.\u0019;\u0002\u0019=,H\u000f];u\r>\u0014X.\u0019;\u0016\u0005\u0005\u0005\b\u0003BAr\u0003WtA!!:\u0002hB\u0011\u0011m\\\u0005\u0004\u0003S|\u0017A\u0002)sK\u0012,g-C\u0002V\u0003[T1!!;p\u0003AyW\u000f\u001e9vi\u001a{'/\\1u?\u0012*\u0017\u000f\u0006\u0003\u0002r\u0005M\b\"CA=7\u0005\u0005\t\u0019AAq\u00035yW\u000f\u001e9vi\u001a{'/\\1uA!zA$a \u0002\u0014\u0006e\u0018qTA\u0000\u0005\u0007\u0011)\u0001\f\u0002\u0002|\u0006\u0012\u0011Q`\u0001\u0010[5zW\u000f\u001e9vi62wN]7bi\u0006\u0012!\u0011A\u0001&\u001fV$\b/\u001e;!M>\u0014X.\u0019;-A\u0015LG\u000f[3sA\u001dR7o\u001c8(A=\u0014\beJ2tm\u001e\nAB^1mS\u0012\fG/Z,ji\"d#Aa\u0002$\u0005\t%\u0001cAA.A\t)r*\u001e;qkR4uN]7biZ\u000bG.\u001b3bi>\u00148\u0003\u0002\u0011B\u0005\u001f\u0001B!!!\u0003\u0012%!!1CAB\u0005MI\u0005+\u0019:b[\u0016$XM\u001d,bY&$\u0017\r^8s)\t\u0011I!\u0001\u0005wC2LG-\u0019;f)\u0019\t\tHa\u0007\u0003\u001e!1\u0011K\ta\u0001\u0003CDqAa\b#\u0001\u0004\t\t/A\u0003wC2,X-A\u0005dc24\u0015\u000e\u001c;feV\u0011!Q\u0005\t\u0005\u0005O\u0011i#\u0004\u0002\u0003*)!!1FA\u0005\u0003\u00191\u0017\u000e\u001c;fe&!!q\u0006B\u0015\u0005\u00191\u0015\u000e\u001c;fe\u0006i1-\u001d7GS2$XM]0%KF$B!!\u001d\u00036!I\u0011\u0011\u0010\u0010\u0002\u0002\u0003\u0007!QE\u0001\u000bGFdg)\u001b7uKJ\u0004\u0003FD\u0010\u0002\u0000\u0005M%1HAPo\u0006\u0015&Q\t\u0017\u0005\u0005{\u0011\t%\t\u0002\u0003@\u0005\u0011Q&]\u0011\u0003\u0005\u0007\nQ!L\u0017dc2\u001c#Aa\u0012\u0011\t\u0005-&\u0011J\u0005\u0005\u0005\u0017\n\tMA\bGS2$XM]\"p]Z,'\u000f^3sQ\u001d\u0011\"q\nB+\u0005/\u0002B!!!\u0003R%!!1KAB\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.\t\u0002\u0003Z\u0005\u00114+Z1sG\"\u0004\u0013/^3ss\u0002\nW\u000fZ5uA1|wm\u001d\u0011g_J\u0004\u0013\rI$f_6+7/\u0019\u0011gK\u0006$XO]3!if\u0004XM\u0001\u0007PkR\u0004X\u000f^,sSR,'o\u0005\u0002$[\u00061\u0001.Z1eKJ$\"Aa\u0019\u0011\u000b9\u0014)'!9\n\u0007\t\u001dtN\u0001\u0004PaRLwN\\\u0001\u0007_V$\b/\u001e;\u0015\t\u0005\u0005(Q\u000e\u0005\b\u0003G)\u0003\u0019AA\u0013\u0005%\u00195O^,sSR,'o\u0005\u0003'[\nM\u0004cAA.GQ\u0011!q\u000f\t\u0004\u000372\u0013aA8viV\u0011!Q\u0010\t\u0004\u0005\n}\u0014b\u0001BA\u0007\ni1\u000b\u001e:j]\u001e\u0014U/\u001b7eKJ\fAa\\;uA\u00059\u0001O]5oi\u0016\u0014XC\u0001BE!\u0011\u0011YI!'\u000e\u0005\t5%\u0002\u0002BH\u0005#\u000b1aY:w\u0015\u0011\u0011\u0019J!&\u0002\u000f\r|W.\\8og*\u0019!qS\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0011YJ!$\u0003\u0015\r\u001bf\u000b\u0015:j]R,'/\u0001\u0005qe&tG/\u001a:!)\u0011\t\tO!)\t\u000f\u0005\rR\u00061\u0001\u0002&\tQ!j]8o/JLG/\u001a:\u0014\t9j'1\u000f\u000b\u0003\u0005S\u00032!a\u0017/)\u0011\t\tO!,\t\u000f\u0005\r\u0012\u00071\u0001\u0002&\u00059\u0001/\u0019:b[N\u0004\u0013aB3yK\u000e,H/\u001a\u000b\u0003\u0003c\nA!\u001a=fGR!\u0011\u0011\u000fB]\u0011\u001d\u0011Yl\u0002a\u0001\u0005{\u000b!\u0001Z:\u0011\t\t}&QY\u0007\u0003\u0005\u0003T1Aa18\u0003\u0011!\u0017\r^1\n\t\t\u001d'\u0011\u0019\u0002\u0012\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,\u0007")
public class AccumuloQueryAuditCommand
implements AccumuloDataStoreCommand {
    private final String name;
    private final AccumuloQueryAuditParams params;

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand.connection$(this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    @Override
    public AccumuloQueryAuditParams params() {
        return this.params;
    }

    public void execute() {
        this.withDataStore((Function1 & Serializable)ds -> {
            this.exec(ds);
            return BoxedUnit.UNIT;
        });
    }

    private void exec(AccumuloDataStore ds) {
        .colon.colon colon2;
        FilterFactory x$2;
        if (ds.getSchema(this.params().featureName()) == null) {
            throw new ParameterException(new StringBuilder(53).append("SimpleFeatureType '").append(this.params().featureName()).append("' does not exist in the data store").toString());
        }
        Option cql = Option$.MODULE$.apply((Object)this.params().cqlFilter()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AccumuloQueryAuditCommand.$anonfun$exec$1(x$1)));
        Option startFilter = Option$.MODULE$.apply((Object)this.params().start()).map((Function1 & Serializable)d -> FilterHelper$.MODULE$.ff().greaterOrEqual((Expression)FilterHelper$.MODULE$.ff().property("end"), (Expression)FilterHelper$.MODULE$.ff().literal(d)));
        Option endFilter = Option$.MODULE$.apply((Object)this.params().end()).map((Function1 & Serializable)d -> FilterHelper$.MODULE$.ff().less((Expression)FilterHelper$.MODULE$.ff().property("end"), (Expression)FilterHelper$.MODULE$.ff().literal(d)));
        Seq x$12 = (Seq)((IterableOps)Option$.MODULE$.option2Iterable(cql).toSeq().$plus$plus((IterableOnce)startFilter)).$plus$plus((IterableOnce)endFilter);
        Option dateFilter = package$.MODULE$.andOption(x$12, x$2 = package$.MODULE$.andOption$default$2(x$12));
        Option intervals = dateFilter.map((Function1 & Serializable)f -> {
            FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(f, "end", FilterHelper$.MODULE$.extractIntervals$default$3(), FilterHelper$.MODULE$.extractIntervals$default$4());
            if (intervals.disjoint()) {
                throw new ParameterException(new StringBuilder(30).append("Invalid disjoint date filter: ").append(ECQL.toCQL((Filter)f)).toString());
            }
            return intervals.values();
        });
        Seq bounds = (Seq)Option$.MODULE$.option2Iterable(intervals).toSeq().flatten(Predef$.MODULE$.$conforms());
        if (bounds.isEmpty()) {
            colon2 = new .colon.colon((Object)new Tuple2((Object)Instant.EPOCH.atZone(ZoneOffset.UTC), (Object)Instant.now().atZone(ZoneOffset.UTC)), (List)Nil$.MODULE$);
        } else {
            ZonedDateTime now = Instant.now().atZone(ZoneOffset.UTC);
            colon2 = (Seq)bounds.map((Function1 & Serializable)bound -> {
                Option start = bound.lower().value().map((Function1 & Serializable)d -> {
                    if (bound.lower().inclusive()) {
                        return d;
                    }
                    return d.plusNanos(1000000L);
                });
                Option end = bound.upper().value().map((Function1 & Serializable)d -> {
                    if (bound.upper().exclusive()) {
                        return d;
                    }
                    return d.plusNanos(1000000L);
                });
                return new Tuple2(start.getOrElse((Function0 & Serializable)() -> Instant.EPOCH.atZone(ZoneOffset.UTC)), end.getOrElse((Function0 & Serializable)() -> now));
            });
        }
        .colon.colon dateRanges = colon2;
        package.WithClose$.MODULE$.apply((Object)new AccumuloAuditReader(ds), arg_0 -> AccumuloQueryAuditCommand.$anonfun$exec$10$adapted(this, (Seq)dateRanges, cql, arg_0), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public static final /* synthetic */ boolean $anonfun$exec$1(Filter x$1) {
        Filter filter = x$1;
        IncludeFilter includeFilter = Filter.INCLUDE;
        return filter == null ? includeFilter != null : !filter.equals(includeFilter);
    }

    public static final /* synthetic */ void $anonfun$exec$11(String h) {
        BoxedUnit boxedUnit;
        if (package.Command$.MODULE$.output().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.output().underlying().info(h);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$exec$15(OutputWriter writer$1, AuditedEvent.QueryEvent event) {
        BoxedUnit boxedUnit;
        if (package.Command$.MODULE$.output().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.output().underlying().info(writer$1.output(event));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$exec$13(Option cql$1, OutputWriter writer$1, CloseableIterator events) {
        CloseableIterator closeableIterator;
        Option option = cql$1;
        if (None$.MODULE$.equals(option)) {
            closeableIterator = events;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Filter f = (Filter)some.value();
            closeableIterator = events.filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)f.evaluate((Object)AccumuloQueryAuditCommand$.MODULE$.org$locationtech$geomesa$accumulo$tools$stats$AccumuloQueryAuditCommand$$toFeature(e))));
        } else {
            throw new MatchError((Object)option);
        }
        CloseableIterator out = closeableIterator;
        out.foreach((Function1 & Serializable)event -> {
            AccumuloQueryAuditCommand.$anonfun$exec$15(writer$1, event);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$exec$12(AccumuloQueryAuditCommand $this, AccumuloAuditReader reader$1, Option cql$1, OutputWriter writer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ZonedDateTime start = (ZonedDateTime)tuple2._1();
            ZonedDateTime end = (ZonedDateTime)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)package.WithClose$.MODULE$.apply((Object)reader$1.getQueryEvents($this.params().featureName(), new Tuple2((Object)start, (Object)end)), (Function1 & Serializable)events -> {
                AccumuloQueryAuditCommand.$anonfun$exec$13(cql$1, writer$1, events);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$exec$10(AccumuloQueryAuditCommand $this, Seq dateRanges$1, Option cql$1, AccumuloAuditReader reader) {
        OutputWriter writer = "json".equalsIgnoreCase($this.params().outputFormat()) ? new JsonWriter() : new CsvWriter();
        writer.header().foreach((Function1 & Serializable)h -> {
            AccumuloQueryAuditCommand.$anonfun$exec$11(h);
            return BoxedUnit.UNIT;
        });
        dateRanges$1.foreach((Function1 & Serializable)x0$1 -> {
            AccumuloQueryAuditCommand.$anonfun$exec$12($this, reader, cql$1, writer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public AccumuloQueryAuditCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        AccumuloDataStoreCommand.$init$(this);
        this.name = "query-audit-logs";
        this.params = new AccumuloQueryAuditParams();
    }

    public static final /* synthetic */ Object $anonfun$exec$10$adapted(AccumuloQueryAuditCommand $this, Seq dateRanges$1, Option cql$1, AccumuloAuditReader reader) {
        AccumuloQueryAuditCommand.$anonfun$exec$10($this, dateRanges$1, cql$1, reader);
        return BoxedUnit.UNIT;
    }

    @Parameters(commandDescription="Search query audit logs for a GeoMesa feature type")
    public static class AccumuloQueryAuditParams
    implements AccumuloDataStoreParams,
    RequiredTypeNameParam {
        @Parameter(names={"-b", "--begin"}, description="Lower bound (inclusive) on the date of log entries to return, in ISO 8601 format", converter=ParameterConverters.DateConverter.class)
        private Date start;
        @Parameter(names={"-e", "--end"}, description="Upper bound (exclusive) on the date of log entries to return, in ISO 8601 format", converter=ParameterConverters.DateConverter.class)
        private Date end;
        @Parameter(names={"--output-format"}, description="Output format, either 'json' or 'csv'", validateWith={OutputFormatValidator.class})
        private String outputFormat;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate to filter log entries. Schema is: user:String,filter:String,hints:String:json=true,metadata:String:json=true,start:Date,end:Date,planTimeMillis:Long,scanTimeMillis:Long,hits:Long", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public Date start() {
            return this.start;
        }

        public void start_$eq(Date x$1) {
            this.start = x$1;
        }

        public Date end() {
            return this.end;
        }

        public void end_$eq(Date x$1) {
            this.end = x$1;
        }

        public String outputFormat() {
            return this.outputFormat;
        }

        public void outputFormat_$eq(String x$1) {
            this.outputFormat = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public AccumuloQueryAuditParams() {
            ZookeepersParam.$init$(this);
            InstanceNameParams.$init$(this);
            PasswordParams.$init$((PasswordParams)this);
            CredentialsParams.$init$((CredentialsParams)this);
            KerberosParams.$init$((KerberosParams)this);
            AccumuloConnectionParams.$init$(this);
            CatalogParam.$init$((CatalogParam)this);
            RequiredTypeNameParam.$init$((RequiredTypeNameParam)this);
            this.outputFormat = "csv";
        }
    }

    private static class CsvWriter
    implements OutputWriter {
        private final StringBuilder out = new StringBuilder();
        private final CSVPrinter printer = new CSVPrinter((Appendable)this.out(), CSVFormat.DEFAULT);

        private StringBuilder out() {
            return this.out;
        }

        private CSVPrinter printer() {
            return this.printer;
        }

        @Override
        public Option<String> header() {
            return new Some((Object)AccumuloQueryAuditCommand$.MODULE$.org$locationtech$geomesa$accumulo$tools$stats$AccumuloQueryAuditCommand$$Spec().replaceAll(":\\w+", ""));
        }

        @Override
        public String output(AuditedEvent.QueryEvent event) {
            this.printer().println();
            this.out().setLength(0);
            this.printer().print((Object)event.user());
            this.printer().print((Object)event.filter());
            this.printer().print((Object)AuditWriter$.MODULE$.Gson().toJson((Object)event.hints()));
            this.printer().print((Object)AuditWriter$.MODULE$.Gson().toJson((Object)event.metadata()));
            this.printer().print(event.start() == -1L ? null : DateParsing$.MODULE$.formatMillis(event.start(), DateParsing$.MODULE$.formatMillis$default$2()));
            this.printer().print((Object)DateParsing$.MODULE$.formatMillis(event.end(), DateParsing$.MODULE$.formatMillis$default$2()));
            this.printer().print((Object)BoxesRunTime.boxToLong((long)event.planTime()));
            this.printer().print((Object)BoxesRunTime.boxToLong((long)event.scanTime()));
            this.printer().print((Object)BoxesRunTime.boxToLong((long)event.hits()));
            return this.out().toString();
        }
    }

    private static class JsonWriter
    implements OutputWriter {
        @Override
        public Option<String> header() {
            return None$.MODULE$;
        }

        @Override
        public String output(AuditedEvent.QueryEvent event) {
            LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
            model.put("user", event.user());
            model.put("filter", event.filter());
            model.put("hints", event.hints());
            model.put("metadata", event.metadata());
            Object object = event.start() != -1L ? model.put("start", DateParsing$.MODULE$.formatMillis(event.start(), DateParsing$.MODULE$.formatMillis$default$2())) : BoxedUnit.UNIT;
            model.put("end", DateParsing$.MODULE$.formatMillis(event.end(), DateParsing$.MODULE$.formatMillis$default$2()));
            model.put("planTimeMillis", BoxesRunTime.boxToLong((long)event.planTime()));
            model.put("scanTimeMillis", BoxesRunTime.boxToLong((long)event.scanTime()));
            model.put("hits", BoxesRunTime.boxToLong((long)event.hits()));
            return AuditWriter$.MODULE$.Gson().toJson(model);
        }
    }

    public static class OutputFormatValidator
    implements IParameterValidator {
        public void validate(String name, String value) {
            new .colon.colon((Object)"json", (List)new .colon.colon((Object)"csv", (List)Nil$.MODULE$)).find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.equalsIgnoreCase(value))).getOrElse((Function0 & Serializable)() -> {
                throw new ParameterException(new StringBuilder(24).append("Invalid output format '").append(value).append("'").toString());
            });
        }
    }

    private static interface OutputWriter {
        public Option<String> header();

        public String output(AuditedEvent.QueryEvent var1);
    }
}

