/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.data;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.Serializable;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.iterators.AgeOffIterator$;
import org.locationtech.geomesa.accumulo.iterators.DtgAgeOffIterator$;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.OptionalDtgParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.conf.FeatureExpiration;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001B\r\u001b\u0001\u001dBQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0013\b\u0003\u0004>\u0001\u0001\u0006IA\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0011@\u0011\u001d\t)\u000b\u0001Q\u0001\n\u0001Cq!a*\u0001\t\u0003\nI\u000bC\u0004\u0002,\u0002!I!!,\b\u000bES\u0002\u0012\u0001*\u0007\u000beQ\u0002\u0012A*\t\u000bQJA\u0011\u0001.\u0007\tmK\u0001\u0001\u0018\u0005\u0006i-!\t\u0001\u001b\u0005\nW.\u0001\r\u00111A\u0005\u00021D\u0011\"^\u0006A\u0002\u0003\u0007I\u0011\u0001<\t\u0013q\\\u0001\u0019!A!B\u0013i\u0007bCA!\u0017\u0001\u0007\t\u0019!C\u0001\u0003\u0007B1\"a\u0013\f\u0001\u0004\u0005\r\u0011\"\u0001\u0002N!Y\u0011\u0011K\u0006A\u0002\u0003\u0005\u000b\u0015BA#\u0011-\t\u0019g\u0003a\u0001\u0002\u0004%\t!a\u0011\t\u0017\u0005\u00154\u00021AA\u0002\u0013\u0005\u0011q\r\u0005\f\u0003WZ\u0001\u0019!A!B\u0013\t)\u0005C\u0006\u0002~-\u0001\r\u00111A\u0005\u0002\u0005\r\u0003bCA@\u0017\u0001\u0007\t\u0019!C\u0001\u0003\u0003C1\"!\"\f\u0001\u0004\u0005\t\u0015)\u0003\u0002F\t)\u0012iY2v[Vdw.Q4f\u001f\u001a47i\\7nC:$'BA\u000e\u001d\u0003\u0011!\u0017\r^1\u000b\u0005uq\u0012!\u0002;p_2\u001c(BA\u0010!\u0003!\t7mY;nk2|'BA\u0011#\u0003\u001d9Wm\\7fg\u0006T!a\t\u0013\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u00151!\tIc&D\u0001+\u0015\tYC&\u0001\u0003mC:<'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u0012aa\u00142kK\u000e$\bCA\u00193\u001b\u0005a\u0012BA\u001a\u001d\u0005a\t5mY;nk2|G)\u0019;b'R|'/Z\"p[6\fg\u000eZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u0003i\tAA\\1nKV\t!\b\u0005\u0002*w%\u0011AH\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002\u000b9\fW.\u001a\u0011\u0002\rA\f'/Y7t+\u0005\u0001\u0005CA!\f\u001d\t\u0011\u0005B\u0004\u0002D!:\u0011Ai\u0014\b\u0003\u000b:s!AR'\u000f\u0005\u001dceB\u0001%L\u001b\u0005I%B\u0001&'\u0003\u0019a$o\\8u}%\tQ%\u0003\u0002$I%\u0011\u0011EI\u0005\u0003?\u0001J!!\b\u0010\n\u0005ma\u0012!F!dGVlW\u000f\\8BO\u0016|eMZ\"p[6\fg\u000e\u001a\t\u0003o%\u0019\"!\u0003+\u0011\u0005UCV\"\u0001,\u000b\u0003]\u000bQa]2bY\u0006L!!\u0017,\u0003\r\u0005s\u0017PU3g)\u0005\u0011&\u0001F!dGVlW\u000f\\8BO\u0016|eM\u001a)be\u0006l7oE\u0003\f)v\u0003W\r\u0005\u00022=&\u0011q\f\b\u0002\u0018\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,\u0007+\u0019:b[N\u0004\"!Y2\u000e\u0003\tT!!\b\u0011\n\u0005\u0011\u0014'!\u0006*fcVL'/\u001a3UsB,g*Y7f!\u0006\u0014\u0018-\u001c\t\u0003C\u001aL!a\u001a2\u0003!=\u0003H/[8oC2$Eo\u001a)be\u0006lG#A5\u0011\u0005)\\Q\"A\u0005\u0002\r\u0015D\b/\u001b:z+\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003!!WO]1uS>t'B\u0001:W\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003i>\u0014\u0001\u0002R;sCRLwN\\\u0001\u000bKb\u0004\u0018N]=`I\u0015\fHCA<{!\t)\u00060\u0003\u0002z-\n!QK\\5u\u0011\u001dYh\"!AA\u00025\f1\u0001\u001f\u00132\u0003\u001d)\u0007\u0010]5ss\u0002Bcb\u0004@\u0002\u0012\u0005M\u0011QDA\u0010\u0003G\t)\u0003E\u0002\u0000\u0003\u001bi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u000bU\u000e|W.\\1oI\u0016\u0014(\u0002BA\u0004\u0003\u0013\tQAY3vgRT!!a\u0003\u0002\u0007\r|W.\u0003\u0003\u0002\u0010\u0005\u0005!!\u0003)be\u0006lW\r^3s\u0003\u0015q\u0017-\\3tY\u0011\t)\"!\u0007\"\u0005\u0005]\u0011AA\u0017fC\t\tY\"\u0001\u0005.[\u0015D\b/\u001b:z\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0005\u0005\u0005\u0012!\u0014#ve\u0006$\u0018n\u001c8!E\u00164wN]3!K:$(/[3tA\u0005\u0014X\rI1hK\u0012lsN\u001a4-A\u0015tsM\f\u0011(c\u0001\"\u0017-_\u0014-A\u001d\u0012\u0004e^3fWN\u0004\u0013M\u001c3!c\u0001Bw.\u001e:(Y\u0001*GoY\u0001\nG>tg/\u001a:uKJ\u001c#!a\n\u0011\t\u0005%\u00121\b\b\u0005\u0003W\t)D\u0004\u0003\u0002.\u0005EbbA#\u00020%\u0011Q\u0004I\u0005\u0004\u0003g\u0011\u0017!B;uS2\u001c\u0018\u0002BA\u001c\u0003s\t1\u0003U1sC6,G/\u001a:D_:4XM\u001d;feNT1!a\rc\u0013\u0011\ti$a\u0010\u0003#\u0011+(/\u0019;j_:\u001cuN\u001c<feR,'O\u0003\u0003\u00028\u0005e\u0012\u0001\u00027jgR,\"!!\u0012\u0011\u0007U\u000b9%C\u0002\u0002JY\u0013qAQ8pY\u0016\fg.\u0001\u0005mSN$x\fJ3r)\r9\u0018q\n\u0005\twF\t\t\u00111\u0001\u0002F\u0005)A.[:uA!R!C`A\t\u0003+\ni\"a\u0018-\t\u0005]\u00131L\u0011\u0003\u00033\n!!\f7\"\u0005\u0005u\u0013AB\u0017.Y&\u001cH/\t\u0002\u0002b\u0005yC*[:uA\u0015D\u0018n\u001d;j]\u001e\u0004\u0013mZ3._\u001a4\u0007EZ8sA\u0005\u00043/[7qY\u0016\u0004c-Z1ukJ,\u0007\u0005^=qK\u0006\u00191/\u001a;\u0002\u000fM,Go\u0018\u0013fcR\u0019q/!\u001b\t\u0011m$\u0012\u0011!a\u0001\u0003\u000b\nAa]3uA!RQC`A\t\u0003_\ni\"!\u001f-\t\u0005E\u0014QO\u0011\u0003\u0003g\n!!L:\"\u0005\u0005]\u0014!B\u0017.g\u0016$\u0018EAA>\u0003\u0015\u001aV\r\u001e\u0011bO\u0016lsN\u001a4!M>\u0014\b%\u0019\u0011tS6\u0004H.\u001a\u0011gK\u0006$XO]3!if\u0004X-\u0001\u0004sK6|g/Z\u0001\u000be\u0016lwN^3`I\u0015\fHcA<\u0002\u0004\"A1pFA\u0001\u0002\u0004\t)%A\u0004sK6|g/\u001a\u0011)\u0015aq\u0018\u0011CAE\u0003;\t\u0019\n\f\u0003\u0002\f\u0006=\u0015EAAG\u0003\ti#/\t\u0002\u0002\u0012\u0006AQ&\f:f[>4X-\t\u0002\u0002\u0016\u0006\t$+Z7pm\u0016\u0004S\r_5ti&tw\rI1hK6zgM\u001a\u0011g_J\u0004\u0013\rI:j[BdW\r\t4fCR,(/\u001a\u0011usB,\u0007fB\u0006\u0002\u001a\u0006}\u0015\u0011\u0015\t\u0004\u007f\u0006m\u0015\u0002BAO\u0003\u0003\u0011!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0005\u0005\r\u0016A\r'jgR|3/\u001a;0e\u0016lwN^3!C\u001e,Wf\u001c4gA\u0019|'\u000fI1!\u000f\u0016|W*Z:bA\u0019,\u0017\r^;sK\u0002\"\u0018\u0010]3\u0002\u000fA\f'/Y7tA\u00059Q\r_3dkR,G#A<\u0002\t\u0015DXm\u0019\u000b\u0004o\u0006=\u0006bBAY\u000f\u0001\u0007\u00111W\u0001\u0003IN\u0004B!!.\u0002:6\u0011\u0011q\u0017\u0006\u00037yIA!a/\u00028\n\t\u0012iY2v[Vdw\u000eR1uCN#xN]3")
public class AccumuloAgeOffCommand
implements AccumuloDataStoreCommand {
    private final String name;
    private final AccumuloAgeOffParams params;

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand.connection$(this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    @Override
    public AccumuloAgeOffParams params() {
        return this.params;
    }

    public void execute() {
        if (package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{this.params().set(), this.params().remove(), this.params().list()})).count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AccumuloAgeOffCommand.$anonfun$execute$1(BoxesRunTime.unboxToBoolean((Object)x$1)))) != 1) {
            throw new ParameterException("Must specify exactly one of 'list', 'set' or 'remove'");
        }
        if (this.params().set() && this.params().expiry() == null) {
            throw new ParameterException("Must specify 'expiry' when setting age-off");
        }
        this.withDataStore((Function1 & Serializable)ds -> {
            this.exec(ds);
            return BoxedUnit.UNIT;
        });
    }

    private void exec(AccumuloDataStore ds) {
        Object x$9;
        List x$8;
        LazyRef mutable$lzy = new LazyRef();
        SimpleFeatureType sft = ds.getSchema(this.params().featureName());
        if (sft == null) {
            throw new ParameterException(new StringBuilder(53).append("SimpleFeatureType '").append(this.params().featureName()).append("' does not exist in the data store").toString());
        }
        if (this.params().list()) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            TableOperations tableOps = ds.connector().tableOperations();
            Seq tables = (Seq)ds.getAllIndexTableNames(sft.getTypeName()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)tableOps.exists(x$1)));
            Option dtgAgeOff = (Option)tables.foldLeft((Object)None$.MODULE$, (Function2 & Serializable)(res, table) -> res.orElse((Function0 & Serializable)() -> DtgAgeOffIterator$.MODULE$.list(tableOps, table)));
            Option ageOff = (Option)tables.foldLeft((Object)None$.MODULE$, (Function2 & Serializable)(res, table) -> res.orElse((Function0 & Serializable)() -> AgeOffIterator$.MODULE$.list(tableOps, table)));
            if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                package.Command$.MODULE$.user().underlying().info("Attribute age-off: {}", dtgAgeOff.getOrElse((Function0 & Serializable)() -> "None"));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                package.Command$.MODULE$.user().underlying().info("Timestamp age-off: {}", ageOff.getOrElse((Function0 & Serializable)() -> "None"));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        if (this.params().set() && this.params().dtgField() == null) {
            Object x$3;
            List x$2;
            String x$12 = new StringBuilder(82).append("Configuring ingest-time-based age-off for schema '").append(this.params().featureName()).append("' ").append("with expiry ").append(this.params().expiry()).append(". Continue (y/n)? ").toString();
            if (Prompt$.MODULE$.confirm(x$12, x$2 = Prompt$.MODULE$.confirm$default$2(), x$3 = Prompt$.MODULE$.confirm$default$3(x$12, x$2))) {
                RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setFeatureExpiration$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(AccumuloAgeOffCommand.mutable$1(mutable$lzy, sft)), (FeatureExpiration)new FeatureExpiration.IngestTimeExpiration(this.params().expiry()));
                ds.updateSchema(sft.getTypeName(), AccumuloAgeOffCommand.mutable$1(mutable$lzy, sft));
                return;
            }
            return;
        }
        if (this.params().set()) {
            Object x$6;
            List x$5;
            String x$4 = new StringBuilder(92).append("Configuring attribute-based age-off for schema '").append(this.params().featureName()).append("' ").append("on field '").append(this.params().dtgField()).append("' with expiry ").append(this.params().expiry()).append(". Continue (y/n)? ").toString();
            if (Prompt$.MODULE$.confirm(x$4, x$5 = Prompt$.MODULE$.confirm$default$2(), x$6 = Prompt$.MODULE$.confirm$default$3(x$4, x$5))) {
                FeatureExpiration.FeatureTimeExpiration expiry = new FeatureExpiration.FeatureTimeExpiration(this.params().dtgField(), sft.indexOf(this.params().dtgField()), this.params().expiry());
                RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setFeatureExpiration$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(AccumuloAgeOffCommand.mutable$1(mutable$lzy, sft)), (FeatureExpiration)expiry);
                ds.updateSchema(sft.getTypeName(), AccumuloAgeOffCommand.mutable$1(mutable$lzy, sft));
                return;
            }
            return;
        }
        String x$7 = new StringBuilder(48).append("Removing age-off for schema '").append(this.params().featureName()).append("'. Continue (y/n)? ").toString();
        if (Prompt$.MODULE$.confirm(x$7, x$8 = Prompt$.MODULE$.confirm$default$2(), x$9 = Prompt$.MODULE$.confirm$default$3(x$7, x$8))) {
            if (AccumuloAgeOffCommand.mutable$1(mutable$lzy, sft).getUserData().remove(SimpleFeatureTypes.Configs$.MODULE$.FeatureExpiration()) == null) {
                TableOperations tableOps = ds.connector().tableOperations();
                ((IterableOnceOps)ds.getAllIndexTableNames(sft.getTypeName()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)tableOps.exists(x$1)))).foreach((Function1 & Serializable)table -> {
                    AccumuloAgeOffCommand.$anonfun$exec$9(tableOps, table);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            ds.updateSchema(sft.getTypeName(), AccumuloAgeOffCommand.mutable$1(mutable$lzy, sft));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(boolean x$1) {
        return x$1;
    }

    private static final /* synthetic */ SimpleFeatureType mutable$lzycompute$1(LazyRef mutable$lzy$1, SimpleFeatureType sft$1) {
        SimpleFeatureType simpleFeatureType;
        LazyRef lazyRef = mutable$lzy$1;
        synchronized (lazyRef) {
            simpleFeatureType = mutable$lzy$1.initialized() ? (SimpleFeatureType)mutable$lzy$1.value() : (SimpleFeatureType)mutable$lzy$1.initialize((Object)SimpleFeatureTypes$.MODULE$.mutable(sft$1));
        }
        return simpleFeatureType;
    }

    private static final SimpleFeatureType mutable$1(LazyRef mutable$lzy$1, SimpleFeatureType sft$1) {
        if (mutable$lzy$1.initialized()) {
            return (SimpleFeatureType)mutable$lzy$1.value();
        }
        return AccumuloAgeOffCommand.mutable$lzycompute$1(mutable$lzy$1, sft$1);
    }

    public static final /* synthetic */ void $anonfun$exec$9(TableOperations tableOps$2, String table) {
        AgeOffIterator$.MODULE$.clear(tableOps$2, table);
        DtgAgeOffIterator$.MODULE$.clear(tableOps$2, table);
    }

    public AccumuloAgeOffCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        AccumuloDataStoreCommand.$init$(this);
        this.name = "configure-age-off";
        this.params = new AccumuloAgeOffParams();
    }

    @Parameters(commandDescription="List/set/remove age-off for a GeoMesa feature type")
    public static class AccumuloAgeOffParams
    implements AccumuloDataStoreParams,
    RequiredTypeNameParam,
    OptionalDtgParam {
        @Parameter(names={"-e", "--expiry"}, description="Duration before entries are aged-off, e.g. '1 day', '2 weeks and 1 hour', etc", converter=ParameterConverters.DurationConverter.class)
        private Duration expiry;
        @Parameter(names={"-l", "--list"}, description="List existing age-off for a simple feature type")
        private boolean list;
        @Parameter(names={"-s", "--set"}, description="Set age-off for a simple feature type")
        private boolean set;
        @Parameter(names={"-r", "--remove"}, description="Remove existing age-off for a simple feature type")
        private boolean remove;
        @Parameter(names={"--dtg"}, description="DateTime field name to use as the default dtg")
        private String dtgField;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;

        public String dtgField() {
            return this.dtgField;
        }

        public void dtgField_$eq(String x$1) {
            this.dtgField = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public Duration expiry() {
            return this.expiry;
        }

        public void expiry_$eq(Duration x$1) {
            this.expiry = x$1;
        }

        public boolean list() {
            return this.list;
        }

        public void list_$eq(boolean x$1) {
            this.list = x$1;
        }

        public boolean set() {
            return this.set;
        }

        public void set_$eq(boolean x$1) {
            this.set = x$1;
        }

        public boolean remove() {
            return this.remove;
        }

        public void remove_$eq(boolean x$1) {
            this.remove = x$1;
        }

        public AccumuloAgeOffParams() {
            ZookeepersParam.$init$(this);
            InstanceNameParams.$init$(this);
            PasswordParams.$init$((PasswordParams)this);
            CredentialsParams.$init$((CredentialsParams)this);
            KerberosParams.$init$((KerberosParams)this);
            AccumuloConnectionParams.$init$(this);
            CatalogParam.$init$((CatalogParam)this);
            RequiredTypeNameParam.$init$((RequiredTypeNameParam)this);
            OptionalDtgParam.$init$((OptionalDtgParam)this);
        }
    }
}

