/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.jobs.AccumuloJobUtils$;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloInputFormat$;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam;
import org.locationtech.geomesa.features.exporters.FeatureExporter;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.NumReducersParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportFormat;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.tools.utils.ParameterValidators;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001\u0002\u0006\f\u0001aAQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013\u0005c\t\u0003\u0004\u007f\u0001\u0001\u0006Ia\u0012\u0005\u0007\u007f\u0002!\t&!\u0001\b\u000b-[\u0001\u0012\u0001'\u0007\u000b)Y\u0001\u0012A'\t\u000b\u00053A\u0011\u0001+\u0007\tU3\u0001A\u0016\u0005\u0006\u0003\"!\t!\u001c\u0002\u0016\u0003\u000e\u001cW/\\;m_\u0016C\bo\u001c:u\u0007>lW.\u00198e\u0015\taQ\"\u0001\u0004fqB|'\u000f\u001e\u0006\u0003\u001d=\tQ\u0001^8pYNT!\u0001E\t\u0002\u0011\u0005\u001c7-^7vY>T!AE\n\u0002\u000f\u001d,w.\\3tC*\u0011A#F\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M!\u0001!G\u0011.!\tQr$D\u0001\u001c\u0015\taR$\u0001\u0003mC:<'\"\u0001\u0010\u0002\t)\fg/Y\u0005\u0003Am\u0011aa\u00142kK\u000e$\bc\u0001\u0012&O5\t1E\u0003\u0002\rI)\u0011a\"E\u0005\u0003M\r\u0012Q\"\u0012=q_J$8i\\7nC:$\u0007C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0010\u0003\u0011!\u0017\r^1\n\u00051J#!E!dGVlW\u000f\\8ECR\f7\u000b^8sKB\u0011aF\u0010\b\u0003_qr!\u0001M\u001e\u000f\u0005ERdB\u0001\u001a:\u001d\t\u0019\u0004H\u0004\u00025o5\tQG\u0003\u00027/\u00051AH]8pizJ\u0011AF\u0005\u0003)UI!AE\n\n\u0005A\t\u0012B\u0001\b\u0010\u0013\tiT\"\u0001\rBG\u000e,X.\u001e7p\t\u0006$\u0018m\u0015;pe\u0016\u001cu.\\7b]\u0012L!a\u0010!\u00035\u0005\u001b7-^7vY>$\u0015n\u001d;sS\n,H/\u001a3D_6l\u0017M\u001c3\u000b\u0005uj\u0011A\u0002\u001fj]&$h\bF\u0001D!\t!\u0005!D\u0001\f\u0003\u0019\u0001\u0018M]1ngV\tq\t\u0005\u0002I\u00119\u0011\u0011*\u0002\b\u0003_)K!\u0001D\u0007\u0002+\u0005\u001b7-^7vY>,\u0005\u0010]8si\u000e{W.\\1oIB\u0011AIB\n\u0003\r9\u0003\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a!\u00118z%\u00164G#\u0001'\u0003)\u0005\u001b7-^7vY>,\u0005\u0010]8siB\u000b'/Y7t'\u0019Aaj\u00162gUB\u0011\u0001l\u0018\b\u00033vs!A\u0017/\u000f\u0005EZ\u0016B\u0001\b\u0012\u0013\taA%\u0003\u0002_G\u0005iQ\t\u001f9peR\u001cu.\\7b]\u0012L!\u0001Y1\u0003\u0019\u0015C\bo\u001c:u!\u0006\u0014\u0018-\\:\u000b\u0005y\u001b\u0003CA2e\u001b\u0005i\u0011BA3\u000e\u0005]\t5mY;nk2|G)\u0019;b'R|'/\u001a)be\u0006l7\u000f\u0005\u0002hQ6\tA%\u0003\u0002jI\t)\"+Z9vSJ,G\rV=qK:\u000bW.\u001a)be\u0006l\u0007CA4l\u0013\taGE\u0001\nPaRLwN\\1m\u0013:$W\r\u001f)be\u0006lG#\u00018\u0011\u0005=DQ\"\u0001\u0004)\t!\t8\u0010 \t\u0003efl\u0011a\u001d\u0006\u0003iV\f!B[2p[6\fg\u000eZ3s\u0015\t1x/A\u0003cKV\u001cHOC\u0001y\u0003\r\u0019w.\\\u0005\u0003uN\u0014!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0003u\f\u0011&\u0012=q_J$\bEZ3biV\u0014Xm\u001d\u0011ge>l\u0007%\u0019\u0011HK>lUm]1!I\u0006$\u0018\rI:u_J,\u0017a\u00029be\u0006l7\u000fI\u0001\nG>tg-[4ve\u0016$\u0002\"a\u0001\u0002\n\u0005\u0005\u0012Q\u0005\t\u0004\u001f\u0006\u0015\u0011bAA\u0004!\n!QK\\5u\u0011\u001d\tY\u0001\u0002a\u0001\u0003\u001b\t1A[8c!\u0011\ty!!\b\u000e\u0005\u0005E!\u0002BA\n\u0003+\t\u0011\"\\1qe\u0016$WoY3\u000b\t\u0005]\u0011\u0011D\u0001\u0007Q\u0006$wn\u001c9\u000b\u0007\u0005mQ#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003?\t\tBA\u0002K_\nDa!a\t\u0005\u0001\u00049\u0013A\u00013t\u0011\u001d\t9\u0003\u0002a\u0001\u0003S\tQ!];fef\u0004B!a\u000b\u000285\u0011\u0011Q\u0006\u0006\u0004U\u0005=\"\u0002BA\u0019\u0003g\t1!\u00199j\u0015\r\t)$F\u0001\tO\u0016|Go\\8mg&!\u0011\u0011HA\u0017\u0005\u0015\tV/\u001a:z\u0001")
public class AccumuloExportCommand
implements ExportCommand<AccumuloDataStore>,
AccumuloDataStoreCommand.AccumuloDistributedCommand {
    private final AccumuloExportParams params;
    private String name;
    private transient Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public /* synthetic */ Seq org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$AccumuloDistributedCommand$$super$libjarsFiles() {
        return ExportCommand.libjarsFiles$((ExportCommand)this);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$AccumuloDistributedCommand$$super$libjarsPaths() {
        return package.DistributedCommand.libjarsPaths$((package.DistributedCommand)this);
    }

    @Override
    public Seq<String> libjarsFiles() {
        return AccumuloDataStoreCommand.AccumuloDistributedCommand.libjarsFiles$(this);
    }

    @Override
    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return AccumuloDataStoreCommand.AccumuloDistributedCommand.libjarsPaths$(this);
    }

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return AccumuloDataStoreCommand.connection$(this);
    }

    public void execute() {
        ExportCommand.execute$((ExportCommand)this);
    }

    public Option export(DataStore ds, Query query, FeatureExporter exporter, boolean writeEmptyFiles) {
        return ExportCommand.export$((ExportCommand)this, (DataStore)ds, (Query)query, (FeatureExporter)exporter, (boolean)writeEmptyFiles);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    public Object console() {
        return package.InteractiveCommand.console$((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.setConsole$((package.InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    private Logger logger$lzycompute() {
        AccumuloExportCommand accumuloExportCommand = this;
        synchronized (accumuloExportCommand) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    @Override
    public AccumuloExportParams params() {
        return this.params;
    }

    public void configure(Job job, AccumuloDataStore ds, Query query) {
        GeoMesaAccumuloInputFormat$.MODULE$.configure(job.getConfiguration(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.connection()).asJava(), AccumuloJobUtils$.MODULE$.getSingleQueryPlan(ds, query));
    }

    public AccumuloExportCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.$init$((package.InteractiveCommand)this);
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
        ExportCommand.$init$((ExportCommand)this);
        AccumuloDataStoreCommand.$init$(this);
        AccumuloDataStoreCommand.AccumuloDistributedCommand.$init$(this);
        this.params = new AccumuloExportParams();
        Statics.releaseFence();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class AccumuloExportParams
    implements ExportCommand.ExportParams,
    AccumuloDataStoreParams,
    RequiredTypeNameParam,
    OptionalIndexParam {
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|avro-native|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed jobs)", validateWith={ParameterValidators.PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.loadIndex$((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            AccumuloExportParams accumuloExportParams = this;
            synchronized (accumuloExportParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.outputFormat$((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.outputFormat;
        }

        public ExportFormat outputFormat() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.outputFormat$lzycompute();
            }
            return this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option<Enumeration.Value> mode$lzycompute() {
            AccumuloExportParams accumuloExportParams = this;
            synchronized (accumuloExportParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.mode$((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.mode;
        }

        public Option<Enumeration.Value> mode() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.mode$lzycompute();
            }
            return this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public AccumuloExportParams() {
            OptionalCqlFilterParam.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.$init$((QueryHintsParams)this);
            DistributedRunParam.$init$((DistributedRunParam)this);
            NumReducersParam.$init$((NumReducersParam)this);
            OptionalForceParam.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.$init$((ExportCommand.ExportParams)this);
            ZookeepersParam.$init$(this);
            InstanceNameParams.$init$(this);
            PasswordParams.$init$((PasswordParams)this);
            CredentialsParams.$init$((CredentialsParams)this);
            KerberosParams.$init$((KerberosParams)this);
            AccumuloConnectionParams.$init$(this);
            CatalogParam.$init$((CatalogParam)this);
            RequiredTypeNameParam.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.$init$((OptionalIndexParam)this);
        }
    }
}

