/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam;
import org.locationtech.geomesa.features.exporters.FeatureExporter;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.NumReducersParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportFormat;
import org.locationtech.geomesa.tools.export.PlaybackCommand;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.tools.utils.ParameterValidators;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005M4A!\u0003\u0006\u0001/!)\u0001\u0007\u0001C\u0001c!9A\u0007\u0001b\u0001\n\u0003*\u0004B\u0002:\u0001A\u0003%agB\u0003H\u0015!\u0005\u0001JB\u0003\n\u0015!\u0005\u0011\nC\u00031\u000b\u0011\u0005\u0001K\u0002\u0003R\u000b\u0001\u0011\u0006\"\u0002\u0019\b\t\u0003\t'aF!dGVlW\u000f\\8QY\u0006L(-Y2l\u0007>lW.\u00198e\u0015\tYA\"\u0001\u0004fqB|'\u000f\u001e\u0006\u0003\u001b9\tQ\u0001^8pYNT!a\u0004\t\u0002\u0011\u0005\u001c7-^7vY>T!!\u0005\n\u0002\u000f\u001d,w.\\3tC*\u00111\u0003F\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0007\u0011-!\tIb$D\u0001\u001b\u0015\tYB$\u0001\u0003mC:<'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011aa\u00142kK\u000e$\bcA\u0011%M5\t!E\u0003\u0002\fG)\u0011Q\u0002E\u0005\u0003K\t\u0012q\u0002\u00157bs\n\f7m[\"p[6\fg\u000e\u001a\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S9\tA\u0001Z1uC&\u00111\u0006\u000b\u0002\u0012\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,\u0007CA\u0017/\u001b\u0005a\u0011BA\u0018\r\u0005a\t5mY;nk2|G)\u0019;b'R|'/Z\"p[6\fg\u000eZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0002\"a\r\u0001\u000e\u0003)\ta\u0001]1sC6\u001cX#\u0001\u001c\u0011\u0005]:aB\u0001\u001d\u0005\u001d\tIdI\u0004\u0002;\u000b:\u00111\b\u0012\b\u0003y\rs!!\u0010\"\u000f\u0005y\nU\"A \u000b\u0005\u00013\u0012A\u0002\u001fs_>$h(C\u0001\u0016\u0013\t\u0019B#\u0003\u0002\u0012%%\u0011q\u0002E\u0005\u0003\u001b9I!a\u0003\u0007\u0002/\u0005\u001b7-^7vY>\u0004F.Y=cC\u000e\\7i\\7nC:$\u0007CA\u001a\u0006'\t)!\n\u0005\u0002L\u001d6\tAJC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyEJ\u0001\u0004B]f\u0014VM\u001a\u000b\u0002\u0011\n1\u0012iY2v[Vdw\u000e\u00157bs\n\f7m\u001b)be\u0006l7o\u0005\u0003\b\u0015Ns\u0006C\u0001+\\\u001d\t)\u0016L\u0004\u0002W1:\u00111hV\u0005\u0003\u001bAI!aC\u0012\n\u0005i\u0013\u0013a\u0004)mCf\u0014\u0017mY6D_6l\u0017M\u001c3\n\u0005qk&A\u0004)mCf\u0014\u0017mY6QCJ\fWn\u001d\u0006\u00035\n\u0002\"!L0\n\u0005\u0001d!aF!dGVlW\u000f\\8ECR\f7\u000b^8sKB\u000b'/Y7t)\u0005\u0011\u0007CA2\b\u001b\u0005)\u0001\u0006B\u0004f_B\u0004\"AZ7\u000e\u0003\u001dT!\u0001[5\u0002\u0015)\u001cw.\\7b]\u0012,'O\u0003\u0002kW\u0006)!-Z;ti*\tA.A\u0002d_6L!A\\4\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0017%A9\u0002\rBc\u0017-\u001f2bG.\u0004c-Z1ukJ,7\u000f\t4s_6\u0004\u0013\rI$f_6+7/\u0019\u0011eCR\f\u0007e\u001d;pe\u0016d\u0003EY1tK\u0012\u0004sN\u001c\u0011uQ\u0016\u0004c-Z1ukJ,\u0007\u0005Z1uK\u00069\u0001/\u0019:b[N\u0004\u0003")
public class AccumuloPlaybackCommand
implements PlaybackCommand<AccumuloDataStore>,
AccumuloDataStoreCommand {
    private final AccumuloPlaybackParams params;
    private String name;
    private transient Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return AccumuloDataStoreCommand.connection$(this);
    }

    public Option export(DataStore ds, Query query, FeatureExporter exporter, boolean writeEmptyFiles) {
        return PlaybackCommand.export$((PlaybackCommand)this, (DataStore)ds, (Query)query, (FeatureExporter)exporter, (boolean)writeEmptyFiles);
    }

    public final void configure(Job job, DataStore ds, Query query) {
        PlaybackCommand.configure$((PlaybackCommand)this, (Job)job, (DataStore)ds, (Query)query);
    }

    public Seq<String> libjarsFiles() {
        return ExportCommand.libjarsFiles$((ExportCommand)this);
    }

    public void execute() {
        ExportCommand.execute$((ExportCommand)this);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    public Object console() {
        return package.InteractiveCommand.console$((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.setConsole$((package.InteractiveCommand)this, (Object)c);
    }

    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return package.DistributedCommand.libjarsPaths$((package.DistributedCommand)this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$PlaybackCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
    }

    private Logger logger$lzycompute() {
        AccumuloPlaybackCommand accumuloPlaybackCommand = this;
        synchronized (accumuloPlaybackCommand) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    @Override
    public AccumuloPlaybackParams params() {
        return this.params;
    }

    public AccumuloPlaybackCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.$init$((package.InteractiveCommand)this);
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
        ExportCommand.$init$((ExportCommand)this);
        PlaybackCommand.$init$((PlaybackCommand)this);
        AccumuloDataStoreCommand.$init$(this);
        this.params = new AccumuloPlaybackParams();
        Statics.releaseFence();
    }

    @Parameters(commandDescription="Playback features from a GeoMesa data store, based on the feature date")
    public static class AccumuloPlaybackParams
    implements PlaybackCommand.PlaybackParams,
    AccumuloDataStoreParams {
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;
        @Parameter(names={"--interval"}, description="Date interval to query, in the format yyyy-MM-dd'T'HH:mm:ss.SSSZ/yyyy-MM-dd'T'HH:mm:ss.SSSZ", required=true, converter=ParameterConverters.IntervalConverter.class)
        private Tuple2<Date, Date> interval;
        @Parameter(names={"--dtg"}, description="Date attribute to base playback on")
        private String dtg;
        @Parameter(names={"--step-window"}, description="Query the interval in discrete chunks instead of all at once ('10 minutes', '30 seconds', etc)", converter=ParameterConverters.DurationConverter.class)
        private Duration window;
        @Parameter(names={"--rate"}, description="Rate multiplier to speed-up (or slow down) features being returned")
        private Float rate;
        @Parameter(names={"--live"}, description="Simulate live data by projecting the dates to current time")
        private Boolean live;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|avro-native|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed jobs)", validateWith={ParameterValidators.PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public Tuple2<Date, Date> interval() {
            return this.interval;
        }

        public void interval_$eq(Tuple2<Date, Date> x$1) {
            this.interval = x$1;
        }

        public String dtg() {
            return this.dtg;
        }

        public void dtg_$eq(String x$1) {
            this.dtg = x$1;
        }

        public Duration window() {
            return this.window;
        }

        public void window_$eq(Duration x$1) {
            this.window = x$1;
        }

        public Float rate() {
            return this.rate;
        }

        public void rate_$eq(Float x$1) {
            this.rate = x$1;
        }

        public Boolean live() {
            return this.live;
        }

        public void live_$eq(Boolean x$1) {
            this.live = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            AccumuloPlaybackParams accumuloPlaybackParams = this;
            synchronized (accumuloPlaybackParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.outputFormat$((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.outputFormat;
        }

        public ExportFormat outputFormat() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.outputFormat$lzycompute();
            }
            return this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option<Enumeration.Value> mode$lzycompute() {
            AccumuloPlaybackParams accumuloPlaybackParams = this;
            synchronized (accumuloPlaybackParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.mode$((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.mode;
        }

        public Option<Enumeration.Value> mode() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.mode$lzycompute();
            }
            return this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public AccumuloPlaybackParams() {
            OptionalCqlFilterParam.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.$init$((QueryHintsParams)this);
            DistributedRunParam.$init$((DistributedRunParam)this);
            NumReducersParam.$init$((NumReducersParam)this);
            OptionalForceParam.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.$init$((ExportCommand.ExportParams)this);
            RequiredTypeNameParam.$init$((RequiredTypeNameParam)this);
            PlaybackCommand.PlaybackParams.$init$((PlaybackCommand.PlaybackParams)this);
            ZookeepersParam.$init$(this);
            InstanceNameParams.$init$(this);
            PasswordParams.$init$((PasswordParams)this);
            CredentialsParams.$init$((CredentialsParams)this);
            KerberosParams.$init$((KerberosParams)this);
            AccumuloConnectionParams.$init$(this);
            CatalogParam.$init$((CatalogParam)this);
        }
    }
}

