/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.jobs.mapreduce.GeoMesaAccumuloFileOutputFormat$;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.jobs.mapreduce.ConverterCombineInputFormat;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.DistributedCombineParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.OutputPathParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.TempPathParam;
import org.locationtech.geomesa.tools.data.CreateSchemaCommand;
import org.locationtech.geomesa.tools.ingest.ConverterIngestJob;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.DistributedCopy;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.hadoop.HadoopDelegate$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tuf\u0001\u0002\u0012$\u0001ABQ!\u0017\u0001\u0005\u0002iCq!\u0018\u0001C\u0002\u0013\u0005c\f\u0003\u0004c\u0001\u0001\u0006Ia\u0018\u0005\bG\u0002\u0011\r\u0011\"\u0011e\u0011\u001d\t)\b\u0001Q\u0001\n\u0015Dq!a\u001e\u0001\t#\nIH\u0002\u0004\u0002j\u0002\u0001\u00111\u001e\u0005\n\u0003[;!\u0011!Q\u0001\n}B!\"a=\b\u0005\u0003\u0005\u000b\u0011BA{\u0011)\t\tl\u0002B\u0001B\u0003%\u00111\u0017\u0005\u000b\u0005\u00139!\u0011!Q\u0001\n\u0005=\u0007B\u0003B\u0006\u000f\t\u0005\t\u0015!\u0003\u0003\u000e!Q!QD\u0004\u0003\u0002\u0003\u0006IAa\b\t\u0015\tMrA!A!\u0002\u0013\u0011)\u0004\u0003\u0006\u0003<\u001d\u0011\t\u0011)A\u0005\u0005{A!B!\u0012\b\u0005\u0003\u0005\u000b\u0011\u0002B$\u0011)\u0011Ie\u0002B\u0001B\u0003%!1\n\u0005\u000b\u0005\u001b:!\u0011!Q\u0001\n\t5\u0001B\u0003B(\u000f\t\u0005\t\u0015!\u0003\u0003R!1\u0011l\u0002C\u0001\u0005WB1B!#\b\u0001\u0004\u0005\r\u0011\"\u0003\u0003\f\"Y!QR\u0004A\u0002\u0003\u0007I\u0011\u0002BH\u0011-\u0011\u0019j\u0002a\u0001\u0002\u0003\u0006KA!\u0002\t\u000f\tUu\u0001\"\u0011\u0003\u0018\"9!\u0011V\u0004\u0005B\t-v!B5$\u0011\u0003Qg!\u0002\u0012$\u0011\u0003Y\u0007\"B-\u001c\t\u0003\u0011h\u0001B:\u001c\u0001QDa!W\u000f\u0005\u0002\u0005\r\u0002\"CA\u0015;\u0001\u0007I\u0011AA\u0016\u0011%\t\u0019$\ba\u0001\n\u0003\t)\u0004\u0003\u0005\u0002Bu\u0001\u000b\u0015BA\u0017\u0005e\t5mY;nk2|')\u001e7l\u0013:<Wm\u001d;D_6l\u0017M\u001c3\u000b\u0005\u0011*\u0013AB5oO\u0016\u001cHO\u0003\u0002'O\u0005)Ao\\8mg*\u0011\u0001&K\u0001\tC\u000e\u001cW/\\;m_*\u0011!fK\u0001\bO\u0016|W.Z:b\u0015\taS&\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001/\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011'O#\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014\u0001\u00027b]\u001eT\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029g\t1qJ\u00196fGR\u00042AO\u001f@\u001b\u0005Y$B\u0001\u0013=\u0015\t1\u0013&\u0003\u0002?w\ti\u0011J\\4fgR\u001cu.\\7b]\u0012\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0014\u0002\t\u0011\fG/Y\u0005\u0003\t\u0006\u0013\u0011#Q2dk6,Hn\u001c#bi\u0006\u001cFo\u001c:f!\t1eK\u0004\u0002H):\u0011\u0001j\u0015\b\u0003\u0013Js!AS)\u000f\u0005-\u0003fB\u0001'P\u001b\u0005i%B\u0001(0\u0003\u0019a$o\\8u}%\ta&\u0003\u0002-[%\u0011!fK\u0005\u0003Q%J!AJ\u0014\n\u0005U+\u0013\u0001G!dGVlW\u000f\\8ECR\f7\u000b^8sK\u000e{W.\\1oI&\u0011q\u000b\u0017\u0002\u001b\u0003\u000e\u001cW/\\;m_\u0012K7\u000f\u001e:jEV$X\rZ\"p[6\fg\u000e\u001a\u0006\u0003+\u0016\na\u0001P5oSRtD#A.\u0011\u0005q\u0003Q\"A\u0012\u0002\t9\fW.Z\u000b\u0002?B\u0011!\u0007Y\u0005\u0003CN\u0012aa\u0015;sS:<\u0017!\u00028b[\u0016\u0004\u0013A\u00029be\u0006l7/F\u0001f!\t1WD\u0004\u0002h59\u0011q\t[\u0005\u0003I\u0015\n\u0011$Q2dk6,Hn\u001c\"vY.LenZ3ti\u000e{W.\\1oIB\u0011AlG\n\u000371\u0004\"!\u001c9\u000e\u00039T\u0011a\\\u0001\u0006g\u000e\fG.Y\u0005\u0003c:\u0014a!\u00118z%\u00164G#\u00016\u00031\u0005\u001b7-^7vY>\u0014U\u000f\\6J]\u001e,7\u000f\u001e)be\u0006l7oE\u0007\u001eYV\f\t!!\u0003\u0002\u0012\u0005]\u0011Q\u0004\t\u0003mvt!a^>\u000f\u0005aThBA%z\u0013\t1\u0013&\u0003\u0002%y%\u0011ApO\u0001\u000e\u0013:<Wm\u001d;D_6l\u0017M\u001c3\n\u0005y|(\u0001D%oO\u0016\u001cH\u000fU1sC6\u001c(B\u0001?<!\u0011\t\u0019!!\u0002\u000e\u0003\u0015J1!a\u0002&\u0005]\t5mY;nk2|G)\u0019;b'R|'/\u001a)be\u0006l7\u000f\u0005\u0003\u0002\f\u00055Q\"\u0001\u001f\n\u0007\u0005=AHA\bPkR\u0004X\u000f\u001e)bi\"\u0004\u0016M]1n!\u0011\tY!a\u0005\n\u0007\u0005UAH\u0001\nPaRLwN\\1m\u0013:$W\r\u001f)be\u0006l\u0007\u0003BA\u0006\u00033I1!a\u0007=\u0005Yy\u0005\u000f^5p]\u0006d7)\u001d7GS2$XM\u001d)be\u0006l\u0007\u0003BA\u0006\u0003?I1!!\t=\u00055!V-\u001c9QCRD\u0007+\u0019:b[R\u0011\u0011Q\u0005\t\u0004\u0003OiR\"A\u000e\u0002\u0015M\\\u0017\u000e]%na>\u0014H/\u0006\u0002\u0002.A\u0019Q.a\f\n\u0007\u0005EbNA\u0004C_>dW-\u00198\u0002\u001dM\\\u0017\u000e]%na>\u0014Ho\u0018\u0013fcR!\u0011qGA\u001f!\ri\u0017\u0011H\u0005\u0004\u0003wq'\u0001B+oSRD\u0011\"a\u0010!\u0003\u0003\u0005\r!!\f\u0002\u0007a$\u0013'A\u0006tW&\u0004\u0018*\u001c9peR\u0004\u0003fC\u0011\u0002F\u0005e\u00131LA1\u0003G\u0002B!a\u0012\u0002V5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%\u0001\u0006kG>lW.\u00198eKJTA!a\u0014\u0002R\u0005)!-Z;ti*\u0011\u00111K\u0001\u0004G>l\u0017\u0002BA,\u0003\u0013\u0012\u0011\u0002U1sC6,G/\u001a:\u0002\u000b9\fW.Z:-\u0005\u0005u\u0013EAA0\u00035iSf]6ja6JW\u000e]8si\u0006YA-Z:de&\u0004H/[8oC\t\t)'A\u001dHK:,'/\u0019;fAQDW\r\t4jY\u0016\u001c\bEY;uAM\\\u0017\u000e\u001d\u0011uQ\u0016\u0004#-\u001e7lA%l\u0007o\u001c:uA%tGo\u001c\u0011BG\u000e,X.\u001e7pQ\u001di\u0012\u0011NA8\u0003c\u0002B!a\u0012\u0002l%!\u0011QNA%\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.\t\u0002\u0002t\u0005i4i\u001c8wKJ$\bE^1sS>,8\u000f\t4jY\u0016\u0004cm\u001c:nCR\u001c\b%\u001b8u_\u0002\u0012W\u000f\\6!Y>\fG-\u001a3!\u0003\u000e\u001cW/\\;m_\u0002\u0012f)\u001b7fg\u00069\u0001/\u0019:b[N\u0004\u0013aC:uCJ$\u0018J\\4fgR$B\"a\u001f\u0002\u0012\u0006-\u0016qVAf\u0003?\u0004B!! \u0002\f:!\u0011qPAC\u001d\rI\u0015\u0011Q\u0005\u0004\u0003\u0007K\u0013\u0001\u00026pENLA!a\"\u0002\n\u00069\u0001/Y2lC\u001e,'bAABS%!\u0011QRAH\u0005%\tu/Y5uC\ndWM\u0003\u0003\u0002\b\u0006%\u0005bBAJ\r\u0001\u0007\u0011QS\u0001\u0005[>$W\r\u0005\u0003\u0002\u0018\u0006\u0015f\u0002BAM\u0003?s1\u0001_AN\u0013\r\ti\nP\u0001\u0014\t&\u001cHO]5ckR,GMU;o!\u0006\u0014\u0018-\\\u0005\u0005\u0003C\u000b\u0019+\u0001\u0005Sk:lu\u000eZ3t\u0015\r\ti\nP\u0005\u0005\u0003O\u000bIKA\u0004Sk:lu\u000eZ3\u000b\t\u0005\u0005\u00161\u0015\u0005\u0007\u0003[3\u0001\u0019A \u0002\u0005\u0011\u001c\bbBAY\r\u0001\u0007\u00111W\u0001\u0004g\u001a$\b\u0003BA[\u0003\u000fl!!a.\u000b\t\u0005e\u00161X\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005u\u0016qX\u0001\bM\u0016\fG/\u001e:f\u0015\u0011\t\t-a1\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002F6\n\u0001bZ3pi>|Gn]\u0005\u0005\u0003\u0013\f9LA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016Dq!!4\u0007\u0001\u0004\ty-A\u0005d_:4XM\u001d;feB!\u0011\u0011[An\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006]\u0017AB2p]\u001aLwM\u0003\u0003\u0002Z\u0006E\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\n\t\u0005u\u00171\u001b\u0002\u0007\u0007>tg-[4\t\u000f\u0005\u0005h\u00011\u0001\u0002d\u00061\u0011N\u001c9viN\u00042A^As\u0013\r\t9o \u0002\u0007\u0013:\u0004X\u000f^:\u0003'\t+Hn[\"p]Z,'\u000f^3s\u0013:<Wm\u001d;\u0014\u0007\u001d\ti\u000fE\u0002;\u0003_L1!!=<\u0005I\u0019uN\u001c<feR,'/\u00138hKN$(j\u001c2\u0002\u0011\u0011\u001c\b+\u0019:b[N\u0004\u0002\"a>\u0002\u0000\n\u0015!Q\u0001\b\u0005\u0003s\fY\u0010\u0005\u0002M]&\u0019\u0011Q 8\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\tAa\u0001\u0003\u00075\u000b\u0007OC\u0002\u0002~:\u0004B!a>\u0003\b%\u0019\u0011Ma\u0001\u0002\u001f\r|gN^3si\u0016\u00148i\u001c8gS\u001e\fQ\u0001]1uQN\u0004bAa\u0004\u0003\u0018\t\u0015a\u0002\u0002B\t\u0005+q1\u0001\u0014B\n\u0013\u0005y\u0017bAAD]&!!\u0011\u0004B\u000e\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u000fs\u0017AB8viB,H\u000f\u0005\u0003\u0003\"\t=RB\u0001B\u0012\u0015\u0011\u0011)Ca\n\u0002\u0005\u0019\u001c(\u0002\u0002B\u0015\u0005W\ta\u0001[1e_>\u0004(b\u0001B\u0017[\u00051\u0011\r]1dQ\u0016LAA!\r\u0003$\t!\u0001+\u0019;i\u0003)!X-\u001c9PkR\u0004X\u000f\u001e\t\u0006[\n]\"qD\u0005\u0004\u0005sq'AB(qi&|g.\u0001\u0007nCb\u001c\u0006\u000f\\5u'&TX\rE\u0003n\u0005o\u0011y\u0004E\u0002n\u0005\u0003J1Aa\u0011o\u0005\rIe\u000e^\u0001\u0006S:$W\r\u001f\t\u0006[\n]\"QA\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#B7\u00038\t5\u0011\u0001\u00047jE*\f'o\u001d$jY\u0016\u001c\u0018\u0001\u00047jE*\f'o\u001d)bi\"\u001c\bC\u0002B\b\u0005'\u00129&\u0003\u0003\u0003V\tm!\u0001C%uKJ\fGo\u001c:\u0011\u000b5\u0014IF!\u0018\n\u0007\tmcNA\u0005Gk:\u001cG/[8oaA1!q\u0002B\f\u0005?\u0002BA!\u0019\u0003h5\u0011!1\r\u0006\u0004\u0005K*\u0014AA5p\u0013\u0011\u0011IGa\u0019\u0003\t\u0019KG.\u001a\u000b\u001b\u0005[\u0012\tHa\u001d\u0003v\t]$\u0011\u0010B>\u0005{\u0012yH!!\u0003\u0004\n\u0015%q\u0011\t\u0004\u0005_:Q\"\u0001\u0001\t\r\u00055F\u00031\u0001@\u0011\u001d\t\u0019\u0010\u0006a\u0001\u0003kDq!!-\u0015\u0001\u0004\t\u0019\fC\u0004\u0003\nQ\u0001\r!a4\t\u000f\t-A\u00031\u0001\u0003\u000e!9!Q\u0004\u000bA\u0002\t}\u0001b\u0002B\u001a)\u0001\u0007!Q\u0007\u0005\b\u0005w!\u0002\u0019\u0001B\u001f\u0011\u001d\u0011)\u0005\u0006a\u0001\u0005\u000fBqA!\u0013\u0015\u0001\u0004\u0011Y\u0005C\u0004\u0003NQ\u0001\rA!\u0004\t\u000f\t=C\u00031\u0001\u0003R\u00059A.\u001b2kCJ\u001cXC\u0001B\u0003\u0003-a\u0017N\u00196beN|F%Z9\u0015\t\u0005]\"\u0011\u0013\u0005\n\u0003\u007f1\u0012\u0011!a\u0001\u0005\u000b\t\u0001\u0002\\5cU\u0006\u00148\u000fI\u0001\rG>tg-[4ve\u0016TuN\u0019\u000b\u0005\u0003o\u0011I\nC\u0004\u0003\u001cb\u0001\rA!(\u0002\u0007)|'\r\u0005\u0003\u0003 \n\u0015VB\u0001BQ\u0015\u0011\u0011\u0019Ka\n\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002\u0002BT\u0005C\u00131AS8c\u0003\u0015\tw/Y5u)\u0011\u0011iKa-\u0011\t\u0005u$qV\u0005\u0005\u0005c\u000byIA\u0005K_\n\u0014Vm];mi\"9!QW\rA\u0002\t]\u0016\u0001\u0003:fa>\u0014H/\u001a:\u0011\t\u0005u$\u0011X\u0005\u0005\u0005w\u000byI\u0001\bTi\u0006$Xo]\"bY2\u0014\u0017mY6")
public class AccumuloBulkIngestCommand
implements IngestCommand<AccumuloDataStore>,
AccumuloDataStoreCommand.AccumuloDistributedCommand {
    private final String name;
    private final AccumuloBulkIngestParams params;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;

    @Override
    public /* synthetic */ Seq org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$AccumuloDistributedCommand$$super$libjarsFiles() {
        return IngestCommand.libjarsFiles$((IngestCommand)this);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$accumulo$tools$AccumuloDataStoreCommand$AccumuloDistributedCommand$$super$libjarsPaths() {
        return package.DistributedCommand.libjarsPaths$((package.DistributedCommand)this);
    }

    @Override
    public Seq<String> libjarsFiles() {
        return AccumuloDataStoreCommand.AccumuloDistributedCommand.libjarsFiles$(this);
    }

    @Override
    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return AccumuloDataStoreCommand.AccumuloDistributedCommand.libjarsPaths$(this);
    }

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand.connection$(this);
    }

    public void execute() {
        IngestCommand.execute$((IngestCommand)this);
    }

    public void setBackendSpecificOptions(SimpleFeatureType sft) {
        CreateSchemaCommand.SchemaOptionsCommand.setBackendSpecificOptions$((CreateSchemaCommand.SchemaOptionsCommand)this, (SimpleFeatureType)sft);
    }

    public Object console() {
        return package.InteractiveCommand.console$((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.setConsole$((package.InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq(String x$1) {
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public String name() {
        return this.name;
    }

    @Override
    public AccumuloBulkIngestParams params() {
        return this.params;
    }

    public package.Awaitable startIngest(Enumeration.Value mode, AccumuloDataStore ds, SimpleFeatureType sft, Config converter, IngestCommand.Inputs inputs) {
        None$ maxSplitSize = !this.params().combineInputs() ? None$.MODULE$ : Option$.MODULE$.apply((Object)this.params().maxSplitSize()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).orElse((Function0 & Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        Option index = this.params().loadIndex(ds, sft.getTypeName(), IndexMode$.MODULE$.Write()).map((Function1 & Serializable)x$2 -> x$2.identifier());
        Option partitions = TablePartition$.MODULE$.apply((package.HasGeoMesaMetadata)ds, sft).map((Function1 & Serializable)tp -> {
            if (this.params().cqlFilter() == null) {
                throw new ParameterException(new StringBuilder(134).append("Schema '").append(sft.getTypeName()).append("' is a partitioned store. In order to bulk load, the '--cql' parameter ").append("must be used to specify the range of the input data set").toString());
            }
            return (Seq)tp.partitions(this.params().cqlFilter()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty())).getOrElse((Function0 & Serializable)() -> {
                throw new ParameterException(new StringBuilder(116).append("Partition filter does not correspond to partition scheme ").append(tp.getClass().getSimpleName()).append(". Please specify ").append("a valid filter using the '--cql' parameter").toString());
            });
        });
        Enumeration.Value value = mode;
        Enumeration.Value value2 = DistributedRunParam.RunModes$.MODULE$.Local();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            throw new IllegalArgumentException("Bulk ingest must be run in distributed mode");
        }
        Enumeration.Value value4 = DistributedRunParam.RunModes$.MODULE$.Distributed();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            BoxedUnit boxedUnit;
            Object object;
            Configuration conf = new Configuration();
            Path output = new Path(this.params().outputPath());
            FileContext context = FileContext.getFileContext((URI)output.toUri(), (Configuration)conf);
            if (context.util().exists(output)) {
                BoxedUnit boxedUnit2;
                String warning = new StringBuilder(26).append("Output directory '").append(output).append("' exists").toString();
                if (this.params().force()) {
                    if (package.Command$.MODULE$.user().underlying().isWarnEnabled()) {
                        package.Command$.MODULE$.user().underlying().warn("{} - deleting it", (Object)warning);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                } else {
                    if (!Prompt$.MODULE$.confirm(new StringBuilder(58).append("WARNING DATA MAY BE LOST: ").append(warning).append(". Delete it and continue (y/n)? ").toString(), Prompt$.MODULE$.confirm$default$2(), this.console())) {
                        throw new ParameterException(new StringBuilder(26).append("Output directory '").append(output).append("' exists").toString());
                    }
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                object = BoxesRunTime.boxToBoolean((boolean)context.delete(output, true));
            } else {
                object = BoxedUnit.UNIT;
            }
            Option tempPath = Option$.MODULE$.apply((Object)this.params().tempPath()).map((Function1 & Serializable)temp -> {
                Object object;
                Path path = new Path(temp);
                FileContext tempContext = FileContext.getFileContext((URI)path.toUri(), (Configuration)conf);
                Path dir = tempContext.makeQualified(path);
                if (tempContext.util().exists(dir)) {
                    BoxedUnit boxedUnit;
                    if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                        package.Command$.MODULE$.user().underlying().info("Deleting temp output path {}", (Object)dir);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)tempContext.delete(dir, true));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return dir;
            });
            if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                package.Command$.MODULE$.user().underlying().info("Running bulk ingestion in distributed {}mode", (Object)(this.params().combineInputs() ? "combine " : ""));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new BulkConverterIngest(this, ds, this.connection(), sft, converter, (Seq<String>)inputs.paths(), output, (Option<Path>)tempPath, (Option<Object>)maxSplitSize, (Option<String>)index, (Option<Seq<String>>)partitions, this.libjarsFiles(), this.libjarsPaths());
        }
        throw new NotImplementedError(new StringBuilder(32).append("Missing implementation for mode ").append(mode).toString());
    }

    public AccumuloBulkIngestCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.$init$((package.InteractiveCommand)this);
        CreateSchemaCommand.SchemaOptionsCommand.$init$((CreateSchemaCommand.SchemaOptionsCommand)this);
        IngestCommand.$init$((IngestCommand)this);
        AccumuloDataStoreCommand.$init$(this);
        AccumuloDataStoreCommand.AccumuloDistributedCommand.$init$(this);
        this.name = "bulk-ingest";
        this.params = new AccumuloBulkIngestParams();
    }

    @Parameters(commandDescription="Convert various file formats into bulk loaded Accumulo RFiles")
    public static class AccumuloBulkIngestParams
    implements IngestCommand.IngestParams,
    AccumuloDataStoreParams,
    OutputPathParam,
    OptionalIndexParam,
    OptionalCqlFilterParam,
    TempPathParam {
        @Parameter(names={"--skip-import"}, description="Generate the files but skip the bulk import into Accumulo")
        private boolean skipImport;
        @Parameter(names={"--temp-path"}, description="Path to temp dir for writing output. Note that this may be useful when using s3 since it is slow as a sink", required=false)
        private String tempPath;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"--output"}, description="Path to use for writing output", required=true)
        private String outputPath;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;
        @Parameter(names={"-t", "--threads"}, description="Number of threads if using local ingest")
        private Integer threads;
        @Parameter(names={"--src-list"}, description="Input files are text files with lists of files, one per line, to ingest.")
        private boolean srcList;
        @Parameter(names={"--no-tracking"}, description="Return immediately after submitting ingest job (distributed jobs)")
        private boolean noWaitForCompletion;
        @Parameter(names={"--combine-inputs"}, description="Combine multiple input files into a single input split (distributed jobs)")
        private boolean combineInputs;
        @Parameter(names={"--split-max-size"}, description="Maximum size of a split in bytes (distributed jobs)")
        private Integer maxSplitSize;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private Option<Enumeration.Value> mode;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, auto-detection will be attempted")
        private String inputFormat;
        @Parameter(description="<file>...")
        private java.util.List<String> files;
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter")
        private String config;
        @Parameter(names={"--converter-error-mode"}, description="Override the converter error mode - 'log-errors' or 'raise-errors'", converter=ParameterConverters.ErrorModeConverter.class)
        private Enumeration.Value errorMode;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;
        private volatile boolean bitmap$0;

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.loadIndex$((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public boolean waitForCompletion() {
            return IngestCommand.IngestParams.waitForCompletion$((IngestCommand.IngestParams)this);
        }

        public String tempPath() {
            return this.tempPath;
        }

        public void tempPath_$eq(String x$1) {
            this.tempPath = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public String outputPath() {
            return this.outputPath;
        }

        public void outputPath_$eq(String x$1) {
            this.outputPath = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public boolean srcList() {
            return this.srcList;
        }

        public void srcList_$eq(boolean x$1) {
            this.srcList = x$1;
        }

        public boolean noWaitForCompletion() {
            return this.noWaitForCompletion;
        }

        public void noWaitForCompletion_$eq(boolean x$1) {
            this.noWaitForCompletion = x$1;
        }

        public boolean combineInputs() {
            return this.combineInputs;
        }

        public void combineInputs_$eq(boolean x$1) {
            this.combineInputs = x$1;
        }

        public Integer maxSplitSize() {
            return this.maxSplitSize;
        }

        public void maxSplitSize_$eq(Integer x$1) {
            this.maxSplitSize = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option<Enumeration.Value> mode$lzycompute() {
            AccumuloBulkIngestParams accumuloBulkIngestParams = this;
            synchronized (accumuloBulkIngestParams) {
                if (!this.bitmap$0) {
                    this.mode = DistributedRunParam.mode$((DistributedRunParam)this);
                    this.bitmap$0 = true;
                }
            }
            return this.mode;
        }

        public Option<Enumeration.Value> mode() {
            if (!this.bitmap$0) {
                return this.mode$lzycompute();
            }
            return this.mode;
        }

        public String inputFormat() {
            return this.inputFormat;
        }

        public void inputFormat_$eq(String x$1) {
            this.inputFormat = x$1;
        }

        public java.util.List<String> files() {
            return this.files;
        }

        public void files_$eq(java.util.List<String> x$1) {
            this.files = x$1;
        }

        public String config() {
            return this.config;
        }

        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        public Enumeration.Value errorMode() {
            return this.errorMode;
        }

        public void errorMode_$eq(Enumeration.Value x$1) {
            this.errorMode = x$1;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String spec() {
            return this.spec;
        }

        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public boolean skipImport() {
            return this.skipImport;
        }

        public void skipImport_$eq(boolean x$1) {
            this.skipImport = x$1;
        }

        public AccumuloBulkIngestParams() {
            OptionalTypeNameParam.$init$((OptionalTypeNameParam)this);
            OptionalFeatureSpecParam.$init$((OptionalFeatureSpecParam)this);
            OptionalForceParam.$init$((OptionalForceParam)this);
            ConverterConfigParam.$init$((ConverterConfigParam)this);
            InputFilesParam.$init$((InputFilesParam)this);
            OptionalInputFormatParam.$init$((OptionalInputFormatParam)this);
            DistributedRunParam.$init$((DistributedRunParam)this);
            DistributedCombineParam.$init$((DistributedCombineParam)this);
            IngestCommand.IngestParams.$init$((IngestCommand.IngestParams)this);
            ZookeepersParam.$init$(this);
            InstanceNameParams.$init$(this);
            PasswordParams.$init$((PasswordParams)this);
            CredentialsParams.$init$((CredentialsParams)this);
            KerberosParams.$init$((KerberosParams)this);
            AccumuloConnectionParams.$init$(this);
            CatalogParam.$init$((CatalogParam)this);
            OutputPathParam.$init$((OutputPathParam)this);
            OptionalIndexParam.$init$((OptionalIndexParam)this);
            OptionalCqlFilterParam.$init$((OptionalCqlFilterParam)this);
            TempPathParam.$init$((TempPathParam)this);
            this.skipImport = false;
        }
    }

    public class BulkConverterIngest
    extends ConverterIngestJob {
        private final AccumuloDataStore ds;
        private final Map<String, String> dsParams;
        private final SimpleFeatureType sft;
        private final Path output;
        private final Option<Path> tempOutput;
        private final Option<Object> maxSplitSize;
        private final Option<String> index;
        private final Option<Seq<String>> partitions;
        private String libjars;
        public final /* synthetic */ AccumuloBulkIngestCommand $outer;

        private String libjars() {
            return this.libjars;
        }

        private void libjars_$eq(String x$1) {
            this.libjars = x$1;
        }

        public void configureJob(Job job) {
            super.configureJob(job);
            Path dest = (Path)this.tempOutput.getOrElse((Function0 & Serializable)() -> $this.output);
            GeoMesaAccumuloFileOutputFormat$.MODULE$.configure(job, this.ds, this.dsParams, this.sft, dest, this.index, this.partitions);
            this.maxSplitSize.foreach((Function1)(JFunction1.mcVI.sp & Serializable)max -> {
                job.setInputFormatClass(ConverterCombineInputFormat.class);
                if (max > 0) {
                    FileInputFormat.setMaxInputSplitSize((Job)job, (long)max);
                    return;
                }
            });
            this.libjars_$eq(job.getConfiguration().get("tmpjars"));
        }

        public package.JobResult await(package.StatusCallback reporter) {
            return super.await(reporter).merge((Function0 & Serializable)() -> $this.tempOutput.map((Function1 & Serializable)dir -> {
                reporter.reset();
                Configuration conf = new Configuration();
                conf.set("tmpjars", this.libjars());
                package.JobResult jobResult = new DistributedCopy(conf).copy((Seq)new .colon.colon(dir, (List)Nil$.MODULE$), $this.output, reporter);
                if (jobResult instanceof package.JobResult$.JobSuccess) {
                    BoxedUnit boxedUnit;
                    package.JobResult$.JobSuccess jobSuccess = (package.JobResult$.JobSuccess)jobResult;
                    String message = jobSuccess.message();
                    Map counts = jobSuccess.counts();
                    if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                        package.Command$.MODULE$.user().underlying().info(message);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return new package.JobResult$.JobSuccess("", counts);
                }
                return jobResult;
            })).merge((Function0 & Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$$outer().params().skipImport()) {
                    BoxedUnit boxedUnit2;
                    if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                        package.Command$.MODULE$.user().underlying().info("Skipping import of RFiles into Accumulo");
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                        package.Command$.MODULE$.user().underlying().info("Files may be imported for each table through the Accumulo shell with the `importdirectory` command");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    BoxedUnit boxedUnit3;
                    if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                        package.Command$.MODULE$.user().underlying().info("Importing RFiles into Accumulo");
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    TableOperations tableOps = $this.ds.connector().tableOperations();
                    Path filesPath = new Path($this.output, GeoMesaAccumuloFileOutputFormat$.MODULE$.FilesPath());
                    FileContext fc = FileContext.getFileContext((URI)filesPath.toUri(), (Configuration)new Configuration());
                    RemoteIterator files = fc.listLocatedStatus(filesPath);
                    while (files.hasNext()) {
                        BoxedUnit boxedUnit4;
                        LocatedFileStatus file = (LocatedFileStatus)files.next();
                        Path path = file.getPath();
                        String table = path.getName();
                        if (!file.isDirectory() || !HadoopDelegate$.MODULE$.HiddenFileFilter().accept(path) || !tableOps.exists(table)) continue;
                        if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                            package.Command$.MODULE$.user().underlying().info("Importing {}", (Object)table);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        tableOps.importDirectory(path.toString()).to(table).load();
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                return None$.MODULE$;
            });
        }

        public /* synthetic */ AccumuloBulkIngestCommand org$locationtech$geomesa$accumulo$tools$ingest$AccumuloBulkIngestCommand$BulkConverterIngest$$$outer() {
            return this.$outer;
        }

        public BulkConverterIngest(AccumuloBulkIngestCommand $outer, AccumuloDataStore ds, Map<String, String> dsParams, SimpleFeatureType sft, Config converterConfig, Seq<String> paths, Path output, Option<Path> tempOutput, Option<Object> maxSplitSize, Option<String> index, Option<Seq<String>> partitions, Seq<String> libjarsFiles, Iterator<Function0<Seq<File>>> libjarsPaths) {
            this.ds = ds;
            this.dsParams = dsParams;
            this.sft = sft;
            this.output = output;
            this.tempOutput = tempOutput;
            this.maxSplitSize = maxSplitSize;
            this.index = index;
            this.partitions = partitions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dsParams, sft, converterConfig, paths, libjarsFiles, libjarsPaths);
        }
    }
}

