/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.accumulo.tools.stats;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.Closeable;
import java.io.Serializable;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.accumulo.combiners.StatsCombiner$;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.accumulo.tools.AccumuloConnectionParams;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreCommand;
import org.locationtech.geomesa.accumulo.tools.AccumuloDataStoreParams;
import org.locationtech.geomesa.accumulo.tools.InstanceNameParams;
import org.locationtech.geomesa.accumulo.tools.ZookeepersParam;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.CredentialsParams;
import org.locationtech.geomesa.tools.KerberosParams;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.stats.StatsConfigureCommand;
import org.locationtech.geomesa.tools.utils.Prompt$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\u0007\u000e\u0001iAQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013\u0005\u0003\b\u0003\u0004v\u0001\u0001\u0006I!\u000f\u0005\u0006m\u0002!\tf\u001e\u0005\u0006{\u0002!\tF \u0005\b\u0003\u0003\u0001A\u0011KA\u0002\u000f\u0015QU\u0002#\u0001L\r\u0015aQ\u0002#\u0001M\u0011\u0015\u0019\u0004\u0002\"\u0001T\r\u0011!\u0006\u0002A+\t\u000bMRA\u0011\u00013\u0003;\u0005\u001b7-^7vY>\u001cF/\u0019;t\u0007>tg-[4ve\u0016\u001cu.\\7b]\u0012T!AD\b\u0002\u000bM$\u0018\r^:\u000b\u0005A\t\u0012!\u0002;p_2\u001c(B\u0001\n\u0014\u0003!\t7mY;nk2|'B\u0001\u000b\u0016\u0003\u001d9Wm\\7fg\u0006T!AF\f\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u000e$_A\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005Y\u0006twMC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"AB(cU\u0016\u001cG\u000fE\u0002%O%j\u0011!\n\u0006\u0003\u001d\u0019R!\u0001E\n\n\u0005!*#!F*uCR\u001c8i\u001c8gS\u001e,(/Z\"p[6\fg\u000e\u001a\t\u0003U5j\u0011a\u000b\u0006\u0003YE\tA\u0001Z1uC&\u0011af\u000b\u0002\u0012\u0003\u000e\u001cW/\\;m_\u0012\u000bG/Y*u_J,\u0007C\u0001\u00192\u001b\u0005y\u0011B\u0001\u001a\u0010\u0005a\t5mY;nk2|G)\u0019;b'R|'/Z\"p[6\fg\u000eZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0002\"A\u000e\u0001\u000e\u00035\ta\u0001]1sC6\u001cX#A\u001d\u0011\u0005iRaBA\u001e\b\u001d\ta\u0014J\u0004\u0002>\u0011:\u0011ah\u0012\b\u0003\u007f\u0019s!\u0001Q#\u000f\u0005\u0005#U\"\u0001\"\u000b\u0005\rK\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\t1r#\u0003\u0002\u0015+%\u0011!cE\u0005\u0003!EI!AD\b\u0002;\u0005\u001b7-^7vY>\u001cF/\u0019;t\u0007>tg-[4ve\u0016\u001cu.\\7b]\u0012\u0004\"A\u000e\u0005\u0014\u0005!i\u0005C\u0001(R\u001b\u0005y%\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{%AB!osJ+g\rF\u0001L\u0005q\t5mY;nk2|7\u000b^1ug\u000e{gNZ5hkJ,\u0007+\u0019:b[N\u001cBAC'WCB\u0011qK\u0018\b\u00031rs!!W.\u000f\u0005yR\u0016B\u0001\t\u0014\u0013\tqa%\u0003\u0002^K\u0005)2\u000b^1ug\u000e{gNZ5hkJ,7i\\7nC:$\u0017BA0a\u0005Q\u0019F/\u0019;t\u0007>tg-[4ve\u0016\u0004\u0016M]1ng*\u0011Q,\n\t\u0003a\tL!aY\b\u0003/\u0005\u001b7-^7vY>$\u0015\r^1Ti>\u0014X\rU1sC6\u001cH#A3\u0011\u0005\u0019TQ\"\u0001\u0005)\t)A'o\u001d\t\u0003SBl\u0011A\u001b\u0006\u0003W2\f!B[2p[6\fg\u000eZ3s\u0015\tig.A\u0003cKV\u001cHOC\u0001p\u0003\r\u0019w.\\\u0005\u0003c*\u0014!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0003Q\f1IV5fo2\u0002\u0013\r\u001a3!_J\u0004#/Z7pm\u0016\u0004\u0013iY2v[Vdw\u000eI:uCR\u001c\beY8nE&t\u0017N\\4!SR,'/\u0019;pe\u00022wN\u001d\u0011bA\r\fG/\u00197pO\u00069\u0001/\u0019:b[N\u0004\u0013\u0001\u00027jgR$\"\u0001_>\u0011\u00059K\u0018B\u0001>P\u0005\u0011)f.\u001b;\t\u000bq$\u0001\u0019A\u0015\u0002\u0005\u0011\u001c\u0018aA1eIR\u0011\u0001p \u0005\u0006y\u0016\u0001\r!K\u0001\u0007e\u0016lwN^3\u0015\u0007a\f)\u0001C\u0003}\r\u0001\u0007\u0011\u0006")
public class AccumuloStatsConfigureCommand
implements StatsConfigureCommand<AccumuloDataStore>,
AccumuloDataStoreCommand {
    private final AccumuloStatsConfigureParams params;
    private String name;

    @Override
    public Map<String, String> connection() {
        return AccumuloDataStoreCommand.connection$(this);
    }

    public void execute() {
        StatsConfigureCommand.execute$((StatsConfigureCommand)this);
    }

    public <T> T withDataStore(Function1<AccumuloDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$stats$StatsConfigureCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    @Override
    public AccumuloStatsConfigureParams params() {
        return this.params;
    }

    public void list(AccumuloDataStore ds) {
        BoxedUnit boxedUnit;
        Iterable configured = (Iterable)StatsCombiner$.MODULE$.list(ds.connector(), new StringBuilder(6).append(ds.config().catalog()).append("_stats").toString()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(4).append(k).append(" -> ").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        });
        if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.user().underlying().info("Configured stats iterator: {}", (Object)configured.mkString("\n  ", "\n  ", ""));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void add(AccumuloDataStore ds) {
        BoxedUnit boxedUnit;
        try (Closeable lock = ds.acquireCatalogLock();){
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames()), (Function1 & Serializable)typeName -> ds.getSchema(typeName), ClassTag$.MODULE$.apply(SimpleFeatureType.class))), (Function1 & Serializable)sft -> {
                AccumuloStatsConfigureCommand.$anonfun$add$2(ds, sft);
                return BoxedUnit.UNIT;
            });
        }
        if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.user().underlying().info("done");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void remove(AccumuloDataStore ds) {
        Object x$3;
        List x$2;
        String x$1 = new StringBuilder(70).append("Removing stats iterator configuration for catalog '").append(ds.config().catalog()).append("'. ").append("Continue (y/n)? ").toString();
        boolean confirm = Prompt$.MODULE$.confirm(x$1, x$2 = Prompt$.MODULE$.confirm$default$2(), x$3 = Prompt$.MODULE$.confirm$default$3(x$1, x$2));
        if (confirm) {
            BoxedUnit boxedUnit;
            try (Closeable lock = ds.acquireCatalogLock();){
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames()), (Function1 & Serializable)typeName -> ds.getSchema(typeName), ClassTag$.MODULE$.apply(SimpleFeatureType.class))), (Function1 & Serializable)sft -> {
                    AccumuloStatsConfigureCommand.$anonfun$remove$2(ds, sft);
                    return BoxedUnit.UNIT;
                });
            }
            if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                package.Command$.MODULE$.user().underlying().info("done");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$add$2(AccumuloDataStore ds$1, SimpleFeatureType sft) {
        BoxedUnit boxedUnit;
        if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.user().underlying().info("Configuring stats iterator for '{}'...", (Object)sft.getTypeName());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ds$1.adapter().ensureTableExists(ds$1.stats().metadata().table(), ds$1.adapter().ensureTableExists$default$2());
        ds$1.stats().configureStatCombiner(ds$1.connector(), sft);
    }

    public static final /* synthetic */ void $anonfun$remove$2(AccumuloDataStore ds$2, SimpleFeatureType sft) {
        BoxedUnit boxedUnit;
        if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.user().underlying().info("Removing stats iterator for '{}'...", (Object)sft.getTypeName());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ds$2.stats().removeStatCombiner(ds$2.connector(), sft);
    }

    public AccumuloStatsConfigureCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        StatsConfigureCommand.$init$((StatsConfigureCommand)this);
        AccumuloDataStoreCommand.$init$(this);
        this.params = new AccumuloStatsConfigureParams();
        Statics.releaseFence();
    }

    @Parameters(commandDescription="View, add or remove Accumulo stats combining iterator for a catalog")
    public static class AccumuloStatsConfigureParams
    implements StatsConfigureCommand.StatsConfigureParams,
    AccumuloDataStoreParams {
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--auths"}, description="Accumulo authorizations")
        private String auths;
        @Parameter(names={"--keytab"}, description="Path to Kerberos keytab file")
        private String keytab;
        @Parameter(names={"-u", "--user"}, description="Connection user name")
        private String user;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-i", "--instance"}, description="Accumulo instance name")
        private String instance;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"--zookeepers-timeout"}, description="Zookeepers timeout")
        private String zkTimeout;
        @Parameter(names={"-l", "--list"}, description="List current stats table configuration for a catalog")
        private boolean list;
        @Parameter(names={"-a", "--add"}, description="Configure the stats table for a catalog")
        private boolean add;
        @Parameter(names={"-r", "--remove"}, description="Remove current stats table configuration for a catalog")
        private boolean remove;

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String keytab() {
            return this.keytab;
        }

        public void keytab_$eq(String x$1) {
            this.keytab = x$1;
        }

        public String user() {
            return this.user;
        }

        public void user_$eq(String x$1) {
            this.user = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        @Override
        public String instance() {
            return this.instance;
        }

        @Override
        public void instance_$eq(String x$1) {
            this.instance = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkTimeout() {
            return this.zkTimeout;
        }

        @Override
        public void zkTimeout_$eq(String x$1) {
            this.zkTimeout = x$1;
        }

        public boolean list() {
            return this.list;
        }

        public void list_$eq(boolean x$1) {
            this.list = x$1;
        }

        public boolean add() {
            return this.add;
        }

        public void add_$eq(boolean x$1) {
            this.add = x$1;
        }

        public boolean remove() {
            return this.remove;
        }

        public void remove_$eq(boolean x$1) {
            this.remove = x$1;
        }

        public AccumuloStatsConfigureParams() {
            StatsConfigureCommand.StatsConfigureParams.$init$((StatsConfigureCommand.StatsConfigureParams)this);
            ZookeepersParam.$init$(this);
            InstanceNameParams.$init$(this);
            PasswordParams.$init$((PasswordParams)this);
            CredentialsParams.$init$((CredentialsParams)this);
            KerberosParams.$init$((KerberosParams)this);
            AccumuloConnectionParams.$init$(this);
            CatalogParam.$init$((CatalogParam)this);
        }
    }
}

