/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Parameter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.text.Text;
import org.geotools.util.Converters;
import org.geotools.util.KVP;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class InterpolateFunction
implements Function {
    private static final Logger LOGGER = Logger.getLogger(InterpolateFunction.class.getName());
    private static final FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2(null);
    private static final double EPS = 1.0E-8;
    public static final String MODE_LINEAR = "linear";
    public static final String MODE_COSINE = "cosine";
    public static final String MODE_CUBIC = "cubic";
    public static final String METHOD_NUMERIC = "numeric";
    public static final String METHOD_COLOR = "color";
    private static final String METHOD_COLOUR = "colour";
    private Mode mode;
    private boolean modeSpecified;
    private Method method;
    private boolean methodSpecified;
    private List<InterpPoint> interpPoints;
    public static final String RASTER_DATA = "Rasterdata";
    private final List<Expression> parameters;
    private final Literal fallback;
    public static final FunctionName NAME;

    public InterpolateFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public InterpolateFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return "Interpolate";
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Object.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        this.initialize();
        if (this.method == Method.NUMERIC && Color.class.isAssignableFrom(context)) {
            throw new IllegalArgumentException("Trying to evaluate the function as Color but the method parameter is set as NUMERIC");
        }
        if (this.method == Method.COLOR && !Color.class.isAssignableFrom(context)) {
            throw new IllegalArgumentException("Trying to evaluate the function as " + context.getSimpleName() + " but the method parameter is set as COLOR");
        }
        Expression lookup = this.parameters.get(0);
        Double lookupValue = null;
        String lookupString = (String)lookup.evaluate(object, String.class);
        lookupValue = lookupString.equalsIgnoreCase(RASTER_DATA) ? Double.valueOf(((Number)object).doubleValue()) : Double.valueOf(lookupString);
        if (this.interpPoints.size() == 1) {
            return (T)this.interpPoints.get((int)0).value.evaluate(object, context);
        }
        int segment = this.findSegment(lookupValue, object);
        if (segment <= 0) {
            return (T)this.interpPoints.get((int)0).value.evaluate(object, context);
        }
        if (segment >= this.interpPoints.size()) {
            return (T)this.interpPoints.get((int)(this.interpPoints.size() - 1)).value.evaluate(object, context);
        }
        switch (this.mode) {
            case COSINE: {
                return this.cosineInterpolate(lookupValue, object, segment, context);
            }
            case CUBIC: {
                return this.cubicInterpolate(lookupValue, object, segment, context);
            }
        }
        return this.linearInterpolate(lookupValue, object, segment, context);
    }

    private <T> T linearInterpolate(Double lookupValue, Object object, int segment, Class<T> context) {
        if (segment < 1 || segment >= this.interpPoints.size()) {
            throw new IllegalArgumentException("segment index outside valid range");
        }
        Double data1 = (Double)this.interpPoints.get((int)segment).data.evaluate(object, Double.class);
        Double data0 = (Double)this.interpPoints.get((int)(segment - 1)).data.evaluate(object, Double.class);
        if (this.method == Method.COLOR) {
            Color color1 = (Color)this.interpPoints.get((int)segment).value.evaluate(object, Color.class);
            Color color0 = (Color)this.interpPoints.get((int)(segment - 1)).value.evaluate(object, Color.class);
            int r = (int)this.clamp(Math.round(this.doLinear(lookupValue, data0, data1, color0.getRed(), color1.getRed())), 0.0, 255.0);
            int g = (int)this.clamp(Math.round(this.doLinear(lookupValue, data0, data1, color0.getGreen(), color1.getGreen())), 0.0, 255.0);
            int b = (int)this.clamp(Math.round(this.doLinear(lookupValue, data0, data1, color0.getBlue(), color1.getBlue())), 0.0, 255.0);
            return (T)new Color(r, g, b);
        }
        Double value1 = (Double)this.interpPoints.get((int)segment).value.evaluate(object, Double.class);
        Double value0 = (Double)this.interpPoints.get((int)(segment - 1)).value.evaluate(object, Double.class);
        double interpolated = this.doLinear(lookupValue, data0, data1, value0, value1);
        return Converters.convert(interpolated, context);
    }

    private <T> T cosineInterpolate(Double lookupValue, Object object, int segment, Class<T> context) {
        if (segment < 1 || segment >= this.interpPoints.size()) {
            throw new IllegalArgumentException("segment index outside valid range");
        }
        Double data1 = (Double)this.interpPoints.get((int)segment).data.evaluate(object, Double.class);
        Double data0 = (Double)this.interpPoints.get((int)(segment - 1)).data.evaluate(object, Double.class);
        if (this.method == Method.COLOR) {
            Color color1 = (Color)this.interpPoints.get((int)segment).value.evaluate(object, Color.class);
            Color color0 = (Color)this.interpPoints.get((int)(segment - 1)).value.evaluate(object, Color.class);
            int r = (int)this.clamp(Math.round(this.doCosine(lookupValue, data0, data1, color0.getRed(), color1.getRed())), 0.0, 255.0);
            int g = (int)this.clamp(Math.round(this.doCosine(lookupValue, data0, data1, color0.getGreen(), color1.getGreen())), 0.0, 255.0);
            int b = (int)this.clamp(Math.round(this.doCosine(lookupValue, data0, data1, color0.getBlue(), color1.getBlue())), 0.0, 255.0);
            return (T)new Color(r, g, b);
        }
        Double value1 = (Double)this.interpPoints.get((int)segment).value.evaluate(object, Double.class);
        Double value0 = (Double)this.interpPoints.get((int)(segment - 1)).value.evaluate(object, Double.class);
        double interpolated = this.doCosine(lookupValue, data0, data1, value0, value1);
        return Converters.convert(interpolated, context);
    }

    private <T> T cubicInterpolate(Double lookupValue, Object object, int segment, Class<T> context) {
        int k;
        double data1;
        double data0;
        if (segment < 1 || segment >= this.interpPoints.size()) {
            throw new IllegalArgumentException("segment index outside valid range");
        }
        double[] xi = new double[4];
        double[] yi = new double[4];
        ArrayList<InterpPoint> workingPoints = new ArrayList<InterpPoint>(this.interpPoints);
        if (segment == 1) {
            data0 = (Double)((InterpPoint)workingPoints.get((int)0)).data.evaluate(object, Double.class);
            data1 = (Double)((InterpPoint)workingPoints.get((int)1)).data.evaluate(object, Double.class);
            workingPoints.add(0, new InterpPoint((Expression)ff2.literal(2.0 * data0 - data1), ((InterpPoint)workingPoints.get((int)0)).value));
            ++segment;
        } else if (segment == this.interpPoints.size() - 1) {
            data0 = (Double)((InterpPoint)workingPoints.get((int)segment)).data.evaluate(object, Double.class);
            data1 = (Double)((InterpPoint)workingPoints.get((int)(segment - 1))).data.evaluate(object, Double.class);
            workingPoints.add(new InterpPoint((Expression)ff2.literal(2.0 * data0 - data1), ((InterpPoint)workingPoints.get((int)segment)).value));
        }
        int i = segment - 2;
        for (k = 0; k < 4; ++k) {
            xi[k] = (Double)((InterpPoint)workingPoints.get((int)i)).data.evaluate(object, Double.class);
            ++i;
        }
        if (this.method == Method.COLOR) {
            Color[] ci = new Color[4];
            int i2 = segment - 2;
            for (int k2 = 0; k2 < 4; ++k2) {
                ci[k2] = (Color)((InterpPoint)workingPoints.get((int)i2)).value.evaluate(object, Color.class);
                ++i2;
            }
            for (i2 = 0; i2 < 4; ++i2) {
                yi[i2] = ci[i2].getRed();
            }
            int r = (int)this.clamp(Math.round(this.doCubic(lookupValue, xi, yi)), 0.0, 255.0);
            for (int i3 = 0; i3 < 4; ++i3) {
                yi[i3] = ci[i3].getGreen();
            }
            int g = (int)this.clamp(Math.round(this.doCubic(lookupValue, xi, yi)), 0.0, 255.0);
            for (int i4 = 0; i4 < 4; ++i4) {
                yi[i4] = ci[i4].getBlue();
            }
            int b = (int)this.clamp(Math.round(this.doCubic(lookupValue, xi, yi)), 0.0, 255.0);
            return (T)new Color(r, g, b);
        }
        i = segment - 2;
        for (k = 0; k < 4; ++k) {
            yi[k] = (Double)((InterpPoint)workingPoints.get((int)i)).value.evaluate(object, Double.class);
            ++i;
        }
        double interpolated = this.doCubic(lookupValue, xi, yi);
        return Converters.convert(interpolated, context);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    private void initialize() {
        this.setMode();
        this.setMethod();
        int numControlParameters = (this.modeSpecified ? 1 : 0) + (this.methodSpecified ? 1 : 0);
        int numInterpolationParmaters = this.parameters.size() - numControlParameters - 1;
        if (numInterpolationParmaters < 2) {
            throw new IllegalArgumentException("Need at least one interpolation point");
        }
        if (numInterpolationParmaters % 2 != 0) {
            throw new IllegalArgumentException("Missing data or value in interpolation points ?");
        }
        List<Expression> sub = this.parameters.subList(1, this.parameters.size() - numControlParameters);
        this.interpPoints = new ArrayList<InterpPoint>();
        for (int i = 0; i < numInterpolationParmaters; i += 2) {
            this.interpPoints.add(new InterpPoint(sub.get(i), sub.get(i + 1)));
        }
        if (this.mode == Mode.CUBIC && this.interpPoints.size() < 3) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Cubic interpolation requested but not enoughpoints supplied. Falling back to linear interpolation");
            }
            this.mode = Mode.LINEAR;
        }
    }

    private void setMode() {
        boolean specified = false;
        int n = this.parameters.size();
        for (int i = 2; i >= 1 && !specified; --i) {
            Expression expr;
            int index = n - i;
            if (index <= 1 || !((expr = this.parameters.get(index)) instanceof Literal) || !(((Literal)expr).getValue() instanceof String)) continue;
            String value = (String)((Literal)expr).getValue();
            if (value.equalsIgnoreCase(MODE_LINEAR)) {
                this.mode = Mode.LINEAR;
                specified = true;
                continue;
            }
            if (value.equalsIgnoreCase(MODE_COSINE)) {
                this.mode = Mode.COSINE;
                specified = true;
                continue;
            }
            if (!value.equalsIgnoreCase(MODE_CUBIC)) continue;
            this.mode = Mode.CUBIC;
            specified = true;
        }
        if (!specified) {
            this.mode = Mode.LINEAR;
        }
        this.modeSpecified = specified;
    }

    private void setMethod() {
        boolean specified = false;
        int n = this.parameters.size();
        for (int i = 2; i >= 1 && !specified; --i) {
            Expression expr;
            int index = n - i;
            if (index <= 1 || !((expr = this.parameters.get(index)) instanceof Literal) || !(((Literal)expr).getValue() instanceof String)) continue;
            String value = (String)((Literal)expr).getValue();
            if (value.equalsIgnoreCase(METHOD_NUMERIC)) {
                this.method = Method.NUMERIC;
                specified = true;
                continue;
            }
            if (!value.equalsIgnoreCase(METHOD_COLOR) && !value.equalsIgnoreCase(METHOD_COLOUR)) continue;
            this.method = Method.COLOR;
            specified = true;
        }
        if (!specified) {
            this.method = Method.NUMERIC;
        }
        this.methodSpecified = specified;
    }

    private int findSegment(Double lookupValue, Object object) {
        int segment = this.interpPoints.size();
        for (int i = 0; i < this.interpPoints.size(); ++i) {
            Double data = (Double)this.interpPoints.get((int)i).data.evaluate(object, Double.class);
            if (!(lookupValue <= data)) continue;
            segment = i;
            break;
        }
        return segment;
    }

    private double doLinear(double x, double x0, double x1, double y0, double y1) {
        double xspan = this.getSpan(x0, x1);
        double t = (x - x0) / xspan;
        return y0 + t * (y1 - y0);
    }

    private double doCosine(double x, double x0, double x1, double y0, double y1) {
        double xspan = this.getSpan(x0, x1);
        double t = (x - x0) / xspan;
        double tcos = 0.5 * (1.0 - Math.cos(t * Math.PI));
        return y0 + tcos * (y1 - y0);
    }

    private double doCubic(double x, double[] xi, double[] yi) {
        double span12 = this.getSpan(xi[1], xi[2]);
        double t = (x - xi[1]) / span12;
        if (t < 1.0E-8) {
            return yi[1];
        }
        if (1.0 - t < 1.0E-8) {
            return yi[2];
        }
        double span01 = this.getSpan(xi[0], xi[1]);
        double span23 = this.getSpan(xi[2], xi[3]);
        double t2 = t * t;
        double t3 = t2 * t;
        double m1 = 0.5 * ((yi[2] - yi[1]) / span12 + (yi[1] - yi[0]) / span01);
        double m2 = 0.5 * ((yi[3] - yi[2]) / span23 + (yi[2] - yi[1]) / span12);
        double y = (2.0 * t3 - 3.0 * t2 + 1.0) * yi[1] + (t3 - 2.0 * t2 + t) * span12 * m1 + (-2.0 * t3 + 3.0 * t2) * yi[2] + (t3 - t2) * span12 * m2;
        return y;
    }

    private double getSpan(double x0, double x1) {
        double xspan = x1 - x0;
        if (xspan < 1.0E-8) {
            throw new IllegalArgumentException("Interpolation points must be in ascending order of data (lookup) values with no ties");
        }
        return xspan;
    }

    private double clamp(double x, double min, double max) {
        return Math.max(min, Math.min(max, x));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        List<Expression> params = this.getParameters();
        if (params != null) {
            Iterator<Expression> it = params.iterator();
            while (it.hasNext()) {
                Expression exp = it.next();
                sb.append("[");
                sb.append(exp);
                sb.append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    static {
        Parameter<Object> lookup = new Parameter<Object>("lookup", Object.class, 1, 1);
        Parameter<Object> table = new Parameter<Object>("data value pairs", Object.class, 4, -1);
        Parameter<String> mode = new Parameter<String>("mode", String.class, Text.text((String)"mode"), Text.text((String)"linear, cosine or cubic"), true, 1, 1, MODE_LINEAR, (Map<String, Object>)new KVP(new Object[]{"options", Arrays.asList(MODE_LINEAR, MODE_COSINE, MODE_CUBIC)}));
        Parameter<String> method = new Parameter<String>("method", String.class, Text.text((String)"method"), Text.text((String)"numeric or color"), false, 0, 1, METHOD_NUMERIC, (Map<String, Object>)new KVP(new Object[]{"options", Arrays.asList(METHOD_NUMERIC, METHOD_COLOR)}));
        NAME = new FunctionNameImpl("Interpolate", lookup, table, mode, method);
    }

    private static class InterpPoint {
        Expression data;
        Expression value;

        public InterpPoint(Expression data, Expression value) {
            this.data = data;
            this.value = value;
        }
    }

    private static enum Method {
        NUMERIC,
        COLOR;

    }

    private static enum Mode {
        LINEAR,
        COSINE,
        CUBIC;

    }
}

