/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001=\u0011Q\u0002T8dC2$U\r\\3hCR,'BA\u0002\u0005\u0003\t17O\u0003\u0002\u0006\r\u0005\u0011\u0011n\u001c\u0006\u0003\u000f!\tQ!\u001e;jYNT!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\u0002$D\u0001\u0003\u0013\tI\"A\u0001\nGS2,7+_:uK6$U\r\\3hCR,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\t9\u0002\u0001C\u0003 \u0001\u0011\u0005\u0003%A\u0007j]R,'\u000f\u001d:fiB\u000bG\u000f\u001b\u000b\u0003C\u0001\u00032A\t\u0016.\u001d\t\u0019\u0003F\u0004\u0002%O5\tQE\u0003\u0002'\u001d\u00051AH]8pizJ\u0011aE\u0005\u0003SI\tq\u0001]1dW\u0006<W-\u0003\u0002,Y\t\u00191+Z9\u000b\u0005%\u0012\u0002C\u0001\u0018>\u001d\ty3H\u0004\u00021u9\u0011\u0011'\u000f\b\u0003ear!aM\u001c\u000f\u0005Q2dB\u0001\u00136\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!\u0001\u0010\u0002\u0002%\u0019KG.Z*zgR,W\u000eR3mK\u001e\fG/Z\u0005\u0003}}\u0012!BR5mK\"\u000bg\u000e\u001a7f\u0015\ta$\u0001C\u0003B=\u0001\u0007!)\u0001\u0003qCRD\u0007CA\"G\u001d\t\tB)\u0003\u0002F%\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)%cB\u0003K\u0005!\u00051*A\u0007M_\u000e\fG\u000eR3mK\u001e\fG/\u001a\t\u0003/13Q!\u0001\u0002\t\u00025\u001b\"\u0001\u0014\t\t\u000bmaE\u0011A(\u0015\u0003-3A!\u0015'\u0001%\nyAj\\2bY\u001aKG.\u001a%b]\u0012dWmE\u0002Q!5B\u0001\u0002\u0016)\u0003\u0002\u0003\u0006I!V\u0001\u0005M&dW\r\u0005\u0002W56\tqK\u0003\u0002\u00061*\t\u0011,\u0001\u0003kCZ\f\u0017BA.X\u0005\u00111\u0015\u000e\\3\t\u000bm\u0001F\u0011A/\u0015\u0005y\u0003\u0007CA0Q\u001b\u0005a\u0005\"\u0002+]\u0001\u0004)\u0006\"B!Q\t\u0003\u0012W#\u0001\"\t\u000b\u0011\u0004F\u0011I3\u0002\r1,gn\u001a;i+\u00051\u0007CA\th\u0013\tA'C\u0001\u0003M_:<\u0007\"\u00026Q\t\u0003Z\u0017\u0001B8qK:,\u0012\u0001\u001c\t\u0003-6L!A\\,\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0004\u0005a2\u0003\u0011OA\u0006Ti\u0012Le\u000eS1oI2,7cA8\u0011[!)1d\u001cC\u0001gR\tA\u000f\u0005\u0002`_\")\u0011i\u001cC!E\")Am\u001cC!K\")!n\u001cC!W\u001e)\u0011\u0010\u0014E\u0001u\u0006Y1\u000b\u001e3J]\"\u000bg\u000e\u001a7f!\ty6PB\u0003q\u0019\"\u0005Ap\u0005\u0002|!!)1d\u001fC\u0001}R\t!\u0010C\u0004\u0002\u0002m$\t!a\u0001\u0002\u0013\u00054\u0018-\u001b7bE2,GCAA\u0003!\u0011\t\u0012qA\u0017\n\u0007\u0005%!C\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u001bYH\u0011AA\b\u0003-I7/\u0011<bS2\f'\r\\3\u0016\u0005\u0005E\u0001cA\t\u0002\u0014%\u0019\u0011Q\u0003\n\u0003\u000f\t{w\u000e\\3b]\u0002")
public class LocalDelegate
implements FileSystemDelegate {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        Tuple2 tuple22;
        Seq seq;
        int firstWildcard = path.indexOf(42);
        if (firstWildcard == -1) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalFileHandle[]{new LocalFileHandle(new File(path))}));
            return seq;
        }
        int lastSep = path.length() - 1 - ((String)new StringOps(Predef$.MODULE$.augmentString(path)).reverse()).indexOf(47, path.length() - firstWildcard - 1);
        Tuple2 tuple2 = lastSep == path.length() ? new Tuple2((Object)new File(".").toPath(), (Object)path) : new Tuple2((Object)new File(path.substring(0, lastSep)).toPath(), (Object)path.substring(lastSep + 1));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Path basepath = (Path)tuple2._1();
        String glob = (String)tuple2._2();
        Tuple2 tuple24 = tuple22 = new Tuple2((Object)basepath, (Object)glob);
        Path basepath2 = (Path)tuple24._1();
        String glob2 = (String)tuple24._2();
        if (glob2.indexOf(47) == -1 && !glob2.contains("**")) {
            DirectoryStream<Path> stream = Files.newDirectoryStream(basepath2, glob2);
            try {
                seq = ((TraversableOnce)JavaConversions$.MODULE$.iterableAsScalaIterable(stream).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LocalFileHandle apply(Path s) {
                        return new LocalFileHandle(s.toFile());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            }
            catch (Throwable throwable) {
                void var11_11;
                var11_11.close();
                throw throwable;
            }
            stream.close();
            return seq;
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(new StringBuilder().append((Object)"glob:").append((Object)glob2).toString());
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(this, matcher, result){
            private final PathMatcher matcher$1;
            private final ArrayBuffer result$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                if (this.matcher$1.matches(file) && attributes.isRegularFile() && !attributes.isDirectory()) {
                    this.result$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileSystemDelegate.FileHandle[]{new LocalFileHandle(file.toFile())}));
                }
                return FileVisitResult.CONTINUE;
            }
            {
                this.matcher$1 = matcher$1;
                this.result$1 = result$1;
            }
        };
        Files.walkFileTree(basepath2, (FileVisitor<? super Path>)visitor);
        seq = result;
        return seq;
    }

    public static class StdInHandle
    implements FileSystemDelegate.FileHandle {
        @Override
        public String path() {
            return "<stdin>";
        }

        @Override
        public long length() {
            return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return System.in.available();
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }));
        }

        @Override
        public InputStream open() {
            return System.in;
        }
    }

    public static class LocalFileHandle
    implements FileSystemDelegate.FileHandle {
        private final File file;

        @Override
        public String path() {
            return this.file.getAbsolutePath();
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public InputStream open() {
            return new FileInputStream(this.file);
        }

        public LocalFileHandle(File file) {
            this.file = file;
        }
    }
}

