/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.List;
import java.util.UUID;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.BaseFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

public abstract class ProcessingCollection<T extends FeatureType, F extends Feature>
extends BaseFeatureCollection<T, F> {
    public ProcessingCollection() {
        this.id = ((Object)((Object)this)).getClass().getSimpleName() + "-" + UUID.randomUUID().toString();
    }

    public abstract FeatureIterator<F> features();

    public abstract ReferencedEnvelope getBounds();

    protected abstract T buildTargetFeatureType();

    public abstract int size();

    protected int getFeatureCount() {
        return DataUtilities.count((FeatureCollection)((Object)this));
    }

    protected List<F> toList() {
        return DataUtilities.list((FeatureCollection)((Object)this));
    }

    protected ReferencedEnvelope getFeatureBounds() {
        return DataUtilities.bounds(this.features());
    }

    public T getSchema() {
        if (this.schema == null) {
            this.schema = this.buildTargetFeatureType();
        }
        return (T)this.schema;
    }
}

