/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaIndexManager;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.WrappedFeature;
import org.locationtech.geomesa.index.geotools.CachingFeatureSource;
import org.locationtech.geomesa.index.geotools.CachingFeatureSource$class;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureWriter;
import org.locationtech.geomesa.index.geotools.MetadataBackedDataStore;
import org.locationtech.geomesa.index.planning.QueryPlanner;
import org.locationtech.geomesa.index.stats.HasGeoMesaStats;
import org.locationtech.geomesa.index.utils.ExplainLogging;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.audit.AuditProvider;
import org.locationtech.geomesa.utils.audit.AuditWriter;
import org.locationtech.geomesa.utils.conf.GeoMesaProperties$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.io.CloseWithLogging$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001dfAB\u0001\u0003\u0003\u0003iaG\u0001\tHK>lUm]1ECR\f7\u000b^8sK*\u00111\u0001B\u0001\tO\u0016|Go\\8mg*\u0011QAB\u0001\u0006S:$W\r\u001f\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001!\u0006\u0003\u000fq\tc5c\u0001\u0001\u0010'A\u0011\u0001#E\u0007\u0002\u0005%\u0011!C\u0001\u0002\u0018\u001b\u0016$\u0018\rZ1uC\n\u000b7m[3e\t\u0006$\u0018m\u0015;pe\u0016\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000bM$\u0018\r^:\n\u0005a)\"a\u0004%bg\u001e+w.T3tCN#\u0018\r^:\t\u0011i\u0001!Q1A\u0005\u0002m\taaY8oM&<W#\u0001\u000f\u0011\u0005uicB\u0001\u0010,\u001d\ty\"F\u0004\u0002!S9\u0011\u0011\u0005\u000b\b\u0003E\u001dr!a\t\u0014\u000e\u0003\u0011R!!\n\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003Y\t\tqcR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3GC\u000e$xN]=\n\u00059z#AF$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f\u0007>tg-[4\u000b\u00051\u0012\u0001\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000f\r|gNZ5hA!)1\u0007\u0001C\u0001i\u00051A(\u001b8jiz\"\"!\u000e*\u0011\u000bA\u0001a'Q&\u0011\u0005]BD\u0002\u0001\u0003\u0006s\u0001\u0011\rA\u000f\u0002\u0003\tN\u000b\"aO\u001b\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\u000f9{G\u000f[5oOB\u0011qG\u0011\u0003\u0006\u0007\u0002\u0011\r\u0001\u0012\u0002\u0002\rF\u00111(\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0012\t1!\u00199j\u0013\tQuI\u0001\bXe\u0006\u0004\b/\u001a3GK\u0006$XO]3\u0011\u0005]bE!B'\u0001\u0005\u0004q%!A,\u0012\u0005mz\u0005C\u0001\u001fQ\u0013\t\tVHA\u0002B]fDQA\u0007\u001aA\u0002qAq\u0001\u0016\u0001C\u0002\u0013%Q+A\nqe>TWm\u0019;WKJ\u001c\u0018n\u001c8DQ\u0016\u001c7.F\u0001W!\t9\u0006-D\u0001Y\u0015\tI&,\u0001\u0004bi>l\u0017n\u0019\u0006\u00037r\u000b!bY8oGV\u0014(/\u001a8u\u0015\tif,\u0001\u0003vi&d'\"A0\u0002\t)\fg/Y\u0005\u0003Cb\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019\u0019\u0007\u0001)A\u0005-\u0006!\u0002O]8kK\u000e$h+\u001a:tS>t7\t[3dW\u0002B\u0001\"\u001a\u0001\t\u0006\u0004%\tAZ\u0001\rcV,'/\u001f)mC:tWM]\u000b\u0002OB)\u0001n\u001b\u001cB\u00176\t\u0011N\u0003\u0002k\t\u0005A\u0001\u000f\\1o]&tw-\u0003\u0002mS\na\u0011+^3ssBc\u0017M\u001c8fe\"Aa\u000e\u0001E\u0001B\u0003&q-A\u0007rk\u0016\u0014\u0018\u0010\u00157b]:,'\u000f\t\u0005\u0006a\u00021\t!]\u0001\b[\u0006t\u0017mZ3s+\u0005\u0011\b#\u0002$tm\u0005[\u0015B\u0001;H\u0005M9Um\\'fg\u0006Le\u000eZ3y\u001b\u0006t\u0017mZ3s\u0011\u00151\bA\"\u0005x\u0003e\u0019'/Z1uK\u001a+\u0017\r^;sK^\u0013\u0018\u000e^3s\u0003B\u0004XM\u001c3\u0015\ta|\u0018q\u0003\t\u0003srt!A\b>\n\u0005m\u0014\u0011\u0001F$f_6+7/\u0019$fCR,(/Z,sSR,'/\u0003\u0002~}\n1b\t\\;tQ\u0006\u0014G.\u001a$fCR,(/Z,sSR,'O\u0003\u0002|\u0005!9\u0011\u0011A;A\u0002\u0005\r\u0011aA:giB!\u0011QAA\n\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011AB:j[BdWM\u0003\u0003\u0002\u000e\u0005=\u0011a\u00024fCR,(/\u001a\u0006\u0004\u0003#Q\u0011aB8qK:<\u0017n]\u0005\u0005\u0003+\t9AA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016Dq!!\u0007v\u0001\u0004\tY\"A\u0004j]\u0012L7-Z:\u0011\u000bq\ni\"!\t\n\u0007\u0005}QH\u0001\u0004PaRLwN\u001c\t\u0007\u0003G\ti#a\r\u000f\t\u0005\u0015\u0012\u0011\u0006\b\u0004G\u0005\u001d\u0012\"\u0001 \n\u0007\u0005-R(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0012\u0011\u0007\u0002\u0004'\u0016\f(bAA\u0016{A1a)!\u000e7\u0003.K1!a\u000eH\u0005M9Um\\'fg\u00064U-\u0019;ve\u0016Le\u000eZ3y\u0011\u001d\tY\u0004\u0001D\t\u0003{\t\u0011d\u0019:fCR,g)Z1ukJ,wK]5uKJlu\u000eZ5gsR9\u00010a\u0010\u0002B\u0005\r\u0003\u0002CA\u0001\u0003s\u0001\r!a\u0001\t\u0011\u0005e\u0011\u0011\ba\u0001\u00037A\u0001\"!\u0012\u0002:\u0001\u0007\u0011qI\u0001\u0007M&dG/\u001a:\u0011\t\u0005%\u0013QJ\u0007\u0003\u0003\u0017RA!!\u0012\u0002\u0010%!\u0011qJA&\u0005\u00191\u0015\u000e\u001c;fe\"9\u00111\u000b\u0001\u0005R\u0005U\u0013aB2bi\u0006dwnZ\u000b\u0003\u0003/\u0002B!!\u0017\u0002`9\u0019A(a\u0017\n\u0007\u0005uS(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\n\u0019G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;j\u0004bBA4\u0001\u0019\u0005\u0011\u0011N\u0001\u0007I\u0016dW\r^3\u0015\u0005\u0005-\u0004c\u0001\u001f\u0002n%\u0019\u0011qN\u001f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003g\u0002A\u0011AA;\u0003A9W\r^!mYR\u000b'\r\\3OC6,7\u000f\u0006\u0003\u0002x\u0005e\u0004CBA\u0012\u0003[\t9\u0006\u0003\u0005\u0002|\u0005E\u0004\u0019AA,\u0003!!\u0018\u0010]3OC6,\u0007bBA@\u0001\u0011\u0005\u0011\u0011Q\u0001\u0016O\u0016$\u0018\t\u001c7J]\u0012,\u0007\u0010V1cY\u0016t\u0015-\\3t)\u0011\t9(a!\t\u0011\u0005m\u0014Q\u0010a\u0001\u0003/Bq!a\"\u0001\t#\tI)\u0001\nde\u0016\fG/Z)vKJL\b\u000b\\1o]\u0016\u0014H#A4\t\u000f\u00055\u0005\u0001\"\u0005\u0002\u0010\u000692M]3bi\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u000b\u0007\u0003#\u000b9*!+\u0011\u0007A\t\u0019*C\u0002\u0002\u0016\n\u0011\u0001dR3p\u001b\u0016\u001c\u0018MR3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0011!\tI*a#A\u0002\u0005m\u0015!B9vKJL\b\u0003BAO\u0003Kk!!a(\u000b\t\u0005\u0005\u00161U\u0001\u0005I\u0006$\u0018M\u0003\u0002\u0004\u0015%!\u0011qUAP\u0005\u0015\tV/\u001a:z\u0011!\tY+a#A\u0002\u00055\u0016AB:pkJ\u001cW\rE\u0002\u0011\u0003_K1!!-\u0003\u0005Q9Um\\'fg\u00064U-\u0019;ve\u0016\u001cv.\u001e:dK\"9\u0011Q\u0017\u0001\u0005\u0012\u0005]\u0016AE4fi&#XM]1u_J4VM]:j_:,\"!!/\u0011\r\u0005e\u00131XA,\u0013\u0011\ti,a\u0019\u0003\u0007M+G\u000fC\u0004\u0002B\u0002!\t&a1\u0002\u001fA\u0014XmU2iK6\f7I]3bi\u0016$B!a\u001b\u0002F\"A\u0011\u0011AA`\u0001\u0004\t\u0019\u0001\u000b\u0004\u0002@\u0006%\u0017Q\u001b\t\u0006y\u0005-\u0017qZ\u0005\u0004\u0003\u001bl$A\u0002;ie><8\u000f\u0005\u0003\u0002$\u0005E\u0017\u0002BAj\u0003c\u0011\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8oG\t\ty\rC\u0004\u0002Z\u0002!\t&a7\u0002\u001fA\u0014XmU2iK6\fW\u000b\u001d3bi\u0016$b!a\u001b\u0002^\u0006}\u0007\u0002CA\u0001\u0003/\u0004\r!a\u0001\t\u0011\u0005\u0005\u0018q\u001ba\u0001\u0003\u0007\t\u0001\u0002\u001d:fm&|Wo\u001d\u0015\u0007\u0003/\fI-!6\t\u000f\u0005\u001d\b\u0001\"\u0015\u0002j\u0006yqN\\*dQ\u0016l\u0017m\u0011:fCR,G\r\u0006\u0003\u0002l\u0005-\b\u0002CA\u0001\u0003K\u0004\r!a\u0001\t\u000f\u0005=\b\u0001\"\u0015\u0002r\u0006yqN\\*dQ\u0016l\u0017-\u00169eCR,G\r\u0006\u0004\u0002l\u0005M\u0018Q\u001f\u0005\t\u0003\u0003\ti\u000f1\u0001\u0002\u0004!A\u0011\u0011]Aw\u0001\u0004\t\u0019\u0001C\u0004\u0002z\u0002!\t&a?\u0002\u001f=t7k\u00195f[\u0006$U\r\\3uK\u0012$B!a\u001b\u0002~\"A\u0011\u0011AA|\u0001\u0004\t\u0019\u0001C\u0004\u0003\u0002\u0001!\tEa\u0001\u0002\u0013\u001d,GoU2iK6\fG\u0003BA\u0002\u0005\u000bA\u0001\"a\u001f\u0002\u0000\u0002\u0007\u0011q\u000b\u0005\b\u0005\u0013\u0001A\u0011\tB\u0006\u0003A9W\r\u001e$fCR,(/Z*pkJ\u001cW\r\u0006\u0003\u0003\u000e\tM\u0001c\u0001\t\u0003\u0010%\u0019!\u0011\u0003\u0002\u0003'\u001d+w.T3tC\u001a+\u0017\r^;sKN#xN]3\t\u0011\u0005m$q\u0001a\u0001\u0003/BqAa\u0006\u0001\t\u0003\u0012I\"\u0001\thKR4U-\u0019;ve\u0016\u0014V-\u00193feR1!1\u0004B\u0011\u0005G\u00012\u0001\u0005B\u000f\u0013\r\u0011yB\u0001\u0002\u0015\u000f\u0016|W*Z:b\r\u0016\fG/\u001e:f%\u0016\fG-\u001a:\t\u0011\u0005e%Q\u0003a\u0001\u00037C\u0001B!\n\u0003\u0016\u0001\u0007!qE\u0001\fiJ\fgn]1di&|g\u000e\u0005\u0003\u0002\u001e\n%\u0012\u0002\u0002B\u0016\u0003?\u00131\u0002\u0016:b]N\f7\r^5p]\"9!q\u0006\u0001\u0005B\tE\u0012\u0001E4fi\u001a+\u0017\r^;sK^\u0013\u0018\u000e^3s)\u001dA(1\u0007B\u001b\u0005oA\u0001\"a\u001f\u0003.\u0001\u0007\u0011q\u000b\u0005\t\u0003\u000b\u0012i\u00031\u0001\u0002H!A!Q\u0005B\u0017\u0001\u0004\u00119\u0003C\u0004\u0003<\u0001!\tE!\u0010\u0002-\u001d,GOR3biV\u0014Xm\u0016:ji\u0016\u0014\u0018\t\u001d9f]\u0012$R\u0001\u001fB \u0005\u0003B\u0001\"a\u001f\u0003:\u0001\u0007\u0011q\u000b\u0005\t\u0005K\u0011I\u00041\u0001\u0003(!9!Q\t\u0001\u0005\u0002\t\u001d\u0013\u0001F4fi&sG-\u001a=Xe&$XM]!qa\u0016tG\rF\u0003y\u0005\u0013\u0012Y\u0005\u0003\u0005\u0002|\t\r\u0003\u0019AA,\u0011!\tIBa\u0011A\u0002\u0005\u0005\u0002b\u0002B(\u0001\u0011\u0005\u0013\u0011N\u0001\bI&\u001c\bo\\:f\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005+\nAbZ3u#V,'/\u001f)mC:$\u0002Ba\u0016\u0003`\t\u0005$Q\r\t\u0007\u0003G\tiC!\u0017\u0011\r\u0019\u0013YFN!L\u0013\r\u0011if\u0012\u0002\n#V,'/\u001f)mC:D\u0001\"!'\u0003R\u0001\u0007\u00111\u0014\u0005\n\u000b\tE\u0003\u0013!a\u0001\u0005G\u0002R\u0001PA\u000f\u0003gA!Ba\u001a\u0003RA\u0005\t\u0019\u0001B5\u0003%)\u0007\u0010\u001d7bS:,'\u000f\u0005\u0003\u0003l\tETB\u0001B7\u0015\r\u0011y\u0007B\u0001\u0006kRLGn]\u0005\u0005\u0005g\u0012iGA\u0005FqBd\u0017-\u001b8fe\"9!q\u000f\u0001\u0005\u0002\te\u0014AC4fiZ+'o]5p]V\u0011!1\u0010\t\by\tu\u0014qKA]\u0013\r\u0011y(\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\t\r\u0005\u0001\"\u0003\u0002j\u0005\u00192\r[3dWB\u0013xN[3diZ+'o]5p]\"I!q\u0011\u0001\u0012\u0002\u0013\u0005!\u0011R\u0001\u0017O\u0016$\u0018+^3ssBc\u0017M\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0012\u0016\u0005\u0005G\u0012ii\u000b\u0002\u0003\u0010B!!\u0011\u0013BN\u001b\t\u0011\u0019J\u0003\u0003\u0003\u0016\n]\u0015!C;oG\",7m[3e\u0015\r\u0011I*P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BO\u0005'\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011\t\u000bAI\u0001\n\u0003\u0011\u0019+\u0001\fhKR\fV/\u001a:z!2\fg\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)K\u000b\u0003\u0003j\t5\u0005")
public abstract class GeoMesaDataStore<DS extends GeoMesaDataStore<DS, F, W>, F extends WrappedFeature, W>
extends MetadataBackedDataStore
implements HasGeoMesaStats {
    private final GeoMesaDataStoreFactory.GeoMesaDataStoreConfig config;
    private final AtomicLong projectVersionCheck;
    private QueryPlanner<DS, F, W> queryPlanner;
    private volatile boolean bitmap$0;

    private QueryPlanner queryPlanner$lzycompute() {
        GeoMesaDataStore geoMesaDataStore = this;
        synchronized (geoMesaDataStore) {
            if (!this.bitmap$0) {
                this.queryPlanner = this.createQueryPlanner();
                this.bitmap$0 = true;
            }
            return this.queryPlanner;
        }
    }

    public GeoMesaDataStoreFactory.GeoMesaDataStoreConfig config() {
        return this.config;
    }

    private AtomicLong projectVersionCheck() {
        return this.projectVersionCheck;
    }

    public QueryPlanner<DS, F, W> queryPlanner() {
        return this.bitmap$0 ? this.queryPlanner : this.queryPlanner$lzycompute();
    }

    public abstract GeoMesaIndexManager<DS, F, W> manager();

    public abstract GeoMesaFeatureWriter.FlushableFeatureWriter createFeatureWriterAppend(SimpleFeatureType var1, Option<Seq<GeoMesaFeatureIndex<DS, F, W>>> var2);

    public abstract GeoMesaFeatureWriter.FlushableFeatureWriter createFeatureWriterModify(SimpleFeatureType var1, Option<Seq<GeoMesaFeatureIndex<DS, F, W>>> var2, Filter var3);

    @Override
    public String catalog() {
        return this.config().catalog();
    }

    public abstract void delete();

    public Seq<String> getAllTableNames(String typeName) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.config().catalog()}))).$plus$plus(this.getAllIndexTableNames(typeName), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> getAllIndexTableNames(String typeName) {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.getSchema(typeName))).toSeq().flatMap((Function1)new Serializable(this, typeName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;
            public final String typeName$1;

            public final Seq<String> apply(SimpleFeatureType x$1) {
                GeoMesaIndexManager<DS, F, W> qual$1 = this.$outer.manager();
                SimpleFeatureType x$11 = x$1;
                Option<String> x$12 = qual$1.indices$default$2();
                IndexMode.IndexMode x$13 = qual$1.indices$default$3();
                return (Seq)qual$1.indices(x$11, x$12, x$13).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getAllIndexTableNames$1 $outer;

                    public final String apply(GeoMesaFeatureIndex<DS, F, W> x$2) {
                        return x$2.getTableName(this.$outer.typeName$1, this.$outer.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$anonfun$$$outer());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ GeoMesaDataStore org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$1 = typeName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public QueryPlanner<DS, F, W> createQueryPlanner() {
        return new QueryPlanner(this);
    }

    public GeoMesaFeatureCollection createFeatureCollection(Query query, GeoMesaFeatureSource source) {
        return new GeoMesaFeatureCollection(source, query);
    }

    public Set<String> getIteratorVersion() {
        return Predef$.MODULE$.Set().empty();
    }

    @Override
    public void preSchemaCreate(SimpleFeatureType sft) throws IllegalArgumentException {
        this.manager().setIndices(sft);
    }

    @Override
    public void preSchemaUpdate(SimpleFeatureType sft, SimpleFeatureType previous) throws IllegalArgumentException {
        Seq previousIndices = (Seq)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(previous)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple3<String, Object, IndexMode.IndexMode> x0$1) {
                Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$1;
                if (tuple3 != null) {
                    String name = (String)tuple3._1();
                    int version = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    Tuple2 tuple2 = new Tuple2((Object)name, (Object)BoxesRunTime.boxToInteger((int)version));
                    return tuple2;
                }
                throw new MatchError(tuple3);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq newIndices = (Seq)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).filterNot((Function1)new Serializable(this, previousIndices){
            public static final long serialVersionUID = 0L;
            private final Seq previousIndices$1;

            public final boolean apply(Tuple3<String, Object, IndexMode.IndexMode> x0$2) {
                Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$2;
                if (tuple3 != null) {
                    String name = (String)tuple3._1();
                    int version = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    boolean bl = this.previousIndices$1.exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;
                        private final int version$1;

                        public final boolean apply(Tuple2<String, Object> x$3) {
                            Tuple2<String, Object> tuple2 = x$3;
                            Tuple2 tuple22 = new Tuple2((Object)this.name$1, (Object)BoxesRunTime.boxToInteger((int)this.version$1));
                            return !(tuple2 != null ? !tuple2.equals((Object)tuple22) : tuple22 != null);
                        }
                        {
                            this.name$1 = name$1;
                            this.version$1 = version$1;
                        }
                    });
                    return bl;
                }
                throw new MatchError(tuple3);
            }
            {
                this.previousIndices$1 = previousIndices$1;
            }
        });
        Seq validatedIndices = (Seq)newIndices.map((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;
            private final SimpleFeatureType sft$1;

            public final GeoMesaFeatureIndex<DS, F, W> apply(Tuple3<String, Object, IndexMode.IndexMode> x0$3) {
                Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$3;
                if (tuple3 != null) {
                    String name = (String)tuple3._1();
                    int version = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    boolean bl = false;
                    Some some = null;
                    Option option = this.$outer.manager().lookup().get((Object)new Tuple2((Object)name, (Object)BoxesRunTime.boxToInteger((int)version)));
                    if (option instanceof Some) {
                        bl = true;
                        some = (Some)option;
                        GeoMesaFeatureIndex i = (GeoMesaFeatureIndex)some.x();
                        if (i.supports(this.sft$1)) {
                            GeoMesaFeatureIndex geoMesaFeatureIndex;
                            GeoMesaFeatureIndex geoMesaFeatureIndex2 = geoMesaFeatureIndex = i;
                            return geoMesaFeatureIndex2;
                        }
                    }
                    if (bl) {
                        GeoMesaFeatureIndex i = (GeoMesaFeatureIndex)some.x();
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " does not support this feature type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i.identifier()})));
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", ":", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)version)})));
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        validatedIndices.foreach((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;
            private final SimpleFeatureType sft$1;

            public final void apply(GeoMesaFeatureIndex<DS, F, W> x$4) {
                x$4.configure(this.sft$1, this.$outer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        });
    }

    @Override
    public void onSchemaCreated(SimpleFeatureType sft) {
        GeoMesaIndexManager<DS, F, W> qual$2 = this.manager();
        SimpleFeatureType x$14 = sft;
        Option<String> x$15 = qual$2.indices$default$2();
        IndexMode.IndexMode x$16 = qual$2.indices$default$3();
        qual$2.indices(x$14, x$15, x$16).foreach((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;
            private final SimpleFeatureType sft$2;

            public final void apply(GeoMesaFeatureIndex<DS, F, W> x$5) {
                x$5.configure(this.sft$2, this.$outer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$2 = sft$2;
            }
        });
    }

    @Override
    public void onSchemaUpdated(SimpleFeatureType sft, SimpleFeatureType previous) {
    }

    @Override
    public void onSchemaDeleted(SimpleFeatureType sft) {
        boolean shared = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) && Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames()).filter((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$3;

            public final boolean apply(String x$6) {
                String string = x$6;
                String string2 = this.sft$3.getTypeName();
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.sft$3 = sft$3;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;

            public final SimpleFeatureType apply(String typeName) {
                return this.$outer.getSchema(typeName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeatureType.class)))).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SimpleFeatureType x$7) {
                return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(x$7));
            }
        });
        GeoMesaIndexManager<DS, F, W> qual$3 = this.manager();
        SimpleFeatureType x$17 = sft;
        Option<String> x$18 = qual$3.indices$default$2();
        IndexMode.IndexMode x$19 = qual$3.indices$default$3();
        ((ParIterableLike)qual$3.indices(x$17, x$18, x$19).par()).foreach((Function1)new Serializable(this, sft, shared){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;
            private final SimpleFeatureType sft$3;
            private final boolean shared$1;

            public final void apply(GeoMesaFeatureIndex<DS, F, W> x$8) {
                x$8.delete(this.sft$3, this.$outer, this.shared$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$3 = sft$3;
                this.shared$1 = shared$1;
            }
        });
        this.stats().clearStats(sft);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SimpleFeatureType getSchema(String typeName) {
        void var2_2;
        SimpleFeatureType sft = super.getSchema(typeName);
        if (sft != null) {
            this.checkProjectVersion();
            Seq missingIndices = (Seq)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GeoMesaDataStore $outer;

                public final boolean apply(Tuple3<String, Object, IndexMode.IndexMode> x0$4) {
                    Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$4;
                    if (tuple3 != null) {
                        String n = (String)tuple3._1();
                        int v = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        boolean bl = this.$outer.manager().AllIndices().exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final String n$1;
                            private final int v$1;

                            public final boolean apply(GeoMesaFeatureIndex<DS, F, W> i) {
                                String string = i.name();
                                String string2 = this.n$1;
                                return !(string != null ? !string.equals(string2) : string2 != null) && i.version() == this.v$1;
                            }
                            {
                                this.n$1 = n$1;
                                this.v$1 = v$1;
                            }
                        });
                        return bl;
                    }
                    throw new MatchError(tuple3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            if (missingIndices.nonEmpty()) {
                BoxedUnit boxedUnit;
                String versions = ((TraversableOnce)missingIndices.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple3<String, Object, IndexMode.IndexMode> x0$5) {
                        Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$5;
                        if (tuple3 != null) {
                            String n = (String)tuple3._1();
                            int v = BoxesRunTime.unboxToInt((Object)tuple3._2());
                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n, BoxesRunTime.boxToInteger((int)v)}));
                            return string;
                        }
                        throw new MatchError(tuple3);
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                String available = ((TraversableOnce)this.manager().AllIndices().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(GeoMesaFeatureIndex<DS, F, W> i) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i.name(), BoxesRunTime.boxToInteger((int)i.version())}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to access schema ", " with invalid index versions '", "' - "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName(), versions}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available indices are '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{available}))).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The schema ", " was written with a newer "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()}))).append((Object)"version of GeoMesa than this client can handle. Please ensure that you are using the ").append((Object)"same GeoMesa jar versions across your entire workflow. For more information, see ").append((Object)"http://www.geomesa.org/documentation/user/installation_and_configuration.html#upgrading").toString());
            }
        }
        return var2_2;
    }

    public GeoMesaFeatureStore getFeatureSource(String typeName) {
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' has not been initialized. Please call 'createSchema' first."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
        }
        return this.config().caching() ? new CachingFeatureSource(this, sft){
            private final LoadingCache<Query, SimpleFeatureCollection> org$locationtech$geomesa$index$geotools$CachingFeatureSource$$featureCache;

            public LoadingCache<Query, SimpleFeatureCollection> org$locationtech$geomesa$index$geotools$CachingFeatureSource$$featureCache() {
                return this.org$locationtech$geomesa$index$geotools$CachingFeatureSource$$featureCache;
            }

            public void org$locationtech$geomesa$index$geotools$CachingFeatureSource$_setter_$org$locationtech$geomesa$index$geotools$CachingFeatureSource$$featureCache_$eq(LoadingCache x$1) {
                this.org$locationtech$geomesa$index$geotools$CachingFeatureSource$$featureCache = x$1;
            }

            public SimpleFeatureCollection getFeatures(Query query) {
                return CachingFeatureSource$class.getFeatures(this, query);
            }

            public int getCount(Query query) {
                return CachingFeatureSource$class.getCount(this, query);
            }
            {
                CachingFeatureSource$class.$init$(this);
            }
        } : new GeoMesaFeatureStore(this, sft, this.queryPlanner(), (Function2<Query, GeoMesaFeatureSource, GeoMesaFeatureCollection>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;

            public final GeoMesaFeatureCollection apply(Query query, GeoMesaFeatureSource source) {
                return this.$outer.createFeatureCollection(query, source);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public GeoMesaFeatureReader getFeatureReader(Query query, Transaction transaction) {
        Predef$.MODULE$.require(query.getTypeName() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Type name is required in the query";
            }
        });
        SimpleFeatureType sft = this.getSchema(query.getTypeName());
        if (sft == null) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' has not been initialized. Please call 'createSchema' first."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.getTypeName()})));
        }
        return GeoMesaFeatureReader$.MODULE$.apply(sft, query, this.queryPlanner(), this.config().queryTimeout(), this.config().audit());
    }

    @Override
    public GeoMesaFeatureWriter.FlushableFeatureWriter getFeatureWriter(String typeName, Filter filter2, Transaction transaction) {
        BoxedUnit boxedUnit;
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' has not been initialized. Please call 'createSchema' first."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
        }
        Transaction transaction2 = transaction;
        Transaction transaction3 = Transaction.AUTO_COMMIT;
        if (!(transaction2 != null ? !transaction2.equals(transaction3) : transaction3 != null)) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Ignoring transaction - not supported");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.createFeatureWriterModify(sft, (Option<Seq<GeoMesaFeatureIndex<DS, F, W>>>)None$.MODULE$, filter2);
    }

    @Override
    public GeoMesaFeatureWriter.FlushableFeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) {
        BoxedUnit boxedUnit;
        Transaction transaction2 = transaction;
        Transaction transaction3 = Transaction.AUTO_COMMIT;
        if (!(transaction2 != null ? !transaction2.equals(transaction3) : transaction3 != null)) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Ignoring transaction - not supported");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.getIndexWriterAppend(typeName, null);
    }

    public GeoMesaFeatureWriter.FlushableFeatureWriter getIndexWriterAppend(String typeName, Seq<GeoMesaFeatureIndex<DS, F, W>> indices2) {
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' has not been initialized. Please call 'createSchema' first."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
        }
        return this.createFeatureWriterAppend(sft, Option$.MODULE$.apply(indices2));
    }

    @Override
    public void dispose() {
        CloseWithLogging$.MODULE$.apply((Object)this.stats());
        this.config().audit().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Throwable> apply(Tuple3<AuditWriter, AuditProvider, String> x0$6) {
                Tuple3<AuditWriter, AuditProvider, String> tuple3 = x0$6;
                if (tuple3 != null) {
                    AuditWriter writer2 = (AuditWriter)tuple3._1();
                    Option option = CloseWithLogging$.MODULE$.apply((Object)writer2);
                    return option;
                }
                throw new MatchError(tuple3);
            }
        });
        super.dispose();
    }

    public Seq<QueryPlan<DS, F, W>> getQueryPlan(Query query, Option<GeoMesaFeatureIndex<DS, F, W>> index, Explainer explainer) {
        Predef$.MODULE$.require(query.getTypeName() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Type name is required in the query";
            }
        });
        SimpleFeatureType sft = this.getSchema(query.getTypeName());
        if (sft == null) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' has not been initialized. Please call 'createSchema' first."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.getTypeName()})));
        }
        return this.queryPlanner().planQuery(sft, query, index, explainer);
    }

    public Option<GeoMesaFeatureIndex<DS, F, W>> getQueryPlan$default$2() {
        return None$.MODULE$;
    }

    public Explainer getQueryPlan$default$3() {
        return new ExplainLogging();
    }

    public Tuple2<String, Set<String>> getVersion() {
        return new Tuple2((Object)GeoMesaProperties$.MODULE$.ProjectVersion(), this.getIteratorVersion());
    }

    private void checkProjectVersion() {
        if (this.projectVersionCheck().get() > System.currentTimeMillis()) {
            this.projectVersionCheck().set(System.currentTimeMillis() + 3600000L);
            Tuple2<String, Set<String>> tuple2 = this.getVersion();
            if (tuple2 != null) {
                Tuple2 tuple22;
                String clientVersion = (String)tuple2._1();
                Set iteratorVersions = (Set)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)clientVersion, (Object)iteratorVersions);
                String clientVersion2 = (String)tuple23._1();
                Set iteratorVersions2 = (Set)tuple23._2();
                if (iteratorVersions2.exists((Function1)new Serializable(this, clientVersion2){
                    public static final long serialVersionUID = 0L;
                    private final String clientVersion$1;

                    public final boolean apply(String x$10) {
                        String string = x$10;
                        String string2 = this.clientVersion$1;
                        return string != null ? !string.equals(string2) : string2 != null;
                    }
                    {
                        this.clientVersion$1 = clientVersion$1;
                    }
                })) {
                    BoxedUnit boxedUnit;
                    String versionMsg = new StringBuilder().append((Object)"Configured server-side iterators do not match client version - ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client version: ", ", server versions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientVersion2, iteratorVersions2.mkString(", ")}))).toString();
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(versionMsg);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            } else {
                throw new MatchError(tuple2);
            }
        }
    }

    public GeoMesaDataStore(GeoMesaDataStoreFactory.GeoMesaDataStoreConfig config) {
        this.config = config;
        super(config);
        this.projectVersionCheck = new AtomicLong(0L);
    }
}

