/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.UnsignedBytes;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.WrappedFeature;
import org.locationtech.geomesa.index.conf.TableSplitter;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.index.AttributeIndex;
import org.locationtech.geomesa.index.index.AttributeIndex$;
import org.locationtech.geomesa.index.index.AttributeIndex$$anonfun$5$;
import org.locationtech.geomesa.index.index.AttributeIndex$$anonfun$getRowKeys$1$;
import org.locationtech.geomesa.index.index.AttributeIndex$$anonfun$org$locationtech$geomesa$index$index$AttributeIndex$;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.z2.XZ2IndexKeySpace$;
import org.locationtech.geomesa.index.index.z2.Z2IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.XZ3IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.Z3IndexKeySpace$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.index.utils.SplitArrays$;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Try;
import scala.util.Try$;

public abstract class AttributeIndex$class {
    public static boolean supports(AttributeIndex $this, SimpleFeatureType sft) {
        return JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor x$1) {
                return RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isIndexed$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(x$1));
            }
        });
    }

    public static Function1 writer(AttributeIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds) {
        Function1 getRows = $this.getRowKeys(sft, false);
        return new Serializable($this, getRows){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeIndex $outer;
            private final Function1 getRows$1;

            public final Seq<W> apply(F wf) {
                return (Seq)((TraversableLike)this.getRows$1.apply(wf)).map((Function1)new Serializable(this, wf){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AttributeIndex$.anonfun.writer.1 $outer;
                    private final WrappedFeature wf$1;

                    public final W apply(Tuple2<Object, byte[]> x0$1) {
                        Tuple2<Object, byte[]> tuple2 = x0$1;
                        if (tuple2 != null) {
                            byte[] r = (byte[])tuple2._2();
                            W w = this.$outer.org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer().createInsert(r, this.wf$1);
                            return w;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.wf$1 = wf$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ AttributeIndex org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.getRows$1 = getRows$1;
            }
        };
    }

    public static Function1 remover(AttributeIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds) {
        Function1 getRows = $this.getRowKeys(sft, true);
        return new Serializable($this, getRows){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeIndex $outer;
            private final Function1 getRows$2;

            public final Seq<W> apply(F wf) {
                return (Seq)((TraversableLike)this.getRows$2.apply(wf)).map((Function1)new Serializable(this, wf){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AttributeIndex$.anonfun.remover.1 $outer;
                    private final WrappedFeature wf$2;

                    public final W apply(Tuple2<Object, byte[]> x0$2) {
                        Tuple2<Object, byte[]> tuple2 = x0$2;
                        if (tuple2 != null) {
                            byte[] r = (byte[])tuple2._2();
                            W w = this.$outer.org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer().createDelete(r, this.wf$2);
                            return w;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.wf$2 = wf$2;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ AttributeIndex org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.getRows$2 = getRows$2;
            }
        };
    }

    public static Function3 getIdFromRow(AttributeIndex $this, SimpleFeatureType sft) {
        int shard = ((byte[])$this.getShards(sft).head()).length;
        int from = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? 3 + shard : 2 + shard;
        int secondary = $this.getSecondaryIndexKeyLength(sft);
        return new Serializable($this, from, secondary){
            public static final long serialVersionUID = 0L;
            private final int from$1;
            private final int secondary$1;

            public final String apply(byte[] row, int offset, int length) {
                int start = Predef$.MODULE$.byteArrayOps(row).indexOf((Object)BoxesRunTime.boxToByte((byte)AttributeIndex$.MODULE$.NullByte()), this.from$1 + offset) + this.secondary$1 + 1;
                return new String(row, start, length + offset - start, StandardCharsets.UTF_8);
            }
            {
                this.from$1 = from$1;
                this.secondary$1 = secondary$1;
            }
        };
    }

    public static Function3 decodeRowValue(AttributeIndex $this, SimpleFeatureType sft, int index) {
        Object object;
        int shard = ((byte[])$this.getShards(sft).head()).length;
        int from = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? 3 + shard : 2 + shard;
        AttributeDescriptor descriptor = sft.getDescriptor(index);
        if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor))) {
            String alias = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)).getSimpleName().toLowerCase(Locale.US);
            object = new Serializable($this, alias){
                public static final long serialVersionUID = 0L;
                private final String alias$1;

                public final List<Object> apply(String encoded) {
                    return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{AttributeIndex$.MODULE$.typeRegistry().decode(this.alias$1, (Object)encoded)}))).asJava();
                }
                {
                    this.alias$1 = alias$1;
                }
            };
        } else {
            String alias = descriptor.getType().getBinding().getSimpleName().toLowerCase(Locale.US);
            object = new Serializable($this, alias){
                public static final long serialVersionUID = 0L;
                private final String alias$2;

                public final Object apply(String x$2) {
                    return AttributeIndex$.MODULE$.typeRegistry().decode(this.alias$2, (Object)x$2);
                }
                {
                    this.alias$2 = alias$2;
                }
            };
        }
        Object decode = object;
        return new Serializable($this, from, (Function1)decode){
            public static final long serialVersionUID = 0L;
            public final int from$2;
            public final Function1 decode$1;

            public final Try<Object> apply(byte[] row, int offset, int length) {
                return Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AttributeIndex$.anonfun.decodeRowValue.1 $outer;
                    private final byte[] row$1;
                    private final int offset$1;
                    private final int length$1;

                    public final Object apply() {
                        int valueEnd;
                        int valueStart = this.offset$1 + this.$outer.from$2;
                        int end = this.offset$1 + this.length$1;
                        for (valueEnd = valueStart; valueEnd < end && this.row$1[valueEnd] != AttributeIndex$.MODULE$.NullByte(); ++valueEnd) {
                        }
                        return this.$outer.decode$1.apply((Object)new String(this.row$1, valueStart, valueEnd - valueStart, StandardCharsets.UTF_8));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.row$1 = row$1;
                        this.offset$1 = offset$1;
                        this.length$1 = length$1;
                    }
                });
            }
            {
                void var3_3;
                this.from$2 = from$2;
                this.decode$1 = var3_3;
            }
        };
    }

    public static Seq getSplits(AttributeIndex $this, SimpleFeatureType sft) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Seq indices2 = (Seq)SimpleFeatureTypes$.MODULE$.getSecondaryIndexedAttributes(sft).map((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$3;

            public final int apply(AttributeDescriptor d) {
                return this.sft$3.indexOf(d.getLocalName());
            }
            {
                this.sft$3 = sft$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq shards = AttributeIndex$class.nonEmpty$1($this, $this.getShards(sft));
        TableSplitter splitter = (TableSplitter)((Class)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSplitter$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Class<DefaultSplitter> apply() {
                return DefaultSplitter.class;
            }
        })).newInstance();
        Seq result = (Seq)indices2.flatMap((Function1)new Serializable($this, sharing, shards, splitter, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeIndex $outer;
            public final byte[] sharing$1;
            private final Seq shards$1;
            private final TableSplitter splitter$1;
            private final SimpleFeatureType sft$3;

            public final Seq<byte[]> apply(int indexOf) {
                SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                builder.setName(this.sft$3.getName());
                builder.add(this.sft$3.getDescriptor(indexOf));
                SimpleFeatureType singleAttributeType = builder.buildFeatureType();
                byte[] bytes = AttributeIndex$.MODULE$.indexToBytes(indexOf);
                Seq splits = AttributeIndex$class.nonEmpty$1(this.$outer, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.splitter$1.getSplits(singleAttributeType, this.$outer.name(), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSplitterOptions$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$3)))));
                return (Seq)this.shards$1.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AttributeIndex$.anonfun.5 $outer;
                    public final byte[] bytes$1;
                    private final Seq splits$1;

                    public final Seq<byte[]> apply(byte[] shard) {
                        return (Seq)this.splits$1.map((Function1)new Serializable(this, shard){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ AttributeIndex$$anonfun$5$.anonfun.apply.4 $outer;
                            private final byte[] shard$3;

                            public final byte[] apply(byte[] split) {
                                return Bytes.concat((byte[][])new byte[][]{this.$outer.org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$anonfun$$$outer().sharing$1, this.$outer.bytes$1, this.shard$3, split});
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.shard$3 = (byte[])shard$3;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }

                    public /* synthetic */ AttributeIndex$.anonfun.5 org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.bytes$1 = bytes$1;
                        this.splits$1 = splits$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sharing$1 = (byte[])sharing$1;
                this.shards$1 = var3_3;
                this.splitter$1 = var4_4;
                this.sft$3 = var5_5;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return Predef$.MODULE$.byteArrayOps(sharing).isEmpty() || BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(sharing).head()) == (byte)0 ? (Seq)result.drop(1) : result;
    }

    public static QueryPlan getQueryPlan(AttributeIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds, FilterStrategy filter2, Hints hints, Explainer explain) {
        QueryPlan queryPlan;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Filter primary = (Filter)filter2.primary().getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Attribute index does not support Filter.INCLUDE");
            }
        });
        Seq secondaryRanges = (Seq)filter2.secondary().map((Function1)new Serializable($this, sft, explain){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeIndex $outer;
            private final SimpleFeatureType sft$4;
            private final Explainer explain$2;

            public final Seq<Tuple2<byte[], byte[]>> apply(Filter x$3) {
                return AttributeIndex$class.org$locationtech$geomesa$index$index$AttributeIndex$$getSecondaryIndexRanges(this.$outer, this.sft$4, x$3, this.explain$2);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$4 = sft$4;
                this.explain$2 = var3_3;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
        String[] names = DataUtilities.attributeNames((Filter)primary);
        Predef$.MODULE$.require(names.length == 1, (Function0)new Serializable($this, primary){
            public static final long serialVersionUID = 0L;
            private final Filter primary$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't extract single attribute name from filter '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.locationtech.geomesa.filter.package$.MODULE$.filterToString(this.primary$1)}));
            }
            {
                this.primary$1 = primary$1;
            }
        });
        String attribute = names[0];
        int i = sft.indexOf(attribute);
        Predef$.MODULE$.require(i != -1, (Function0)new Serializable($this, primary, attribute, sft){
            public static final long serialVersionUID = 0L;
            private final Filter primary$1;
            private final String attribute$1;
            private final SimpleFeatureType sft$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute '", "' from filter '", "' does not exist in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attribute$1, org.locationtech.geomesa.filter.package$.MODULE$.filterToString(this.primary$1), this.sft$4}));
            }
            {
                void var4_4;
                void var3_3;
                this.primary$1 = primary$1;
                this.attribute$1 = var3_3;
                this.sft$4 = var4_4;
            }
        });
        AttributeDescriptor descriptor = sft.getDescriptor(i);
        Class binding = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) ? RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) : descriptor.getType().getBinding();
        Predef$.MODULE$.require(Comparable.class.isAssignableFrom(binding), (Function0)new Serializable($this, attribute){
            public static final long serialVersionUID = 0L;
            private final String attribute$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute '", "' is not comparable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attribute$1}));
            }
            {
                this.attribute$1 = attribute$1;
            }
        });
        IndexedSeq<byte[]> shards = $this.getShards(sft);
        FilterValues fb = FilterHelper$.MODULE$.extractAttributeBounds(primary, attribute, binding);
        if (fb.isEmpty()) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isWarnEnabled()) {
                $this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to extract any attribute bounds from: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.locationtech.geomesa.filter.package$.MODULE$.filterToString(primary)})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Seq<byte[]> starts = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$lowerBounds(sft, i, (Seq<byte[]>)shards);
            Seq<byte[]> ends = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$upperBounds(sft, i, (Seq<byte[]>)shards);
            scala.collection.immutable.IndexedSeq ranges = (scala.collection.immutable.IndexedSeq)shards.indices().map((Function1)new Serializable($this, starts, ends){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AttributeIndex $outer;
                private final Seq starts$1;
                private final Seq ends$1;

                public final R apply(int i) {
                    return this.$outer.range((byte[])this.starts$1.apply(i), (byte[])this.ends$1.apply(i));
                }
                {
                    void var3_3;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.starts$1 = starts$1;
                    this.ends$1 = var3_3;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            queryPlan = $this.scanPlan(sft, ds, filter2, $this.scanConfig(sft, ds, filter2, ranges, filter2.filter(), hints));
        } else {
            ObjectRef lowerSecondary$lzy = ObjectRef.zero();
            ObjectRef upperSecondary$lzy = ObjectRef.zero();
            Ordering ordering = package$.MODULE$.Ordering().comparatorToOrdering(UnsignedBytes.lexicographicalComparator());
            Seq ranges = (Seq)fb.values().flatMap((Function1)new Serializable($this, secondaryRanges, i, shards, ordering, lowerSecondary$lzy, upperSecondary$lzy, sft, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AttributeIndex $outer;
                private final Seq secondaryRanges$1;
                private final int i$1;
                private final IndexedSeq shards$2;
                private final Ordering ordering$1;
                private final ObjectRef lowerSecondary$lzy$1;
                private final ObjectRef upperSecondary$lzy$1;
                private final SimpleFeatureType sft$4;
                private final VolatileByteRef bitmap$0$1;

                public final Seq<R> apply(Bounds<Object> bounds) {
                    Tuple2 tuple2;
                    block11: {
                        Seq seq;
                        block8: {
                            Seq seq2;
                            block10: {
                                block9: {
                                    block7: {
                                        tuple2 = bounds.bounds();
                                        if (tuple2 == null) break block7;
                                        Option option = (Option)tuple2._1();
                                        Option option2 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option2)) break block7;
                                        Seq<byte[]> starts = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$lowerBounds(this.sft$4, this.i$1, (Seq<byte[]>)this.shards$2);
                                        Seq<byte[]> ends = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$upperBounds(this.sft$4, this.i$1, (Seq<byte[]>)this.shards$2);
                                        seq = (Seq)this.shards$2.indices().map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ AttributeIndex$.anonfun.11 $outer;
                                            private final Seq starts$2;
                                            private final Seq ends$2;

                                            public final R apply(int i) {
                                                return this.$outer.org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer().range((byte[])this.starts$2.apply(i), (byte[])this.ends$2.apply(i));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.starts$2 = starts$2;
                                                this.ends$2 = ends$2;
                                            }
                                        }, IndexedSeq$.MODULE$.canBuildFrom());
                                        break block8;
                                    }
                                    if (tuple2 == null) break block9;
                                    Option option = (Option)tuple2._1();
                                    Option option3 = (Option)tuple2._2();
                                    if (!(option instanceof Some)) break block9;
                                    Some some = (Some)option;
                                    Object lower = some.x();
                                    if (!None$.MODULE$.equals(option3)) break block9;
                                    Seq<byte[]> starts = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$startRows(this.sft$4, this.i$1, (Seq<byte[]>)this.shards$2, lower, bounds.lower().inclusive(), AttributeIndex$class.lowerSecondary$1(this.$outer, this.secondaryRanges$1, this.ordering$1, this.lowerSecondary$lzy$1, this.bitmap$0$1));
                                    Seq<byte[]> ends = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$upperBounds(this.sft$4, this.i$1, (Seq<byte[]>)this.shards$2);
                                    seq = (Seq)this.shards$2.indices().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ AttributeIndex$.anonfun.11 $outer;
                                        private final Seq starts$3;
                                        private final Seq ends$3;

                                        public final R apply(int i) {
                                            return this.$outer.org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer().range((byte[])this.starts$3.apply(i), (byte[])this.ends$3.apply(i));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.starts$3 = starts$3;
                                            this.ends$3 = ends$3;
                                        }
                                    }, IndexedSeq$.MODULE$.canBuildFrom());
                                    break block8;
                                }
                                if (tuple2 == null) break block10;
                                Option option = (Option)tuple2._1();
                                Option option4 = (Option)tuple2._2();
                                if (!None$.MODULE$.equals(option) || !(option4 instanceof Some)) break block10;
                                Some some = (Some)option4;
                                Object upper = some.x();
                                Seq<byte[]> starts = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$lowerBounds(this.sft$4, this.i$1, (Seq<byte[]>)this.shards$2);
                                Seq<byte[]> ends = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$endRows(this.sft$4, this.i$1, (Seq<byte[]>)this.shards$2, upper, bounds.upper().inclusive(), AttributeIndex$class.upperSecondary$1(this.$outer, this.secondaryRanges$1, this.ordering$1, this.upperSecondary$lzy$1, this.bitmap$0$1));
                                seq = (Seq)this.shards$2.indices().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ AttributeIndex$.anonfun.11 $outer;
                                    private final Seq starts$4;
                                    private final Seq ends$4;

                                    public final R apply(int i) {
                                        return this.$outer.org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer().range((byte[])this.starts$4.apply(i), (byte[])this.ends$4.apply(i));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.starts$4 = starts$4;
                                        this.ends$4 = ends$4;
                                    }
                                }, IndexedSeq$.MODULE$.canBuildFrom());
                                break block8;
                            }
                            if (tuple2 == null) break block11;
                            Option option = (Option)tuple2._1();
                            Option option5 = (Option)tuple2._2();
                            if (!(option instanceof Some)) break block11;
                            Some some = (Some)option;
                            Object lower = some.x();
                            if (!(option5 instanceof Some)) break block11;
                            Some some2 = (Some)option5;
                            Object upper = some2.x();
                            if (BoxesRunTime.equals((Object)lower, (Object)upper)) {
                                seq2 = AttributeIndex$class.org$locationtech$geomesa$index$index$AttributeIndex$$equals(this.$outer, this.sft$4, this.i$1, (Seq)this.shards$2, lower, this.secondaryRanges$1);
                            } else {
                                String string = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(lower), org.locationtech.geomesa.filter.package$.MODULE$.WILDCARD_SUFFIX());
                                Object object = upper;
                                if (!(string != null ? !string.equals(object) : object != null)) {
                                    byte[] prefix = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$rowPrefix(this.sft$4, this.i$1);
                                    byte[] value = AttributeIndex$.MODULE$.encodeForQuery(lower, this.sft$4.getDescriptor(this.i$1));
                                    seq2 = (Seq)this.shards$2.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ AttributeIndex$.anonfun.11 $outer;
                                        private final byte[] prefix$1;
                                        private final byte[] value$2;

                                        public final R apply(byte[] shard) {
                                            return this.$outer.org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer().rangePrefix(Bytes.concat((byte[][])new byte[][]{this.prefix$1, shard, this.value$2}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.prefix$1 = prefix$1;
                                            this.value$2 = value$2;
                                        }
                                    }, scala.collection.IndexedSeq$.MODULE$.canBuildFrom());
                                } else {
                                    Seq<byte[]> starts = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$startRows(this.sft$4, this.i$1, (Seq<byte[]>)this.shards$2, lower, bounds.lower().inclusive(), AttributeIndex$class.lowerSecondary$1(this.$outer, this.secondaryRanges$1, this.ordering$1, this.lowerSecondary$lzy$1, this.bitmap$0$1));
                                    Seq<byte[]> ends = AttributeIndex$.MODULE$.org$locationtech$geomesa$index$index$AttributeIndex$$endRows(this.sft$4, this.i$1, (Seq<byte[]>)this.shards$2, upper, bounds.upper().inclusive(), AttributeIndex$class.upperSecondary$1(this.$outer, this.secondaryRanges$1, this.ordering$1, this.upperSecondary$lzy$1, this.bitmap$0$1));
                                    seq2 = (Seq)this.shards$2.indices().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ AttributeIndex$.anonfun.11 $outer;
                                        private final Seq starts$5;
                                        private final Seq ends$5;

                                        public final R apply(int i) {
                                            return this.$outer.org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer().range((byte[])this.starts$5.apply(i), (byte[])this.ends$5.apply(i));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.starts$5 = starts$5;
                                            this.ends$5 = ends$5;
                                        }
                                    }, IndexedSeq$.MODULE$.canBuildFrom());
                                }
                            }
                            seq = seq2;
                        }
                        return seq;
                    }
                    throw new MatchError((Object)tuple2);
                }

                public /* synthetic */ AttributeIndex org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    void var9_9;
                    void var8_8;
                    void var7_7;
                    void var6_6;
                    void var5_5;
                    void var4_4;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.secondaryRanges$1 = secondaryRanges$1;
                    this.i$1 = i$1;
                    this.shards$2 = var4_4;
                    this.ordering$1 = var5_5;
                    this.lowerSecondary$lzy$1 = var6_6;
                    this.upperSecondary$lzy$1 = var7_7;
                    this.sft$4 = var8_8;
                    this.bitmap$0$1 = var9_9;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Option<Filter> ecql = fb.precise() ? filter2.secondary() : filter2.filter();
            queryPlan = $this.scanPlan(sft, ds, filter2, $this.scanConfig(sft, ds, filter2, ranges, ecql, hints));
        }
        return queryPlan;
    }

    public static IndexedSeq getShards(AttributeIndex $this, SimpleFeatureType sft) {
        return (IndexedSeq)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getAttributeShards$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)))).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$6) {
                return this.apply$mcZI$sp(x$6);
            }

            public boolean apply$mcZI$sp(int x$6) {
                return x$6 > 1;
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<byte[]> apply(int numSplits) {
                return SplitArrays$.MODULE$.apply(numSplits);
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<byte[]> apply() {
                return SplitArrays$.MODULE$.EmptySplits();
            }
        });
    }

    public static Function1 getRowKeys(AttributeIndex $this, SimpleFeatureType sft, boolean lenient) {
        Object object;
        byte[] prefix = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Function1 getSecondaryKey = AttributeIndex$class.getSecondaryIndexKey($this, sft, lenient);
        IndexedSeq<byte[]> shards = $this.getShards(sft);
        if (shards.length() == 1) {
            byte[] shard = (byte[])shards.head();
            object = new Serializable($this, shard){
                public static final long serialVersionUID = 0L;
                private final byte[] shard$1;

                public final byte[] apply(F x$7) {
                    return this.shard$1;
                }
                {
                    this.shard$1 = (byte[])shard$1;
                }
            };
        } else {
            object = new Serializable($this, shards){
                public static final long serialVersionUID = 0L;
                private final IndexedSeq shards$3;

                public final byte[] apply(F wf) {
                    return (byte[])this.shards$3.apply(wf.idHash() % this.shards$3.length());
                }
                {
                    this.shards$3 = shards$3;
                }
            };
        }
        Object getShard = object;
        Seq indexedAttributes = (Seq)SimpleFeatureTypes$.MODULE$.getSecondaryIndexedAttributes(sft).map((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$5;

            public final Tuple3<AttributeDescriptor, Object, byte[]> apply(AttributeDescriptor d) {
                int i = this.sft$5.indexOf(d.getName());
                return new Tuple3((Object)d, (Object)BoxesRunTime.boxToInteger((int)i), (Object)AttributeIndex$.MODULE$.indexToBytes(i));
            }
            {
                this.sft$5 = sft$5;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Serializable($this, prefix, getSecondaryKey, (Function1)getShard, indexedAttributes){
            public static final long serialVersionUID = 0L;
            public final byte[] prefix$2;
            private final Function1 getSecondaryKey$1;
            private final Function1 getShard$1;
            private final Seq indexedAttributes$1;

            public final Seq<Tuple2<Object, byte[]>> apply(F wf) {
                byte[] secondary = (byte[])this.getSecondaryKey$1.apply(wf);
                byte[] shard = (byte[])this.getShard$1.apply(wf);
                return (Seq)this.indexedAttributes$1.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AttributeIndex$.anonfun.getRowKeys.1 $outer;
                    public final byte[] secondary$5;
                    public final byte[] shard$2;
                    public final WrappedFeature wf$3;

                    public final Seq<Tuple2<Object, byte[]>> apply(Tuple3<AttributeDescriptor, Object, byte[]> x0$3) {
                        Tuple3<AttributeDescriptor, Object, byte[]> tuple3 = x0$3;
                        if (tuple3 != null) {
                            AttributeDescriptor descriptor = (AttributeDescriptor)tuple3._1();
                            int idx = BoxesRunTime.unboxToInt((Object)tuple3._2());
                            byte[] idxBytes = (byte[])tuple3._3();
                            Seq<byte[]> attributes = AttributeIndex$.MODULE$.encodeForIndex(this.wf$3.feature().getAttribute(idx), descriptor);
                            Seq seq = (Seq)attributes.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ AttributeIndex$$anonfun$getRowKeys$1$.anonfun.apply.11 $outer;
                                private final int idx$1;
                                private final byte[] idxBytes$1;

                                public final Tuple2<Object, byte[]> apply(byte[] a) {
                                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.idx$1), (Object)Bytes.concat((byte[][])new byte[][]{this.$outer.org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$anonfun$$$outer().prefix$2, this.idxBytes$1, this.$outer.shard$2, a, AttributeIndex$.MODULE$.NullByteArray(), this.$outer.secondary$5, this.$outer.wf$3.idBytes()}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.idx$1 = idx$1;
                                    this.idxBytes$1 = idxBytes$1;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            return seq;
                        }
                        throw new MatchError(tuple3);
                    }

                    public /* synthetic */ AttributeIndex$.anonfun.getRowKeys.1 org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.secondary$5 = secondary$5;
                        this.shard$2 = shard$2;
                        this.wf$3 = wf$3;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                this.prefix$2 = (byte[])prefix$2;
                this.getSecondaryKey$1 = var3_3;
                this.getShard$1 = var4_4;
                this.indexedAttributes$1 = var5_5;
            }
        };
    }

    public static Option secondaryIndex(AttributeIndex $this, SimpleFeatureType sft) {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IndexKeySpace[]{Z3IndexKeySpace$.MODULE$, XZ3IndexKeySpace$.MODULE$, Z2IndexKeySpace$.MODULE$, XZ2IndexKeySpace$.MODULE$}))).find((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$6;

            public final boolean apply(IndexKeySpace<? extends Product> x$8) {
                return x$8.supports(this.sft$6);
            }
            {
                this.sft$6 = sft$6;
            }
        });
    }

    public static int getSecondaryIndexKeyLength(AttributeIndex $this, SimpleFeatureType sft) {
        return BoxesRunTime.unboxToInt((Object)$this.secondaryIndex(sft).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(IndexKeySpace<?> x$9) {
                return x$9.indexKeyLength();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
    }

    public static Seq org$locationtech$geomesa$index$index$AttributeIndex$$equals(AttributeIndex $this, SimpleFeatureType sft, int i, Seq shards, Object value, Seq secondary) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        byte[] index = AttributeIndex$.MODULE$.indexToBytes(i);
        Seq prefixes = (Seq)shards.map((Function1)new Serializable($this, sharing, index){
            public static final long serialVersionUID = 0L;
            private final byte[] sharing$2;
            private final byte[] index$1;

            public final byte[] apply(byte[] shard) {
                return Bytes.concat((byte[][])new byte[][]{this.sharing$2, this.index$1, shard});
            }
            {
                void var3_3;
                this.sharing$2 = (byte[])sharing$2;
                this.index$1 = var3_3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        byte[] encoded = AttributeIndex$.MODULE$.encodeForQuery(value, sft.getDescriptor(i));
        return secondary.isEmpty() ? (Seq)prefixes.map((Function1)new Serializable($this, encoded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeIndex $outer;
            private final byte[] encoded$1;

            public final R apply(byte[] prefix) {
                return this.$outer.rangePrefix(Bytes.concat((byte[][])new byte[][]{prefix, this.encoded$1, AttributeIndex$.MODULE$.NullByteArray()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.encoded$1 = (byte[])encoded$1;
            }
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)prefixes.flatMap((Function1)new Serializable($this, secondary, encoded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeIndex $outer;
            private final Seq secondary$4;
            public final byte[] encoded$1;

            public final Seq<R> apply(byte[] prefix) {
                return (Seq)this.secondary$4.map((Function1)new Serializable(this, prefix){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AttributeIndex$$anonfun$org$locationtech$geomesa$index$index$AttributeIndex$.equals.2 $outer;
                    private final byte[] prefix$7;

                    public final R apply(Tuple2<byte[], byte[]> x0$4) {
                        Tuple2<byte[], byte[]> tuple2 = x0$4;
                        if (tuple2 != null) {
                            byte[] lo = (byte[])tuple2._1();
                            byte[] hi = (byte[])tuple2._2();
                            byte[] start = Bytes.concat((byte[][])new byte[][]{this.prefix$7, this.$outer.encoded$1, AttributeIndex$.MODULE$.NullByteArray(), lo});
                            byte[] end = Bytes.concat((byte[][])new byte[][]{this.prefix$7, this.$outer.encoded$1, AttributeIndex$.MODULE$.NullByteArray(), hi});
                            R r = this.$outer.org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer().range(start, end);
                            return r;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.prefix$7 = (byte[])prefix$7;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ AttributeIndex org$locationtech$geomesa$index$index$AttributeIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.secondary$4 = secondary$4;
                this.encoded$1 = var3_3;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private static Function1 getSecondaryIndexKey(AttributeIndex $this, SimpleFeatureType sft, boolean lenient) {
        Option option;
        block4: {
            Object object;
            block3: {
                block2: {
                    option = $this.secondaryIndex(sft).map((Function1)new Serializable($this, sft, lenient){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$2;
                        private final boolean lenient$1;

                        public final Function1<SimpleFeature, byte[]> apply(IndexKeySpace<?> x$10) {
                            return x$10.toIndexKey(this.sft$2, this.lenient$1);
                        }
                        {
                            this.sft$2 = sft$2;
                            this.lenient$1 = lenient$1;
                        }
                    });
                    if (!None$.MODULE$.equals(option)) break block2;
                    object = new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final byte[] apply(F x$11) {
                            return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
                        }
                    };
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Function1 toKey = (Function1)some.x();
                object = new Serializable($this, toKey){
                    public static final long serialVersionUID = 0L;
                    private final Function1 toKey$1;

                    public final byte[] apply(F f) {
                        return (byte[])this.toKey$1.apply((Object)f.feature());
                    }
                    {
                        this.toKey$1 = toKey$1;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)option);
    }

    public static Seq org$locationtech$geomesa$index$index$AttributeIndex$$getSecondaryIndexRanges(AttributeIndex $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        return (Seq)$this.secondaryIndex(sft).map((Function1)new Serializable($this, sft, filter2, explain){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final Filter filter$1;
            private final Explainer explain$1;

            public final Seq<Tuple2<byte[], byte[]>> apply(IndexKeySpace<?> secondary) {
                ? indexValues = secondary.getIndexValues(this.sft$1, this.filter$1, this.explain$1);
                return secondary.getRanges(this.sft$1, indexValues).toSeq();
            }
            {
                void var4_4;
                void var3_3;
                this.sft$1 = sft$1;
                this.filter$1 = var3_3;
                this.explain$1 = var4_4;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public static final Seq nonEmpty$1(AttributeIndex $this, Seq bytes) {
        return bytes.nonEmpty() ? bytes : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())}));
    }

    private static final byte[] lowerSecondary$lzycompute$1(AttributeIndex $this, Seq secondaryRanges$1, Ordering ordering$1, ObjectRef lowerSecondary$lzy$1, VolatileByteRef bitmap$0$1) {
        AttributeIndex attributeIndex = $this;
        synchronized (attributeIndex) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                lowerSecondary$lzy$1.elem = (byte[])ScalaImplicits.RichTraversableOnce$.MODULE$.minOption$extension(ScalaImplicits$.MODULE$.RichTraversableOnce((TraversableOnce)secondaryRanges$1.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final byte[] apply(Tuple2<byte[], byte[]> x$4) {
                        return (byte[])x$4._1();
                    }
                }, Seq$.MODULE$.canBuildFrom())), ordering$1).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final byte[] apply() {
                        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (byte[])lowerSecondary$lzy$1.elem;
        }
    }

    public static final byte[] lowerSecondary$1(AttributeIndex $this, Seq secondaryRanges$1, Ordering ordering$1, ObjectRef lowerSecondary$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? AttributeIndex$class.lowerSecondary$lzycompute$1($this, secondaryRanges$1, ordering$1, lowerSecondary$lzy$1, bitmap$0$1) : (byte[])lowerSecondary$lzy$1.elem;
    }

    private static final byte[] upperSecondary$lzycompute$1(AttributeIndex $this, Seq secondaryRanges$1, Ordering ordering$1, ObjectRef upperSecondary$lzy$1, VolatileByteRef bitmap$0$1) {
        AttributeIndex attributeIndex = $this;
        synchronized (attributeIndex) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                upperSecondary$lzy$1.elem = (byte[])ScalaImplicits.RichTraversableOnce$.MODULE$.maxOption$extension(ScalaImplicits$.MODULE$.RichTraversableOnce((TraversableOnce)secondaryRanges$1.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final byte[] apply(Tuple2<byte[], byte[]> x$5) {
                        return (byte[])x$5._2();
                    }
                }, Seq$.MODULE$.canBuildFrom())), ordering$1).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final byte[] apply() {
                        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (byte[])upperSecondary$lzy$1.elem;
        }
    }

    public static final byte[] upperSecondary$1(AttributeIndex $this, Seq secondaryRanges$1, Ordering ordering$1, ObjectRef upperSecondary$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? AttributeIndex$class.upperSecondary$lzycompute$1($this, secondaryRanges$1, ordering$1, upperSecondary$lzy$1, bitmap$0$1) : (byte[])upperSecondary$lzy$1.elem;
    }

    public static void $init$(AttributeIndex $this) {
        $this.org$locationtech$geomesa$index$index$AttributeIndex$_setter_$name_$eq(AttributeIndex$.MODULE$.Name());
    }
}

