/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.WrappedFeature;
import org.locationtech.geomesa.index.conf.TableSplitter;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.index.BaseFeatureIndex;
import org.locationtech.geomesa.index.index.BaseFeatureIndex$;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.index.utils.SplitArrays$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class BaseFeatureIndex$class {
    public static boolean supports(BaseFeatureIndex $this, SimpleFeatureType sft) {
        return $this.keySpace().supports(sft);
    }

    public static Function1 writer(BaseFeatureIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        IndexedSeq<byte[]> shards = SplitArrays$.MODULE$.apply(sft);
        IndexKeySpace qual$1 = $this.keySpace();
        SimpleFeatureType x$3 = sft;
        boolean x$4 = qual$1.toIndexKey$default$2();
        Function1<SimpleFeature, byte[]> toIndexKey2 = qual$1.toIndexKey(x$3, x$4);
        return new Serializable($this, sharing, shards, toIndexKey2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseFeatureIndex $outer;
            private final byte[] sharing$1;
            private final IndexedSeq shards$1;
            private final Function1 toIndexKey$1;

            public final Seq<W> apply(F wf) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.createInsert(BaseFeatureIndex$class.org$locationtech$geomesa$index$index$BaseFeatureIndex$$getRowKey(this.$outer, this.sharing$1, this.shards$1, this.toIndexKey$1, wf), wf)}));
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sharing$1 = (byte[])sharing$1;
                this.shards$1 = var3_3;
                this.toIndexKey$1 = var4_4;
            }
        };
    }

    public static Function1 remover(BaseFeatureIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        IndexedSeq<byte[]> shards = SplitArrays$.MODULE$.apply(sft);
        Function1<SimpleFeature, byte[]> toIndexKey2 = $this.keySpace().toIndexKey(sft, true);
        return new Serializable($this, sharing, shards, toIndexKey2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseFeatureIndex $outer;
            private final byte[] sharing$2;
            private final IndexedSeq shards$2;
            private final Function1 toIndexKey$2;

            public final Seq<W> apply(F wf) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.createDelete(BaseFeatureIndex$class.org$locationtech$geomesa$index$index$BaseFeatureIndex$$getRowKey(this.$outer, this.sharing$2, this.shards$2, this.toIndexKey$2, wf), wf)}));
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sharing$2 = (byte[])sharing$2;
                this.shards$2 = var3_3;
                this.toIndexKey$2 = var4_4;
            }
        };
    }

    public static byte[] org$locationtech$geomesa$index$index$BaseFeatureIndex$$getRowKey(BaseFeatureIndex $this, byte[] sharing, IndexedSeq shards, Function1 toIndexKey2, WrappedFeature wrapper) {
        byte[] split = (byte[])shards.apply(wrapper.idHash() % shards.length());
        byte[] indexKey = (byte[])toIndexKey2.apply((Object)wrapper.feature());
        return Bytes.concat((byte[][])new byte[][]{sharing, split, indexKey, wrapper.idBytes()});
    }

    public static Function3 getIdFromRow(BaseFeatureIndex $this, SimpleFeatureType sft) {
        int start = $this.keySpace().indexKeyLength() + (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? 2 : 1);
        return new Serializable($this, start){
            public static final long serialVersionUID = 0L;
            private final int start$1;

            public final String apply(byte[] row, int offset, int length) {
                return new String(row, offset + this.start$1, length - this.start$1, StandardCharsets.UTF_8);
            }
            {
                this.start$1 = start$1;
            }
        };
    }

    public static Seq getSplits(BaseFeatureIndex $this, SimpleFeatureType sft) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Seq shards = BaseFeatureIndex$class.nonEmpty$1($this, SplitArrays$.MODULE$.apply(sft));
        TableSplitter splitter = (TableSplitter)((Class)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSplitter$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Class<DefaultSplitter> apply() {
                return DefaultSplitter.class;
            }
        })).newInstance();
        Seq splits = BaseFeatureIndex$class.nonEmpty$1($this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])splitter.getSplits(sft, $this.name(), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSplitterOptions$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)))));
        Seq result = (Seq)shards.flatMap((Function1)new Serializable($this, sharing, splits){
            public static final long serialVersionUID = 0L;
            public final byte[] sharing$3;
            private final Seq splits$1;

            public final Seq<byte[]> apply(byte[] shard) {
                return (Seq)this.splits$1.map((Function1)new Serializable(this, shard){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseFeatureIndex$.anonfun.2 $outer;
                    private final byte[] shard$1;

                    public final byte[] apply(byte[] split) {
                        return Bytes.concat((byte[][])new byte[][]{this.$outer.sharing$3, this.shard$1, split});
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.shard$1 = (byte[])shard$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                void var3_3;
                this.sharing$3 = (byte[])sharing$3;
                this.splits$1 = var3_3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return Predef$.MODULE$.byteArrayOps(sharing).isEmpty() || BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(sharing).head()) == (byte)0 ? (Seq)result.drop(1) : result;
    }

    public static QueryPlan getQueryPlan(BaseFeatureIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds, FilterStrategy filter2, Hints hints, Explainer explain) {
        Option option;
        block4: {
            Seq seq;
            Option indexValues;
            block3: {
                byte[] sharing;
                block2: {
                    sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
                    indexValues = filter2.primary().map((Function1)new Serializable($this, sft, explain){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ BaseFeatureIndex $outer;
                        private final SimpleFeatureType sft$1;
                        private final Explainer explain$1;

                        public final K apply(Filter x$1) {
                            return this.$outer.keySpace().getIndexValues(this.sft$1, x$1, this.explain$1);
                        }
                        {
                            void var3_3;
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sft$1 = sft$1;
                            this.explain$1 = var3_3;
                        }
                    });
                    option = indexValues;
                    if (!None$.MODULE$.equals(option)) break block2;
                    filter2.secondary().foreach((Function1)new Serializable($this, sft){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ BaseFeatureIndex $outer;
                        private final SimpleFeatureType sft$1;

                        public final void apply(Filter f) {
                            BoxedUnit boxedUnit;
                            if (this.$outer.logger().underlying().isWarnEnabled()) {
                                this.$outer.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running full table scan for schema ", " with filter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sft$1.getTypeName(), package$.MODULE$.filterToString(f)})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sft$1 = sft$1;
                        }
                    });
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.rangePrefix(sharing)}));
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Object values = some.x();
                IndexedSeq splits = SplitArrays$.MODULE$.apply(sft);
                IndexedSeq prefixes = sharing.length == 0 ? splits : (IndexedSeq)splits.map((Function1)new Serializable($this, sharing){
                    public static final long serialVersionUID = 0L;
                    private final byte[] sharing$4;

                    public final byte[] apply(byte[] x$2) {
                        return Bytes.concat((byte[][])new byte[][]{this.sharing$4, x$2});
                    }
                    {
                        this.sharing$4 = (byte[])sharing$4;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                seq = $this.keySpace().getRanges(sft, values).flatMap((Function1)new Serializable($this, prefixes){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseFeatureIndex $outer;
                    private final IndexedSeq prefixes$1;

                    public final IndexedSeq<R> apply(Tuple2<byte[], byte[]> x0$1) {
                        Tuple2<byte[], byte[]> tuple2 = x0$1;
                        if (tuple2 != null) {
                            byte[] s = (byte[])tuple2._1();
                            byte[] e = (byte[])tuple2._2();
                            IndexedSeq indexedSeq = (IndexedSeq)this.prefixes$1.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ BaseFeatureIndex$.anonfun.6 $outer;
                                private final byte[] s$1;
                                private final byte[] e$1;

                                public final R apply(byte[] p) {
                                    return this.$outer.org$locationtech$geomesa$index$index$BaseFeatureIndex$$anonfun$$$outer().range(Bytes.concat((byte[][])new byte[][]{p, this.s$1}), Bytes.concat((byte[][])new byte[][]{p, this.e$1}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.s$1 = s$1;
                                    this.e$1 = e$1;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                            return indexedSeq;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ BaseFeatureIndex org$locationtech$geomesa$index$index$BaseFeatureIndex$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.prefixes$1 = prefixes$1;
                    }
                }).toSeq();
            }
            Seq ranges = seq;
            Option<Filter> ecql = $this.useFullFilter(sft, ds, filter2, indexValues, hints) ? filter2.filter() : filter2.secondary();
            Object config = $this.updateScanConfig(sft, $this.scanConfig(sft, ds, filter2, ranges, ecql, hints), indexValues);
            return $this.scanPlan(sft, ds, filter2, config);
        }
        throw new MatchError((Object)option);
    }

    public static Object updateScanConfig(BaseFeatureIndex $this, SimpleFeatureType sft, Object config, Option indexValues) {
        return config;
    }

    private static final Seq nonEmpty$1(BaseFeatureIndex $this, Seq bytes) {
        return bytes.nonEmpty() ? bytes : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())}));
    }

    public static void $init$(BaseFeatureIndex $this) {
    }
}

