/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2;

import com.google.common.primitives.Longs;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import org.locationtech.geomesa.curve.XZ2SFC;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.index.z2.XZ2IndexKeySpace;
import org.locationtech.geomesa.index.index.z2.XZ2IndexValues;
import org.locationtech.geomesa.index.utils.ByteArrays$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.util.control.NonFatal$;

public abstract class XZ2IndexKeySpace$class {
    public static boolean supports(XZ2IndexKeySpace $this, SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.nonPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
    }

    public static Function1 toIndexKey(XZ2IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        XZ2SFC sfc = XZ2SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        return new Serializable($this, sfc, geomIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final XZ2SFC sfc$1;
            private final int geomIndex$1;
            private final boolean lenient$1;

            /*
             * WARNING - void declaration
             */
            public final byte[] apply(SimpleFeature feature) {
                long xz;
                Geometry geom = (Geometry)feature.getAttribute(this.geomIndex$1);
                if (geom == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
                }
                Envelope envelope = geom.getEnvelopeInternal();
                try {
                    xz = this.sfc$1.index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), this.lenient$1);
                }
                catch (Throwable throwable) {
                    void var2_2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid xz value from geometry: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})), e);
                }
                return Longs.toByteArray((long)xz);
            }
            {
                this.sfc$1 = sfc$1;
                this.geomIndex$1 = geomIndex$1;
                this.lenient$1 = lenient$1;
            }
        };
    }

    public static XZ2IndexValues getIndexValues(XZ2IndexKeySpace $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)new Serializable($this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        XZ2SFC sfc = XZ2SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Seq xy = (Seq)geometries.values().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(Geometry geometry) {
                return GeometryUtils$.MODULE$.bounds(geometry);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new XZ2IndexValues(sfc, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    public static Iterator getRanges(XZ2IndexKeySpace $this, SimpleFeatureType sft, XZ2IndexValues indexValues) {
        XZ2IndexValues xZ2IndexValues = indexValues;
        if (xZ2IndexValues != null) {
            Tuple2 tuple2;
            XZ2SFC sfc = xZ2IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = xZ2IndexValues.bounds();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)sfc, xy);
            XZ2SFC sfc2 = (XZ2SFC)tuple22._1();
            Seq xy2 = (Seq)tuple22._2();
            Seq zs = sfc2.ranges(xy2, QueryProperties$.MODULE$.SCAN_RANGES_TARGET().option().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$2) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
                }
            }));
            return zs.iterator().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<byte[], byte[]> apply(IndexRange r) {
                    return new Tuple2((Object)Longs.toByteArray((long)r.lower()), (Object)ByteArrays$.MODULE$.toBytesFollowingPrefix(r.upper()));
                }
            });
        }
        throw new MatchError((Object)xZ2IndexValues);
    }

    public static void $init$(XZ2IndexKeySpace $this) {
        $this.org$locationtech$geomesa$index$index$z2$XZ2IndexKeySpace$_setter_$indexKeyLength_$eq(8);
    }
}

