/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2;

import com.google.common.primitives.Longs;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.index.z2.Z2IndexKeySpace;
import org.locationtech.geomesa.index.index.z2.Z2IndexValues;
import org.locationtech.geomesa.index.utils.ByteArrays$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.util.control.NonFatal$;

public abstract class Z2IndexKeySpace$class {
    public static boolean supports(Z2IndexKeySpace $this, SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
    }

    public static Function1 toIndexKey(Z2IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        return new Serializable($this, geomIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z2IndexKeySpace $outer;
            private final int geomIndex$1;
            private final boolean lenient$1;

            /*
             * WARNING - void declaration
             */
            public final byte[] apply(SimpleFeature feature) {
                long z;
                Point geom = (Point)feature.getAttribute(this.geomIndex$1);
                if (geom == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
                }
                try {
                    z = this.$outer.sfc().index(geom.getX(), geom.getY(), this.lenient$1);
                }
                catch (Throwable throwable) {
                    void var2_2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z value from geometry: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})), e);
                }
                return Longs.toByteArray((long)z);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.geomIndex$1 = geomIndex$1;
                this.lenient$1 = lenient$1;
            }
        };
    }

    public static Z2IndexValues getIndexValues(Z2IndexKeySpace $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)new Serializable($this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        if (geometries.disjoint()) {
            explain.apply((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Non-intersecting geometries extracted, short-circuiting to empty query";
                }
            });
            return new Z2IndexValues($this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()));
        }
        Seq xy = (Seq)geometries.values().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(Geometry geometry) {
                return GeometryUtils$.MODULE$.bounds(geometry);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Z2IndexValues($this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    public static Iterator getRanges(Z2IndexKeySpace $this, SimpleFeatureType sft, Z2IndexValues indexValues) {
        Z2IndexValues z2IndexValues = indexValues;
        if (z2IndexValues != null) {
            Iterator iterator;
            Seq<Tuple4<Object, Object, Object, Object>> xy = z2IndexValues.bounds();
            Seq<Tuple4<Object, Object, Object, Object>> seq = xy;
            Seq<Tuple4<Object, Object, Object, Object>> xy2 = seq;
            if (xy2.isEmpty()) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                Seq zs = $this.sfc().ranges(xy2, 64, QueryProperties$.MODULE$.SCAN_RANGES_TARGET().option().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
                    }
                }));
                iterator = zs.iterator().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<byte[], byte[]> apply(IndexRange r) {
                        return new Tuple2((Object)Longs.toByteArray((long)r.lower()), (Object)ByteArrays$.MODULE$.toBytesFollowingPrefix(r.upper()));
                    }
                });
            }
            return iterator;
        }
        throw new MatchError((Object)z2IndexValues);
    }

    public static void $init$(Z2IndexKeySpace $this) {
        $this.org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$_setter_$indexKeyLength_$eq(8);
    }
}

