/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z3;

import com.google.common.primitives.Shorts;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.time.ZonedDateTime;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.XZ3SFC;
import org.locationtech.geomesa.curve.XZ3SFC$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.index.z3.XZ3IndexKeySpace;
import org.locationtech.geomesa.index.index.z3.XZ3IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.XZ3IndexValues;
import org.locationtech.geomesa.index.utils.ByteArrays$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

public abstract class XZ3IndexKeySpace$class {
    public static boolean supports(XZ3IndexKeySpace $this, SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).isDefined() && RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.nonPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
    }

    public static Function1 toIndexKey(XZ3IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        XZ3SFC sfc = XZ3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        int dtgIndex = BoxesRunTime.unboxToInt((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("XZ3 index requires a valid date");
            }
        }));
        Function1 timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        return new Serializable($this, sfc, dtgIndex, timeToIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final XZ3SFC sfc$1;
            private final int dtgIndex$1;
            private final Function1 timeToIndex$1;
            private final boolean lenient$1;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final byte[] apply(SimpleFeature feature) {
                Tuple2 tuple2;
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                if (geom == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
                }
                Envelope envelope = geom.getEnvelopeInternal();
                Date dtg = (Date)feature.getAttribute(this.dtgIndex$1);
                long time = dtg == null ? 0L : dtg.getTime();
                BinnedTime binnedTime = (BinnedTime)this.timeToIndex$1.apply((Object)BoxesRunTime.boxToLong((long)time));
                if (binnedTime == null) throw new MatchError((Object)binnedTime);
                short b = binnedTime.bin();
                long t = binnedTime.offset();
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
                short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long t2 = tuple22._2$mcJ$sp();
                try {
                    long xz = this.sfc$1.index(envelope.getMinX(), envelope.getMinY(), (double)t2, envelope.getMaxX(), envelope.getMaxY(), (double)t2, this.lenient$1);
                    return ByteArrays$.MODULE$.toBytes(b2, xz);
                }
                catch (Throwable throwable) {
                    void var4_4;
                    void var2_2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid xz value from geometry/time: ", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2, var4_4})), e);
                }
            }
            {
                this.sfc$1 = sfc$1;
                this.dtgIndex$1 = dtgIndex$1;
                this.timeToIndex$1 = timeToIndex$1;
                this.lenient$1 = lenient$1;
            }
        };
    }

    public static XZ3IndexValues getIndexValues(XZ3IndexKeySpace $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        String dtgField = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new RuntimeException("Trying to execute an xz3 query but the schema does not have a date");
            }
        });
        XZ3SFC sfc = XZ3SFC$.MODULE$.apply(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getXZPrecision$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$7 = filter2;
        String x$8 = dtgField;
        boolean x$9 = true;
        boolean x$10 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$7, x$8, x$10, x$9);
        explain.apply((Function0<String>)new Serializable($this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        explain.apply((Function0<String>)new Serializable($this, intervals){
            public static final long serialVersionUID = 0L;
            private final FilterValues intervals$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.intervals$1}));
            }
            {
                this.intervals$1 = intervals$1;
            }
        });
        if (intervals.disjoint()) {
            explain.apply((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disjoint dates extracted, short-circuiting to empty query";
                }
            });
            return new XZ3IndexValues(sfc, (FilterValues<Geometry>)FilterValues$.MODULE$.empty(), (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()), (FilterValues<Bounds<ZonedDateTime>>)FilterValues$.MODULE$.empty(), (Map<Object, Tuple2<Object, Object>>)Predef$.MODULE$.Map().empty());
        }
        Seq xy = (Seq)geometries.values().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(Geometry geometry) {
                return GeometryUtils$.MODULE$.bounds(geometry);
            }
        }, Seq$.MODULE$.canBuildFrom());
        scala.collection.mutable.Map timesByBin = Map$.MODULE$.empty();
        Function1 dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Function1 boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        intervals.foreach((Function1)new Serializable($this, sfc, timesByBin, dateToIndex, boundsToDates){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XZ3IndexKeySpace $outer;
            public final XZ3SFC sfc$2;
            public final scala.collection.mutable.Map timesByBin$1;
            private final Function1 dateToIndex$1;
            private final Function1 boundsToDates$1;

            public final void apply(Bounds<ZonedDateTime> interval) {
                Tuple2 tuple2 = (Tuple2)this.boundsToDates$1.apply((Object)interval.bounds());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    ZonedDateTime lower = (ZonedDateTime)tuple2._1();
                    ZonedDateTime upper = (ZonedDateTime)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)lower, (Object)upper);
                    ZonedDateTime lower2 = (ZonedDateTime)tuple23._1();
                    ZonedDateTime upper2 = (ZonedDateTime)tuple23._2();
                    BinnedTime binnedTime = (BinnedTime)this.dateToIndex$1.apply((Object)lower2);
                    if (binnedTime != null) {
                        Tuple2 tuple24;
                        short lb = binnedTime.bin();
                        long lt = binnedTime.offset();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
                        short lb2 = BoxesRunTime.unboxToShort((Object)tuple25._1());
                        long lt2 = tuple25._2$mcJ$sp();
                        BinnedTime binnedTime2 = (BinnedTime)this.dateToIndex$1.apply((Object)upper2);
                        if (binnedTime2 != null) {
                            Tuple2 tuple26;
                            short ub = binnedTime2.bin();
                            long ut = binnedTime2.offset();
                            Tuple2 tuple27 = tuple26 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
                            short ub2 = BoxesRunTime.unboxToShort((Object)tuple27._1());
                            long ut2 = tuple27._2$mcJ$sp();
                            if (lb2 == ub2) {
                                XZ3IndexKeySpace$class.updateTime$1(this.$outer, lb2, lt2, ut2, this.timesByBin$1);
                            } else {
                                XZ3IndexKeySpace$class.updateTime$1(this.$outer, lb2, lt2, this.sfc$2.zBounds()._2$mcD$sp(), this.timesByBin$1);
                                XZ3IndexKeySpace$class.updateTime$1(this.$outer, ub2, this.sfc$2.zBounds()._1$mcD$sp(), ut2, this.timesByBin$1);
                                package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ XZ3IndexKeySpace$.anonfun.getIndexValues.4 $outer;

                                    public final void apply(int b) {
                                        this.apply$mcVI$sp(b);
                                    }

                                    public void apply$mcVI$sp(int b) {
                                        this.$outer.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)this.$outer.sfc$2.zBounds());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            return;
                        }
                        throw new MatchError((Object)binnedTime2);
                    }
                    throw new MatchError((Object)binnedTime);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sfc$2 = sfc$2;
                this.timesByBin$1 = timesByBin$1;
                this.dateToIndex$1 = dateToIndex$1;
                this.boundsToDates$1 = boundsToDates$1;
            }
        });
        return new XZ3IndexValues(sfc, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Tuple2<Object, Object>>)timesByBin.toMap(Predef$.MODULE$.$conforms()));
    }

    public static Iterator getRanges(XZ3IndexKeySpace $this, SimpleFeatureType sft, XZ3IndexValues indexValues) {
        ObjectRef wholePeriodRanges$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        XZ3IndexValues xZ3IndexValues = indexValues;
        if (xZ3IndexValues != null) {
            Tuple3 tuple3;
            XZ3SFC sfc = xZ3IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = xZ3IndexValues.spatialBounds();
            Map<Object, Tuple2<Object, Object>> timesByBin = xZ3IndexValues.temporalBounds();
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)sfc, xy, timesByBin);
            XZ3SFC sfc2 = (XZ3SFC)tuple32._1();
            Seq xy2 = (Seq)tuple32._2();
            Map timesByBin2 = (Map)tuple32._3();
            Option rangeTarget = QueryProperties$.MODULE$.SCAN_RANGES_TARGET().option().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$6) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$6)).toInt();
                }
            });
            return timesByBin2.iterator().flatMap((Function1)new Serializable($this, sfc2, xy2, rangeTarget, wholePeriodRanges$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ XZ3IndexKeySpace $outer;
                private final XZ3SFC sfc$3;
                private final Seq xy$1;
                private final Option rangeTarget$1;
                private final ObjectRef wholePeriodRanges$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final GenTraversableOnce<Tuple2<byte[], byte[]>> apply(Tuple2<Object, Tuple2<Object, Object>> x0$2) {
                    Tuple2<Object, Tuple2<Object, Object>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        Tuple2 times = (Tuple2)tuple2._2();
                        byte[] b = Shorts.toByteArray((short)bin);
                        Seq zs = times == this.sfc$3.zBounds() ? XZ3IndexKeySpace$class.wholePeriodRanges$1(this.$outer, this.sfc$3, this.xy$1, this.rangeTarget$1, this.wholePeriodRanges$lzy$1, this.bitmap$0$1) : XZ3IndexKeySpace$class.toZRanges$1(this.$outer, times, this.sfc$3, this.xy$1, this.rangeTarget$1);
                        GenTraversableOnce genTraversableOnce = (GenTraversableOnce)zs.map((Function1)new Serializable(this, b){
                            public static final long serialVersionUID = 0L;
                            private final byte[] b$1;

                            public final Tuple2<byte[], byte[]> apply(IndexRange r) {
                                return new Tuple2((Object)ByteArrays$.MODULE$.toBytes(this.b$1, r.lower()), (Object)ByteArrays$.MODULE$.toBytesFollowingPrefix(this.b$1, r.upper()));
                            }
                            {
                                this.b$1 = b$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return genTraversableOnce;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sfc$3 = sfc$3;
                    this.xy$1 = xy$1;
                    this.rangeTarget$1 = rangeTarget$1;
                    this.wholePeriodRanges$lzy$1 = wholePeriodRanges$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
        }
        throw new MatchError((Object)xZ3IndexValues);
    }

    public static final void updateTime$1(XZ3IndexKeySpace $this, short week, double lt, double ut, scala.collection.mutable.Map timesByBin$1) {
        Option option;
        block4: {
            Tuple2.mcDD.sp sp2;
            block3: {
                Some some;
                Tuple2 tuple2;
                block2: {
                    option = timesByBin$1.get((Object)BoxesRunTime.boxToShort((short)week));
                    if (!None$.MODULE$.equals(option)) break block2;
                    sp2 = new Tuple2.mcDD.sp(lt, ut);
                    break block3;
                }
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block4;
                double min = tuple2._1$mcD$sp();
                double max = tuple2._2$mcD$sp();
                sp2 = new Tuple2.mcDD.sp(scala.math.package$.MODULE$.min(min, lt), scala.math.package$.MODULE$.max(max, ut));
            }
            Tuple2.mcDD.sp times = sp2;
            timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)week), (Object)times);
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final Seq toZRanges$1(XZ3IndexKeySpace $this, Tuple2 t, XZ3SFC sfc$3, Seq xy$1, Option rangeTarget$1) {
        return sfc$3.ranges((Seq)xy$1.map((Function1)new Serializable($this, t){
            public static final long serialVersionUID = 0L;
            private final Tuple2 t$1;

            public final Tuple6<Object, Object, Object, Object, Object, Object> apply(Tuple4<Object, Object, Object, Object> x0$1) {
                Tuple4<Object, Object, Object, Object> tuple4 = x0$1;
                if (tuple4 != null) {
                    double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                    double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                    Tuple6 tuple6 = new Tuple6((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)this.t$1._1$mcD$sp()), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax), (Object)BoxesRunTime.boxToDouble((double)this.t$1._2$mcD$sp()));
                    return tuple6;
                }
                throw new MatchError(tuple4);
            }
            {
                this.t$1 = t$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), rangeTarget$1);
    }

    private static final Seq wholePeriodRanges$lzycompute$1(XZ3IndexKeySpace $this, XZ3SFC sfc$3, Seq xy$1, Option rangeTarget$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        XZ3IndexKeySpace xZ3IndexKeySpace = $this;
        synchronized (xZ3IndexKeySpace) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                wholePeriodRanges$lzy$1.elem = XZ3IndexKeySpace$class.toZRanges$1($this, sfc$3.zBounds(), sfc$3, xy$1, rangeTarget$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Seq)wholePeriodRanges$lzy$1.elem;
        }
    }

    public static final Seq wholePeriodRanges$1(XZ3IndexKeySpace $this, XZ3SFC sfc$3, Seq xy$1, Option rangeTarget$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? XZ3IndexKeySpace$class.wholePeriodRanges$lzycompute$1($this, sfc$3, xy$1, rangeTarget$1, wholePeriodRanges$lzy$1, bitmap$0$1) : (Seq)wholePeriodRanges$lzy$1.elem;
    }

    public static void $init$(XZ3IndexKeySpace $this) {
        $this.org$locationtech$geomesa$index$index$z3$XZ3IndexKeySpace$_setter_$indexKeyLength_$eq(10);
    }
}

