/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z3;

import com.google.common.primitives.Shorts;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.time.ZonedDateTime;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.index.z3.Z3IndexKeySpace;
import org.locationtech.geomesa.index.index.z3.Z3IndexKeySpace$;
import org.locationtech.geomesa.index.index.z3.Z3IndexValues;
import org.locationtech.geomesa.index.utils.ByteArrays$;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

public abstract class Z3IndexKeySpace$class {
    public static boolean supports(Z3IndexKeySpace $this, SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).isDefined() && RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
    }

    public static Function1 toIndexKey(Z3IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        Z3SFC z3 = $this.sfc(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Function1 timeToIndex = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        int dtgIndex = BoxesRunTime.unboxToInt((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Z3 index requires a valid date");
            }
        }));
        return new Serializable($this, z3, timeToIndex, geomIndex, dtgIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final Z3SFC z3$1;
            private final Function1 timeToIndex$1;
            private final int geomIndex$1;
            private final int dtgIndex$1;
            private final boolean lenient$1;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final byte[] apply(SimpleFeature feature) {
                Tuple2 tuple2;
                Point geom = (Point)feature.getAttribute(this.geomIndex$1);
                if (geom == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
                }
                Date dtg = (Date)feature.getAttribute(this.dtgIndex$1);
                long time = dtg == null ? 0L : dtg.getTime();
                BinnedTime binnedTime = (BinnedTime)this.timeToIndex$1.apply((Object)BoxesRunTime.boxToLong((long)time));
                if (binnedTime == null) throw new MatchError((Object)binnedTime);
                short b = binnedTime.bin();
                long t = binnedTime.offset();
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)t));
                short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long t2 = tuple22._2$mcJ$sp();
                try {
                    long z = this.z3$1.index(geom.getX(), geom.getY(), t2, this.lenient$1);
                    return ByteArrays$.MODULE$.toBytes(b2, z);
                }
                catch (Throwable throwable) {
                    void var3_3;
                    void var2_2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z value from geometry/time: ", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2, var3_3})), e);
                }
            }
            {
                this.z3$1 = z3$1;
                this.timeToIndex$1 = timeToIndex$1;
                this.geomIndex$1 = geomIndex$1;
                this.dtgIndex$1 = dtgIndex$1;
                this.lenient$1 = lenient$1;
            }
        };
    }

    public static Z3IndexValues getIndexValues(Z3IndexKeySpace $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        String dtgField = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new RuntimeException("Trying to execute a z3 query but the schema does not have a date");
            }
        });
        Z3SFC z3 = $this.sfc(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        Filter x$7 = filter2;
        String x$8 = dtgField;
        boolean x$9 = true;
        boolean x$10 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues intervals = FilterHelper$.MODULE$.extractIntervals(x$7, x$8, x$10, x$9);
        explain.apply((Function0<String>)new Serializable($this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        explain.apply((Function0<String>)new Serializable($this, intervals){
            public static final long serialVersionUID = 0L;
            private final FilterValues intervals$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.intervals$1}));
            }
            {
                this.intervals$1 = intervals$1;
            }
        });
        if (geometries.disjoint() || intervals.disjoint()) {
            explain.apply((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disjoint geometries or dates extracted, short-circuiting to empty query";
                }
            });
            return new Z3IndexValues(z3, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()), (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)Predef$.MODULE$.Map().empty());
        }
        long minTime = (long)z3.time().min();
        long maxTime = (long)z3.time().max();
        Seq xy = (Seq)geometries.values().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(Geometry geometry) {
                return GeometryUtils$.MODULE$.bounds(geometry);
            }
        }, Seq$.MODULE$.canBuildFrom());
        scala.collection.mutable.Map timesByBin = Map$.MODULE$.empty().withDefaultValue((Object)Seq$.MODULE$.empty());
        Function1 dateToIndex = BinnedTime$.MODULE$.dateToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Function1 boundsToDates = BinnedTime$.MODULE$.boundsToIndexableDates(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        intervals.foreach((Function1)new Serializable($this, z3, minTime, maxTime, timesByBin, dateToIndex, boundsToDates){
            public static final long serialVersionUID = 0L;
            public final Z3SFC z3$2;
            private final long minTime$1;
            private final long maxTime$1;
            public final scala.collection.mutable.Map timesByBin$1;
            private final Function1 dateToIndex$1;
            private final Function1 boundsToDates$1;

            public final void apply(Bounds<ZonedDateTime> interval) {
                Tuple2 tuple2 = (Tuple2)this.boundsToDates$1.apply((Object)interval.bounds());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    ZonedDateTime lower = (ZonedDateTime)tuple2._1();
                    ZonedDateTime upper = (ZonedDateTime)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)lower, (Object)upper);
                    ZonedDateTime lower2 = (ZonedDateTime)tuple23._1();
                    ZonedDateTime upper2 = (ZonedDateTime)tuple23._2();
                    BinnedTime binnedTime = (BinnedTime)this.dateToIndex$1.apply((Object)lower2);
                    if (binnedTime != null) {
                        Tuple2 tuple24;
                        short lb = binnedTime.bin();
                        long lt = binnedTime.offset();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToShort((short)lb), (Object)BoxesRunTime.boxToLong((long)lt));
                        short lb2 = BoxesRunTime.unboxToShort((Object)tuple25._1());
                        long lt2 = tuple25._2$mcJ$sp();
                        BinnedTime binnedTime2 = (BinnedTime)this.dateToIndex$1.apply((Object)upper2);
                        if (binnedTime2 != null) {
                            Tuple2 tuple26;
                            short ub = binnedTime2.bin();
                            long ut = binnedTime2.offset();
                            Tuple2 tuple27 = tuple26 = new Tuple2((Object)BoxesRunTime.boxToShort((short)ub), (Object)BoxesRunTime.boxToLong((long)ut));
                            short ub2 = BoxesRunTime.unboxToShort((Object)tuple27._1());
                            long ut2 = tuple27._2$mcJ$sp();
                            if (lb2 == ub2) {
                                this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(lt2, ut2)})), Seq$.MODULE$.canBuildFrom()));
                            } else {
                                this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)lb2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)lb2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(lt2, this.maxTime$1)})), Seq$.MODULE$.canBuildFrom()));
                                this.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)ub2), ((TraversableLike)this.timesByBin$1.apply((Object)BoxesRunTime.boxToShort((short)ub2))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(this.minTime$1, ut2)})), Seq$.MODULE$.canBuildFrom()));
                                package$.MODULE$.Range().inclusive(lb2 + 1, ub2 - 1).foreach$mVc$sp((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ Z3IndexKeySpace$.anonfun.getIndexValues.4 $outer;

                                    public final void apply(int b) {
                                        this.apply$mcVI$sp(b);
                                    }

                                    public void apply$mcVI$sp(int b) {
                                        this.$outer.timesByBin$1.update((Object)BoxesRunTime.boxToShort((short)((short)b)), (Object)this.$outer.z3$2.wholePeriod());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            return;
                        }
                        throw new MatchError((Object)binnedTime2);
                    }
                    throw new MatchError((Object)binnedTime);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.z3$2 = z3$2;
                this.minTime$1 = minTime$1;
                this.maxTime$1 = maxTime$1;
                this.timesByBin$1 = timesByBin$1;
                this.dateToIndex$1 = dateToIndex$1;
                this.boundsToDates$1 = boundsToDates$1;
            }
        });
        return new Z3IndexValues(z3, (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy, (FilterValues<Bounds<ZonedDateTime>>)intervals, (Map<Object, Seq<Tuple2<Object, Object>>>)timesByBin.toMap(Predef$.MODULE$.$conforms()));
    }

    public static Iterator getRanges(Z3IndexKeySpace $this, SimpleFeatureType sft, Z3IndexValues values) {
        ObjectRef wholePeriodRanges$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Z3IndexValues z3IndexValues = values;
        if (z3IndexValues != null) {
            Tuple3 tuple3;
            Z3SFC z3 = z3IndexValues.sfc();
            Seq<Tuple4<Object, Object, Object, Object>> xy = z3IndexValues.spatialBounds();
            Map<Object, Seq<Tuple2<Object, Object>>> timesByBin = z3IndexValues.temporalBounds();
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)z3, xy, timesByBin);
            Z3SFC z32 = (Z3SFC)tuple32._1();
            Seq xy2 = (Seq)tuple32._2();
            Map timesByBin2 = (Map)tuple32._3();
            Option rangeTarget = QueryProperties$.MODULE$.SCAN_RANGES_TARGET().option().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$6) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$6)).toInt();
                }
            });
            return timesByBin2.iterator().flatMap((Function1)new Serializable($this, z32, xy2, rangeTarget, wholePeriodRanges$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Z3IndexKeySpace $outer;
                private final Z3SFC z3$3;
                private final Seq xy$1;
                private final Option rangeTarget$1;
                private final ObjectRef wholePeriodRanges$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final GenTraversableOnce<Tuple2<byte[], byte[]>> apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x0$1) {
                    Tuple2<Object, Seq<Tuple2<Object, Object>>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        Seq times = (Seq)tuple2._2();
                        byte[] b = Shorts.toByteArray((short)bin);
                        Seq zs = times == this.z3$3.wholePeriod() ? Z3IndexKeySpace$class.wholePeriodRanges$1(this.$outer, this.z3$3, this.xy$1, this.rangeTarget$1, this.wholePeriodRanges$lzy$1, this.bitmap$0$1) : Z3IndexKeySpace$class.toZRanges$1(this.$outer, times, this.z3$3, this.xy$1, this.rangeTarget$1);
                        GenTraversableOnce genTraversableOnce = (GenTraversableOnce)zs.map((Function1)new Serializable(this, b){
                            public static final long serialVersionUID = 0L;
                            private final byte[] b$1;

                            public final Tuple2<byte[], byte[]> apply(IndexRange range2) {
                                return new Tuple2((Object)ByteArrays$.MODULE$.toBytes(this.b$1, range2.lower()), (Object)ByteArrays$.MODULE$.toBytesFollowingPrefix(this.b$1, range2.upper()));
                            }
                            {
                                this.b$1 = b$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return genTraversableOnce;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.z3$3 = z3$3;
                    this.xy$1 = xy$1;
                    this.rangeTarget$1 = rangeTarget$1;
                    this.wholePeriodRanges$lzy$1 = wholePeriodRanges$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
        }
        throw new MatchError((Object)z3IndexValues);
    }

    public static final Seq toZRanges$1(Z3IndexKeySpace $this, Seq t, Z3SFC z3$3, Seq xy$1, Option rangeTarget$1) {
        return z3$3.ranges(xy$1, t, 64, rangeTarget$1);
    }

    private static final Seq wholePeriodRanges$lzycompute$1(Z3IndexKeySpace $this, Z3SFC z3$3, Seq xy$1, Option rangeTarget$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        Z3IndexKeySpace z3IndexKeySpace = $this;
        synchronized (z3IndexKeySpace) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                wholePeriodRanges$lzy$1.elem = Z3IndexKeySpace$class.toZRanges$1($this, z3$3.wholePeriod(), z3$3, xy$1, rangeTarget$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Seq)wholePeriodRanges$lzy$1.elem;
        }
    }

    public static final Seq wholePeriodRanges$1(Z3IndexKeySpace $this, Z3SFC z3$3, Seq xy$1, Option rangeTarget$1, ObjectRef wholePeriodRanges$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? Z3IndexKeySpace$class.wholePeriodRanges$lzycompute$1($this, z3$3, xy$1, rangeTarget$1, wholePeriodRanges$lzy$1, bitmap$0$1) : (Seq)wholePeriodRanges$lzy$1.elem;
    }

    public static void $init$(Z3IndexKeySpace $this) {
        $this.org$locationtech$geomesa$index$index$z3$Z3IndexKeySpace$_setter_$indexKeyLength_$eq(10);
    }
}

