/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.SimpleFeatureConverter;
import org.locationtech.geomesa.convert.SimpleFeatureConverters$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.tools.ConvertParameters;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportCommand$;
import org.locationtech.geomesa.tools.export.formats.ArrowExporter;
import org.locationtech.geomesa.tools.export.formats.AvroExporter;
import org.locationtech.geomesa.tools.export.formats.BinExporter;
import org.locationtech.geomesa.tools.export.formats.DelimitedExporter;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.export.formats.GeoJsonExporter;
import org.locationtech.geomesa.tools.export.formats.GmlExporter;
import org.locationtech.geomesa.tools.export.formats.ShapefileExporter;
import org.locationtech.geomesa.tools.utils.CLArgResolver$;
import org.locationtech.geomesa.tools.utils.DataFormats$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class ConvertCommand$
implements LazyLogging {
    public static final ConvertCommand$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ConvertCommand$();
    }

    private Logger logger$lzycompute() {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleFeatureConverter<Object> getConverter(ConvertParameters.ConvertParameters params, SimpleFeatureType sft) {
        if (params.config() == null) {
            throw new ParameterException("Unable to parse Simple Feature type from sft config or string");
        }
        Config converterConfig = CLArgResolver$.MODULE$.getConfig(params.config());
        return SimpleFeatureConverters$.MODULE$.build(sft, converterConfig);
    }

    public FeatureExporter getExporter(ConvertParameters.ConvertParameters params, Function0<Iterator<SimpleFeature>> features) {
        block14: {
            FeatureExporter featureExporter;
            block8: {
                Enumeration.Value value;
                VolatileByteRef bitmap$0;
                ObjectRef arrowDictionaries$lzy;
                ObjectRef hints$lzy;
                ObjectRef outputStream$lzy;
                block13: {
                    block12: {
                        IntRef avroCompression$lzy;
                        block11: {
                            block10: {
                                boolean bl;
                                ObjectRef writer$lzy;
                                block9: {
                                    block7: {
                                        boolean bl2;
                                        outputStream$lzy = ObjectRef.zero();
                                        writer$lzy = ObjectRef.zero();
                                        avroCompression$lzy = IntRef.zero();
                                        hints$lzy = ObjectRef.zero();
                                        arrowDictionaries$lzy = ObjectRef.zero();
                                        bitmap$0 = VolatileByteRef.create((byte)0);
                                        value = params.outputFormat();
                                        Enumeration.Value value2 = DataFormats$.MODULE$.Csv();
                                        Enumeration.Value value3 = value;
                                        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                                            bl2 = true;
                                        } else {
                                            Enumeration.Value value4 = DataFormats$.MODULE$.Tsv();
                                            Enumeration.Value value5 = value;
                                            bl2 = !(value4 != null ? !value4.equals(value5) : value5 != null);
                                        }
                                        if (!bl2) break block7;
                                        featureExporter = new DelimitedExporter(this.writer$1(params, writer$lzy, bitmap$0), params.outputFormat(), (Option<ExportCommand.ExportAttributes>)None$.MODULE$, !params.noHeader());
                                        break block8;
                                    }
                                    Enumeration.Value value6 = DataFormats$.MODULE$.Shp();
                                    Enumeration.Value value7 = value;
                                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block9;
                                    featureExporter = new ShapefileExporter(ExportCommand$.MODULE$.checkShpFile(params));
                                    break block8;
                                }
                                Enumeration.Value value8 = DataFormats$.MODULE$.GeoJson();
                                Enumeration.Value value9 = value;
                                if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                    bl = true;
                                } else {
                                    Enumeration.Value value10 = DataFormats$.MODULE$.Json();
                                    Enumeration.Value value11 = value;
                                    bl = !(value10 != null ? !value10.equals(value11) : value11 != null);
                                }
                                if (!bl) break block10;
                                featureExporter = new GeoJsonExporter(this.writer$1(params, writer$lzy, bitmap$0));
                                break block8;
                            }
                            Enumeration.Value value12 = DataFormats$.MODULE$.Gml();
                            Enumeration.Value value13 = value;
                            if (value12 != null ? !value12.equals(value13) : value13 != null) break block11;
                            featureExporter = new GmlExporter(this.outputStream$1(params, outputStream$lzy, bitmap$0));
                            break block8;
                        }
                        Enumeration.Value value14 = DataFormats$.MODULE$.Avro();
                        Enumeration.Value value15 = value;
                        if (value14 != null ? !value14.equals(value15) : value15 != null) break block12;
                        featureExporter = new AvroExporter(this.outputStream$1(params, outputStream$lzy, bitmap$0), this.avroCompression$1(params, avroCompression$lzy, bitmap$0));
                        break block8;
                    }
                    Enumeration.Value value16 = DataFormats$.MODULE$.Bin();
                    Enumeration.Value value17 = value;
                    if (value16 != null ? !value16.equals(value17) : value17 != null) break block13;
                    featureExporter = new BinExporter(this.hints$1(params, hints$lzy, bitmap$0), this.outputStream$1(params, outputStream$lzy, bitmap$0));
                    break block8;
                }
                Enumeration.Value value18 = DataFormats$.MODULE$.Arrow();
                Enumeration.Value value19 = value;
                if (value18 != null ? !value18.equals(value19) : value19 != null) break block14;
                featureExporter = new ArrowExporter(this.hints$1(params, hints$lzy, bitmap$0), this.outputStream$1(params, outputStream$lzy, bitmap$0), (Function0<scala.collection.immutable.Map<String, Object[]>>)new Serializable(params, features, hints$lzy, arrowDictionaries$lzy, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final ConvertParameters.ConvertParameters params$1;
                    private final Function0 features$2;
                    private final ObjectRef hints$lzy$1;
                    private final ObjectRef arrowDictionaries$lzy$1;
                    private final VolatileByteRef bitmap$0$1;

                    public final scala.collection.immutable.Map<String, Object[]> apply() {
                        return ConvertCommand$.MODULE$.org$locationtech$geomesa$tools$ConvertCommand$$arrowDictionaries$1(this.params$1, this.features$2, this.hints$lzy$1, this.arrowDictionaries$lzy$1, this.bitmap$0$1);
                    }
                    {
                        this.params$1 = params$1;
                        this.features$2 = features$2;
                        this.hints$lzy$1 = hints$lzy$1;
                        this.arrowDictionaries$lzy$1 = arrowDictionaries$lzy$1;
                        this.bitmap$0$1 = bitmap$0$1;
                    }
                });
            }
            return featureExporter;
        }
        throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Format ", " is not supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.outputFormat()})));
    }

    public Iterator<SimpleFeature> convertFeatures(Iterator<FileSystemDelegate.FileHandle> files, SimpleFeatureConverter<Object> converter, EvaluationContext ec, Option<Filter> filter, Option<Object> maxFeatures) {
        Iterator all = files.flatMap((Function1)new Serializable(converter, ec){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureConverter converter$2;
            private final EvaluationContext ec$2;

            public final Iterator<SimpleFeature> apply(FileSystemDelegate.FileHandle file) {
                this.ec$2.set(this.ec$2.indexOf("inputFilePath"), (Object)file.path());
                InputStream is = PathUtils$.MODULE$.handleCompression(file.open(), file.path());
                return this.converter$2.process(is, this.ec$2);
            }
            {
                this.converter$2 = converter$2;
                this.ec$2 = ec$2;
            }
        });
        Iterator filtered = (Iterator)filter.map((Function1)new Serializable(all){
            public static final long serialVersionUID = 0L;
            private final Iterator all$1;

            public final Iterator<SimpleFeature> apply(Filter f) {
                return this.all$1.filter((Function1)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final Filter f$2;

                    public final boolean apply(Object x$1) {
                        return this.f$2.evaluate(x$1);
                    }
                    {
                        this.f$2 = f$2;
                    }
                });
            }
            {
                this.all$1 = all$1;
            }
        }).getOrElse((Function0)new Serializable(all){
            public static final long serialVersionUID = 0L;
            private final Iterator all$1;

            public final Iterator<SimpleFeature> apply() {
                return this.all$1;
            }
            {
                this.all$1 = all$1;
            }
        });
        Iterator limited = (Iterator)maxFeatures.map((Function1)new Serializable(filtered){
            public static final long serialVersionUID = 0L;
            private final Iterator filtered$1;

            public final Iterator<SimpleFeature> apply(int n) {
                return this.filtered$1.take(n);
            }
            {
                this.filtered$1 = filtered$1;
            }
        }).getOrElse((Function0)new Serializable(filtered){
            public static final long serialVersionUID = 0L;
            private final Iterator filtered$1;

            public final Iterator<SimpleFeature> apply() {
                return this.filtered$1;
            }
            {
                this.filtered$1 = filtered$1;
            }
        });
        return limited;
    }

    private final OutputStream outputStream$lzycompute$1(ConvertParameters.ConvertParameters params$1, ObjectRef outputStream$lzy$1, VolatileByteRef bitmap$0$1) {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                outputStream$lzy$1.elem = ExportCommand$.MODULE$.createOutputStream(params$1.file(), params$1.gzip());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (OutputStream)outputStream$lzy$1.elem;
        }
    }

    private final OutputStream outputStream$1(ConvertParameters.ConvertParameters params$1, ObjectRef outputStream$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.outputStream$lzycompute$1(params$1, outputStream$lzy$1, bitmap$0$1) : (OutputStream)outputStream$lzy$1.elem;
    }

    private final Writer writer$lzycompute$1(ConvertParameters.ConvertParameters params$1, ObjectRef writer$lzy$1, VolatileByteRef bitmap$0$1) {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                writer$lzy$1.elem = ExportCommand$.MODULE$.getWriter(params$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (Writer)writer$lzy$1.elem;
        }
    }

    private final Writer writer$1(ConvertParameters.ConvertParameters params$1, ObjectRef writer$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.writer$lzycompute$1(params$1, writer$lzy$1, bitmap$0$1) : (Writer)writer$lzy$1.elem;
    }

    private final int avroCompression$lzycompute$1(ConvertParameters.ConvertParameters params$1, IntRef avroCompression$lzy$1, VolatileByteRef bitmap$0$1) {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if ((byte)(bitmap$0$1.elem & 4) == 0) {
                avroCompression$lzy$1.elem = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)params$1.gzip()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Integer x$3) {
                        return Predef$.MODULE$.Integer2int(x$3);
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                }));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 4);
            }
            return avroCompression$lzy$1.elem;
        }
    }

    private final int avroCompression$1(ConvertParameters.ConvertParameters params$1, IntRef avroCompression$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 4) == 0 ? this.avroCompression$lzycompute$1(params$1, avroCompression$lzy$1, bitmap$0$1) : avroCompression$lzy$1.elem;
    }

    private final Hints hints$lzycompute$1(ConvertParameters.ConvertParameters params$1, ObjectRef hints$lzy$1, VolatileByteRef bitmap$0$1) {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if ((byte)(bitmap$0$1.elem & 8) == 0) {
                Query q = new Query("");
                Option$.MODULE$.apply(params$1.hints()).foreach((Function1)new Serializable(q){
                    public static final long serialVersionUID = 0L;
                    private final Query q$1;

                    public final void apply(Map<String, String> hints2) {
                        this.q$1.getHints().put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, hints2);
                        ViewParams$.MODULE$.setHints(this.q$1);
                    }
                    {
                        this.q$1 = q$1;
                    }
                });
                hints$lzy$1.elem = q.getHints();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 8);
            }
            return (Hints)hints$lzy$1.elem;
        }
    }

    private final Hints hints$1(ConvertParameters.ConvertParameters params$1, ObjectRef hints$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 8) == 0 ? this.hints$lzycompute$1(params$1, hints$lzy$1, bitmap$0$1) : (Hints)hints$lzy$1.elem;
    }

    private final scala.collection.immutable.Map arrowDictionaries$lzycompute$1(ConvertParameters.ConvertParameters params$1, Function0 features$2, ObjectRef hints$lzy$1, ObjectRef arrowDictionaries$lzy$1, VolatileByteRef bitmap$0$1) {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if ((byte)(bitmap$0$1.elem & 0x10) == 0) {
                scala.collection.immutable.Map map;
                Seq attributes = QueryHints$.MODULE$.RichHints(this.hints$1(params$1, hints$lzy$1, bitmap$0$1)).getArrowDictionaryFields();
                if (attributes.isEmpty()) {
                    map = Predef$.MODULE$.Map().empty();
                } else {
                    Seq values = (Seq)attributes.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, HashSet<Object>> apply(String a) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)a), (Object)HashSet$.MODULE$.empty());
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    ((Iterator)features$2.apply()).foreach((Function1)new Serializable(values){
                        public static final long serialVersionUID = 0L;
                        private final Seq values$1;

                        public final void apply(SimpleFeature f) {
                            this.values$1.foreach((Function1)new Serializable(this, f){
                                public static final long serialVersionUID = 0L;
                                private final SimpleFeature f$1;

                                public final boolean apply(Tuple2<String, HashSet<Object>> x0$1) {
                                    Tuple2<String, HashSet<Object>> tuple2 = x0$1;
                                    if (tuple2 != null) {
                                        String a = (String)tuple2._1();
                                        HashSet v = (HashSet)tuple2._2();
                                        boolean bl = v.add(this.f$1.getAttribute(a));
                                        return bl;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.f$1 = f$1;
                                }
                            });
                        }
                        {
                            this.values$1 = values$1;
                        }
                    });
                    map = ((TraversableOnce)values.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, Object[]> apply(Tuple2<String, HashSet<Object>> x0$2) {
                            Tuple2<String, HashSet<Object>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String attribute = (String)tuple2._1();
                                HashSet value = (HashSet)tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attribute), value.toArray(ClassTag$.MODULE$.AnyRef()));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                }
                arrowDictionaries$lzy$1.elem = map;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 0x10);
            }
            return (scala.collection.immutable.Map)arrowDictionaries$lzy$1.elem;
        }
    }

    public final scala.collection.immutable.Map org$locationtech$geomesa$tools$ConvertCommand$$arrowDictionaries$1(ConvertParameters.ConvertParameters params$1, Function0 features$2, ObjectRef hints$lzy$1, ObjectRef arrowDictionaries$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 0x10) == 0 ? this.arrowDictionaries$lzycompute$1(params$1, features$2, hints$lzy$1, arrowDictionaries$lzy$1, bitmap$0$1) : (scala.collection.immutable.Map)arrowDictionaries$lzy$1.elem;
    }

    private ConvertCommand$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

