/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import java.io.OutputStream;
import org.geotools.GML;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u001f\tYq)\u001c7FqB|'\u000f^3s\u0015\t\u0019A!A\u0004g_Jl\u0017\r^:\u000b\u0005\u00151\u0011AB3ya>\u0014HO\u0003\u0002\b\u0011\u0005)Ao\\8mg*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0003\u0007\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\\1oO*\tQ#\u0001\u0003kCZ\f\u0017BA\f\u0013\u0005\u0019y%M[3diB\u0011\u0011DG\u0007\u0002\u0005%\u00111D\u0001\u0002\u0010\r\u0016\fG/\u001e:f\u000bb\u0004xN\u001d;fe\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u0002pgB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005F\u0001\u0003S>L!a\t\u0011\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t9\u0003\u0006\u0005\u0002\u001a\u0001!)Q\u0004\na\u0001=!9!\u0006\u0001b\u0001\n\u0013Y\u0013AB3oG>$W-F\u0001-!\ti\u0003'D\u0001/\u0015\tyC\"\u0001\u0005hK>$xn\u001c7t\u0013\t\tdFA\u0002H\u001b2Caa\r\u0001!\u0002\u0013a\u0013aB3oG>$W\r\t\u0005\nk\u0001\u0001\r\u00111A\u0005\nY\n1a\u001d4u+\u00059\u0004C\u0001\u001d@\u001b\u0005I$B\u0001\u001e<\u0003\u0019\u0019\u0018.\u001c9mK*\u0011A(P\u0001\bM\u0016\fG/\u001e:f\u0015\tqD\"A\u0004pa\u0016tw-[:\n\u0005\u0001K$!E*j[BdWMR3biV\u0014X\rV=qK\"I!\t\u0001a\u0001\u0002\u0004%IaQ\u0001\bg\u001a$x\fJ3r)\t!%\n\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0003V]&$\bbB&B\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0004BB'\u0001A\u0003&q'\u0001\u0003tMR\u0004\u0003\"C(\u0001\u0001\u0004\u0005\r\u0011\"\u0003Q\u0003\u001d\u0011X\r^=qK\u0012,\u0012!\u0015\t\u0004\u000bJ;\u0014BA*G\u0005\u0019y\u0005\u000f^5p]\"IQ\u000b\u0001a\u0001\u0002\u0004%IAV\u0001\fe\u0016$\u0018\u0010]3e?\u0012*\u0017\u000f\u0006\u0002E/\"91\nVA\u0001\u0002\u0004\t\u0006BB-\u0001A\u0003&\u0011+\u0001\u0005sKRL\b/\u001a3!\u0011\u0015Y\u0006\u0001\"\u0011]\u0003\u0015\u0019H/\u0019:u)\t!U\fC\u000365\u0002\u0007q\u0007C\u0003\u0006\u0001\u0011\u0005s\f\u0006\u0002aIB\u0019QIU1\u0011\u0005\u0015\u0013\u0017BA2G\u0005\u0011auN\\4\t\u000b\u0015t\u0006\u0019\u00014\u0002\u0011\u0019,\u0017\r^;sKN\u00042aZ8s\u001d\tAWN\u0004\u0002jY6\t!N\u0003\u0002l\u001d\u00051AH]8pizJ\u0011aR\u0005\u0003]\u001a\u000bq\u0001]1dW\u0006<W-\u0003\u0002qc\nA\u0011\n^3sCR|'O\u0003\u0002o\rB\u0011\u0001h]\u0005\u0003if\u0012QbU5na2,g)Z1ukJ,\u0007\"\u0002<\u0001\t\u0003:\u0018!B2m_N,G#\u0001#")
public class GmlExporter
implements FeatureExporter {
    private final OutputStream os;
    private final GML encode;
    private SimpleFeatureType sft;
    private Option<SimpleFeatureType> retyped;

    private GML encode() {
        return this.encode;
    }

    private SimpleFeatureType sft() {
        return this.sft;
    }

    private void sft_$eq(SimpleFeatureType x$1) {
        this.sft = x$1;
    }

    private Option<SimpleFeatureType> retyped() {
        return this.retyped;
    }

    private void retyped_$eq(Option<SimpleFeatureType> x$1) {
        this.retyped = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        None$ none$;
        this.sft_$eq(sft);
        if (sft.getName().getNamespaceURI() == null) {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.init(sft);
            builder.setNamespaceURI("http://geomesa.org");
            none$ = new Some((Object)builder.buildFeatureType());
        } else {
            none$ = None$.MODULE$;
        }
        this.retyped_$eq((Option<SimpleFeatureType>)none$);
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        SimpleFeature[] array = (SimpleFeature[])features.toArray(ClassTag$.MODULE$.apply(SimpleFeature.class));
        ListFeatureCollection list = new ListFeatureCollection(this.sft(), array);
        SimpleFeatureCollection collection = (SimpleFeatureCollection)this.retyped().map((Function1)new Serializable(this, list){
            public static final long serialVersionUID = 0L;
            private final ListFeatureCollection list$1;

            public final ReTypingFeatureCollection apply(SimpleFeatureType r) {
                return new ReTypingFeatureCollection((SimpleFeatureCollection)this.list$1, r);
            }
            {
                this.list$1 = list$1;
            }
        }).getOrElse((Function0)new Serializable(this, list){
            public static final long serialVersionUID = 0L;
            private final ListFeatureCollection list$1;

            public final ListFeatureCollection apply() {
                return this.list$1;
            }
            {
                this.list$1 = list$1;
            }
        });
        this.encode().encode(this.os, collection);
        this.os.flush();
        return new Some((Object)BoxesRunTime.boxToLong((long)array.length));
    }

    @Override
    public void close() {
        this.os.close();
    }

    public GmlExporter(OutputStream os) {
        this.os = os;
        this.encode = new GML(GML.Version.WFS1_0);
        this.encode().setNamespace("geomesa", "http://geomesa.org");
    }
}

