/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.beust.jcommander.ParameterException;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.factory.Hints;
import org.geotools.filter.identity.FeatureIdImpl;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DistributedRunParam$RunModes$;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import org.locationtech.geomesa.tools.ingest.AbstractIngest$;
import org.locationtech.geomesa.tools.ingest.LocalIngestConverter;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import org.locationtech.geomesa.utils.stats.CountingInputStream;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEc!B\u0001\u0003\u0003\u0003i!AD!cgR\u0014\u0018m\u0019;J]\u001e,7\u000f\u001e\u0006\u0003\u0007\u0011\ta!\u001b8hKN$(BA\u0003\u0007\u0003\u0015!xn\u001c7t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qa#\u0007\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qbF\u0005\u00031A\u0011\u0001BU;o]\u0006\u0014G.\u001a\t\u00035\u0005j\u0011a\u0007\u0006\u00039u\tAb]2bY\u0006dwnZ4j]\u001eT!AH\u0010\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001I\u0001\u0004G>l\u0017B\u0001\u0012\u001c\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011\u0011\u0002!Q1A\u0005\u0002\u0015\n\u0001\u0002Z:QCJ\fWn]\u000b\u0002MA!q%\f\u00191\u001d\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0004\u001b\u0006\u0004(B\u0001\u0017*!\t9\u0013'\u0003\u00023_\t11\u000b\u001e:j]\u001eD\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006IAJ\u0001\nIN\u0004\u0016M]1ng\u0002B\u0001B\u000e\u0001\u0003\u0006\u0004%\taN\u0001\tif\u0004XMT1nKV\t\u0001\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u00031\u0003%!\u0018\u0010]3OC6,\u0007\u0005\u0003\u0005<\u0001\t\u0015\r\u0011\"\u0001=\u0003\u0019Ig\u000e];ugV\tQ\bE\u0002?\rBr!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\tc\u0011A\u0002\u001fs_>$h(C\u0001+\u0013\t)\u0015&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%aA*fc*\u0011Q)\u000b\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005{\u00059\u0011N\u001c9viN\u0004\u0003\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\u0002\t5|G-\u001a\t\u0004Q9\u0003\u0016BA(*\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u000b\u0019\b\u0003%vs!aU.\u000f\u0005QSfBA+Z\u001d\t1\u0006L\u0004\u0002A/&\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!\u0001\u0018\u0003\u0002'\u0011K7\u000f\u001e:jEV$X\r\u001a*v]B\u000b'/Y7\n\u0005y{\u0016\u0001\u0003*v]6{G-Z:\u000b\u0005q#\u0011BA1c\u0005\u001d\u0011VO\\'pI\u0016T!AX0\t\u0011\u0011\u0004!\u0011!Q\u0001\nA\n1\u0002\\5cU\u0006\u00148OR5mK\"Aa\r\u0001B\u0001B\u0003%q-\u0001\u0007mS\nT\u0017M]:QCRD7\u000fE\u0002?Q*L!!\u001b%\u0003\u0011%#XM]1u_J\u00042\u0001K6n\u0013\ta\u0017FA\u0005Gk:\u001cG/[8oaA\u0019aH\u00128\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\u0014\u0012AA5p\u0013\t\u0019\bO\u0001\u0003GS2,\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011\u0002<\u0002\u001f9,X\u000eT8dC2$\u0006N]3bIN\u0004\"\u0001K<\n\u0005aL#aA%oi\")!\u0010\u0001C\u0001w\u00061A(\u001b8jiz\"R\u0002 @\u0000\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u0001CA?\u0001\u001b\u0005\u0011\u0001\"\u0002\u0013z\u0001\u00041\u0003\"\u0002\u001cz\u0001\u0004\u0001\u0004\"B\u001ez\u0001\u0004i\u0004\"\u0002'z\u0001\u0004i\u0005\"\u00023z\u0001\u0004\u0001\u0004\"\u00024z\u0001\u00049\u0007\"B;z\u0001\u00041\bbBA\u0007\u0001\u0019\u0005\u0011qB\u0001\u000fE\u00164wN]3Sk:$\u0016m]6t)\t\t\t\u0002E\u0002)\u0003'I1!!\u0006*\u0005\u0011)f.\u001b;\t\u000f\u0005e\u0001A\"\u0001\u0002\u001c\u0005!2M]3bi\u0016dunY1m\u0007>tg/\u001a:uKJ$b!!\b\u0002$\u0005\u001d\u0002cA?\u0002 %\u0019\u0011\u0011\u0005\u0002\u0003)1{7-\u00197J]\u001e,7\u000f^\"p]Z,'\u000f^3s\u0011\u001d\t)#a\u0006A\u0002A\nA\u0001]1uQ\"A\u0011\u0011FA\f\u0001\u0004\tY#\u0001\u0005gC&dWO]3t!\u0011\ti#a\u000f\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\ta!\u0019;p[&\u001c'\u0002BA\u001b\u0003o\t!bY8oGV\u0014(/\u001a8u\u0015\r\tIDE\u0001\u0005kRLG.\u0003\u0003\u0002>\u0005=\"AC!u_6L7\rT8oO\"9\u0011\u0011\t\u0001\u0007\u0002\u0005\r\u0013!\u0005:v]\u0012K7\u000f\u001e:jEV$X\r\u001a&pER!\u0011QIA)!\u001dA\u0013qIA&\u0003\u0017J1!!\u0013*\u0005\u0019!V\u000f\u001d7feA\u0019\u0001&!\u0014\n\u0007\u0005=\u0013F\u0001\u0003M_:<\u0007\u0002CA*\u0003\u007f\u0001\r!!\u0016\u0002\u001dM$\u0018\r^;t\u0007\u0006dGNY1dWB!\u0011qKAF\u001d\ri\u0018\u0011L\u0004\b\u00037\u0012\u0001\u0012AA/\u00039\t%m\u001d;sC\u000e$\u0018J\\4fgR\u00042!`A0\r\u0019\t!\u0001#\u0001\u0002bM!\u0011qLA2!\rA\u0013QM\u0005\u0004\u0003OJ#AB!osJ+g\rC\u0004{\u0003?\"\t!a\u001b\u0015\u0005\u0005u\u0003bCA8\u0003?B)\u0019!C\u0005\u0003c\nQ\u0002^3s[&t\u0017\r\\,jIRDWCAA:!\u0011A3.!\u001e\u0011\u0007!\n9(C\u0002\u0002z%\u0012QA\u00127pCRD1\"! \u0002`!\u0005\t\u0015)\u0003\u0002t\u0005qA/\u001a:nS:\fGnV5ei\"\u0004\u0003\u0002CAA\u0003?\"\t!a!\u0002\u0017\u001d,Go\u0015;bi&sgm\u001c\u000b\u0006a\u0005\u0015\u0015\u0011\u0012\u0005\t\u0003\u000f\u000by\b1\u0001\u0002L\u0005I1/^2dKN\u001cXm\u001d\u0005\t\u0003S\ty\b1\u0001\u0002L\u0019Q\u0011QRA0!\u0003\r\n#a$\u0003\u001dM#\u0018\r^;t\u0007\u0006dGNY1dWN!\u00111RA2\u0011!\t\u0019*a#\u0007\u0002\u0005=\u0011!\u0002:fg\u0016$\b\u0002CAL\u0003\u00173\t!!'\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\u0005E\u00111TAP\u0003G\u000bY\u000bC\u0004\u0002\u001e\u0006U\u0005\u0019\u0001\u0019\u0002\rA\u0014XMZ5y\u0011!\t\t+!&A\u0002\u0005U\u0014\u0001\u00039s_\u001e\u0014Xm]:\t\u0011\u0005\u0015\u0016Q\u0013a\u0001\u0003O\u000b\u0001bY8v]R,'o\u001d\t\u0005}\u0019\u000bI\u000b\u0005\u0004)\u0003\u000f\u0002\u00141\n\u0005\t\u0003[\u000b)\n1\u0001\u00020\u0006!Am\u001c8f!\rA\u0013\u0011W\u0005\u0004\u0003gK#a\u0002\"p_2,\u0017M\\\u0015\u0005\u0003\u0017\u000b9LB\u0004\u0002:\u0006}\u0003!a/\u0003\u001bA\u0013\u0018N\u001c;Qe><'/Z:t'\u0019\t9,a\u0019\u0002>B!\u0011qXAF\u001b\t\ty\u0006C\u0006\u0002D\u0006]&\u0011!Q\u0001\n\u0005\u0015\u0017aA8viB\u0019q.a2\n\u0007\u0005%\u0007OA\u0006Qe&tGo\u0015;sK\u0006l\u0007BCAg\u0003o\u0013\t\u0011)A\u0005a\u0005AQ-\u001c9us\n\u000b'\u000fC\u0006\u0002R\u0006]&\u0011!Q\u0001\n\u0005M\u0017a\u0003:fa2\f7-Z7f]R\u00042\u0001KAk\u0013\r\t9.\u000b\u0002\u0005\u0007\"\f'\u000fC\u0006\u0002\\\u0006]&\u0011!Q\u0001\n\u0005M\u0017!C5oI&\u001c\u0017\r^8s\u0011-\ty.a.\u0003\u0002\u0003\u0006I!a5\u0002\rQ|wm\u001a7f\u0011\u001dQ\u0018q\u0017C\u0001\u0003G$B\"!:\u0002h\u0006%\u00181^Aw\u0003_\u0004B!a0\u00028\"A\u00111YAq\u0001\u0004\t)\rC\u0004\u0002N\u0006\u0005\b\u0019\u0001\u0019\t\u0011\u0005E\u0017\u0011\u001da\u0001\u0003'D\u0001\"a7\u0002b\u0002\u0007\u00111\u001b\u0005\t\u0003?\f\t\u000f1\u0001\u0002T\"Q\u00111_A\\\u0001\u0004%I!!>\u0002\u000fQ|wm\u001a7fIV\u0011\u0011q\u0016\u0005\u000b\u0003s\f9\f1A\u0005\n\u0005m\u0018a\u0003;pO\u001edW\rZ0%KF$B!!\u0005\u0002~\"Q\u0011q`A|\u0003\u0003\u0005\r!a,\u0002\u0007a$\u0013\u0007C\u0005\u0003\u0004\u0005]\u0006\u0015)\u0003\u00020\u0006AAo\\4hY\u0016$\u0007\u0005\u0003\u0006\u0003\b\u0005]\u0006\u0019!C\u0005\u0005\u0013\tQa\u001d;beR,\"!a\u0013\t\u0015\t5\u0011q\u0017a\u0001\n\u0013\u0011y!A\u0005ti\u0006\u0014Ho\u0018\u0013fcR!\u0011\u0011\u0003B\t\u0011)\tyPa\u0003\u0002\u0002\u0003\u0007\u00111\n\u0005\n\u0005+\t9\f)Q\u0005\u0003\u0017\naa\u001d;beR\u0004\u0003\u0002CAJ\u0003o#\t%a\u0004\t\u0011\u0005]\u0015q\u0017C!\u00057!\"\"!\u0005\u0003\u001e\t}!\u0011\u0005B\u0012\u0011\u001d\tiJ!\u0007A\u0002AB\u0001\"!)\u0003\u001a\u0001\u0007\u0011Q\u000f\u0005\t\u0003K\u0013I\u00021\u0001\u0002(\"A\u0011Q\u0016B\r\u0001\u0004\ty\u000bC\u0005\u0003(\u0001\u0011\r\u0011\"\u0005\u0003*\u0005\u0011Am]\u000b\u0003\u0005W\u0001BA!\f\u000385\u0011!q\u0006\u0006\u0005\u0005c\u0011\u0019$\u0001\u0003eCR\f'b\u0001B\u001b\u0015\u0005Aq-Z8u_>d7/\u0003\u0003\u0003:\t=\"!\u0003#bi\u0006\u001cFo\u001c:f\u0011!\u0011i\u0004\u0001Q\u0001\n\t-\u0012a\u00013tA!9!\u0011\t\u0001\u0005B\u0005=\u0011a\u0001:v]\"9!Q\t\u0001\u0005\u0012\u0005=\u0011\u0001\u0003:v]2{7-\u00197\t\u000f\t%\u0003\u0001\"\u0005\u0002\u0010\u0005q!/\u001e8ESN$(/\u001b2vi\u0016$\u0007b\u0002B'\u0001\u0011%!qJ\u0001\u000fGJ,\u0017\r^3DC2d'-Y2l)\t\t)\u0006")
public abstract class AbstractIngest
implements Runnable,
LazyLogging {
    private final scala.collection.immutable.Map<String, String> dsParams;
    private final String typeName;
    private final Seq<String> inputs;
    private final Option<Enumeration.Value> mode;
    private final int numLocalThreads;
    private final DataStore ds;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String getStatInfo(long l, long l2) {
        return AbstractIngest$.MODULE$.getStatInfo(l, l2);
    }

    private Logger logger$lzycompute() {
        AbstractIngest abstractIngest = this;
        synchronized (abstractIngest) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public scala.collection.immutable.Map<String, String> dsParams() {
        return this.dsParams;
    }

    public String typeName() {
        return this.typeName;
    }

    public Seq<String> inputs() {
        return this.inputs;
    }

    public abstract void beforeRunTasks();

    public abstract LocalIngestConverter createLocalConverter(String var1, AtomicLong var2);

    public abstract Tuple2<Object, Object> runDistributedJob(StatusCallback var1);

    public DataStore ds() {
        return this.ds;
    }

    @Override
    public void run() {
        block8: {
            block7: {
                block6: {
                    if (this.inputs().isEmpty() && !LocalDelegate.StdInHandle$.MODULE$.isAvailable()) {
                        throw new ParameterException("Missing option: <files>... is required");
                    }
                    if (!this.inputs().headOption().exists((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String path) {
                            return PathUtils$.MODULE$.isRemote(path);
                        }
                    })) break block6;
                    if (this.mode.contains((Object)DistributedRunParam$RunModes$.MODULE$.Local())) {
                        this.runLocal();
                    } else {
                        this.runDistributed();
                    }
                    break block7;
                }
                if (!this.mode.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Enumeration.Value x$1) {
                        Enumeration.Value value = x$1;
                        Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
                        return !(value != null ? !value.equals(value2) : value2 != null);
                    }
                })) break block8;
                this.runLocal();
            }
            this.ds().dispose();
            return;
        }
        throw new ParameterException("To run in distributed mode, please copy input files to a distributed file system");
    }

    /*
     * WARNING - void declaration
     */
    public void runLocal() {
        this.beforeRunTasks();
        Command$.MODULE$.user().info("Running ingestion in local mode");
        Tuple2 tuple2 = new Tuple2((Object)new AtomicLong(0L), (Object)new AtomicLong(0L));
        if (tuple2 != null) {
            Object object;
            int n;
            Seq files;
            Tuple2 tuple22;
            AtomicLong written = (AtomicLong)tuple2._1();
            AtomicLong failed2 = (AtomicLong)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)written, (Object)failed2);
            AtomicLong written2 = (AtomicLong)tuple23._1();
            AtomicLong failed3 = (AtomicLong)tuple23._2();
            AtomicLong bytesRead = new AtomicLong(0L);
            boolean stdin = this.inputs().isEmpty();
            Seq seq = files = stdin ? Option$.MODULE$.option2Iterable(LocalDelegate.StdInHandle$.MODULE$.available()).toSeq() : (Seq)this.inputs().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<FileSystemDelegate.FileHandle> apply(String path) {
                    return PathUtils$.MODULE$.interpretPath(path);
                }
            }, Seq$.MODULE$.canBuildFrom());
            if (this.numLocalThreads <= files.length()) {
                n = this.numLocalThreads;
            } else {
                Command$.MODULE$.user().warn("Can't use more threads than there are input files - reducing thread count");
                n = files.length();
            }
            int threads = n;
            Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ingesting ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stdin ? "from stdin" : TextTools$.MODULE$.getPlural((long)files.length(), "file")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getPlural((long)threads, "thread")}))).toString());
            if (stdin) {
                object = new Serializable(this, bytesRead, files){
                    public static final long serialVersionUID = 0L;
                    private final AtomicLong bytesRead$1;
                    private final Seq files$1;

                    public final float apply() {
                        return this.apply$mcF$sp();
                    }

                    public float apply$mcF$sp() {
                        return this.bytesRead$1.get() + BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.files$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(FileSystemDelegate.FileHandle x$4) {
                                return x$4.length();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    }
                    {
                        this.bytesRead$1 = bytesRead$1;
                        this.files$1 = files$1;
                    }
                };
            } else {
                float length = BoxesRunTime.unboxToLong((Object)((TraversableOnce)files.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileSystemDelegate.FileHandle x$5) {
                        return x$5.length();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                object = new Serializable(this, length){
                    public static final long serialVersionUID = 0L;
                    private final float length$1;

                    public final float apply() {
                        return this.apply$mcF$sp();
                    }

                    public float apply$mcF$sp() {
                        return this.length$1;
                    }
                    {
                        this.length$1 = length$1;
                    }
                };
            }
            Serializable totalLength = object;
            long start2 = System.currentTimeMillis();
            StatusCallback statusCallback = this.createCallback();
            ExecutorService es = Executors.newFixedThreadPool(threads);
            List futures = ((TraversableOnce)files.map((Function1)new Serializable(this, written2, failed3, bytesRead, es){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractIngest $outer;
                private final AtomicLong written$1;
                private final AtomicLong failed$1;
                private final AtomicLong bytesRead$1;
                private final ExecutorService es$1;

                public final Future<?> apply(FileSystemDelegate.FileHandle f) {
                    public class Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1
                    implements Runnable {
                        private final FileSystemDelegate.FileHandle file;
                        public final /* synthetic */ AbstractIngest $outer;
                        public final AtomicLong written$1;
                        public final AtomicLong failed$1;
                        public final AtomicLong bytesRead$1;

                        /*
                         * WARNING - void declaration
                         */
                        public void run() {
                            block11: {
                                try {
                                    Tuple2<SimpleFeatureType, Iterator<SimpleFeature>> tuple2;
                                    block10: {
                                        ObjectRef fw = ObjectRef.create(null);
                                        LocalIngestConverter converter = this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().createLocalConverter(this.file.path(), this.failed$1);
                                        CountingInputStream countingStream = new CountingInputStream(this.file.open());
                                        InputStream is = PathUtils$.MODULE$.handleCompression((InputStream)countingStream, this.file.path());
                                        try {
                                            Tuple2 tuple22;
                                            tuple2 = converter.convert(is);
                                            if (tuple2 == null) break block10;
                                            SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
                                            Iterator features = (Iterator)tuple2._2();
                                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sft, (Object)features);
                                            SimpleFeatureType sft2 = (SimpleFeatureType)tuple23._1();
                                            Iterator features2 = (Iterator)tuple23._2();
                                            if (features2.hasNext()) {
                                                this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().ds().createSchema((FeatureType)sft2);
                                                fw.elem = this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().ds().getFeatureWriterAppend(this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().typeName(), Transaction.AUTO_COMMIT);
                                            }
                                            features2.foreach((Function1)new Serializable(this, fw, countingStream){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1 $outer;
                                                private final ObjectRef fw$1;
                                                private final CountingInputStream countingStream$1;

                                                public final void apply(SimpleFeature sf) {
                                                    long l;
                                                    SimpleFeature toWrite = (SimpleFeature)((FeatureWriter)this.fw$1.elem).next();
                                                    toWrite.setAttributes(sf.getAttributes());
                                                    ((FeatureIdImpl)toWrite.getIdentifier()).setID(sf.getID());
                                                    toWrite.getUserData().putAll(sf.getUserData());
                                                    toWrite.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
                                                    try {
                                                        ((FeatureWriter)this.fw$1.elem).write();
                                                        l = this.$outer.written$1.incrementAndGet();
                                                    }
                                                    catch (Throwable throwable) {
                                                        long l2;
                                                        BoxedUnit boxedUnit;
                                                        Throwable throwable2 = throwable;
                                                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                                                        if (option.isEmpty()) {
                                                            throw throwable;
                                                        }
                                                        Throwable e = (Throwable)option.get();
                                                        if (this.$outer.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().isErrorEnabled()) {
                                                            this.$outer.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataUtilities.encodeFeature((SimpleFeature)toWrite)})), e);
                                                            boxedUnit = BoxedUnit.UNIT;
                                                        } else {
                                                            boxedUnit = BoxedUnit.UNIT;
                                                        }
                                                        l = l2 = this.$outer.failed$1.incrementAndGet();
                                                    }
                                                    this.$outer.bytesRead$1.addAndGet(this.countingStream$1.getCount());
                                                    this.countingStream$1.resetCount();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.fw$1 = fw$1;
                                                    this.countingStream$1 = countingStream$1;
                                                }
                                            });
                                        }
                                        catch (Throwable throwable) {
                                            void var8_1;
                                            void var11_4;
                                            void var9_2;
                                            IOUtils.closeQuietly((Closeable)var9_2);
                                            IOUtils.closeQuietly((InputStream)var11_4);
                                            IOUtils.closeQuietly((Closeable)((FeatureWriter)var8_1.elem));
                                            throw throwable;
                                        }
                                        IOUtils.closeQuietly((Closeable)converter);
                                        IOUtils.closeQuietly((InputStream)is);
                                        IOUtils.closeQuietly((Closeable)((FeatureWriter)fw.elem));
                                        break block11;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                catch (Throwable throwable) {
                                    BoxedUnit boxedUnit;
                                    Throwable throwable2 = throwable;
                                    boolean bl = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
                                    if (bl) {
                                        throw throwable2;
                                    }
                                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                                    if (option.isEmpty()) {
                                        throw throwable;
                                    }
                                    Throwable e = (Throwable)option.get();
                                    String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fatal error running local ingest worker on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file.path()}));
                                    Command$.MODULE$.user().error(msg);
                                    if (this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().isErrorEnabled()) {
                                        this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().error(msg, e);
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit2 = boxedUnit;
                                }
                            }
                        }

                        public /* synthetic */ AbstractIngest org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer() {
                            return this.$outer;
                        }

                        public Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1(AbstractIngest $outer, FileSystemDelegate.FileHandle file, AtomicLong written$1, AtomicLong failed$1, AtomicLong bytesRead$1) {
                            this.file = file;
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.written$1 = written$1;
                            this.failed$1 = failed$1;
                            this.bytesRead$1 = bytesRead$1;
                        }
                    }
                    return this.es$1.submit(new Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1(this.$outer, f, this.written$1, this.failed$1, this.bytesRead$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.written$1 = written$1;
                    this.failed$1 = failed$1;
                    this.bytesRead$1 = bytesRead$1;
                    this.es$1 = es$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).toList();
            es.shutdown();
            while (true) {
                void var7_7;
                void var6_6;
                void var12_13;
                void var8_8;
                void var16_15;
                if (es.isTerminated()) {
                    statusCallback.apply("", this.progress$1(bytesRead, (Function0)totalLength), (Seq<Tuple2<String, Object>>)this.counters$1(written2, failed3), true);
                    futures.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Future<?> x$6) {
                            return x$6.get();
                        }
                    });
                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local ingestion complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start2)})));
                    Command$.MODULE$.user().info(AbstractIngest$.MODULE$.getStatInfo(written2.get(), failed3.get()));
                    return;
                }
                Thread.sleep(500L);
                var16_15.apply("", this.progress$1((AtomicLong)var8_8, (Function0)var12_13), (Seq<Tuple2<String, Object>>)this.counters$1((AtomicLong)var6_6, (AtomicLong)var7_7), false);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public void runDistributed() {
        this.beforeRunTasks();
        Command$.MODULE$.user().info("Running ingestion in distributed mode");
        long start2 = System.currentTimeMillis();
        StatusCallback statusCallback = this.createCallback();
        Tuple2<Object, Object> tuple2 = this.runDistributedJob(statusCallback);
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long success = tuple2._1$mcJ$sp();
            long failed2 = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(success, failed2);
            long success2 = sp3._1$mcJ$sp();
            long failed3 = sp3._2$mcJ$sp();
            Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distributed ingestion complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start2)})));
            Command$.MODULE$.user().info(AbstractIngest$.MODULE$.getStatInfo(success2, failed3));
            return;
        }
        throw new MatchError(tuple2);
    }

    private StatusCallback createCallback() {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"accumulo.mock", "useMock"}))).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIngest $outer;

            public final boolean apply(String x$8) {
                return this.$outer.dsParams().get((Object)x$8).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$9) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toBoolean();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }) ? new PrintProgress(System.err, TextTools$.MODULE$.buildString('\u26ac', 60), ' ', '\u15e7', '\u2b58') : new PrintProgress(System.err, TextTools$.MODULE$.buildString(' ', 60), '=', '>', '>');
    }

    private final float progress$1(AtomicLong bytesRead$1, Function0 totalLength$1) {
        return (float)((double)bytesRead$1.get() / (double)totalLength$1.apply$mcF$sp());
    }

    private final Seq counters$1(AtomicLong written$1, AtomicLong failed$1) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"ingested", (Object)BoxesRunTime.boxToLong((long)written$1.get())), new Tuple2((Object)"failed", (Object)BoxesRunTime.boxToLong((long)failed$1.get()))}));
    }

    public AbstractIngest(scala.collection.immutable.Map<String, String> dsParams, String typeName, Seq<String> inputs, Option<Enumeration.Value> mode, String libjarsFile, Iterator<Function0<Seq<File>>> libjarsPaths, int numLocalThreads) {
        this.dsParams = dsParams;
        this.typeName = typeName;
        this.inputs = inputs;
        this.mode = mode;
        this.numLocalThreads = numLocalThreads;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ds = DataStoreFinder.getDataStore((Map)JavaConversions$.MODULE$.mapAsJavaMap(dsParams));
    }

    public static class PrintProgress
    implements StatusCallback {
        private final PrintStream out;
        private final String emptyBar;
        private final char replacement;
        private final char indicator;
        private final char toggle;
        private boolean toggled;
        private long start;

        private boolean toggled() {
            return this.toggled;
        }

        private void toggled_$eq(boolean x$1) {
            this.toggled = x$1;
        }

        private long start() {
            return this.start;
        }

        private void start_$eq(long x$1) {
            this.start = x$1;
        }

        @Override
        public void reset() {
            this.start_$eq(System.currentTimeMillis());
        }

        @Override
        public void apply(String prefix, float progress, Seq<Tuple2<String, Object>> counters, boolean done) {
            String string;
            int arg$macro$1 = (int)(progress * (float)100);
            String percent = new StringOps("%3d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
            String counterString = counters.isEmpty() ? "" : ((TraversableOnce)counters.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, Object> x0$1) {
                    Tuple2<String, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String label = (String)tuple2._1();
                        long count = tuple2._2$mcJ$sp();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)count), label}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(" ", " ", "");
            String info = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", "% complete", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{percent, counterString, TextTools$.MODULE$.getTime(this.start())}));
            float tWidth = AbstractIngest$.MODULE$.org$locationtech$geomesa$tools$ingest$AbstractIngest$$terminalWidth().apply$mcF$sp();
            float scaleFactor = tWidth > (float)(info.length() + 3) && tWidth < (float)(this.emptyBar.length() + info.length() + 2 + prefix.length()) ? (tWidth - (float)info.length() - (float)2 - (float)prefix.length()) / (float)this.emptyBar.length() : 1.0f;
            int scaledLen = (int)((float)this.emptyBar.length() * scaleFactor);
            int numDone = (int)((float)scaledLen * progress);
            if (numDone < 1) {
                string = this.emptyBar.substring(this.emptyBar.length() - scaledLen);
            } else if (numDone >= scaledLen) {
                string = TextTools$.MODULE$.buildString(this.replacement, scaledLen);
            } else {
                String doneStr = TextTools$.MODULE$.buildString(this.replacement, numDone - 1);
                String doStr = this.emptyBar.substring(this.emptyBar.length() - (scaledLen - numDone));
                char i = this.toggled() ? this.toggle : this.indicator;
                this.toggled_$eq(!this.toggled());
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{doneStr, BoxesRunTime.boxToCharacter((char)i), doStr}));
            }
            String bar = string;
            this.out.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\r", "[", "]", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, bar, info})));
            if (done) {
                this.out.println();
            }
        }

        public PrintProgress(PrintStream out, String emptyBar, char replacement, char indicator, char toggle) {
            this.out = out;
            this.emptyBar = emptyBar;
            this.replacement = replacement;
            this.indicator = indicator;
            this.toggle = toggle;
            this.toggled = false;
            this.start = System.currentTimeMillis();
        }
    }

    public static interface StatusCallback {
        public void reset();

        public void apply(String var1, float var2, Seq<Tuple2<String, Object>> var3, boolean var4);
    }
}

