/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.NullableFloat4Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.impl.AbstractPolygonVector;

public class PolygonFloatVector
extends AbstractPolygonVector {
    public static final List<Field> fields = GeometryFields.XY_FLOAT_LIST_2;

    public PolygonFloatVector(String name, BufferAllocator allocator, @Nullable Map<String, String> metadata) {
        super(name, allocator, metadata);
    }

    public PolygonFloatVector(String name, AbstractContainerVector container, @Nullable Map<String, String> metadata) {
        super(name, container, metadata);
    }

    public PolygonFloatVector(ListVector vector) {
        super(vector);
    }

    @Override
    protected List<Field> getFields() {
        return fields;
    }

    @Override
    protected AbstractPolygonVector.PolygonWriter createWriter(ListVector vector) {
        return new PolygonFloatWriter(vector);
    }

    @Override
    protected AbstractPolygonVector.PolygonReader createReader(ListVector vector) {
        return new PolygonFloatReader(vector);
    }

    public static class PolygonFloatReader
    extends AbstractPolygonVector.PolygonReader {
        private NullableFloat4Vector.Accessor accessor;

        public PolygonFloatReader(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalAccessor(ValueVector.Accessor accessor) {
            this.accessor = (NullableFloat4Vector.Accessor)accessor;
        }

        @Override
        protected double readOrdinal(int index) {
            return this.accessor.get(index);
        }
    }

    public static class PolygonFloatWriter
    extends AbstractPolygonVector.PolygonWriter {
        private NullableFloat4Vector.Mutator mutator;

        public PolygonFloatWriter(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalMutator(ValueVector.Mutator mutator) {
            this.mutator = (NullableFloat4Vector.Mutator)mutator;
        }

        @Override
        protected void writeOrdinal(int index, double ordinal) {
            this.mutator.setSafe(index, (float)ordinal);
        }
    }
}

