/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.curve.Z3SFC$;
import org.locationtech.geomesa.utils.clearspring.CountMinSketch;
import org.locationtech.geomesa.utils.clearspring.CountMinSketch$;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.stats.Frequency$;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$class;
import org.locationtech.geomesa.utils.stats.Z3Frequency$;
import org.locationtech.geomesa.utils.stats.Z3Frequency$$anonfun$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.ListMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\u0001\u0003\u00015\u00111BW\u001aGe\u0016\fX/\u001a8ds*\u00111\u0001B\u0001\u0006gR\fGo\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0005'R\fG\u000f\u0005\u0002\u001aA5\t!D\u0003\u0002\u001c9\u0005a1oY1mC2|wmZ5oO*\u0011QDH\u0001\tif\u0004Xm]1gK*\tq$A\u0002d_6L!!\t\u000e\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005Iq-Z8n\u0013:$W\r_\u000b\u0002KA\u0011qBJ\u0005\u0003OA\u00111!\u00138u\u0011!I\u0003A!A!\u0002\u0013)\u0013AC4f_6Le\u000eZ3yA!A1\u0006\u0001BC\u0002\u0013\u0005A%\u0001\u0005ei\u001eLe\u000eZ3y\u0011!i\u0003A!A!\u0002\u0013)\u0013!\u00033uO&sG-\u001a=!\u0011!y\u0003A!b\u0001\n\u0003\u0001\u0014A\u00029fe&|G-F\u00012!\t\u0011$I\u0004\u00024\u007f9\u0011A'\u0010\b\u0003kqr!AN\u001e\u000f\u0005]RT\"\u0001\u001d\u000b\u0005eb\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011aHB\u0001\u0006GV\u0014h/Z\u0005\u0003\u0001\u0006\u000b!\u0002V5nKB+'/[8e\u0015\tqd!\u0003\u0002D\t\nQA+[7f!\u0016\u0014\u0018n\u001c3\u000b\u0005\u0001\u000b\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u000fA,'/[8eA!A\u0001\n\u0001BC\u0002\u0013\u0005A%A\u0005qe\u0016\u001c\u0017n]5p]\"A!\n\u0001B\u0001B\u0003%Q%\u0001\u0006qe\u0016\u001c\u0017n]5p]\u0002B\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!T\u0001\u0004KB\u001cX#\u0001(\u0011\u0005=y\u0015B\u0001)\u0011\u0005\u0019!u.\u001e2mK\"A!\u000b\u0001B\u0001B\u0003%a*\u0001\u0003faN\u0004\u0003\u0002\u0003+\u0001\u0005\u000b\u0007I\u0011A'\u0002\u0015\r|gNZ5eK:\u001cW\r\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003O\u0003-\u0019wN\u001c4jI\u0016t7-\u001a\u0011\t\u000ba\u0003A\u0011A-\u0002\rqJg.\u001b;?)\u001dQ6\fX/_?\u0002\u0004\"!\u0006\u0001\t\u000b\r:\u0006\u0019A\u0013\t\u000b-:\u0006\u0019A\u0013\t\u000b=:\u0006\u0019A\u0019\t\u000b!;\u0006\u0019A\u0013\t\u000f1;\u0006\u0013!a\u0001\u001d\"9Ak\u0016I\u0001\u0002\u0004qU\u0001\u00022\u0001Ai\u0013\u0011a\u0015\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0003\u0011i\u0017m]6\u0016\u0003\u0019\u0004\"aD4\n\u0005!\u0004\"\u0001\u0002'p]\u001eDaA\u001b\u0001!\u0002\u00131\u0017!B7bg.\u0004\u0003b\u00027\u0001\u0005\u0004%I!\\\u0001\u0004g\u001a\u001cW#\u00018\u0011\u0005=\u0004X\"A!\n\u0005E\f%!\u0002.4'\u001a\u001b\u0005BB:\u0001A\u0003%a.\u0001\u0003tM\u000e\u0004\u0003bB;\u0001\u0005\u0004%IA^\u0001\ni&lW\rV8CS:,\u0012a\u001e\t\u0003qnt!a\\=\n\u0005i\f\u0015A\u0003\"j]:,G\rV5nK&\u0011A0 \u0002\u0011)&lW\rV8CS:tW\r\u001a+j[\u0016T!A_!\t\r}\u0004\u0001\u0015!\u0003x\u0003)!\u0018.\\3U_\nKg\u000e\t\u0005\u000b\u0003\u0007\u0001!\u0019!C\u0001\u0005\u0005\u0015\u0011\u0001C:lKR\u001c\u0007.Z:\u0016\u0005\u0005\u001d\u0001\u0003CA\u0005\u0003'\t9\"!\b\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tq!\\;uC\ndWMC\u0002\u0002\u0012A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)\"a\u0003\u0003\u00075\u000b\u0007\u000fE\u0002\u0010\u00033I1!a\u0007\u0011\u0005\u0015\u0019\u0006n\u001c:u!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012\t\u0005Y1\r\\3beN\u0004(/\u001b8h\u0013\u0011\t9#!\t\u0003\u001d\r{WO\u001c;NS:\u001c6.\u001a;dQ\"A\u00111\u0006\u0001!\u0002\u0013\t9!A\u0005tW\u0016$8\r[3tA!A\u0011q\u0006\u0001\u0005\u0002\t\t\t$A\u0005oK^\u001c6.\u001a;dQV\u0011\u0011Q\u0004\u0005\b\u0003k\u0001A\u0011BA\u001c\u0003\u0015!xnS3z)\u0019\tI$a\u0010\u0002VA1q\"a\u000f\u0002\u0018\u0019L1!!\u0010\u0011\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011IA\u001a\u0001\u0004\t\u0019%\u0001\u0003hK>l\u0007\u0003BA#\u0003#j!!a\u0012\u000b\t\u0005\u0005\u0013\u0011\n\u0006\u0005\u0003\u0017\ni%A\u0002kiNT1!a\u0014\u001f\u000391\u0018N^5eg>dW\u000f^5p]NLA!a\u0015\u0002H\tAq)Z8nKR\u0014\u0018\u0010\u0003\u0005\u0002X\u0005M\u0002\u0019AA-\u0003\r!Go\u001a\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0014\u0001\u00026bm\u0006LA!a\u001a\u0002^\t!A)\u0019;f\u0011\u001d\tY\u0007\u0001C\u0001\u0003[\nQaY8v]R$RAZA8\u0003cB\u0001\"!\u0011\u0002j\u0001\u0007\u00111\t\u0005\t\u0003/\nI\u00071\u0001\u0002Z!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0014aC2pk:$H)\u001b:fGR$RAZA=\u0003{B\u0001\"a\u001f\u0002t\u0001\u0007\u0011qC\u0001\u0004E&t\u0007bBA@\u0003g\u0002\rAZ\u0001\u0003uNBa!a!\u0001\t\u0003)\u0017\u0001B:ju\u0016Dq!a\"\u0001\t\u0003\tI)A\u0006ta2LGOQ=US6,WCAAF!\u0019\ti)a&\u0002\u001e:!\u0011qRAJ\u001d\r9\u0014\u0011S\u0005\u0002#%\u0019\u0011Q\u0013\t\u0002\u000fA\f7m[1hK&!\u0011\u0011TAN\u0005\r\u0019V-\u001d\u0006\u0004\u0003+\u0003\u0002CB\b\u0002<\u0005]!\fC\u0004\u0002\"\u0002!\t%a)\u0002\u000f=\u00147/\u001a:wKR!\u0011QUAV!\ry\u0011qU\u0005\u0004\u0003S\u0003\"\u0001B+oSRD\u0001\"!,\u0002 \u0002\u0007\u0011qV\u0001\u0003g\u001a\u0004B!!-\u0002@6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003s\u000bY,A\u0004gK\u0006$XO]3\u000b\u0007\u0005u&\"A\u0004pa\u0016tw-[:\n\t\u0005\u0005\u00171\u0017\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000f\u0005\u0015\u0007\u0001\"\u0011\u0002H\u0006IQO\\8cg\u0016\u0014h/\u001a\u000b\u0005\u0003K\u000bI\r\u0003\u0005\u0002.\u0006\r\u0007\u0019AAX\u0011\u001d\ti\r\u0001C!\u0003\u001f\fQ\u0001\n9mkN$2AWAi\u0011\u001d\t\u0019.a3A\u0002i\u000bQa\u001c;iKJDq!a6\u0001\t\u0003\nI.\u0001\u0005%a2,8\u000fJ3r)\u0011\t)+a7\t\u000f\u0005M\u0017Q\u001ba\u00015\"9\u0011q\u001c\u0001\u0005B\u0005\u0005\u0018!B2mK\u0006\u0014HCAAS\u0011\u001d\t)\u000f\u0001C!\u0003O\fq![:F[B$\u00180\u0006\u0002\u0002jB\u0019q\"a;\n\u0007\u00055\bCA\u0004C_>dW-\u00198\t\u000f\u0005E\b\u0001\"\u0011\u0002t\u0006aAo\u001c&t_:|%M[3diV\u0011\u0011Q\u001f\t\u0004\u001f\u0005]\u0018bAA}!\t\u0019\u0011I\\=\t\u000f\u0005u\b\u0001\"\u0011\u0002\u0000\u0006a\u0011n]#rk&4\u0018\r\\3oiR!\u0011\u0011\u001eB\u0001\u0011\u001d\t\u0019.a?A\u0002Q9\u0011B!\u0002\u0003\u0003\u0003E\tAa\u0002\u0002\u0017i\u001bdI]3rk\u0016t7-\u001f\t\u0004+\t%a\u0001C\u0001\u0003\u0003\u0003E\tAa\u0003\u0014\u0007\t%a\u0002C\u0004Y\u0005\u0013!\tAa\u0004\u0015\u0005\t\u001d\u0001B\u0003B\n\u0005\u0013\t\n\u0011\"\u0001\u0003\u0016\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"Aa\u0006+\u00079\u0013Ib\u000b\u0002\u0003\u001cA!!Q\u0004B\u0014\u001b\t\u0011yB\u0003\u0003\u0003\"\t\r\u0012!C;oG\",7m[3e\u0015\r\u0011)\u0003E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0015\u0005?\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011iC!\u0003\u0012\u0002\u0013\u0005!QC\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c")
public class Z3Frequency
implements Stat,
LazyLogging {
    private final int geomIndex;
    private final int dtgIndex;
    private final Enumeration.Value period;
    private final int precision;
    private final double eps;
    private final double confidence;
    private final long mask;
    private final Z3SFC sfc;
    private final Function1<Object, BinnedTime> timeToBin;
    private final Map<Object, CountMinSketch> sketches;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static double $lessinit$greater$default$6() {
        return Z3Frequency$.MODULE$.$lessinit$greater$default$6();
    }

    public static double $lessinit$greater$default$5() {
        return Z3Frequency$.MODULE$.$lessinit$greater$default$5();
    }

    private Logger logger$lzycompute() {
        Z3Frequency z3Frequency2 = this;
        synchronized (z3Frequency2) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat$class.$plus$eq(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat$class.$plus(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat$class.toJson(this);
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    public int dtgIndex() {
        return this.dtgIndex;
    }

    public Enumeration.Value period() {
        return this.period;
    }

    public int precision() {
        return this.precision;
    }

    public double eps() {
        return this.eps;
    }

    public double confidence() {
        return this.confidence;
    }

    private long mask() {
        return this.mask;
    }

    private Z3SFC sfc() {
        return this.sfc;
    }

    private Function1<Object, BinnedTime> timeToBin() {
        return this.timeToBin;
    }

    public Map<Object, CountMinSketch> sketches() {
        return this.sketches;
    }

    public CountMinSketch newSketch() {
        return CountMinSketch$.MODULE$.apply(this.eps(), this.confidence(), Frequency$.MODULE$.Seed());
    }

    private Tuple2<Object, Object> toKey(Geometry geom, Date dtg) {
        BinnedTime binnedTime = (BinnedTime)this.timeToBin().apply((Object)BoxesRunTime.boxToLong((long)dtg.getTime()));
        if (binnedTime != null) {
            Tuple2 tuple2;
            short b = binnedTime.bin();
            long o = binnedTime.offset();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)b), (Object)BoxesRunTime.boxToLong((long)o));
            short b2 = BoxesRunTime.unboxToShort((Object)tuple22._1());
            long o2 = tuple22._2$mcJ$sp();
            Point centroid = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom));
            long z = this.sfc().index(centroid.getX(), centroid.getY(), o2, this.sfc().index$default$4()) & this.mask();
            return new Tuple2((Object)BoxesRunTime.boxToShort((short)b2), (Object)BoxesRunTime.boxToLong((long)z));
        }
        throw new MatchError((Object)binnedTime);
    }

    public long count(Geometry geom, Date dtg) {
        Tuple2<Object, Object> tuple2 = this.toKey(geom, dtg);
        if (tuple2 != null) {
            Tuple2 tuple22;
            short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
            long z3 = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)z3));
            short bin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
            long z32 = tuple23._2$mcJ$sp();
            return this.countDirect(bin2, z32);
        }
        throw new MatchError(tuple2);
    }

    public long countDirect(short bin, long z3) {
        return BoxesRunTime.unboxToLong((Object)this.sketches().get((Object)BoxesRunTime.boxToShort((short)bin)).map((Function1)new Serializable(this, z3){
            public static final long serialVersionUID = 0L;
            private final long z3$1;

            public final long apply(CountMinSketch x$3) {
                return x$3.estimateCount(this.z3$1);
            }
            {
                this.z3$1 = z3$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public long size() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.sketches().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(CountMinSketch x$4) {
                return x$4.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public Seq<Tuple2<Object, Z3Frequency>> splitByTime() {
        return (Seq)this.sketches().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Frequency $outer;

            public final Tuple2<Object, Z3Frequency> apply(Tuple2<Object, CountMinSketch> x0$1) {
                Tuple2<Object, CountMinSketch> tuple2 = x0$1;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    CountMinSketch sketch = (CountMinSketch)tuple2._2();
                    Z3Frequency freq = new Z3Frequency(this.$outer.geomIndex(), this.$outer.dtgIndex(), this.$outer.period(), this.$outer.precision(), this.$outer.eps(), this.$outer.confidence());
                    freq.sketches().put((Object)BoxesRunTime.boxToShort((short)w), (Object)sketch);
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)w), (Object)freq);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void observe(SimpleFeature sf) {
        Geometry geom = (Geometry)sf.getAttribute(this.geomIndex());
        Date dtg = (Date)sf.getAttribute(this.dtgIndex());
        if (geom != null && dtg != null) {
            try {
                Tuple2 tuple2;
                Tuple2<Object, Object> tuple22 = this.toKey(geom, dtg);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                short bin = BoxesRunTime.unboxToShort((Object)tuple22._1());
                long z3 = tuple22._2$mcJ$sp();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToShort((short)bin), (Object)BoxesRunTime.boxToLong((long)z3));
                short bin2 = BoxesRunTime.unboxToShort((Object)tuple23._1());
                long z32 = tuple23._2$mcJ$sp();
                ((CountMinSketch)this.sketches().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)bin2), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Z3Frequency $outer;

                    public final CountMinSketch apply() {
                        return this.$outer.newSketch();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).add(z32, 1L);
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error observing geom '", "' and date '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geom, dtg, exception.toString()})));
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
    }

    /*
     * WARNING - void declaration
     */
    public Z3Frequency $plus(Z3Frequency other) {
        void var2_2;
        Z3Frequency plus2 = new Z3Frequency(this.geomIndex(), this.dtgIndex(), this.period(), this.precision(), this.eps(), this.confidence());
        plus2.$plus$eq(this);
        plus2.$plus$eq(other);
        return var2_2;
    }

    public void $plus$eq(Z3Frequency other) {
        ((IterableLike)other.sketches().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, CountMinSketch> x$6) {
                return ((CountMinSketch)x$6._2()).size() > 0L;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Frequency $outer;

            public final void apply(Tuple2<Object, CountMinSketch> x0$2) {
                Tuple2<Object, CountMinSketch> tuple2 = x0$2;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    CountMinSketch sketch = (CountMinSketch)tuple2._2();
                    ((CountMinSketch)this.$outer.sketches().getOrElseUpdate((Object)BoxesRunTime.boxToShort((short)w), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$$plus$eq$2 $outer;

                        public final CountMinSketch apply() {
                            return this.$outer.org$locationtech$geomesa$utils$stats$Z3Frequency$$anonfun$$$outer().newSketch();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    })).$plus$eq(sketch);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ Z3Frequency org$locationtech$geomesa$utils$stats$Z3Frequency$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void clear() {
        this.sketches().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CountMinSketch x$7) {
                x$7.clear();
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.sketches().values().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CountMinSketch x$8) {
                return x$8.size() == 0L;
            }
        });
    }

    @Override
    public Object toJsonObject() {
        Tuple2 tuple2 = (Tuple2)this.sketches().values().headOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(CountMinSketch s) {
                return new Tuple2.mcDD.sp(s.eps(), s.confidence());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply() {
                return new Tuple2.mcDD.sp(0.0, 0.0);
            }
        });
        if (tuple2 != null) {
            Tuple2.mcDD.sp sp2;
            double e = tuple2._1$mcD$sp();
            double c = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(e, c);
            double e2 = sp3._1$mcD$sp();
            double c2 = sp3._2$mcD$sp();
            return ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"eps"), (Object)BoxesRunTime.boxToDouble((double)e2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confidence"), (Object)BoxesRunTime.boxToDouble((double)c2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToLong((long)this.size()))}));
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat2 = other;
        if (!(stat2 instanceof Z3Frequency)) return false;
        Z3Frequency z3Frequency2 = (Z3Frequency)stat2;
        if (this.geomIndex() != z3Frequency2.geomIndex()) return false;
        if (this.dtgIndex() != z3Frequency2.dtgIndex()) return false;
        Enumeration.Value value2 = this.period();
        Enumeration.Value value3 = z3Frequency2.period();
        if (value2 == null) {
            if (value3 != null) {
                return false;
            }
        } else if (!value2.equals(value3)) return false;
        if (this.precision() != z3Frequency2.precision()) return false;
        Map nonEmpty = (Map)this.sketches().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, CountMinSketch> x$10) {
                return ((CountMinSketch)x$10._2()).size() > 0L;
            }
        });
        Map sNonEmpty = (Map)z3Frequency2.sketches().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, CountMinSketch> x$11) {
                return ((CountMinSketch)x$11._2()).size() > 0L;
            }
        });
        Iterable iterable = nonEmpty.keys();
        Iterable iterable2 = sNonEmpty.keys();
        if (iterable == null) {
            if (iterable2 != null) {
                return false;
            }
        } else if (!iterable.equals(iterable2)) return false;
        if (!nonEmpty.keys().forall((Function1)new Serializable(this, z3Frequency2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z3Frequency $outer;
            private final Z3Frequency x2$1;

            public final boolean apply(short k) {
                return ((CountMinSketch)this.$outer.sketches().apply((Object)BoxesRunTime.boxToShort((short)k))).isEquivalent((CountMinSketch)this.x2$1.sketches().apply((Object)BoxesRunTime.boxToShort((short)k)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.x2$1 = x2$1;
            }
        })) return false;
        return true;
    }

    public Z3Frequency(int geomIndex, int dtgIndex, Enumeration.Value period, int precision, double eps, double confidence) {
        this.geomIndex = geomIndex;
        this.dtgIndex = dtgIndex;
        this.period = period;
        this.precision = precision;
        this.eps = eps;
        this.confidence = confidence;
        Stat$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.mask = Frequency$.MODULE$.getMask(precision);
        this.sfc = Z3SFC$.MODULE$.apply(period);
        this.timeToBin = BinnedTime$.MODULE$.timeToBinnedTime(period);
        this.sketches = Map$.MODULE$.empty();
    }
}

