/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.curve;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.TimePeriod$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class BinnedTime$
implements Serializable {
    public static final BinnedTime$ MODULE$;
    private final ZonedDateTime Epoch;
    private final ZonedDateTime ZMinDate;
    private final ZonedDateTime DaysMaxDate;
    private final ZonedDateTime WeeksMaxDate;
    private final ZonedDateTime MonthsMaxDate;
    private final ZonedDateTime YearsMaxDate;

    static {
        new BinnedTime$();
    }

    public ZonedDateTime Epoch() {
        return this.Epoch;
    }

    public ZonedDateTime ZMinDate() {
        return this.ZMinDate;
    }

    public ZonedDateTime DaysMaxDate() {
        return this.DaysMaxDate;
    }

    public ZonedDateTime WeeksMaxDate() {
        return this.WeeksMaxDate;
    }

    public ZonedDateTime MonthsMaxDate() {
        return this.MonthsMaxDate;
    }

    public ZonedDateTime YearsMaxDate() {
        return this.YearsMaxDate;
    }

    public Function1<Object, BinnedTime> timeToBinnedTime(Enumeration.Value period) {
        Enumeration.Value value;
        block6: {
            Object object;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            value = period;
                            Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final BinnedTime apply(long time) {
                                    return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toDayAndMillis(time);
                                }
                            };
                            break block3;
                        }
                        Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final BinnedTime apply(long time) {
                                return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toWeekAndSeconds(time);
                            }
                        };
                        break block3;
                    }
                    Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final BinnedTime apply(long time) {
                            return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toMonthAndSeconds(time);
                        }
                    };
                    break block3;
                }
                Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final BinnedTime apply(long time) {
                        return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toYearAndMinutes(time);
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Function1<ZonedDateTime, BinnedTime> dateToBinnedTime(Enumeration.Value period) {
        Enumeration.Value value;
        block6: {
            Object object;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            value = period;
                            Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final BinnedTime apply(ZonedDateTime date) {
                                    return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toDayAndMillis(date);
                                }
                            };
                            break block3;
                        }
                        Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final BinnedTime apply(ZonedDateTime date) {
                                return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toWeekAndSeconds(date);
                            }
                        };
                        break block3;
                    }
                    Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final BinnedTime apply(ZonedDateTime date) {
                            return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toMonthAndSeconds(date);
                        }
                    };
                    break block3;
                }
                Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final BinnedTime apply(ZonedDateTime date) {
                        return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$toYearAndMinutes(date);
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Function1<BinnedTime, ZonedDateTime> binnedTimeToDate(Enumeration.Value period) {
        Enumeration.Value value;
        block6: {
            Object object;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            value = period;
                            Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            object = new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final ZonedDateTime apply(BinnedTime date) {
                                    return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$fromDayAndMillis(date);
                                }
                            };
                            break block3;
                        }
                        Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        object = new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final ZonedDateTime apply(BinnedTime date) {
                                return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$fromWeekAndSeconds(date);
                            }
                        };
                        break block3;
                    }
                    Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final ZonedDateTime apply(BinnedTime date) {
                            return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$fromMonthAndSeconds(date);
                        }
                    };
                    break block3;
                }
                Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final ZonedDateTime apply(BinnedTime date) {
                        return BinnedTime$.MODULE$.org$locationtech$geomesa$curve$BinnedTime$$fromYearAndMinutes(date);
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public long maxOffset(Enumeration.Value period) {
        Enumeration.Value value;
        block6: {
            long l;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            value = period;
                            Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            l = ChronoUnit.DAYS.getDuration().toMillis();
                            break block3;
                        }
                        Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        l = ChronoUnit.WEEKS.getDuration().toMillis() / 1000L;
                        break block3;
                    }
                    Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    l = ChronoUnit.DAYS.getDuration().toMillis() / 1000L * 31L;
                    break block3;
                }
                Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                l = ChronoUnit.WEEKS.getDuration().toMinutes() * 52L;
            }
            return l;
        }
        throw new MatchError((Object)value);
    }

    public ZonedDateTime maxDate(Enumeration.Value period) {
        Enumeration.Value value;
        block6: {
            ZonedDateTime zonedDateTime;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            value = period;
                            Enumeration.Value value2 = TimePeriod$.MODULE$.Day();
                            Enumeration.Value value3 = value;
                            if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                            zonedDateTime = this.DaysMaxDate();
                            break block3;
                        }
                        Enumeration.Value value4 = TimePeriod$.MODULE$.Week();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                        zonedDateTime = this.WeeksMaxDate();
                        break block3;
                    }
                    Enumeration.Value value6 = TimePeriod$.MODULE$.Month();
                    Enumeration.Value value7 = value;
                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                    zonedDateTime = this.MonthsMaxDate();
                    break block3;
                }
                Enumeration.Value value8 = TimePeriod$.MODULE$.Year();
                Enumeration.Value value9 = value;
                if (value8 != null ? !value8.equals(value9) : value9 != null) break block6;
                zonedDateTime = this.YearsMaxDate();
            }
            return zonedDateTime;
        }
        throw new MatchError((Object)value);
    }

    public Function1<Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>>, Tuple2<ZonedDateTime, ZonedDateTime>> boundsToIndexableDates(Enumeration.Value period) {
        ZonedDateTime maxDateTime = this.maxDate(period).minus(1L, ChronoUnit.MILLIS);
        return new Serializable(maxDateTime){
            public static final long serialVersionUID = 0L;
            private final ZonedDateTime maxDateTime$1;

            public final Tuple2<ZonedDateTime, ZonedDateTime> apply(Tuple2<Option<ZonedDateTime>, Option<ZonedDateTime>> bounds) {
                Option option;
                block6: {
                    Option option2;
                    block11: {
                        ZonedDateTime zonedDateTime;
                        ZonedDateTime lo;
                        block8: {
                            ZonedDateTime dt;
                            Some some;
                            boolean bl;
                            block10: {
                                ZonedDateTime dt2;
                                block9: {
                                    block7: {
                                        ZonedDateTime zonedDateTime2;
                                        block3: {
                                            ZonedDateTime dt3;
                                            Some some2;
                                            boolean bl2;
                                            block5: {
                                                ZonedDateTime dt4;
                                                block4: {
                                                    block2: {
                                                        bl2 = false;
                                                        some2 = null;
                                                        option = (Option)bounds._1();
                                                        if (!None$.MODULE$.equals(option)) break block2;
                                                        zonedDateTime2 = BinnedTime$.MODULE$.ZMinDate();
                                                        break block3;
                                                    }
                                                    if (!(option instanceof Some)) break block4;
                                                    bl2 = true;
                                                    some2 = (Some)option;
                                                    ZonedDateTime dt5 = (ZonedDateTime)some2.x();
                                                    if (!dt5.isBefore(BinnedTime$.MODULE$.ZMinDate())) break block4;
                                                    zonedDateTime2 = BinnedTime$.MODULE$.ZMinDate();
                                                    break block3;
                                                }
                                                if (!bl2 || !(dt4 = (ZonedDateTime)some2.x()).isAfter(this.maxDateTime$1)) break block5;
                                                zonedDateTime2 = this.maxDateTime$1;
                                                break block3;
                                            }
                                            if (!bl2) break block6;
                                            zonedDateTime2 = dt3 = (ZonedDateTime)some2.x();
                                        }
                                        lo = zonedDateTime2;
                                        bl = false;
                                        some = null;
                                        option2 = (Option)bounds._2();
                                        if (!None$.MODULE$.equals(option2)) break block7;
                                        zonedDateTime = this.maxDateTime$1;
                                        break block8;
                                    }
                                    if (!(option2 instanceof Some)) break block9;
                                    bl = true;
                                    some = (Some)option2;
                                    ZonedDateTime dt6 = (ZonedDateTime)some.x();
                                    if (!dt6.isBefore(BinnedTime$.MODULE$.ZMinDate())) break block9;
                                    zonedDateTime = BinnedTime$.MODULE$.ZMinDate();
                                    break block8;
                                }
                                if (!bl || !(dt2 = (ZonedDateTime)some.x()).isAfter(this.maxDateTime$1)) break block10;
                                zonedDateTime = this.maxDateTime$1;
                                break block8;
                            }
                            if (!bl) break block11;
                            zonedDateTime = dt = (ZonedDateTime)some.x();
                        }
                        ZonedDateTime hi = zonedDateTime;
                        return new Tuple2((Object)lo, (Object)hi);
                    }
                    throw new MatchError((Object)option2);
                }
                throw new MatchError((Object)option);
            }
            {
                this.maxDateTime$1 = maxDateTime$1;
            }
        };
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toDayAndMillis(long time) {
        return this.org$locationtech$geomesa$curve$BinnedTime$$toDayAndMillis(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toDayAndMillis(ZonedDateTime date) {
        Predef$.MODULE$.require(!date.isBefore(this.ZMinDate()), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final ZonedDateTime date$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds minimum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.ZMinDate(), this.date$1}));
            }
            {
                this.date$1 = date$1;
            }
        });
        Predef$.MODULE$.require(this.DaysMaxDate().isAfter(date), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final ZonedDateTime date$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds maximum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.DaysMaxDate(), this.date$1}));
            }
            {
                this.date$1 = date$1;
            }
        });
        long days = ChronoUnit.DAYS.between(this.Epoch(), date);
        long millisInDay = date.toInstant().toEpochMilli() - this.Epoch().plus(days, ChronoUnit.DAYS).toInstant().toEpochMilli();
        return new BinnedTime((short)days, millisInDay);
    }

    public ZonedDateTime org$locationtech$geomesa$curve$BinnedTime$$fromDayAndMillis(BinnedTime date) {
        return this.Epoch().plusDays(date.bin()).plus(date.offset(), ChronoUnit.MILLIS);
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toWeekAndSeconds(long time) {
        return this.org$locationtech$geomesa$curve$BinnedTime$$toWeekAndSeconds(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toWeekAndSeconds(ZonedDateTime date) {
        Predef$.MODULE$.require(!date.isBefore(this.ZMinDate()), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final ZonedDateTime date$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds minimum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.ZMinDate(), this.date$2}));
            }
            {
                this.date$2 = date$2;
            }
        });
        Predef$.MODULE$.require(this.WeeksMaxDate().isAfter(date), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final ZonedDateTime date$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds maximum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.WeeksMaxDate(), this.date$2}));
            }
            {
                this.date$2 = date$2;
            }
        });
        long weeks = ChronoUnit.WEEKS.between(this.Epoch(), date);
        long secondsInWeek = date.toEpochSecond() - this.Epoch().plus(weeks, ChronoUnit.WEEKS).toEpochSecond();
        return new BinnedTime((short)weeks, secondsInWeek);
    }

    public ZonedDateTime org$locationtech$geomesa$curve$BinnedTime$$fromWeekAndSeconds(BinnedTime date) {
        return this.Epoch().plusWeeks(date.bin()).plus(date.offset(), ChronoUnit.SECONDS);
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toMonthAndSeconds(long time) {
        return this.org$locationtech$geomesa$curve$BinnedTime$$toMonthAndSeconds(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toMonthAndSeconds(ZonedDateTime date) {
        Predef$.MODULE$.require(!date.isBefore(this.ZMinDate()), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final ZonedDateTime date$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds minimum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.ZMinDate(), this.date$3}));
            }
            {
                this.date$3 = date$3;
            }
        });
        Predef$.MODULE$.require(this.MonthsMaxDate().isAfter(date), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final ZonedDateTime date$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds maximum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.MonthsMaxDate(), this.date$3}));
            }
            {
                this.date$3 = date$3;
            }
        });
        long months = ChronoUnit.MONTHS.between(this.Epoch(), date);
        long secondsInMonth = date.toEpochSecond() - this.Epoch().plus(months, ChronoUnit.MONTHS).toEpochSecond();
        return new BinnedTime((short)months, secondsInMonth);
    }

    public ZonedDateTime org$locationtech$geomesa$curve$BinnedTime$$fromMonthAndSeconds(BinnedTime date) {
        return this.Epoch().plusMonths(date.bin()).plus(date.offset(), ChronoUnit.SECONDS);
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toYearAndMinutes(long time) {
        return this.org$locationtech$geomesa$curve$BinnedTime$$toYearAndMinutes(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneOffset.UTC));
    }

    public BinnedTime org$locationtech$geomesa$curve$BinnedTime$$toYearAndMinutes(ZonedDateTime date) {
        Predef$.MODULE$.require(!date.isBefore(this.ZMinDate()), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final ZonedDateTime date$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds minimum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.ZMinDate(), this.date$4}));
            }
            {
                this.date$4 = date$4;
            }
        });
        Predef$.MODULE$.require(this.YearsMaxDate().isAfter(date), (Function0)new Serializable(date){
            public static final long serialVersionUID = 0L;
            private final ZonedDateTime date$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Date exceeds maximum indexable value (", "): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinnedTime$.MODULE$.YearsMaxDate(), this.date$4}));
            }
            {
                this.date$4 = date$4;
            }
        });
        long years = ChronoUnit.YEARS.between(this.Epoch(), date);
        long minutesInYear = (date.toEpochSecond() - this.Epoch().plus(years, ChronoUnit.YEARS).toEpochSecond()) / 60L;
        return new BinnedTime((short)years, minutesInYear);
    }

    public ZonedDateTime org$locationtech$geomesa$curve$BinnedTime$$fromYearAndMinutes(BinnedTime date) {
        return this.Epoch().plusYears(date.bin()).plus(date.offset(), ChronoUnit.MINUTES);
    }

    public BinnedTime apply(short bin, long offset) {
        return new BinnedTime(bin, offset);
    }

    public Option<Tuple2<Object, Object>> unapply(BinnedTime x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)x$0.bin()), (Object)BoxesRunTime.boxToLong((long)x$0.offset())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BinnedTime$() {
        MODULE$ = this;
        this.Epoch = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
        this.ZMinDate = this.Epoch();
        this.DaysMaxDate = this.Epoch().plusDays(Short.MAX_VALUE + 1);
        this.WeeksMaxDate = this.Epoch().plusWeeks(Short.MAX_VALUE + 1);
        this.MonthsMaxDate = this.Epoch().plusMonths(Short.MAX_VALUE + 1);
        this.YearsMaxDate = this.Epoch().plusYears(Short.MAX_VALUE + 1);
    }
}

