/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import org.calrissian.mango.types.TypeEncoder;

public class ReverseEncoder<T>
implements TypeEncoder<T, String> {
    private static final long serialVersionUID = 1L;
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private final TypeEncoder<T, String> encoder;

    public ReverseEncoder(TypeEncoder<T, String> encoder) {
        this.encoder = encoder;
    }

    @Override
    public String getAlias() {
        return this.encoder.getAlias();
    }

    @Override
    public Class<T> resolves() {
        return this.encoder.resolves();
    }

    @Override
    public String encode(T value) {
        String encoded = this.encoder.encode(value);
        return new String(ReverseEncoder.reverse(encoded.getBytes()), ISO_8859_1);
    }

    @Override
    public T decode(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        String reversed = new String(ReverseEncoder.reverse(value.getBytes(ISO_8859_1)));
        return this.encoder.decode(reversed);
    }

    private static byte[] reverse(byte[] bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (byte)(255 - (0xFF & bytes[i]));
        }
        return result;
    }
}

