/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.parser.Location;
import org.xml.sax.Locator;

public class ExplicitLocation
implements Location {
    private String systemId;
    private int lineNumber;
    private int columnNumber = -1;
    public static ExplicitLocation UNKNOWN_LOCATION = new ExplicitLocation(null, -1, -1);

    public ExplicitLocation(SourceLocator loc) {
        this.systemId = loc.getSystemId();
        this.lineNumber = loc.getLineNumber();
        this.columnNumber = loc.getColumnNumber();
    }

    public static ExplicitLocation makeFromSax(Locator loc) {
        return new ExplicitLocation(loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber());
    }

    public ExplicitLocation(String systemId, int lineNumber, int columnNumber) {
        this.systemId = systemId;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public Location saveLocation() {
        return this;
    }
}

