/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.WrappedFeature;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.conf.TableSplitter;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.BaseFeatureIndex;
import org.locationtech.geomesa.index.index.BaseFeatureIndex$;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.ShardStrategy;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.MethodCache;
import scala.runtime.ScalaRunTime$;

public abstract class BaseFeatureIndex$class {
    private static Class[] reflParams$Cache1 = new Class[]{String.class, Filter.class};
    private static volatile SoftReference reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());

    public static Method reflMethod$Method1(Class x$1) {
        Method method1;
        MethodCache methodCache1 = (MethodCache)reflPoly$Cache1.get();
        if (methodCache1 == null) {
            methodCache1 = new EmptyMethodCache();
            reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1);
        }
        if ((method1 = methodCache1.find(x$1)) != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("onFullTableScan", reflParams$Cache1));
        reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1.add(x$1, method1));
        return method1;
    }

    public static Object updateScanConfig(BaseFeatureIndex $this, SimpleFeatureType sft, Object config, Option indexValues) {
        return config;
    }

    public static boolean supports(BaseFeatureIndex $this, SimpleFeatureType sft) {
        return $this.keySpace().supports(sft);
    }

    public static Function1 writer(BaseFeatureIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        ShardStrategy shards = $this.shardStrategy(sft);
        IndexKeySpace qual$1 = $this.keySpace();
        SimpleFeatureType x$4 = sft;
        boolean x$5 = qual$1.toIndexKeyBytes$default$2();
        Function3<Seq<byte[]>, SimpleFeature, byte[], Seq<byte[]>> toIndexKey2 = qual$1.toIndexKeyBytes(x$4, x$5);
        Serializable serializable = new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseFeatureIndex $outer;

            public final W apply(byte[] row, F feature) {
                return this.$outer.createInsert(row, feature);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        return new Serializable($this, sharing, shards, toIndexKey2, (Function2)serializable){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseFeatureIndex $outer;
            private final byte[] sharing$1;
            private final ShardStrategy shards$1;
            private final Function3 toIndexKey$1;
            private final Function2 eta$0$1$1;

            public final Seq<W> apply(F feature) {
                return BaseFeatureIndex$class.org$locationtech$geomesa$index$index$BaseFeatureIndex$$mutator(this.$outer, this.sharing$1, this.shards$1, this.toIndexKey$1, this.eta$0$1$1, feature);
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sharing$1 = (byte[])sharing$1;
                this.shards$1 = var3_3;
                this.toIndexKey$1 = var4_4;
                this.eta$0$1$1 = var5_5;
            }
        };
    }

    public static Function1 remover(BaseFeatureIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        ShardStrategy shards = $this.shardStrategy(sft);
        Function3<Seq<byte[]>, SimpleFeature, byte[], Seq<byte[]>> toIndexKey2 = $this.keySpace().toIndexKeyBytes(sft, true);
        Serializable serializable = new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseFeatureIndex $outer;

            public final W apply(byte[] row, F feature) {
                return this.$outer.createDelete(row, feature);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        return new Serializable($this, sharing, shards, toIndexKey2, (Function2)serializable){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseFeatureIndex $outer;
            private final byte[] sharing$2;
            private final ShardStrategy shards$2;
            private final Function3 toIndexKey$2;
            private final Function2 eta$0$2$1;

            public final Seq<W> apply(F feature) {
                return BaseFeatureIndex$class.org$locationtech$geomesa$index$index$BaseFeatureIndex$$mutator(this.$outer, this.sharing$2, this.shards$2, this.toIndexKey$2, this.eta$0$2$1, feature);
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sharing$2 = (byte[])sharing$2;
                this.shards$2 = var3_3;
                this.toIndexKey$2 = var4_4;
                this.eta$0$2$1 = var5_5;
            }
        };
    }

    public static Function4 getIdFromRow(BaseFeatureIndex $this, SimpleFeatureType sft) {
        int sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? 1 : 0;
        int shards = $this.shardStrategy(sft).shards().isEmpty() ? 0 : 1;
        int start = sharing + shards + $this.keySpace().indexKeyByteLength();
        Function4<byte[], Object, Object, SimpleFeature, String> idFromBytes2 = GeoMesaFeatureIndex$.MODULE$.idFromBytes(sft);
        return new Serializable($this, start, idFromBytes2){
            public static final long serialVersionUID = 0L;
            private final int start$1;
            private final Function4 idFromBytes$1;

            public final String apply(byte[] row, int offset, int length, SimpleFeature feature) {
                return (String)this.idFromBytes$1.apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)(offset + this.start$1)), (Object)BoxesRunTime.boxToInteger((int)(length - this.start$1)), (Object)feature);
            }
            {
                void var3_3;
                this.start$1 = start$1;
                this.idFromBytes$1 = var3_3;
            }
        };
    }

    public static Seq getSplits(BaseFeatureIndex $this, SimpleFeatureType sft) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Seq shards = BaseFeatureIndex$class.nonEmpty$1($this, $this.shardStrategy(sft).shards());
        TableSplitter splitter = (TableSplitter)((Class)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSplitter$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Class<DefaultSplitter> apply() {
                return DefaultSplitter.class;
            }
        })).newInstance();
        Seq splits = BaseFeatureIndex$class.nonEmpty$1($this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])splitter.getSplits(sft, $this.name(), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSplitterOptions$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)))));
        Seq result = (Seq)shards.flatMap((Function1)new Serializable($this, sharing, splits){
            public static final long serialVersionUID = 0L;
            public final byte[] sharing$3;
            private final Seq splits$1;

            public final Seq<byte[]> apply(byte[] shard) {
                return (Seq)this.splits$1.map((Function1)new Serializable(this, shard){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseFeatureIndex$.anonfun.2 $outer;
                    private final byte[] shard$1;

                    public final byte[] apply(byte[] split) {
                        return ByteArrays$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.$outer.sharing$3, this.shard$1, split}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.shard$1 = (byte[])shard$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                void var3_3;
                this.sharing$3 = (byte[])sharing$3;
                this.splits$1 = var3_3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return Predef$.MODULE$.byteArrayOps(sharing).isEmpty() || BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(sharing).head()) == (byte)0 ? (Seq)result.drop(1) : result;
    }

    public static QueryPlan getQueryPlan(BaseFeatureIndex $this, SimpleFeatureType sft, GeoMesaDataStore ds, FilterStrategy filter2, Hints hints, Explainer explain) {
        Option option;
        block6: {
            Tuple2 tuple2;
            block10: {
                Iterator iterator;
                Option indexValues;
                block5: {
                    Seq seq;
                    Object values;
                    block8: {
                        block9: {
                            block7: {
                                byte[] sharing;
                                block4: {
                                    sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
                                    indexValues = filter2.primary().map((Function1)new Serializable($this, sft, explain){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ BaseFeatureIndex $outer;
                                        private final SimpleFeatureType sft$1;
                                        private final Explainer explain$1;

                                        public final V apply(Filter x$1) {
                                            return this.$outer.keySpace().getIndexValues(this.sft$1, x$1, this.explain$1);
                                        }
                                        {
                                            void var3_3;
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.sft$1 = sft$1;
                                            this.explain$1 = var3_3;
                                        }
                                    });
                                    option = indexValues;
                                    if (!None$.MODULE$.equals(option)) break block4;
                                    GeoMesaSystemProperties.SystemProperty qual1 = QueryProperties$.MODULE$.BlockFullTableScans();
                                    try {
                                        BaseFeatureIndex$class.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, sft.getTypeName(), filter2.filter().getOrElse((Function0)new Serializable($this){
                                            public static final long serialVersionUID = 0L;

                                            public final IncludeFilter apply() {
                                                return Filter.INCLUDE;
                                            }
                                        }));
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        throw invocationTargetException.getCause();
                                    }
                                    filter2.secondary().foreach((Function1)new Serializable($this, sft){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ BaseFeatureIndex $outer;
                                        private final SimpleFeatureType sft$1;

                                        public final void apply(Filter f) {
                                            BoxedUnit boxedUnit;
                                            if (this.$outer.logger().underlying().isWarnEnabled()) {
                                                this.$outer.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running full table scan on ", " index for schema ", " with filter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), this.sft$1.getTypeName(), org.locationtech.geomesa.filter.package$.MODULE$.filterToString(f)})));
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.sft$1 = sft$1;
                                        }
                                    });
                                    iterator = package$.MODULE$.Iterator().single($this.createRange(sharing, ByteArrays$.MODULE$.rowFollowingPrefix(sharing)));
                                    break block5;
                                }
                                if (!(option instanceof Some)) break block6;
                                Some some = (Some)option;
                                values = some.x();
                                tuple2 = new Tuple2($this.shardStrategy(sft).shards(), (Object)sharing);
                                if (tuple2 == null) break block7;
                                Seq shards = (Seq)tuple2._1();
                                byte[] byArray = (byte[])tuple2._2();
                                Option option2 = Array$.MODULE$.unapplySeq((Object)byArray);
                                if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(0) != 0) break block7;
                                seq = shards;
                                break block8;
                            }
                            if (tuple2 == null) break block9;
                            Seq seq2 = (Seq)tuple2._1();
                            byte[] share = (byte[])tuple2._2();
                            Some some = Seq$.MODULE$.unapplySeq(seq2);
                            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(0) != 0) break block9;
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{share}));
                            break block8;
                        }
                        if (tuple2 == null) break block10;
                        Seq shards = (Seq)tuple2._1();
                        byte[] share = (byte[])tuple2._2();
                        seq = (Seq)shards.map((Function1)new Serializable($this, share){
                            public static final long serialVersionUID = 0L;
                            private final byte[] share$1;

                            public final byte[] apply(byte[] x$2) {
                                return ByteArrays$.MODULE$.concat(this.share$1, x$2);
                            }
                            {
                                this.share$1 = (byte[])share$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    Seq prefixes = seq;
                    IndexKeySpace qual$2 = $this.keySpace();
                    Iterator x$6 = $this.keySpace().getRanges(values);
                    Seq x$7 = prefixes;
                    boolean x$8 = qual$2.getRangeBytes$default$3();
                    iterator = qual$2.getRangeBytes(x$6, (Seq<byte[]>)x$7, x$8).map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ BaseFeatureIndex $outer;

                        public final R apply(IndexKeySpace.ByteRange x0$1) {
                            IndexKeySpace.ByteRange byteRange;
                            block4: {
                                R r;
                                block3: {
                                    block2: {
                                        byteRange = x0$1;
                                        if (!(byteRange instanceof IndexKeySpace.BoundedByteRange)) break block2;
                                        IndexKeySpace.BoundedByteRange boundedByteRange = (IndexKeySpace.BoundedByteRange)byteRange;
                                        byte[] lo = boundedByteRange.lower();
                                        byte[] hi = boundedByteRange.upper();
                                        r = this.$outer.createRange(lo, hi);
                                        break block3;
                                    }
                                    if (!(byteRange instanceof IndexKeySpace.SingleRowByteRange)) break block4;
                                    IndexKeySpace.SingleRowByteRange singleRowByteRange = (IndexKeySpace.SingleRowByteRange)byteRange;
                                    byte[] row = singleRowByteRange.row();
                                    r = this.$outer.createRange(row);
                                }
                                return r;
                            }
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{byteRange})));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                Iterator ranges = iterator;
                boolean useFullFilter2 = $this.keySpace().useFullFilter(indexValues, (Option<GeoMesaDataStoreFactory.GeoMesaDataStoreConfig>)new Some((Object)ds.config()), hints);
                Option<Filter> ecql = useFullFilter2 ? filter2.filter() : filter2.secondary();
                Object config = $this.updateScanConfig(sft, $this.scanConfig(sft, ds, filter2, ranges.toSeq(), ecql, hints), indexValues);
                return $this.scanPlan(sft, ds, filter2, config);
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError((Object)option);
    }

    public static Seq org$locationtech$geomesa$index$index$BaseFeatureIndex$$mutator(BaseFeatureIndex $this, byte[] sharing, ShardStrategy shards, Function3 toIndexKey2, Function2 operation, WrappedFeature feature) {
        return (Seq)((TraversableLike)toIndexKey2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sharing, shards.apply(feature)})), (Object)feature.feature(), (Object)feature.idBytes())).map((Function1)new Serializable($this, operation, feature){
            public static final long serialVersionUID = 0L;
            private final Function2 operation$1;
            private final WrappedFeature feature$1;

            public final W apply(byte[] x$3) {
                return (W)this.operation$1.apply((Object)x$3, (Object)this.feature$1);
            }
            {
                void var3_3;
                this.operation$1 = operation$1;
                this.feature$1 = var3_3;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq nonEmpty$1(BaseFeatureIndex $this, Seq bytes) {
        return bytes.nonEmpty() ? bytes : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())}));
    }

    public static void $init$(BaseFeatureIndex $this) {
    }
}

