/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.z2;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.FilterValues$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.IndexKeySpace$BoundedRange$mcJ$sp;
import org.locationtech.geomesa.index.index.z2.Z2IndexKeySpace;
import org.locationtech.geomesa.index.index.z2.Z2IndexValues;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.sfcurve.IndexRange;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

public abstract class Z2IndexKeySpace$class {
    public static boolean supports(Z2IndexKeySpace $this, SimpleFeatureType sft) {
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
    }

    public static Function1 toIndexKey(Z2IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        return new Serializable($this, geomIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z2IndexKeySpace $outer;
            private final int geomIndex$1;
            private final boolean lenient$1;

            public final Seq<Object> apply(SimpleFeature feature) {
                return Z2IndexKeySpace$class.org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$$getZValue(this.$outer, this.geomIndex$1, this.lenient$1, feature);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.geomIndex$1 = geomIndex$1;
                this.lenient$1 = lenient$1;
            }
        };
    }

    public static Function3 toIndexKeyBytes(Z2IndexKeySpace $this, SimpleFeatureType sft, boolean lenient) {
        int geomIndex = sft.indexOf(sft.getGeometryDescriptor().getLocalName());
        return new Serializable($this, geomIndex, lenient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Z2IndexKeySpace $outer;
            private final int geomIndex$2;
            private final boolean lenient$2;

            public final Seq<byte[]> apply(Seq<byte[]> prefix, SimpleFeature feature, byte[] suffix) {
                return Z2IndexKeySpace$class.org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$$getZValueBytes(this.$outer, this.geomIndex$2, this.lenient$2, prefix, feature, suffix);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.geomIndex$2 = geomIndex$2;
                this.lenient$2 = lenient$2;
            }
        };
    }

    public static Z2IndexValues getIndexValues(Z2IndexKeySpace $this, SimpleFeatureType sft, Filter filter2, Explainer explain) {
        FilterValues extracted = FilterHelper$.MODULE$.extractGeometries(filter2, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        FilterValues geometries = extracted.nonEmpty() ? extracted : new FilterValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Polygon[]{org.locationtech.geomesa.utils.geotools.package$.MODULE$.WholeWorldPolygon()})), FilterValues$.MODULE$.apply$default$2(), FilterValues$.MODULE$.apply$default$3());
        explain.apply((Function0<String>)new Serializable($this, geometries){
            public static final long serialVersionUID = 0L;
            private final FilterValues geometries$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geometries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.geometries$1}));
            }
            {
                this.geometries$1 = geometries$1;
            }
        });
        if (geometries.disjoint()) {
            explain.apply((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Non-intersecting geometries extracted, short-circuiting to empty query";
                }
            });
            return new Z2IndexValues($this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)((Seq)Seq$.MODULE$.empty()));
        }
        Seq xy = (Seq)geometries.values().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(Geometry geometry) {
                return GeometryUtils$.MODULE$.bounds(geometry);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Z2IndexValues($this.sfc(), (FilterValues<Geometry>)geometries, (Seq<Tuple4<Object, Object, Object, Object>>)xy);
    }

    public static Iterator getRanges(Z2IndexKeySpace $this, Z2IndexValues values) {
        Z2IndexValues z2IndexValues = values;
        if (z2IndexValues != null) {
            Iterator iterator;
            Seq<Tuple4<Object, Object, Object, Object>> xy = z2IndexValues.bounds();
            Seq<Tuple4<Object, Object, Object, Object>> seq = xy;
            Seq<Tuple4<Object, Object, Object, Object>> xy2 = seq;
            if (xy2.isEmpty()) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                Seq zs = $this.sfc().ranges(xy2, 64, QueryProperties$.MODULE$.ScanRangesTarget().option().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
                    }
                }));
                iterator = zs.iterator().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final IndexKeySpace.BoundedRange<Object> apply(IndexRange r) {
                        return new IndexKeySpace$BoundedRange$mcJ$sp(r.lower(), r.upper());
                    }
                });
            }
            return iterator;
        }
        throw new MatchError((Object)z2IndexValues);
    }

    public static Iterator getRangeBytes(Z2IndexKeySpace $this, Iterator ranges, Seq prefixes, boolean tier) {
        return prefixes.isEmpty() ? ranges.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final IndexKeySpace.ByteRange apply(IndexKeySpace.ScanRange<Object> x0$1) {
                IndexKeySpace.ScanRange<Object> scanRange = x0$1;
                if (scanRange instanceof IndexKeySpace.BoundedRange) {
                    IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    IndexKeySpace.BoundedByteRange boundedByteRange = new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.toBytes(lo), ByteArrays$.MODULE$.toBytesFollowingPrefix(hi));
                    return boundedByteRange;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
        }) : ranges.flatMap((Function1)new Serializable($this, prefixes){
            public static final long serialVersionUID = 0L;
            private final Seq prefixes$1;

            public final GenTraversableOnce<IndexKeySpace.ByteRange> apply(IndexKeySpace.ScanRange<Object> x0$2) {
                IndexKeySpace.ScanRange<Object> scanRange = x0$2;
                if (scanRange instanceof IndexKeySpace.BoundedRange) {
                    IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    byte[] lower = ByteArrays$.MODULE$.toBytes(lo);
                    byte[] upper = ByteArrays$.MODULE$.toBytesFollowingPrefix(hi);
                    GenTraversableOnce genTraversableOnce = (GenTraversableOnce)this.prefixes$1.map((Function1)new Serializable(this, lower, upper){
                        public static final long serialVersionUID = 0L;
                        private final byte[] lower$1;
                        private final byte[] upper$1;

                        public final IndexKeySpace.BoundedByteRange apply(byte[] p) {
                            return new IndexKeySpace.BoundedByteRange(ByteArrays$.MODULE$.concat(p, this.lower$1), ByteArrays$.MODULE$.concat(p, this.upper$1));
                        }
                        {
                            this.lower$1 = lower$1;
                            this.upper$1 = upper$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return genTraversableOnce;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scanRange})));
            }
            {
                this.prefixes$1 = prefixes$1;
            }
        });
    }

    public static boolean useFullFilter(Z2IndexKeySpace $this, Option values, Option config, Hints hints) {
        BooleanRef simpleGeoms$lzy = BooleanRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        boolean looseBBox = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(hints.get((Object)QueryHints$.MODULE$.LOOSE_BBOX())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x) {
                return BoxesRunTime.unboxToBoolean((Object)x);
            }
        }).getOrElse((Function0)new Serializable($this, config){
            public static final long serialVersionUID = 0L;
            private final Option config$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.config$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(GeoMesaDataStoreFactory.GeoMesaDataStoreConfig x$2) {
                        return x$2.looseBBox();
                    }
                });
            }
            {
                this.config$1 = config$1;
            }
        }));
        return !looseBBox || !Z2IndexKeySpace$class.simpleGeoms$1($this, simpleGeoms$lzy, values, bitmap$0);
    }

    public static Seq org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$$getZValue(Z2IndexKeySpace $this, int geomIndex, boolean lenient, SimpleFeature feature) {
        Point geom = (Point)feature.getAttribute(geomIndex);
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
        }
        try {
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{$this.sfc().index(geom.getX(), geom.getY(), lenient)}));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z value from geometry: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geom})), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Seq org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$$getZValueBytes(Z2IndexKeySpace $this, int geomIndex, boolean lenient, Seq prefix, SimpleFeature feature, byte[] suffix) {
        long z;
        Point geom = (Point)feature.getAttribute(geomIndex);
        if (geom == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Null geometry in feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature.getID()})));
        }
        try {
            z = $this.sfc().index(geom.getX(), geom.getY(), lenient);
        }
        catch (Throwable throwable) {
            void var6_6;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z value from geometry: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6})), e);
        }
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(BoxesRunTime.unboxToInt((Object)((TraversableOnce)prefix.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(byte[] x$4) {
                return x$4.length;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 8 + suffix.length, ClassTag$.MODULE$.Byte());
        IntRef i = IntRef.create((int)0);
        prefix.foreach((Function1)new Serializable($this, bytes, i){
            public static final long serialVersionUID = 0L;
            private final byte[] bytes$1;
            private final IntRef i$1;

            public final void apply(byte[] p) {
                System.arraycopy(p, 0, this.bytes$1, this.i$1.elem, p.length);
                this.i$1.elem += p.length;
            }
            {
                this.bytes$1 = bytes$1;
                this.i$1 = i$1;
            }
        });
        ByteArrays$.MODULE$.writeLong(z, bytes, i.elem);
        System.arraycopy(suffix, 0, bytes, i.elem + 8, suffix.length);
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{bytes}));
    }

    private static final boolean simpleGeoms$lzycompute$1(Z2IndexKeySpace $this, BooleanRef simpleGeoms$lzy$1, Option values$1, VolatileByteRef bitmap$0$1) {
        Z2IndexKeySpace z2IndexKeySpace = $this;
        synchronized (z2IndexKeySpace) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                simpleGeoms$lzy$1.elem = ((IterableLike)Option$.MODULE$.option2Iterable(values$1).toSeq().flatMap((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Geometry> apply(Z2IndexValues x$3) {
                        return x$3.geometries().values();
                    }
                }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Geometry geometry) {
                        return GeometryUtils$.MODULE$.isRectangular(geometry);
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return simpleGeoms$lzy$1.elem;
        }
    }

    private static final boolean simpleGeoms$1(Z2IndexKeySpace $this, BooleanRef simpleGeoms$lzy$1, Option values$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? Z2IndexKeySpace$class.simpleGeoms$lzycompute$1($this, simpleGeoms$lzy$1, values$1, bitmap$0$1) : simpleGeoms$lzy$1.elem;
    }

    public static void $init$(Z2IndexKeySpace $this) {
        $this.org$locationtech$geomesa$index$index$z2$Z2IndexKeySpace$_setter_$indexKeyByteLength_$eq(8);
    }
}

