/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.stats;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.filter.visitor.QueryPlanFilterVisitor;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata$;
import org.locationtech.geomesa.index.stats.GeoMesaStats$;
import org.locationtech.geomesa.index.stats.MetadataBackedStats;
import org.locationtech.geomesa.index.stats.MetadataBackedStats$;
import org.locationtech.geomesa.index.stats.MetadataBackedStats$$anonfun$10$;
import org.locationtech.geomesa.index.stats.MetadataStatUpdater;
import org.locationtech.geomesa.index.stats.NoopStatUpdater$;
import org.locationtech.geomesa.index.stats.StatUpdater;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.stats.CountStat;
import org.locationtech.geomesa.utils.stats.Frequency;
import org.locationtech.geomesa.utils.stats.Histogram;
import org.locationtech.geomesa.utils.stats.Histogram$;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.SeqStat;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.geomesa.utils.stats.TopK;
import org.locationtech.geomesa.utils.stats.Z3Histogram;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public abstract class MetadataBackedStats$class {
    public static Option getCount(MetadataBackedStats $this, SimpleFeatureType sft, Filter filter2, boolean exact) {
        return exact ? $this.runStats(sft, Stat$.MODULE$.Count(), filter2).headOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(CountStat x$1) {
                return x$1.count();
            }
        }) : $this.estimateCount(sft, (Filter)filter2.accept((FilterVisitor)new QueryPlanFilterVisitor(sft), null));
    }

    public static Option getAttributeBounds(MetadataBackedStats $this, SimpleFeatureType sft, String attribute, Filter filter2, boolean exact) {
        Option stat = exact ? $this.runStats(sft, Stat$.MODULE$.MinMax(attribute), filter2).headOption() : MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat($this, sft, MetadataBackedStats$.MODULE$.minMaxKey(attribute), MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3($this));
        return stat.filterNot((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MinMax<T> x$2) {
                return x$2.isEmpty();
            }
        });
    }

    public static Seq getStats(MetadataBackedStats $this, SimpleFeatureType sft, Seq attributes, Seq options, ClassTag ct) {
        Seq seq;
        Class clas;
        Seq toRetrieve = attributes.nonEmpty() ? (Seq)attributes.filter((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final boolean apply(String a) {
                return Option$.MODULE$.apply((Object)this.sft$1.getDescriptor(a)).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AttributeDescriptor d) {
                        return GeoMesaStats$.MODULE$.okForStats(d);
                    }
                });
            }
            {
                this.sft$1 = sft$1;
            }
        }) : (Seq)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor d) {
                return GeoMesaStats$.MODULE$.okForStats(d);
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(AttributeDescriptor x$3) {
                return x$3.getLocalName();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Class clazz = clas = ct.runtimeClass();
        Class<CountStat> clazz2 = CountStat.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            seq = Option$.MODULE$.option2Iterable(MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat($this, sft, MetadataBackedStats$.MODULE$.countKey(), MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3($this))).toSeq();
        } else {
            Class clazz3 = clas;
            Class<MinMax> clazz4 = MinMax.class;
            if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
                seq = (Seq)toRetrieve.flatMap((Function1)new Serializable($this, sft){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MetadataBackedStats $outer;
                    private final SimpleFeatureType sft$1;

                    public final Iterable<MinMax<Object>> apply(String a) {
                        return Option$.MODULE$.option2Iterable(MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat(this.$outer, this.sft$1, MetadataBackedStats$.MODULE$.minMaxKey(a), MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3(this.$outer)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sft$1 = sft$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            } else {
                Class clazz5 = clas;
                Class<TopK> clazz6 = TopK.class;
                if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
                    seq = (Seq)toRetrieve.flatMap((Function1)new Serializable($this, sft){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MetadataBackedStats $outer;
                        private final SimpleFeatureType sft$1;

                        public final Iterable<TopK<Object>> apply(String a) {
                            return Option$.MODULE$.option2Iterable(MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat(this.$outer, this.sft$1, MetadataBackedStats$.MODULE$.topKKey(a), MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3(this.$outer)));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sft$1 = sft$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                } else {
                    Class clazz7 = clas;
                    Class<Histogram> clazz8 = Histogram.class;
                    if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
                        seq = (Seq)toRetrieve.flatMap((Function1)new Serializable($this, sft){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ MetadataBackedStats $outer;
                            private final SimpleFeatureType sft$1;

                            public final Iterable<Histogram<Object>> apply(String a) {
                                return Option$.MODULE$.option2Iterable(MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat(this.$outer, this.sft$1, MetadataBackedStats$.MODULE$.histogramKey(a), MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3(this.$outer)));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.sft$1 = sft$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    } else {
                        Class clazz9 = clas;
                        Class<Frequency> clazz10 = Frequency.class;
                        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
                            if (options.nonEmpty()) {
                                Seq weeks = options;
                                Seq frequencies = (Seq)toRetrieve.flatMap((Function1)new Serializable($this, weeks, sft){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ MetadataBackedStats $outer;
                                    private final Seq weeks$1;
                                    public final SimpleFeatureType sft$1;

                                    public final Seq<Frequency<Object>> apply(String a) {
                                        return (Seq)((TraversableLike)this.weeks$1.map((Function1)new Serializable(this, a){
                                            public static final long serialVersionUID = 0L;
                                            private final String a$1;

                                            public final String apply(short x$4) {
                                                return MetadataBackedStats$.MODULE$.frequencyKey(this.a$1, x$4);
                                            }
                                            {
                                                this.a$1 = a$1;
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ MetadataBackedStats$.anonfun.8 $outer;

                                            public final Iterable<Frequency<Object>> apply(String x$5) {
                                                return Option$.MODULE$.option2Iterable(MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat(this.$outer.org$locationtech$geomesa$index$stats$MetadataBackedStats$$anonfun$$$outer(), this.$outer.sft$1, x$5, MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3(this.$outer.org$locationtech$geomesa$index$stats$MetadataBackedStats$$anonfun$$$outer())));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        }, Seq$.MODULE$.canBuildFrom());
                                    }

                                    public /* synthetic */ MetadataBackedStats org$locationtech$geomesa$index$stats$MetadataBackedStats$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.weeks$1 = weeks$1;
                                        this.sft$1 = sft$1;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                seq = Option$.MODULE$.option2Iterable(Stat$.MODULE$.combine(frequencies)).toSeq();
                            } else {
                                seq = (Seq)toRetrieve.flatMap((Function1)new Serializable($this, sft){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ MetadataBackedStats $outer;
                                    private final SimpleFeatureType sft$1;

                                    public final Iterable<Frequency<Object>> apply(String a) {
                                        return Option$.MODULE$.option2Iterable(MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat(this.$outer, this.sft$1, MetadataBackedStats$.MODULE$.frequencyKey(a), MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3(this.$outer)));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.sft$1 = sft$1;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                            }
                        } else {
                            Class clazz11 = clas;
                            Class<Z3Histogram> clazz12 = Z3Histogram.class;
                            if (!(clazz11 != null ? !clazz11.equals(clazz12) : clazz12 != null)) {
                                Option geomDtgOption = Option$.MODULE$.apply((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).flatMap((Function1)new Serializable($this, toRetrieve, sft){
                                    public static final long serialVersionUID = 0L;
                                    public final Seq toRetrieve$1;
                                    private final SimpleFeatureType sft$1;

                                    public final Option<Tuple2<String, String>> apply(String geom) {
                                        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1)).withFilter((Function1)new Serializable(this, geom){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ MetadataBackedStats$.anonfun.10 $outer;
                                            public final String geom$3;

                                            public final boolean apply(String dtg) {
                                                return this.$outer.toRetrieve$1.exists((Function1)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ MetadataBackedStats$$anonfun$10$.anonfun.apply.4 $outer;

                                                    public final boolean apply(String x$6) {
                                                        String string = x$6;
                                                        String string2 = this.$outer.geom$3;
                                                        return !(string != null ? !string.equals(string2) : string2 != null);
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                    }
                                                }) && this.$outer.toRetrieve$1.exists((Function1)new Serializable(this, dtg){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String dtg$4;

                                                    public final boolean apply(String x$7) {
                                                        String string = x$7;
                                                        String string2 = this.dtg$4;
                                                        return !(string != null ? !string.equals(string2) : string2 != null);
                                                    }
                                                    {
                                                        this.dtg$4 = dtg$4;
                                                    }
                                                });
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.geom$3 = geom$3;
                                            }
                                        }).map((Function1)new Serializable(this, geom){
                                            public static final long serialVersionUID = 0L;
                                            private final String geom$3;

                                            public final Tuple2<String, String> apply(String dtg) {
                                                return new Tuple2((Object)this.geom$3, (Object)dtg);
                                            }
                                            {
                                                this.geom$3 = geom$3;
                                            }
                                        });
                                    }
                                    {
                                        this.toRetrieve$1 = toRetrieve$1;
                                        this.sft$1 = sft$1;
                                    }
                                });
                                seq = Option$.MODULE$.option2Iterable(geomDtgOption.flatMap((Function1)new Serializable($this, sft, options){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ MetadataBackedStats $outer;
                                    public final SimpleFeatureType sft$1;
                                    private final Seq options$1;

                                    public final Option<Z3Histogram> apply(Tuple2<String, String> x0$1) {
                                        Tuple2<String, String> tuple2 = x0$1;
                                        if (tuple2 != null) {
                                            String geom = (String)tuple2._1();
                                            String dtg = (String)tuple2._2();
                                            Seq timeBins = this.options$1.nonEmpty() ? this.options$1 : (Seq)MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat(this.$outer, this.sft$1, MetadataBackedStats$.MODULE$.minMaxKey(dtg), MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3(this.$outer)).map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ MetadataBackedStats$.anonfun.11 $outer;

                                                public final IndexedSeq<Object> apply(MinMax<Date> bounds) {
                                                    Function1 timeToBin = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.$outer.sft$1)));
                                                    short lBin = ((BinnedTime)timeToBin.apply((Object)BoxesRunTime.boxToLong((long)((Date)bounds.min()).getTime()))).bin();
                                                    short uBin = ((BinnedTime)timeToBin.apply((Object)BoxesRunTime.boxToLong((long)((Date)bounds.max()).getTime()))).bin();
                                                    return (IndexedSeq)package$.MODULE$.Range().inclusive((int)lBin, (int)uBin).map((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final short apply(int x$8) {
                                                            return (short)x$8;
                                                        }
                                                    }, IndexedSeq$.MODULE$.canBuildFrom());
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }).getOrElse((Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final Seq<Nothing$> apply() {
                                                    return (Seq)Seq$.MODULE$.empty();
                                                }
                                            });
                                            Seq histograms = (Seq)((TraversableLike)timeBins.map((Function1)new Serializable(this, geom, dtg){
                                                public static final long serialVersionUID = 0L;
                                                private final String geom$1;
                                                private final String dtg$1;

                                                public final String apply(short x$9) {
                                                    return MetadataBackedStats$.MODULE$.histogramKey(this.geom$1, this.dtg$1, x$9);
                                                }
                                                {
                                                    this.geom$1 = geom$1;
                                                    this.dtg$1 = dtg$1;
                                                }
                                            }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ MetadataBackedStats$.anonfun.11 $outer;

                                                public final Iterable<Z3Histogram> apply(String x$10) {
                                                    return Option$.MODULE$.option2Iterable(MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat(this.$outer.org$locationtech$geomesa$index$stats$MetadataBackedStats$$anonfun$$$outer(), this.$outer.sft$1, x$10, MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3(this.$outer.org$locationtech$geomesa$index$stats$MetadataBackedStats$$anonfun$$$outer())));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }, Seq$.MODULE$.canBuildFrom());
                                            Option option = Stat$.MODULE$.combine(histograms);
                                            return option;
                                        }
                                        throw new MatchError(tuple2);
                                    }

                                    public /* synthetic */ MetadataBackedStats org$locationtech$geomesa$index$stats$MetadataBackedStats$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.sft$1 = sft$1;
                                        this.options$1 = options$1;
                                    }
                                })).toSeq();
                            } else {
                                seq = (Seq)Seq$.MODULE$.empty();
                            }
                        }
                    }
                }
            }
        }
        Seq stats = seq;
        return stats;
    }

    /*
     * WARNING - void declaration
     */
    public static Seq generateStats(MetadataBackedStats $this, SimpleFeatureType sft) {
        void var3_3;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        String statString = $this.buildStatsFor(sft);
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Calculating stats for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName(), statString})));
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        Seq stats = $this.runStats(sft, statString, $this.runStats$default$3());
        if ($this.logger().underlying().isTraceEnabled()) {
            $this.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stats for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName(), ((TraversableOnce)stats.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(Stat x$11) {
                    return x$11.toJson();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing stats for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $this.writeStat((Stat)new SeqStat(stats), sft, false);
        String date = org.locationtech.geomesa.utils.geotools.package$.MODULE$.GeoToolsDateFormat().format(Instant.now().atZone(ZoneOffset.UTC));
        $this.ds().metadata().insert(sft.getTypeName(), GeoMesaMetadata$.MODULE$.STATS_GENERATION_KEY(), date);
        return var3_3;
    }

    public static StatUpdater statUpdater(MetadataBackedStats $this, SimpleFeatureType sft) {
        return $this.generateStats() ? new MetadataStatUpdater($this, sft, (Function0<Stat>)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataBackedStats $outer;
            private final SimpleFeatureType sft$2;

            public final Stat apply() {
                return Stat$.MODULE$.apply(this.sft$2, this.$outer.buildStatsFor(this.sft$2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$2 = sft$2;
            }
        }) : NoopStatUpdater$.MODULE$;
    }

    public static void clearStats(MetadataBackedStats $this, SimpleFeatureType sft) {
        $this.metadata().delete(sft.getTypeName());
    }

    public static void close(MetadataBackedStats $this) {
        $this.metadata().close();
    }

    public static void writeStat(MetadataBackedStats $this, Stat stat, SimpleFeatureType sft, boolean merge) {
        String typeName = sft.getTypeName();
        Seq<MetadataBackedStats.KeyAndStat> toWrite = $this.getKeysAndStatsForWrite(stat, sft);
        if (merge) {
            $this.writeMerge(typeName, toWrite);
        } else {
            $this.writeAuthoritative(typeName, toWrite);
        }
    }

    public static void writeMerge(MetadataBackedStats $this, String typeName, Seq toWrite) {
        toWrite.foreach((Function1)new Serializable($this, typeName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataBackedStats $outer;
            private final String typeName$2;

            public final void apply(MetadataBackedStats.KeyAndStat ks) {
                this.$outer.metadata().insert(this.typeName$2, ks.key(), ks.stat());
                this.$outer.metadata().invalidateCache(this.typeName$2, ks.key());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$2 = typeName$2;
            }
        });
    }

    public static void writeAuthoritative(MetadataBackedStats $this, String typeName, Seq toWrite) {
        toWrite.foreach((Function1)new Serializable($this, typeName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataBackedStats $outer;
            private final String typeName$3;

            public final void apply(MetadataBackedStats.KeyAndStat ks) {
                this.$outer.metadata().insert(this.typeName$3, ks.key(), ks.stat());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$3 = typeName$3;
            }
        });
    }

    public static Seq getKeysAndStatsForWrite(MetadataBackedStats $this, Stat stat, SimpleFeatureType sft) {
        block9: {
            Seq seq;
            block3: {
                Stat stat2;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        stat2 = stat;
                                        if (!(stat2 instanceof SeqStat)) break block2;
                                        SeqStat seqStat = (SeqStat)stat2;
                                        seq = (Seq)seqStat.stats().flatMap((Function1)new Serializable($this, sft){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ MetadataBackedStats $outer;
                                            private final SimpleFeatureType sft$3;

                                            public final Seq<MetadataBackedStats.KeyAndStat> apply(Stat x$12) {
                                                return this.$outer.getKeysAndStatsForWrite(x$12, this.sft$3);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.sft$3 = sft$3;
                                            }
                                        }, Seq$.MODULE$.canBuildFrom());
                                        break block3;
                                    }
                                    if (!(stat2 instanceof CountStat)) break block4;
                                    CountStat countStat = (CountStat)stat2;
                                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetadataBackedStats.KeyAndStat[]{new MetadataBackedStats.KeyAndStat(MetadataBackedStats$.MODULE$.countKey(), (Stat)countStat)}));
                                    break block3;
                                }
                                if (!(stat2 instanceof MinMax)) break block5;
                                MinMax minMax2 = (MinMax)stat2;
                                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetadataBackedStats.KeyAndStat[]{new MetadataBackedStats.KeyAndStat(MetadataBackedStats$.MODULE$.minMaxKey(MetadataBackedStats$class.name$1($this, minMax2.attribute(), sft)), (Stat)minMax2)}));
                                break block3;
                            }
                            if (!(stat2 instanceof TopK)) break block6;
                            TopK topK = (TopK)stat2;
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetadataBackedStats.KeyAndStat[]{new MetadataBackedStats.KeyAndStat(MetadataBackedStats$.MODULE$.topKKey(MetadataBackedStats$class.name$1($this, topK.attribute(), sft)), (Stat)topK)}));
                            break block3;
                        }
                        if (!(stat2 instanceof Histogram)) break block7;
                        Histogram histogram = (Histogram)stat2;
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetadataBackedStats.KeyAndStat[]{new MetadataBackedStats.KeyAndStat(MetadataBackedStats$.MODULE$.histogramKey(MetadataBackedStats$class.name$1($this, histogram.attribute(), sft)), (Stat)histogram)}));
                        break block3;
                    }
                    if (!(stat2 instanceof Frequency)) break block8;
                    Frequency frequency = (Frequency)stat2;
                    String attribute = MetadataBackedStats$class.name$1($this, frequency.attribute(), sft);
                    seq = frequency.dtgIndex() == -1 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetadataBackedStats.KeyAndStat[]{new MetadataBackedStats.KeyAndStat(MetadataBackedStats$.MODULE$.frequencyKey(attribute), (Stat)frequency)})) : (Seq)frequency.splitByTime().map((Function1)new Serializable($this, attribute){
                        public static final long serialVersionUID = 0L;
                        private final String attribute$1;

                        public final MetadataBackedStats.KeyAndStat apply(Tuple2<Object, Frequency<Object>> x0$2) {
                            Tuple2<Object, Frequency<Object>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                short b = BoxesRunTime.unboxToShort((Object)tuple2._1());
                                Frequency f = (Frequency)tuple2._2();
                                MetadataBackedStats.KeyAndStat keyAndStat = new MetadataBackedStats.KeyAndStat(MetadataBackedStats$.MODULE$.frequencyKey(this.attribute$1, b), (Stat)f);
                                return keyAndStat;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.attribute$1 = attribute$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!(stat2 instanceof Z3Histogram)) break block9;
                Z3Histogram z3Histogram = (Z3Histogram)stat2;
                String geom = MetadataBackedStats$class.name$1($this, z3Histogram.geomIndex(), sft);
                String dtg = MetadataBackedStats$class.name$1($this, z3Histogram.dtgIndex(), sft);
                seq = (Seq)z3Histogram.splitByTime().map((Function1)new Serializable($this, geom, dtg){
                    public static final long serialVersionUID = 0L;
                    private final String geom$2;
                    private final String dtg$2;

                    public final MetadataBackedStats.KeyAndStat apply(Tuple2<Object, Z3Histogram> x0$3) {
                        Tuple2<Object, Z3Histogram> tuple2 = x0$3;
                        if (tuple2 != null) {
                            short b = BoxesRunTime.unboxToShort((Object)tuple2._1());
                            Z3Histogram z = (Z3Histogram)tuple2._2();
                            MetadataBackedStats.KeyAndStat keyAndStat = new MetadataBackedStats.KeyAndStat(MetadataBackedStats$.MODULE$.histogramKey(this.geom$2, this.dtg$2, b), (Stat)z);
                            return keyAndStat;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.geom$2 = geom$2;
                        this.dtg$2 = dtg$2;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new NotImplementedError("Only Count, Frequency, MinMax, TopK and Histogram stats are tracked");
    }

    public static Option org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat(MetadataBackedStats $this, SimpleFeatureType sft, String key, boolean cache) {
        return $this.metadata().read(sft.getTypeName(), key, cache).collect((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Stat, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 instanceof Stat && !(A1 = A12).isEmpty() ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Stat x1) {
                Stat stat;
                Stat stat2 = x1;
                boolean bl = stat2 instanceof Stat && !(stat = stat2).isEmpty();
                return bl;
            }
        });
    }

    public static boolean org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3(MetadataBackedStats $this) {
        return true;
    }

    public static String buildStatsFor(MetadataBackedStats $this, SimpleFeatureType sft) {
        Option option;
        block4: {
            Seq seq;
            Buffer descriptors;
            Buffer topK;
            Seq minMax2;
            String count;
            Buffer indexedAttributes;
            Seq stAttributes;
            block3: {
                block2: {
                    stAttributes = (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)))).toSeq().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))), Seq$.MODULE$.canBuildFrom());
                    indexedAttributes = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).filter((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(AttributeDescriptor d) {
                            return RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isIndexed$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(d)) && GeoMesaStats$.MODULE$.okForStats(d);
                        }
                    })).map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(AttributeDescriptor x$13) {
                            return x$13.getLocalName();
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    Buffer flaggedAttributes = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).filter((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(AttributeDescriptor d) {
                            return RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isKeepStats$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(d)) && GeoMesaStats$.MODULE$.okForStats(d);
                        }
                    })).map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(AttributeDescriptor x$14) {
                            return x$14.getLocalName();
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    count = Stat$.MODULE$.Count();
                    minMax2 = (Seq)((TraversableLike)((SeqLike)((TraversableLike)stAttributes.$plus$plus((GenTraversableOnce)indexedAttributes, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)flaggedAttributes, Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String attribute) {
                            return Stat$.MODULE$.MinMax(attribute);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    topK = (Buffer)((TraversableLike)indexedAttributes.$plus$plus((GenTraversableOnce)flaggedAttributes).distinct()).map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String attribute) {
                            return Stat$.MODULE$.TopK(attribute);
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    descriptors = (Buffer)indexedAttributes.map((Function1)new Serializable($this, sft){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$4;

                        public final AttributeDescriptor apply(String x$1) {
                            return this.sft$4.getDescriptor(x$1);
                        }
                        {
                            this.sft$4 = sft$4;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    option = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
                    if (!None$.MODULE$.equals(option)) break block2;
                    seq = (Seq)Seq$.MODULE$.empty();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                String dtg = (String)some.x();
                Enumeration.Value period = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
                seq = (Seq)descriptors.map((Function1)new Serializable($this, dtg, period){
                    public static final long serialVersionUID = 0L;
                    private final String dtg$3;
                    private final Enumeration.Value period$1;

                    public final String apply(AttributeDescriptor d) {
                        return Stat$.MODULE$.Frequency(d.getLocalName(), this.dtg$3, this.period$1, GeoMesaStats$.MODULE$.defaultPrecision(d.getType().getBinding()));
                    }
                    {
                        this.dtg$3 = dtg$3;
                        this.period$1 = period$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom());
            }
            Seq withDates = seq;
            Buffer noDates = (Buffer)descriptors.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(AttributeDescriptor d) {
                    return Stat$.MODULE$.Frequency(d.getLocalName(), GeoMesaStats$.MODULE$.defaultPrecision(d.getType().getBinding()));
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Seq frequencies = (Seq)withDates.$plus$plus((GenTraversableOnce)noDates, Seq$.MODULE$.canBuildFrom());
            Seq histograms = (Seq)((TraversableLike)((SeqLike)stAttributes.$plus$plus((GenTraversableOnce)indexedAttributes, Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1)new Serializable($this, sft){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MetadataBackedStats $outer;
                private final SimpleFeatureType sft$4;

                public final String apply(String attribute) {
                    Option option;
                    block8: {
                        Tuple2 tuple2;
                        Option mm;
                        Class binding;
                        block6: {
                            Some some;
                            boolean bl;
                            block7: {
                                block5: {
                                    binding = this.sft$4.getDescriptor(attribute).getType().getBinding();
                                    mm = this.liftedTree1$1(attribute);
                                    bl = false;
                                    some = null;
                                    option = mm;
                                    if (!None$.MODULE$.equals(option)) break block5;
                                    tuple2 = GeoMesaStats$.MODULE$.defaultBounds(binding);
                                    break block6;
                                }
                                if (!(option instanceof Some)) break block7;
                                bl = true;
                                some = (Some)option;
                                MinMax b = (MinMax)some.x();
                                if (!BoxesRunTime.equals((Object)b.min(), (Object)b.max())) break block7;
                                tuple2 = Histogram$.MODULE$.buffer(b.min());
                                break block6;
                            }
                            if (!bl) break block8;
                            MinMax b = (MinMax)some.x();
                            tuple2 = b.bounds();
                        }
                        Tuple2 tuple22 = tuple2;
                        if (tuple22 != null) {
                            Object max2;
                            Object max3;
                            Object min2 = tuple22._1();
                            Tuple2 tuple23 = new Tuple2(min2, max3 = tuple22._2());
                            Tuple2 tuple24 = tuple23;
                            Object min3 = tuple24._1();
                            Tuple3 tuple3 = new Tuple3(min3, max2 = tuple24._2(), mm.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(MinMax<Object> x$16) {
                                    return x$16.cardinality();
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply() {
                                    return this.apply$mcJ$sp();
                                }

                                public long apply$mcJ$sp() {
                                    return 0L;
                                }
                            }));
                            if (tuple3 != null) {
                                Tuple3 tuple32;
                                Object lower = tuple3._1();
                                Object upper = tuple3._2();
                                long cardinality = BoxesRunTime.unboxToLong((Object)tuple3._3());
                                Tuple3 tuple33 = tuple32 = new Tuple3(lower, upper, (Object)BoxesRunTime.boxToLong((long)cardinality));
                                Object lower2 = tuple33._1();
                                Object upper2 = tuple33._2();
                                long cardinality2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
                                String string = attribute;
                                String string2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$4));
                                int size = !(string != null ? !string.equals(string2) : string2 != null) ? GeoMesaStats$.MODULE$.MaxHistogramSize() : scala.math.package$.MODULE$.min(GeoMesaStats$.MODULE$.MaxHistogramSize(), (int)scala.math.package$.MODULE$.max((long)GeoMesaStats$.MODULE$.DefaultHistogramSize(), cardinality2 / 10000L));
                                return Stat$.MODULE$.Histogram(attribute, size, lower2, upper2, ClassTag$.MODULE$.apply(binding));
                            }
                            throw new MatchError((Object)tuple3);
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    throw new MatchError((Object)option);
                }

                private final Option liftedTree1$1(String attribute$2) {
                    Option option;
                    try {
                        option = MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat(this.$outer, this.sft$4, MetadataBackedStats$.MODULE$.minMaxKey(attribute$2), MetadataBackedStats$class.org$locationtech$geomesa$index$stats$MetadataBackedStats$$readStat$default$3(this.$outer));
                    }
                    catch (Throwable throwable) {
                        BoxedUnit boxedUnit;
                        Throwable throwable2 = throwable;
                        Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                        if (option2.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = (Throwable)option2.get();
                        if (this.$outer.logger().underlying().isErrorEnabled()) {
                            this.$outer.logger().underlying().error("Error reading existing stats - possibly the distributed runtime jar is not available", e);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        None$ none$ = None$.MODULE$;
                        option = none$;
                    }
                    return option;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sft$4 = sft$4;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Option z3Histogram = Option$.MODULE$.apply((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).filter((Function1)new Serializable($this, stAttributes){
                public static final long serialVersionUID = 0L;
                private final Seq stAttributes$1;

                public final boolean apply(Object elem) {
                    return this.stAttributes$1.contains(elem);
                }
                {
                    this.stAttributes$1 = stAttributes$1;
                }
            }).flatMap((Function1)new Serializable($this, stAttributes, sft){
                public static final long serialVersionUID = 0L;
                public final Seq stAttributes$1;
                public final SimpleFeatureType sft$4;

                public final Option<String> apply(String geom) {
                    return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$4)).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MetadataBackedStats$.anonfun.28 $outer;

                        public final boolean apply(Object elem) {
                            return this.$outer.stAttributes$1.contains(elem);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }).map((Function1)new Serializable(this, geom){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MetadataBackedStats$.anonfun.28 $outer;
                        private final String geom$4;

                        public final String apply(String dtg) {
                            return Stat$.MODULE$.Z3Histogram(this.geom$4, dtg, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.$outer.sft$4)), GeoMesaStats$.MODULE$.MaxHistogramSize());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.geom$4 = geom$4;
                        }
                    });
                }
                {
                    this.stAttributes$1 = stAttributes$1;
                    this.sft$4 = sft$4;
                }
            });
            return Stat$.MODULE$.SeqStat((Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{count}))).$plus$plus((GenTraversableOnce)minMax2, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)topK, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)histograms, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)frequencies, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(z3Histogram), Seq$.MODULE$.canBuildFrom()));
        }
        throw new MatchError((Object)option);
    }

    private static final String name$1(MetadataBackedStats $this, int i, SimpleFeatureType sft$3) {
        return sft$3.getDescriptor(i).getLocalName();
    }

    public static void $init$(MetadataBackedStats $this) {
    }
}

