/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.build.line;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.graph.build.line.BasicLineGraphGenerator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;

public class LineStringGraphGenerator
extends BasicLineGraphGenerator {
    private static GeometryFactory gf = new GeometryFactory();

    public LineStringGraphGenerator(double tolerance) {
        super(tolerance);
    }

    public LineStringGraphGenerator() {
    }

    @Override
    public Graphable add(Object obj) {
        LineString ls = null;
        ls = obj instanceof MultiLineString ? (LineString)((MultiLineString)obj).getGeometryN(0) : (LineString)obj;
        Edge e = (Edge)super.add(new LineSegment(ls.getCoordinateN(0), ls.getCoordinateN(ls.getNumPoints() - 1)));
        if (this.useTolerance()) {
            LineSegment lineSegment = (LineSegment)e.getObject();
            Coordinate[] coordinates = ls.getCoordinates();
            List<Coordinate> coordinateList = Arrays.asList(coordinates);
            ArrayList<Coordinate> nCoordinateList = new ArrayList<Coordinate>(coordinateList);
            if (!ls.getCoordinateN(0).equals((Object)lineSegment.p0)) {
                nCoordinateList.add(0, lineSegment.p0);
            } else if (!ls.getCoordinateN(ls.getNumPoints() - 1).equals((Object)lineSegment.p1)) {
                nCoordinateList.add(lineSegment.p1);
            }
            Coordinate[] newCoordinates = nCoordinateList.toArray(new Coordinate[nCoordinateList.size()]);
            ls = gf.createLineString(newCoordinates);
        }
        e.setObject(ls);
        return e;
    }

    @Override
    protected LineSegment alterLine(LineSegment line, Node n1, Node n2) {
        Point c1added = (Point)n1.getObject();
        Point c2added = (Point)n2.getObject();
        if (!c1added.getCoordinate().equals((Object)line.p0) || c2added.getCoordinate().equals((Object)line.p1)) {
            line = new LineSegment(c1added.getCoordinate(), c2added.getCoordinate());
        }
        return line;
    }

    @Override
    public Graphable remove(Object obj) {
        LineString ls = (LineString)obj;
        return super.remove(new LineSegment(ls.getCoordinateN(0), ls.getCoordinateN(ls.getNumPoints() - 1)));
    }

    @Override
    public Graphable get(Object obj) {
        LineString ls = (LineString)obj;
        return super.get(new LineSegment(ls.getCoordinateN(0), ls.getCoordinateN(ls.getNumPoints() - 1)));
    }

    @Override
    protected void setObject(Node n, Object obj) {
        Coordinate c = (Coordinate)obj;
        n.setObject(gf.createPoint(c));
    }
}

