/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterators;
import org.calrissian.mango.collect.FluentCloseableIterable;
import org.calrissian.mango.collect.Iterables2;

public class CloseableIterables {
    private static final CloseableIterable EMPTY_ITERABLE = CloseableIterables.wrap(Collections.emptySet());

    private CloseableIterables() {
    }

    public static <T> CloseableIterable<T> distinct(CloseableIterable<T> iterable) {
        return CloseableIterables.wrap(Iterables2.distinct(iterable), iterable);
    }

    public static <T> CloseableIterable<T> concat(CloseableIterable<? extends Iterable<? extends T>> inputs) {
        return CloseableIterables.wrap(Iterables.concat(inputs), inputs);
    }

    public static <T> CloseableIterable<T> cycle(CloseableIterable<T> iterable) {
        return CloseableIterables.wrap(Iterables.cycle(iterable), iterable);
    }

    public static <T> CloseableIterable<T> filter(CloseableIterable<?> iterable, Class<T> type) {
        return CloseableIterables.wrap(Iterables.filter(iterable, type), iterable);
    }

    public static <T> CloseableIterable<T> filter(CloseableIterable<T> iterable, Predicate<? super T> filter) {
        return CloseableIterables.wrap(Iterables.filter(iterable, filter), iterable);
    }

    public static <T> CloseableIterable<T> limit(CloseableIterable<T> iterable, int limitSize) {
        return CloseableIterables.wrap(Iterables.limit(iterable, (int)limitSize), iterable);
    }

    public static <T> CloseableIterable<List<T>> paddedParition(CloseableIterable<T> iterable, int size) {
        return CloseableIterables.wrap(Iterables.paddedPartition(iterable, (int)size), iterable);
    }

    public static <T> CloseableIterable<List<T>> partition(CloseableIterable<T> iterable, int size) {
        return CloseableIterables.wrap(Iterables.partition(iterable, (int)size), iterable);
    }

    public static <T> CloseableIterable<T> skip(CloseableIterable<T> iterable, int numberToSkip) {
        return CloseableIterables.wrap(Iterables.skip(iterable, (int)numberToSkip), iterable);
    }

    public static <F, T> CloseableIterable<T> transform(CloseableIterable<F> iterable, Function<? super F, ? extends T> function) {
        return CloseableIterables.wrap(Iterables.transform(iterable, function), iterable);
    }

    public static <T> CloseableIterable<T> chain(CloseableIterable<? extends T> ... iterables) {
        return CloseableIterables.chain(Arrays.asList(iterables));
    }

    public static <T> CloseableIterable<T> chain(final Iterable<? extends CloseableIterable<? extends T>> iterables) {
        Preconditions.checkNotNull(iterables);
        return new FluentCloseableIterable<T>(){

            @Override
            protected void doClose() throws IOException {
                for (CloseableIterable curr : iterables) {
                    curr.closeQuietly();
                }
            }

            @Override
            protected Iterator<T> retrieveIterator() {
                return Iterators.concat((Iterator)CloseableIterables.iterators(iterables));
            }
        };
    }

    public static <T> CloseableIterable<T> autoClose(final CloseableIterable<? extends T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new FluentCloseableIterable<T>(){

            @Override
            protected void doClose() throws IOException {
                iterable.close();
            }

            @Override
            protected Iterator<T> retrieveIterator() {
                return CloseableIterators.autoClose(CloseableIterators.wrap(iterable.iterator(), iterable));
            }
        };
    }

    public static <T> CloseableIterable<T> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public static <T> CloseableIterable<T> singleton(T value) {
        return CloseableIterables.wrap(Collections.singleton(value));
    }

    public static <T> CloseableIterable<T> wrap(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof CloseableIterable) {
            return (CloseableIterable)iterable;
        }
        return new FluentCloseableIterable<T>(){

            @Override
            protected void doClose() throws IOException {
                if (iterable instanceof Closeable) {
                    ((Closeable)((Object)iterable)).close();
                }
            }

            @Override
            protected Iterator<T> retrieveIterator() {
                return iterable.iterator();
            }
        };
    }

    static <T> FluentCloseableIterable<T> wrap(final Iterable<T> iterable, final Closeable closeable) {
        return new FluentCloseableIterable<T>(){

            @Override
            protected void doClose() throws IOException {
                closeable.close();
            }

            @Override
            protected Iterator<T> retrieveIterator() {
                return iterable.iterator();
            }
        };
    }

    private static <T> UnmodifiableIterator<Iterator<? extends T>> iterators(Iterable<? extends CloseableIterable<? extends T>> iterables) {
        final Iterator<? extends CloseableIterable<? extends T>> iterableIterator = iterables.iterator();
        return new UnmodifiableIterator<Iterator<? extends T>>(){

            public boolean hasNext() {
                return iterableIterator.hasNext();
            }

            public Iterator<? extends T> next() {
                return ((Iterable)iterableIterator.next()).iterator();
            }
        };
    }
}

