/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import com.vividsolutions.jts.geom.Envelope;

class GridTransform {
    private Envelope env;
    private int xSize;
    private int ySize;
    private double dx;
    private double dy;
    private boolean isClamped = true;

    public GridTransform(Envelope env, int xSize, int ySize) {
        this.env = env;
        this.xSize = xSize;
        this.ySize = ySize;
        this.dx = env.getWidth() / (double)(xSize - 1);
        this.dy = env.getHeight() / (double)(ySize - 1);
    }

    public void setClamp(boolean isClamped) {
        this.isClamped = isClamped;
    }

    public double x(int i) {
        if (i >= this.xSize - 1) {
            return this.env.getMaxX();
        }
        return this.env.getMinX() + (double)i * this.dx;
    }

    public double y(int j) {
        if (j >= this.ySize - 1) {
            return this.env.getMaxY();
        }
        return this.env.getMinY() + (double)j * this.dy;
    }

    public int i(double x) {
        if (this.isClamped && x > this.env.getMaxX()) {
            return this.xSize;
        }
        if (this.isClamped && x < this.env.getMinX()) {
            return -1;
        }
        int i = (int)((x - this.env.getMinX()) / this.dx);
        if (this.isClamped && i >= this.xSize) {
            i = this.xSize - 1;
        }
        return i;
    }

    public int j(double y) {
        if (this.isClamped && y > this.env.getMaxY()) {
            return this.ySize;
        }
        if (this.isClamped && y < this.env.getMinY()) {
            return -1;
        }
        int j = (int)((y - this.env.getMinY()) / this.dy);
        if (this.isClamped && j >= this.ySize) {
            j = this.ySize - 1;
        }
        return j;
    }
}

