/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.BBOXExpandingFilterVisitor;
import org.geotools.process.vector.BilinearInterpolator;
import org.geotools.process.vector.HeatmapSurface;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Heatmap", description="Computes a heatmap surface over a set of data points and outputs as a single-band raster.")
public class HeatmapProcess
implements VectorProcess {
    private static final double METRES_PER_DEGREE = 111320.0;

    @DescribeResult(name="result", description="Output raster")
    public GridCoverage2D execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection obsFeatures, @DescribeParameter(name="radiusPixels", description="Radius of the density kernel in pixels") Integer argRadiusPixels, @DescribeParameter(name="weightAttr", description="Name of the attribute to use for data point weight", min=0, max=1) String valueAttr, @DescribeParameter(name="pixelsPerCell", description="Resolution at which to compute the heatmap (in pixels). Default = 1", defaultValue="1", min=0, max=1) Integer argPixelsPerCell, @DescribeParameter(name="outputBBOX", description="Bounding box of the output") ReferencedEnvelope argOutputEnv, @DescribeParameter(name="outputWidth", description="Width of output raster in pixels") Integer argOutputWidth, @DescribeParameter(name="outputHeight", description="Height of output raster in pixels") Integer argOutputHeight, ProgressListener monitor) throws ProcessException {
        int pixelsPerCell = 1;
        if (argPixelsPerCell != null && argPixelsPerCell > 1) {
            pixelsPerCell = argPixelsPerCell;
        }
        int outputWidth = argOutputWidth;
        int outputHeight = argOutputHeight;
        int gridWidth = outputWidth;
        int gridHeight = outputHeight;
        if (pixelsPerCell > 1) {
            gridWidth = outputWidth / pixelsPerCell;
            gridHeight = outputHeight / pixelsPerCell;
        }
        CoordinateReferenceSystem srcCRS = ((SimpleFeatureType)obsFeatures.getSchema()).getCoordinateReferenceSystem();
        CoordinateReferenceSystem dstCRS = argOutputEnv.getCoordinateReferenceSystem();
        MathTransform trans = null;
        try {
            trans = CRS.findMathTransform((CoordinateReferenceSystem)srcCRS, (CoordinateReferenceSystem)dstCRS);
        }
        catch (FactoryException e) {
            throw new ProcessException(e);
        }
        int radiusCells = 100;
        if (argRadiusPixels != null) {
            radiusCells = argRadiusPixels;
        }
        if (pixelsPerCell > 1) {
            radiusCells /= pixelsPerCell;
        }
        HeatmapSurface heatMap = new HeatmapSurface(radiusCells, argOutputEnv, gridWidth, gridHeight);
        try {
            this.extractPoints(obsFeatures, valueAttr, trans, heatMap);
        }
        catch (CQLException e) {
            throw new ProcessException(e);
        }
        float[][] heatMapGrid = heatMap.computeSurface();
        float[][] outGrid = heatMapGrid = this.flipXY(heatMapGrid);
        if (pixelsPerCell > 1) {
            outGrid = this.upsample(heatMapGrid, -999.0f, outputWidth, outputHeight);
        }
        GridCoverageFactory gcf = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
        GridCoverage2D gridCov = gcf.create((CharSequence)"Process Results", outGrid, (Envelope)argOutputEnv);
        return gridCov;
    }

    private static double distanceConversionFactor(CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem dstCRS) {
        Unit dstUnit;
        Unit srcUnit = srcCRS.getCoordinateSystem().getAxis(0).getUnit();
        if (srcUnit == (dstUnit = dstCRS.getCoordinateSystem().getAxis(0).getUnit())) {
            return 1.0;
        }
        if (srcUnit == NonSI.DEGREE_ANGLE && dstUnit == SI.METER) {
            return 111320.0;
        }
        if (srcUnit == SI.METER && dstUnit == NonSI.DEGREE_ANGLE) {
            return 8.98311174991017E-6;
        }
        throw new IllegalStateException("Unable to convert distances from " + srcUnit + " to " + dstUnit);
    }

    private float[][] flipXY(float[][] grid) {
        int xsize = grid.length;
        int ysize = grid[0].length;
        float[][] grid2 = new float[ysize][xsize];
        for (int ix = 0; ix < xsize; ++ix) {
            for (int iy = 0; iy < ysize; ++iy) {
                int iy2 = ysize - iy - 1;
                grid2[iy2][ix] = grid[ix][iy];
            }
        }
        return grid2;
    }

    private float[][] upsample(float[][] grid, float noDataValue, int width, int height) {
        BilinearInterpolator bi = new BilinearInterpolator(grid, noDataValue);
        float[][] outGrid = bi.interpolate(width, height, false);
        return outGrid;
    }

    public Query invertQuery(@DescribeParameter(name="radiusPixels", description="Radius to use for the kernel", min=0, max=1) Integer argRadiusPixels, @DescribeParameter(name="outputBBOX", description="Georeferenced bounding box of the output") ReferencedEnvelope argOutputEnv, @DescribeParameter(name="outputWidth", description="Width of the output raster") Integer argOutputWidth, @DescribeParameter(name="outputHeight", description="Height of the output raster") Integer argOutputHeight, Query targetQuery, GridGeometry targetGridGeometry) throws ProcessException {
        int radiusPixels = argRadiusPixels > 0 ? argRadiusPixels : 0;
        double queryBuffer = (double)radiusPixels / this.pixelSize(argOutputEnv, argOutputWidth, argOutputHeight);
        targetQuery.setFilter(this.expandBBox(targetQuery.getFilter(), queryBuffer));
        targetQuery.setProperties(null);
        Hints hints = targetQuery.getHints();
        hints.put((Object)Hints.GEOMETRY_DISTANCE, (Object)0.0);
        return targetQuery;
    }

    private double pixelSize(ReferencedEnvelope outputEnv, int outputWidth, int outputHeight) {
        if (outputEnv.getWidth() <= 0.0) {
            return 0.0;
        }
        return (double)outputWidth / outputEnv.getWidth();
    }

    protected Filter expandBBox(Filter filter, double distance) {
        return (Filter)filter.accept((FilterVisitor)new BBOXExpandingFilterVisitor(distance, distance, distance, distance), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractPoints(SimpleFeatureCollection obsPoints, String attrName, MathTransform trans, HeatmapSurface heatMap) throws CQLException {
        block9: {
            Expression attrExpr = null;
            if (attrName != null) {
                attrExpr = ECQL.toExpression((String)attrName);
            }
            SimpleFeatureIterator obsIt = obsPoints.features();
            double[] srcPt = new double[2];
            double[] dstPt = new double[2];
            boolean i = false;
            block5: while (true) {
                while (obsIt.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)obsIt.next();
                    try {
                        double val = 1.0;
                        if (attrExpr != null) {
                            val = HeatmapProcess.getPointValue(feature, attrExpr);
                        }
                        Geometry geom = (Geometry)feature.getDefaultGeometry();
                        Coordinate p = HeatmapProcess.getPoint(geom);
                        srcPt[0] = p.x;
                        srcPt[1] = p.y;
                        trans.transform(srcPt, 0, dstPt, 0, 1);
                        Coordinate pobs = new Coordinate(dstPt[0], dstPt[1], val);
                        heatMap.addPoint(pobs.x, pobs.y, val);
                        continue block5;
                    }
                    catch (Exception exception) {
                    }
                }
                break block9;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                obsIt.close();
            }
        }
    }

    private static Coordinate getPoint(Geometry g) {
        if (g.getNumPoints() == 1) {
            return g.getCoordinate();
        }
        return g.getCentroid().getCoordinate();
    }

    private static double getPointValue(SimpleFeature feature, Expression attrExpr) {
        Double valObj = (Double)attrExpr.evaluate((Object)feature, Double.class);
        if (valObj != null) {
            return valObj;
        }
        return 1.0;
    }
}

