/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.filters;

import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import org.locationtech.geomesa.curve.Z2SFC;
import org.locationtech.geomesa.index.filters.Z2Filter;
import org.locationtech.geomesa.index.filters.Z2Filter$;
import org.locationtech.geomesa.index.filters.Z3Filter$;
import org.locationtech.geomesa.index.index.z2.Z2IndexValues;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Z2Filter$
implements Serializable {
    public static final Z2Filter$ MODULE$;
    private final String org$locationtech$geomesa$index$filters$Z2Filter$$RangeSeparator;
    private final String TermSeparator;

    static {
        new Z2Filter$();
    }

    public String org$locationtech$geomesa$index$filters$Z2Filter$$RangeSeparator() {
        return this.org$locationtech$geomesa$index$filters$Z2Filter$$RangeSeparator;
    }

    private String TermSeparator() {
        return this.TermSeparator;
    }

    public Z2Filter apply(Z2IndexValues values) {
        Z2SFC sfc = values.sfc();
        int[][] xy = (int[][])((TraversableOnce)values.bounds().map((Function1)new Serializable(sfc){
            public static final long serialVersionUID = 0L;
            private final Z2SFC sfc$1;

            public final int[] apply(Tuple4<Object, Object, Object, Object> x0$1) {
                Tuple4<Object, Object, Object, Object> tuple4 = x0$1;
                if (tuple4 != null) {
                    double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                    double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                    int[] nArray = new int[]{this.sfc$1.lon().normalize(xmin), this.sfc$1.lat().normalize(ymin), this.sfc$1.lon().normalize(xmax), this.sfc$1.lat().normalize(ymax)};
                    return nArray;
                }
                throw new MatchError(tuple4);
            }
            {
                this.sfc$1 = sfc$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        return new Z2Filter(xy);
    }

    public byte[] serializeToBytes(Z2Filter filter2) {
        int xyLength = 4 + filter2.xy().length * 16;
        ByteBuffer buffer = ByteBuffer.allocate(xyLength);
        buffer.putInt(filter2.xy().length);
        Predef$.MODULE$.refArrayOps((Object[])filter2.xy()).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            public final ByteBuffer buffer$1;

            public final void apply(int[] bounds) {
                Predef$.MODULE$.intArrayOps(bounds).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.serializeToBytes.1 $outer;

                    public final ByteBuffer apply(int x$1) {
                        return this.$outer.buffer$1.putInt(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
        return buffer.array();
    }

    public Z2Filter deserializeFromBytes(byte[] serialized) {
        ByteBuffer buffer = ByteBuffer.wrap(serialized);
        int[][] xy = (int[][])Array$.MODULE$.fill(buffer.getInt(), (Function0)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            public final ByteBuffer buffer$2;

            public final int[] apply() {
                return (int[])Array$.MODULE$.fill(4, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.$outer.buffer$2.getInt();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Int());
            }
            {
                this.buffer$2 = buffer$2;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        return new Z2Filter(xy);
    }

    public scala.collection.immutable.Map<String, String> serializeToStrings(Z2Filter filter2) {
        String xy = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filter2.xy()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int[] bounds) {
                return Predef$.MODULE$.intArrayOps(bounds).mkString(Z2Filter$.MODULE$.org$locationtech$geomesa$index$filters$Z2Filter$$RangeSeparator());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(this.TermSeparator());
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Z3Filter$.MODULE$.XYKey()), (Object)xy)}));
    }

    public Z2Filter deserializeFromStrings(Map<String, String> serialized) {
        int[][] xy = (int[][])Predef$.MODULE$.refArrayOps((Object[])((String)serialized.apply((Object)Z3Filter$.MODULE$.XYKey())).split(this.TermSeparator())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int[] apply(String x$2) {
                return (int[])Predef$.MODULE$.refArrayOps((Object[])x$2.split(Z2Filter$.MODULE$.org$locationtech$geomesa$index$filters$Z2Filter$$RangeSeparator())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$3) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        return new Z2Filter(xy);
    }

    public long org$locationtech$geomesa$index$filters$Z2Filter$$rowToZ(byte[] b, int i) {
        return Longs.fromBytes((byte)b[i], (byte)b[i + 1], (byte)b[i + 2], (byte)b[i + 3], (byte)b[i + 4], (byte)b[i + 5], (byte)b[i + 6], (byte)b[i + 7]);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Z2Filter$() {
        MODULE$ = this;
        this.org$locationtech$geomesa$index$filters$Z2Filter$$RangeSeparator = ":";
        this.TermSeparator = ";";
    }
}

