/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geoserver;

import com.google.common.collect.ImmutableBiMap;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryHints$Internal$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.planning.QueryPlanner$CostEvaluation$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class ViewParams$
implements LazyLogging {
    public static final ViewParams$ MODULE$;
    private final ImmutableBiMap<String, Hints.Key> org$locationtech$geomesa$index$geoserver$ViewParams$$hints;
    private final scala.collection.immutable.Map<Hints.Key, String> org$locationtech$geomesa$index$geoserver$ViewParams$$internalHints;
    private final Regex org$locationtech$geomesa$index$geoserver$ViewParams$$envelope;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ViewParams$();
    }

    private Logger logger$lzycompute() {
        ViewParams$ viewParams$ = this;
        synchronized (viewParams$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public ImmutableBiMap<String, Hints.Key> org$locationtech$geomesa$index$geoserver$ViewParams$$hints() {
        return this.org$locationtech$geomesa$index$geoserver$ViewParams$$hints;
    }

    public scala.collection.immutable.Map<Hints.Key, String> org$locationtech$geomesa$index$geoserver$ViewParams$$internalHints() {
        return this.org$locationtech$geomesa$index$geoserver$ViewParams$$internalHints;
    }

    public Regex org$locationtech$geomesa$index$geoserver$ViewParams$$envelope() {
        return this.org$locationtech$geomesa$index$geoserver$ViewParams$$envelope;
    }

    public void setHints(Query query) {
        Map viewParams = (Map)query.getHints().get((Object)Hints.VIRTUAL_TABLE_PARAMETERS);
        scala.collection.immutable.Map params = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)viewParams).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, String> apply(Map<String, String> x$1) {
                return JavaConversions$.MODULE$.mapAsScalaMap(x$1).toMap(Predef$.MODULE$.$conforms());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Nothing$> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        });
        params.foreach((Function1)new Serializable(query){
            public static final long serialVersionUID = 0L;
            public final Query query$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                String original = (String)tuple2._1();
                String value = (String)tuple2._2();
                String string = original;
                String string2 = "STRATEGY";
                String key = !(string != null ? !string.equals(string2) : string2 != null) ? "QUERY_INDEX" : original;
                Hints.Key key2 = (Hints.Key)ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$hints().get((Object)key);
                if (key2 == null) {
                    BoxedUnit boxedUnit;
                    if (ViewParams$.MODULE$.logger().underlying().isDebugEnabled()) {
                        ViewParams$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring view param ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    BoxedUnit boxedUnit;
                    try {
                        Class clazz;
                        Serializable setHint = new Serializable(this, key, key2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.setHints.1 $outer;
                            private final String key$1;
                            private final Hints.Key x1$1;

                            public final void apply(Object value) {
                                ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$setQueryHint(this.$outer.query$1, this.key$1, this.x1$1, value);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.key$1 = key$1;
                                this.x1$1 = x1$1;
                            }
                        };
                        Class clazz2 = clazz = key2.getValueClass();
                        Class<String> clazz3 = String.class;
                        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                            BoxedUnit boxedUnit3 = (BoxedUnit)setHint.apply((Object)value);
                        } else {
                            Class clazz4 = clazz;
                            Class<Boolean> clazz5 = Boolean.class;
                            if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                                ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toBoolean(key, value).foreach((Function1)new Serializable(this, (Function1)setHint){
                                    public static final long serialVersionUID = 0L;
                                    private final Function1 setHint$1;

                                    public final void apply(Object v1) {
                                        this.setHint$1.apply(v1);
                                    }
                                    {
                                        this.setHint$1 = setHint$1;
                                    }
                                });
                                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                            } else {
                                Class clazz6 = clazz;
                                Class<Integer> clazz7 = Integer.class;
                                if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                                    ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toInt(key, value).foreach((Function1)new Serializable(this, (Function1)setHint){
                                        public static final long serialVersionUID = 0L;
                                        private final Function1 setHint$1;

                                        public final void apply(Object v1) {
                                            this.setHint$1.apply(v1);
                                        }
                                        {
                                            this.setHint$1 = setHint$1;
                                        }
                                    });
                                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                                } else {
                                    Class clazz8 = clazz;
                                    Class<Float> clazz9 = Float.class;
                                    if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                                        ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toFloat(key, value).foreach((Function1)new Serializable(this, (Function1)setHint){
                                            public static final long serialVersionUID = 0L;
                                            private final Function1 setHint$1;

                                            public final void apply(Object v1) {
                                                this.setHint$1.apply(v1);
                                            }
                                            {
                                                this.setHint$1 = setHint$1;
                                            }
                                        });
                                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                                    } else {
                                        Class clazz10 = clazz;
                                        Class<ReferencedEnvelope> clazz11 = ReferencedEnvelope.class;
                                        if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                                            ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toEnvelope(key, value).foreach((Function1)new Serializable(this, (Function1)setHint){
                                                public static final long serialVersionUID = 0L;
                                                private final Function1 setHint$1;

                                                public final void apply(Object v1) {
                                                    this.setHint$1.apply(v1);
                                                }
                                                {
                                                    this.setHint$1 = setHint$1;
                                                }
                                            });
                                            BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                                        } else {
                                            Class clazz12 = clazz;
                                            Class<Enumeration.Value> clazz13 = Enumeration.Value.class;
                                            if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
                                                ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$toCost(value).foreach((Function1)new Serializable(this, (Function1)setHint){
                                                    public static final long serialVersionUID = 0L;
                                                    private final Function1 setHint$1;

                                                    public final void apply(Object v1) {
                                                        this.setHint$1.apply(v1);
                                                    }
                                                    {
                                                        this.setHint$1 = setHint$1;
                                                    }
                                                });
                                                BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                                            } else {
                                                BoxedUnit boxedUnit9;
                                                if (ViewParams$.MODULE$.logger().underlying().isWarnEnabled()) {
                                                    ViewParams$.MODULE$.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled hint type for '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
                                                    boxedUnit9 = BoxedUnit.UNIT;
                                                } else {
                                                    boxedUnit9 = BoxedUnit.UNIT;
                                                }
                                                BoxedUnit boxedUnit10 = boxedUnit9;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        BoxedUnit boxedUnit11;
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = (Throwable)option.get();
                        if (ViewParams$.MODULE$.logger().underlying().isWarnEnabled()) {
                            ViewParams$.MODULE$.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error invoking query hint for ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})), e);
                            boxedUnit11 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit11 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit12 = boxedUnit11;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit13 = boxedUnit;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.query$1 = query$1;
            }
        });
    }

    public String getReadableHints(Query query) {
        Builder readable = Seq$.MODULE$.newBuilder();
        readable.sizeHint(query.getHints().size());
        JavaConversions$.MODULE$.mapAsScalaMap((Map)query.getHints()).foreach((Function1)new Serializable(readable){
            public static final long serialVersionUID = 0L;
            private final Builder readable$1;

            public final Builder<String, Seq<String>> apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    if (k instanceof Hints.Key) {
                        String string;
                        Hints.Key key = (Hints.Key)k;
                        String key2 = ViewParams$.MODULE$.hintToString(key);
                        Object object = v;
                        if (object == null) {
                            string = "null";
                        } else if (object instanceof SimpleFeatureType) {
                            SimpleFeatureType simpleFeatureType = (SimpleFeatureType)object;
                            string = SimpleFeatureTypes$.MODULE$.encodeType(simpleFeatureType, SimpleFeatureTypes$.MODULE$.encodeType$default$2());
                        } else {
                            string = object.toString();
                        }
                        String value = string;
                        Builder builder = this.readable$1.$plus$eq((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key2, value})));
                        return builder;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.readable$1 = readable$1;
            }
        });
        return ((TraversableOnce)((SeqLike)readable.result()).sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ");
    }

    public String hintToString(Hints.Key hint) {
        return (String)Option$.MODULE$.apply(this.org$locationtech$geomesa$index$geoserver$ViewParams$$hints().inverse().get((Object)hint)).orElse((Function0)new Serializable(hint){
            public static final long serialVersionUID = 0L;
            private final Hints.Key hint$1;

            public final Option<String> apply() {
                return ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$internalHints().get((Object)this.hint$1);
            }
            {
                this.hint$1 = hint$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unknown_hint";
            }
        });
    }

    public void org$locationtech$geomesa$index$geoserver$ViewParams$$setQueryHint(Query query, String name, Hints.Key hint, Object value) {
        Object old = query.getHints().get((Object)hint);
        if (old == null) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using query hint from geoserver view params: ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, value})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            query.getHints().put((Object)hint, value);
        } else if (!BoxesRunTime.equals((Object)old, (Object)value)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)"Ignoring query hint from geoserver in favor of hint directly set in query. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", "=", " and disregarding ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, old, value}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Option<Enumeration.Value> org$locationtech$geomesa$index$geoserver$ViewParams$$toCost(String name) {
        void var3_3;
        BoxedUnit boxedUnit;
        String check = name.toLowerCase(Locale.US);
        Option value = QueryPlanner$CostEvaluation$.MODULE$.values().find((Function1)new Serializable(check){
            public static final long serialVersionUID = 0L;
            private final String check$1;

            public final boolean apply(Enumeration.Value x$2) {
                String string = x$2.toString().toLowerCase(Locale.US);
                String string2 = this.check$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.check$1 = check$1;
            }
        });
        if (value.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring invalid cost type from view params: ", ". Valid values "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{QueryPlanner$CostEvaluation$.MODULE$.values().mkString(", ")}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Option<ReferencedEnvelope> org$locationtech$geomesa$index$geoserver$ViewParams$$toEnvelope(String name, String geom) {
        void var3_3;
        BoxedUnit boxedUnit;
        Option value = this.fromBbox$1(geom).orElse((Function0)new Serializable(geom){
            public static final long serialVersionUID = 0L;
            private final String geom$1;

            public final Try<ReferencedEnvelope> apply() {
                return ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$fromWkt$1(this.geom$1);
            }
            {
                this.geom$1 = geom$1;
            }
        }).toOption();
        if (value.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring invalid envelope from view params: ", "=", ". Envelope should be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, geom}))).append((Object)"WKT or in the form [-180.0,-90.0,180.0,90.0]").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public Option<Object> org$locationtech$geomesa$index$geoserver$ViewParams$$toInt(String name, String string) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(string)).toInt()));
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring invalid int type from view params: ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, string})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public Option<Object> org$locationtech$geomesa$index$geoserver$ViewParams$$toFloat(String name, String string) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(string)).toFloat()));
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring invalid float type from view params: ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, string})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public Option<Object> org$locationtech$geomesa$index$geoserver$ViewParams$$toBoolean(String name, String bool) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(bool)).toBoolean()));
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring invalid int type from view params: ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, bool})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private final Try fromBbox$1(String geom$1) {
        return Try$.MODULE$.apply((Function0)new Serializable(geom$1){
            public static final long serialVersionUID = 0L;
            private final String geom$1;

            public final ReferencedEnvelope apply() {
                String string = this.geom$1;
                Option option = ViewParams$.MODULE$.org$locationtech$geomesa$index$geoserver$ViewParams$$envelope().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(8) == 0) {
                    Tuple4 tuple4;
                    String xmin = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String ymin = (String)((LinearSeqOptimized)option.get()).apply(2);
                    String xmax = (String)((LinearSeqOptimized)option.get()).apply(4);
                    String ymax = (String)((LinearSeqOptimized)option.get()).apply(6);
                    Tuple4 tuple42 = tuple4 = new Tuple4((Object)xmin, (Object)ymin, (Object)xmax, (Object)ymax);
                    String xmin2 = (String)tuple42._1();
                    String ymin2 = (String)tuple42._2();
                    String xmax2 = (String)tuple42._3();
                    String ymax2 = (String)tuple42._4();
                    return new ReferencedEnvelope(new StringOps(Predef$.MODULE$.augmentString(xmin2)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(xmax2)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(ymin2)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(ymax2)).toDouble(), package$.MODULE$.CRS_EPSG_4326());
                }
                throw new MatchError((Object)string);
            }
            {
                this.geom$1 = geom$1;
            }
        });
    }

    public final Try org$locationtech$geomesa$index$geoserver$ViewParams$$fromWkt$1(String geom$1) {
        return Try$.MODULE$.apply((Function0)new Serializable(geom$1){
            public static final long serialVersionUID = 0L;
            private final String geom$1;

            public final ReferencedEnvelope apply() {
                return new ReferencedEnvelope(WKTUtils$.MODULE$.read(this.geom$1).getEnvelopeInternal(), package$.MODULE$.CRS_EPSG_4326());
            }
            {
                this.geom$1 = geom$1;
            }
        });
    }

    private ViewParams$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        Method[] methods = (Method[])Predef$.MODULE$.refArrayOps((Object[])QueryHints$.MODULE$.getClass().getDeclaredMethods()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method m) {
                return m.getParameterCount() == 0 && Hints.Key.class.isAssignableFrom(m.getReturnType());
            }
        });
        ImmutableBiMap.Builder map = ImmutableBiMap.builder();
        Predef$.MODULE$.refArrayOps((Object[])methods).foreach((Function1)new Serializable(map){
            public static final long serialVersionUID = 0L;
            private final ImmutableBiMap.Builder map$1;

            public final ImmutableBiMap.Builder<String, Hints.Key> apply(Method m) {
                return this.map$1.put((Object)m.getName().toUpperCase(), (Object)((Hints.Key)m.invoke((Object)QueryHints$.MODULE$, new Object[0])));
            }
            {
                this.map$1 = map$1;
            }
        });
        this.org$locationtech$geomesa$index$geoserver$ViewParams$$hints = map.build();
        Method[] methods2 = (Method[])Predef$.MODULE$.refArrayOps((Object[])QueryHints$Internal$.MODULE$.getClass().getDeclaredMethods()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Method m) {
                return m.getParameterCount() == 0 && Hints.Key.class.isAssignableFrom(m.getReturnType());
            }
        });
        Builder map2 = Predef$.MODULE$.Map().newBuilder();
        map2.sizeHint(methods2.length);
        Predef$.MODULE$.refArrayOps((Object[])methods2).foreach((Function1)new Serializable(map2){
            public static final long serialVersionUID = 0L;
            private final Builder map$2;

            public final Builder<Tuple2<Hints.Key, String>, scala.collection.immutable.Map<Hints.Key, String>> apply(Method m) {
                return this.map$2.$plus$eq((Object)new Tuple2((Object)((Hints.Key)m.invoke((Object)QueryHints$Internal$.MODULE$, new Object[0])), (Object)m.getName().toUpperCase()));
            }
            {
                this.map$2 = map$2;
            }
        });
        this.org$locationtech$geomesa$index$geoserver$ViewParams$$internalHints = (scala.collection.immutable.Map)map2.result();
        this.org$locationtech$geomesa$index$geoserver$ViewParams$$envelope = new StringOps(Predef$.MODULE$.augmentString("\\[\\s*(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?),\\s*(-?\\d+(\\.\\d+)?)\\s*]")).r();
    }
}

