/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.GeoMesaIndexManager;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.WrappedFeature;
import org.locationtech.geomesa.index.geotools.CachingFeatureSource;
import org.locationtech.geomesa.index.geotools.CachingFeatureSource$class;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureWriter;
import org.locationtech.geomesa.index.geotools.MetadataBackedDataStore;
import org.locationtech.geomesa.index.index.attribute.AttributeIndex$;
import org.locationtech.geomesa.index.planning.QueryPlanner;
import org.locationtech.geomesa.index.stats.HasGeoMesaStats;
import org.locationtech.geomesa.index.utils.ExplainLogging;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.utils.audit.AuditProvider;
import org.locationtech.geomesa.utils.audit.AuditWriter;
import org.locationtech.geomesa.utils.conf.GeoMesaProperties$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.conf.SemanticVersion$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.CloseWithLogging$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\rbAB\u0001\u0003\u0003\u0003iaG\u0001\tHK>lUm]1ECR\f7\u000b^8sK*\u00111\u0001B\u0001\tO\u0016|Go\\8mg*\u0011QAB\u0001\u0006S:$W\r\u001f\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001!\u0006\u0003\u000fq\tc5c\u0001\u0001\u0010'A\u0011\u0001#E\u0007\u0002\u0005%\u0011!C\u0001\u0002\u0018\u001b\u0016$\u0018\rZ1uC\n\u000b7m[3e\t\u0006$\u0018m\u0015;pe\u0016\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000bM$\u0018\r^:\n\u0005a)\"a\u0004%bg\u001e+w.T3tCN#\u0018\r^:\t\u0011i\u0001!Q1A\u0005\u0002m\taaY8oM&<W#\u0001\u000f\u0011\u0005uicB\u0001\u0010,\u001d\ty\"F\u0004\u0002!S9\u0011\u0011\u0005\u000b\b\u0003E\u001dr!a\t\u0014\u000e\u0003\u0011R!!\n\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003Y\t\tqcR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3GC\u000e$xN]=\n\u00059z#AF$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f\u0007>tg-[4\u000b\u00051\u0012\u0001\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000f\r|gNZ5hA!)1\u0007\u0001C\u0001i\u00051A(\u001b8jiz\"\"!\u000e*\u0011\u000bA\u0001a'Q&\u0011\u0005]BD\u0002\u0001\u0003\u0006s\u0001\u0011\rA\u000f\u0002\u0003\tN\u000b\"aO\u001b\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\u000f9{G\u000f[5oOB\u0011qG\u0011\u0003\u0006\u0007\u0002\u0011\r\u0001\u0012\u0002\u0002\rF\u00111(\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0012\t1!\u00199j\u0013\tQuI\u0001\bXe\u0006\u0004\b/\u001a3GK\u0006$XO]3\u0011\u0005]bE!B'\u0001\u0005\u0004q%!A,\u0012\u0005mz\u0005C\u0001\u001fQ\u0013\t\tVHA\u0002B]fDQA\u0007\u001aA\u0002qA\u0001\u0002\u0016\u0001\t\u0006\u0004%\t!V\u0001\rcV,'/\u001f)mC:tWM]\u000b\u0002-B)qK\u0017\u001cB\u00176\t\u0001L\u0003\u0002Z\t\u0005A\u0001\u000f\\1o]&tw-\u0003\u0002\\1\na\u0011+^3ssBc\u0017M\u001c8fe\"AQ\f\u0001E\u0001B\u0003&a+A\u0007rk\u0016\u0014\u0018\u0010\u00157b]:,'\u000f\t\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0003Q\u0019X\u000f\u001d9sKN\u001ch+\u001a:tS>t7\t[3dWV\t\u0011\rE\u0002cO&l\u0011a\u0019\u0006\u0003I\u0016\fA\u0001\\1oO*\ta-\u0001\u0003kCZ\f\u0017B\u00015d\u0005-!\u0006N]3bI2{7-\u00197\u0011\u0005qR\u0017BA6>\u0005\u001d\u0011un\u001c7fC:Da!\u001c\u0001!\u0002\u0013\t\u0017!F:vaB\u0014Xm]:WKJ\u001c\u0018n\u001c8DQ\u0016\u001c7\u000e\t\u0005\u0006_\u00021\t\u0001]\u0001\b[\u0006t\u0017mZ3s+\u0005\t\b#\u0002$sm\u0005[\u0015BA:H\u0005M9Um\\'fg\u0006Le\u000eZ3y\u001b\u0006t\u0017mZ3s\u0011\u0015)\bA\"\u0005w\u0003e\u0019'/Z1uK\u001a+\u0017\r^;sK^\u0013\u0018\u000e^3s\u0003B\u0004XM\u001c3\u0015\t]t\u0018Q\u0003\t\u0003qnt!AH=\n\u0005i\u0014\u0011\u0001F$f_6+7/\u0019$fCR,(/Z,sSR,'/\u0003\u0002}{\n1b\t\\;tQ\u0006\u0014G.\u001a$fCR,(/Z,sSR,'O\u0003\u0002{\u0005!1q\u0010\u001ea\u0001\u0003\u0003\t1a\u001d4u!\u0011\t\u0019!!\u0005\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\taa]5na2,'\u0002BA\u0006\u0003\u001b\tqAZ3biV\u0014XMC\u0002\u0002\u0010)\tqa\u001c9f]\u001eL7/\u0003\u0003\u0002\u0014\u0005\u0015!!E*j[BdWMR3biV\u0014X\rV=qK\"9\u0011q\u0003;A\u0002\u0005e\u0011aB5oI&\u001cWm\u001d\t\u0006y\u0005m\u0011qD\u0005\u0004\u0003;i$AB(qi&|g\u000e\u0005\u0004\u0002\"\u0005-\u0012\u0011\u0007\b\u0005\u0003G\t9CD\u0002$\u0003KI\u0011AP\u0005\u0004\u0003Si\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003[\tyCA\u0002TKFT1!!\u000b>!\u00191\u00151\u0007\u001cB\u0017&\u0019\u0011QG$\u0003'\u001d+w.T3tC\u001a+\u0017\r^;sK&sG-\u001a=\t\u000f\u0005e\u0002A\"\u0005\u0002<\u0005I2M]3bi\u00164U-\u0019;ve\u0016<&/\u001b;fe6{G-\u001b4z)\u001d9\u0018QHA \u0003\u0003Bqa`A\u001c\u0001\u0004\t\t\u0001\u0003\u0005\u0002\u0018\u0005]\u0002\u0019AA\r\u0011!\t\u0019%a\u000eA\u0002\u0005\u0015\u0013A\u00024jYR,'\u000f\u0005\u0003\u0002H\u0005-SBAA%\u0015\u0011\t\u0019%!\u0004\n\t\u00055\u0013\u0011\n\u0002\u0007\r&dG/\u001a:\t\u000f\u0005E\u0003\u0001\"\u0015\u0002T\u000591-\u0019;bY><WCAA+!\u0011\t9&!\u0018\u000f\u0007q\nI&C\u0002\u0002\\u\na\u0001\u0015:fI\u00164\u0017\u0002BA0\u0003C\u0012aa\u0015;sS:<'bAA.{!9\u0011Q\r\u0001\u0007\u0002\u0005\u001d\u0014A\u00023fY\u0016$X\r\u0006\u0002\u0002jA\u0019A(a\u001b\n\u0007\u00055TH\u0001\u0003V]&$\bbBA9\u0001\u0011\u0005\u00111O\u0001\u0011O\u0016$\u0018\t\u001c7UC\ndWMT1nKN$B!!\u001e\u0002xA1\u0011\u0011EA\u0016\u0003+B\u0001\"!\u001f\u0002p\u0001\u0007\u0011QK\u0001\tif\u0004XMT1nK\"9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0014!F4fi\u0006cG.\u00138eKb$\u0016M\u00197f\u001d\u0006lWm\u001d\u000b\u0005\u0003k\n\t\t\u0003\u0005\u0002z\u0005m\u0004\u0019AA+\u0011\u001d\t)\t\u0001C\t\u0003\u000f\u000b!c\u0019:fCR,\u0017+^3ssBc\u0017M\u001c8feR\ta\u000bC\u0004\u0002\f\u0002!\t\"!$\u0002/\r\u0014X-\u0019;f\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>tGCBAH\u0003+\u000b9\u000bE\u0002\u0011\u0003#K1!a%\u0003\u0005a9Um\\'fg\u00064U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0005\t\u0003/\u000bI\t1\u0001\u0002\u001a\u0006)\u0011/^3ssB!\u00111TAR\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001\u00023bi\u0006T!a\u0001\u0006\n\t\u0005\u0015\u0016Q\u0014\u0002\u0006#V,'/\u001f\u0005\t\u0003S\u000bI\t1\u0001\u0002,\u000611o\\;sG\u0016\u00042\u0001EAW\u0013\r\tyK\u0001\u0002\u0015\u000f\u0016|W*Z:b\r\u0016\fG/\u001e:f'>,(oY3\t\u000f\u0005M\u0006\u0001\"\u0005\u00026\u0006\u0011r-\u001a;Ji\u0016\u0014\u0018\r^8s-\u0016\u00148/[8o+\t\t9\f\u0005\u0004\u0002X\u0005e\u0016QK\u0005\u0005\u0003w\u000b\tGA\u0002TKRDq!a0\u0001\t#\t\t-\u0001\nhKR4VM]:j_:\u001c\u0005.Z2l\u0017\u0016LXCAAb!\ra\u0014QY\u0005\u0004\u0003\u000fl$AB!osJ+g\rC\u0004\u0002L\u0002!\t&!4\u0002\u001fA\u0014XmU2iK6\f7I]3bi\u0016$B!!\u001b\u0002P\"9q0!3A\u0002\u0005\u0005\u0001FBAe\u0003'\fy\u000eE\u0003=\u0003+\fI.C\u0002\u0002Xv\u0012a\u0001\u001e5s_^\u001c\b\u0003BA\u0011\u00037LA!!8\u00020\tA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8$\u0005\u0005e\u0007bBAr\u0001\u0011E\u0013Q]\u0001\u0010aJ,7k\u00195f[\u0006,\u0006\u000fZ1uKR1\u0011\u0011NAt\u0003SDqa`Aq\u0001\u0004\t\t\u0001\u0003\u0005\u0002l\u0006\u0005\b\u0019AA\u0001\u0003!\u0001(/\u001a<j_V\u001c\bFBAq\u0003'\fy\u000eC\u0004\u0002r\u0002!\t&a=\u0002\u001f=t7k\u00195f[\u0006\u001c%/Z1uK\u0012$B!!\u001b\u0002v\"9q0a<A\u0002\u0005\u0005\u0001bBA}\u0001\u0011E\u00131`\u0001\u0010_:\u001c6\r[3nCV\u0003H-\u0019;fIR1\u0011\u0011NA\u007f\u0003\u007fDqa`A|\u0001\u0004\t\t\u0001\u0003\u0005\u0002l\u0006]\b\u0019AA\u0001\u0011\u001d\u0011\u0019\u0001\u0001C)\u0005\u000b\tqb\u001c8TG\",W.\u0019#fY\u0016$X\r\u001a\u000b\u0005\u0003S\u00129\u0001C\u0004\u0000\u0005\u0003\u0001\r!!\u0001\t\u000f\t-\u0001\u0001\"\u0011\u0003\u000e\u0005a1M]3bi\u0016\u001c6\r[3nCR!\u0011\u0011\u000eB\b\u0011\u001dy(\u0011\u0002a\u0001\u0003\u0003AqAa\u0005\u0001\t\u0003\u0012)\"A\u0005hKR\u001c6\r[3nCR!\u0011\u0011\u0001B\f\u0011!\tIH!\u0005A\u0002\u0005U\u0003b\u0002B\u000e\u0001\u0011\u0005#QD\u0001\u0011O\u0016$h)Z1ukJ,7k\\;sG\u0016$BAa\b\u0003&A\u0019\u0001C!\t\n\u0007\t\r\"AA\nHK>lUm]1GK\u0006$XO]3Ti>\u0014X\r\u0003\u0005\u0002z\te\u0001\u0019AA+\u0011\u001d\u0011I\u0003\u0001C!\u0005W\t\u0001cZ3u\r\u0016\fG/\u001e:f%\u0016\fG-\u001a:\u0015\r\t5\"1\u0007B\u001b!\r\u0001\"qF\u0005\u0004\u0005c\u0011!\u0001F$f_6+7/\u0019$fCR,(/\u001a*fC\u0012,'\u000f\u0003\u0005\u0002\u0018\n\u001d\u0002\u0019AAM\u0011!\u00119Da\nA\u0002\te\u0012a\u0003;sC:\u001c\u0018m\u0019;j_:\u0004B!a'\u0003<%!!QHAO\u0005-!&/\u00198tC\u000e$\u0018n\u001c8\t\u000f\t\u0005\u0003\u0001\"\u0011\u0003D\u0005\u0001r-\u001a;GK\u0006$XO]3Xe&$XM\u001d\u000b\bo\n\u0015#q\tB%\u0011!\tIHa\u0010A\u0002\u0005U\u0003\u0002CA\"\u0005\u007f\u0001\r!!\u0012\t\u0011\t]\"q\ba\u0001\u0005sAqA!\u0014\u0001\t\u0003\u0012y%\u0001\fhKR4U-\u0019;ve\u0016<&/\u001b;fe\u0006\u0003\b/\u001a8e)\u00159(\u0011\u000bB*\u0011!\tIHa\u0013A\u0002\u0005U\u0003\u0002\u0003B\u001c\u0005\u0017\u0002\rA!\u000f\t\u000f\t]\u0003\u0001\"\u0001\u0003Z\u0005!r-\u001a;J]\u0012,\u0007p\u0016:ji\u0016\u0014\u0018\t\u001d9f]\u0012$Ra\u001eB.\u0005;B\u0001\"!\u001f\u0003V\u0001\u0007\u0011Q\u000b\u0005\t\u0003/\u0011)\u00061\u0001\u0002 !9!\u0011\r\u0001\u0005B\u0005\u001d\u0014a\u00023jgB|7/\u001a\u0005\b\u0005K\u0002A\u0011\u0001B4\u000319W\r^)vKJL\b\u000b\\1o)!\u0011IG!\u001d\u0003t\t]\u0004CBA\u0011\u0003W\u0011Y\u0007\u0005\u0004G\u0005[2\u0014iS\u0005\u0004\u0005_:%!C)vKJL\b\u000b\\1o\u0011!\t9Ja\u0019A\u0002\u0005e\u0005\"C\u0003\u0003dA\u0005\t\u0019\u0001B;!\u0015a\u00141DA\u0019\u0011)\u0011IHa\u0019\u0011\u0002\u0003\u0007!1P\u0001\nKb\u0004H.Y5oKJ\u0004BA! \u0003\u00046\u0011!q\u0010\u0006\u0004\u0005\u0003#\u0011!B;uS2\u001c\u0018\u0002\u0002BC\u0005\u007f\u0012\u0011\"\u0012=qY\u0006Lg.\u001a:\t\u000f\t%\u0005\u0001\"\u0001\u0003\f\u0006Qq-\u001a;WKJ\u001c\u0018n\u001c8\u0016\u0005\t5\u0005c\u0002\u001f\u0003\u0010\u0006U\u0013qW\u0005\u0004\u0005#k$A\u0002+va2,'\u0007C\u0004\u0003\u0016\u0002!I!a\u001a\u0002'\rDWmY6Qe>TWm\u0019;WKJ\u001c\u0018n\u001c8\t\u0013\te\u0005!%A\u0005\u0002\tm\u0015AF4fiF+XM]=QY\u0006tG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tu%\u0006\u0002B;\u0005?[#A!)\u0011\t\t\r&QV\u0007\u0003\u0005KSAAa*\u0003*\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005Wk\u0014AC1o]>$\u0018\r^5p]&!!q\u0016BS\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005g\u0003\u0011\u0013!C\u0001\u0005k\u000bacZ3u#V,'/\u001f)mC:$C-\u001a4bk2$HeM\u000b\u0003\u0005oSCAa\u001f\u0003 \u001e9!1\u0018\u0002\t\u0002\tu\u0016\u0001E$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f!\r\u0001\"q\u0018\u0004\u0007\u0003\tA\tA!1\u0014\t\t}\u00161\u0019\u0005\bg\t}F\u0011\u0001Bc)\t\u0011i\f\u0003\u0006\u0003J\n}&\u0019!C\u0005\u0005\u0017\fA\u0003\u001d:pU\u0016\u001cGOV3sg&|gn\u00115fG.\u001cXC\u0001Bg!!\u0011yM!:\u0003j\n=XB\u0001Bi\u0015\u0011\u0011\u0019N!6\u0002\u000b\r\f7\r[3\u000b\t\t]'\u0011\\\u0001\tG\u00064g-Z5oK*!!1\u001cBo\u0003!\u0011WM\\7b]\u0016\u001c(\u0002\u0002Bp\u0005C\faaZ5uQV\u0014'B\u0001Br\u0003\r\u0019w.\\\u0005\u0005\u0005O\u0014\tN\u0001\u0007M_\u0006$\u0017N\\4DC\u000eDW\rE\u0002c\u0005WL1A!<d\u0005\u0019y%M[3diB!!\u0011\u001fB\u0000\u001b\t\u0011\u0019P\u0003\u0003\u0003v\n]\u0018AB1u_6L7M\u0003\u0003\u0003z\nm\u0018AC2p]\u000e,(O]3oi*\u0019!Q`3\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007\u0003\u0011\u0019P\u0001\u0006Bi>l\u0017n\u0019'p]\u001eD\u0011b!\u0002\u0003@\u0002\u0006IA!4\u0002+A\u0014xN[3diZ+'o]5p]\u000eCWmY6tA!Q1\u0011\u0002B`\u0005\u0004%Iaa\u0003\u0002%U\u0004H-\u0019;f-\u0016\u00148/[8o\u0007\",7m[\u000b\u0003\u0007\u001b\u0011baa\u0004\u0003j\u000e]aaBB\t\u0007'\u00011Q\u0002\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\n\u0007+\u0011y\f)A\u0005\u0007\u001b\t1#\u001e9eCR,g+\u001a:tS>t7\t[3dW\u0002\u0002Ba!\u0007\u0004 5\u001111\u0004\u0006\u0005\u0007;\u0011Y0\u0001\u0005gk:\u001cG/[8o\u0013\u0011\u0019\tca\u0007\u0003#1{gnZ+oCJLx\n]3sCR|'\u000f")
public abstract class GeoMesaDataStore<DS extends GeoMesaDataStore<DS, F, W>, F extends WrappedFeature, W>
extends MetadataBackedDataStore
implements HasGeoMesaStats {
    private final GeoMesaDataStoreFactory.GeoMesaDataStoreConfig config;
    private QueryPlanner<DS, F, W> queryPlanner;
    private final ThreadLocal<Object> suppressVersionCheck;
    private volatile boolean bitmap$0;

    private QueryPlanner queryPlanner$lzycompute() {
        GeoMesaDataStore geoMesaDataStore = this;
        synchronized (geoMesaDataStore) {
            if (!this.bitmap$0) {
                this.queryPlanner = this.createQueryPlanner();
                this.bitmap$0 = true;
            }
            return this.queryPlanner;
        }
    }

    public GeoMesaDataStoreFactory.GeoMesaDataStoreConfig config() {
        return this.config;
    }

    public QueryPlanner<DS, F, W> queryPlanner() {
        return this.bitmap$0 ? this.queryPlanner : this.queryPlanner$lzycompute();
    }

    private ThreadLocal<Object> suppressVersionCheck() {
        return this.suppressVersionCheck;
    }

    public abstract GeoMesaIndexManager<DS, F, W> manager();

    public abstract GeoMesaFeatureWriter.FlushableFeatureWriter createFeatureWriterAppend(SimpleFeatureType var1, Option<Seq<GeoMesaFeatureIndex<DS, F, W>>> var2);

    public abstract GeoMesaFeatureWriter.FlushableFeatureWriter createFeatureWriterModify(SimpleFeatureType var1, Option<Seq<GeoMesaFeatureIndex<DS, F, W>>> var2, Filter var3);

    @Override
    public String catalog() {
        return this.config().catalog();
    }

    public abstract void delete();

    public Seq<String> getAllTableNames(String typeName) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.config().catalog()}))).$plus$plus(this.getAllIndexTableNames(typeName), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> getAllIndexTableNames(String typeName) {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.getSchema(typeName))).toSeq().flatMap((Function1)new Serializable(this, typeName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;
            public final String typeName$1;

            public final Seq<String> apply(SimpleFeatureType x$1) {
                GeoMesaIndexManager<DS, F, W> qual$1 = this.$outer.manager();
                SimpleFeatureType x$13 = x$1;
                Option<String> x$14 = qual$1.indices$default$2();
                IndexMode.IndexMode x$15 = qual$1.indices$default$3();
                return (Seq)qual$1.indices(x$13, x$14, x$15).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getAllIndexTableNames$1 $outer;

                    public final String apply(GeoMesaFeatureIndex<DS, F, W> x$2) {
                        return x$2.getTableName(this.$outer.typeName$1, this.$outer.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$anonfun$$$outer());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ GeoMesaDataStore org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$1 = typeName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public QueryPlanner<DS, F, W> createQueryPlanner() {
        return new QueryPlanner(this);
    }

    public GeoMesaFeatureCollection createFeatureCollection(Query query, GeoMesaFeatureSource source) {
        return new GeoMesaFeatureCollection(source, query);
    }

    public Set<String> getIteratorVersion() {
        return Predef$.MODULE$.Set().empty();
    }

    public Object getVersionCheckKey() {
        return this.catalog();
    }

    @Override
    public void preSchemaCreate(SimpleFeatureType sft) throws IllegalArgumentException {
        this.manager().setIndices(sft);
    }

    @Override
    public void preSchemaUpdate(SimpleFeatureType sft, SimpleFeatureType previous) throws IllegalArgumentException {
        if (!((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(previous.getAttributeDescriptors()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor x$3) {
                return RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isIndexed$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(x$3));
            }
        }) && ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AttributeDescriptor x$4) {
                return RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isIndexed$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(x$4));
            }
        }) && RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<String, Object, IndexMode.IndexMode> x$5) {
                Object object = x$5._1();
                String string = AttributeIndex$.MODULE$.Name();
                return object != null ? !object.equals(string) : string != null;
            }
        })) {
            Option attr = this.manager().CurrentIndices().find((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(GeoMesaFeatureIndex<DS, F, W> x$6) {
                    String string = x$6.name();
                    String string2 = AttributeIndex$.MODULE$.Name();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            });
            RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft), (Seq)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(attr.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple3<String, Object, IndexMode.IndexMode> apply(GeoMesaFeatureIndex<DS, F, W> i) {
                    return new Tuple3((Object)i.name(), (Object)BoxesRunTime.boxToInteger((int)i.version()), (Object)IndexMode$.MODULE$.ReadWrite());
                }
            })), Seq$.MODULE$.canBuildFrom()));
        }
        Seq previousIndices = (Seq)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(previous)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple3<String, Object, IndexMode.IndexMode> x0$1) {
                Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$1;
                if (tuple3 != null) {
                    String name = (String)tuple3._1();
                    int version = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    Tuple2 tuple2 = new Tuple2((Object)name, (Object)BoxesRunTime.boxToInteger((int)version));
                    return tuple2;
                }
                throw new MatchError(tuple3);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq newIndices = (Seq)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).filterNot((Function1)new Serializable(this, previousIndices){
            public static final long serialVersionUID = 0L;
            private final Seq previousIndices$1;

            public final boolean apply(Tuple3<String, Object, IndexMode.IndexMode> x0$2) {
                Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$2;
                if (tuple3 != null) {
                    String name = (String)tuple3._1();
                    int version = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    boolean bl = this.previousIndices$1.contains((Object)new Tuple2((Object)name, (Object)BoxesRunTime.boxToInteger((int)version)));
                    return bl;
                }
                throw new MatchError(tuple3);
            }
            {
                this.previousIndices$1 = previousIndices$1;
            }
        });
        Seq validatedIndices = (Seq)newIndices.map((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;
            private final SimpleFeatureType sft$1;

            public final GeoMesaFeatureIndex<DS, F, W> apply(Tuple3<String, Object, IndexMode.IndexMode> x0$3) {
                Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$3;
                if (tuple3 != null) {
                    String name = (String)tuple3._1();
                    int version = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    boolean bl = false;
                    Some some = null;
                    Option option = this.$outer.manager().lookup().get((Object)new Tuple2((Object)name, (Object)BoxesRunTime.boxToInteger((int)version)));
                    if (option instanceof Some) {
                        bl = true;
                        some = (Some)option;
                        GeoMesaFeatureIndex i = (GeoMesaFeatureIndex)some.x();
                        if (i.supports(this.sft$1)) {
                            GeoMesaFeatureIndex geoMesaFeatureIndex;
                            GeoMesaFeatureIndex geoMesaFeatureIndex2 = geoMesaFeatureIndex = i;
                            return geoMesaFeatureIndex2;
                        }
                    }
                    if (bl) {
                        GeoMesaFeatureIndex i = (GeoMesaFeatureIndex)some.x();
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " does not support this feature type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i.identifier()})));
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", ":", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, BoxesRunTime.boxToInteger((int)version)})));
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        validatedIndices.foreach((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;
            private final SimpleFeatureType sft$1;

            public final void apply(GeoMesaFeatureIndex<DS, F, W> x$7) {
                x$7.configure(this.sft$1, this.$outer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        });
    }

    @Override
    public void onSchemaCreated(SimpleFeatureType sft) {
        GeoMesaIndexManager<DS, F, W> qual$2 = this.manager();
        SimpleFeatureType x$16 = sft;
        Option<String> x$17 = qual$2.indices$default$2();
        IndexMode.IndexMode x$18 = qual$2.indices$default$3();
        qual$2.indices(x$16, x$17, x$18).foreach((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;
            private final SimpleFeatureType sft$2;

            public final void apply(GeoMesaFeatureIndex<DS, F, W> x$8) {
                x$8.configure(this.sft$2, this.$outer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$2 = sft$2;
            }
        });
    }

    @Override
    public void onSchemaUpdated(SimpleFeatureType sft, SimpleFeatureType previous) {
    }

    @Override
    public void onSchemaDeleted(SimpleFeatureType sft) {
        boolean shared = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) && Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.getTypeNames()).filter((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$3;

            public final boolean apply(String x$9) {
                String string = x$9;
                String string2 = this.sft$3.getTypeName();
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.sft$3 = sft$3;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;

            public final SimpleFeatureType apply(String typeName) {
                return this.$outer.getSchema(typeName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeatureType.class)))).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(SimpleFeatureType x$10) {
                return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(x$10));
            }
        });
        GeoMesaIndexManager<DS, F, W> qual$3 = this.manager();
        SimpleFeatureType x$19 = sft;
        Option<String> x$20 = qual$3.indices$default$2();
        IndexMode.IndexMode x$21 = qual$3.indices$default$3();
        ((ParIterableLike)qual$3.indices(x$19, x$20, x$21).par()).foreach((Function1)new Serializable(this, sft, shared){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;
            private final SimpleFeatureType sft$3;
            private final boolean shared$1;

            public final void apply(GeoMesaFeatureIndex<DS, F, W> x$11) {
                x$11.delete(this.sft$3, this.$outer, this.shared$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$3 = sft$3;
                this.shared$1 = shared$1;
            }
        });
        this.stats().clearStats(sft);
    }

    @Override
    public void createSchema(SimpleFeatureType sft) {
        this.suppressVersionCheck().set(BoxesRunTime.boxToBoolean((boolean)true));
        try {
            super.createSchema(sft);
            return;
        }
        finally {
            this.suppressVersionCheck().remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SimpleFeatureType getSchema(String typeName) {
        void var2_2;
        SimpleFeatureType sft = super.getSchema(typeName);
        if (sft != null) {
            this.checkProjectVersion();
            Seq missingIndices = (Seq)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GeoMesaDataStore $outer;

                public final boolean apply(Tuple3<String, Object, IndexMode.IndexMode> x0$4) {
                    Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$4;
                    if (tuple3 != null) {
                        String n = (String)tuple3._1();
                        int v = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        boolean bl = this.$outer.manager().AllIndices().exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final String n$1;
                            private final int v$1;

                            public final boolean apply(GeoMesaFeatureIndex<DS, F, W> i) {
                                String string = i.name();
                                String string2 = this.n$1;
                                return !(string != null ? !string.equals(string2) : string2 != null) && i.version() == this.v$1;
                            }
                            {
                                this.n$1 = n$1;
                                this.v$1 = v$1;
                            }
                        });
                        return bl;
                    }
                    throw new MatchError(tuple3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            if (missingIndices.nonEmpty()) {
                BoxedUnit boxedUnit;
                String versions = ((TraversableOnce)missingIndices.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple3<String, Object, IndexMode.IndexMode> x0$5) {
                        Tuple3<String, Object, IndexMode.IndexMode> tuple3 = x0$5;
                        if (tuple3 != null) {
                            String n = (String)tuple3._1();
                            int v = BoxesRunTime.unboxToInt((Object)tuple3._2());
                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n, BoxesRunTime.boxToInteger((int)v)}));
                            return string;
                        }
                        throw new MatchError(tuple3);
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                String available = ((TraversableOnce)this.manager().AllIndices().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(GeoMesaFeatureIndex<DS, F, W> i) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{i.name(), BoxesRunTime.boxToInteger((int)i.version())}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to access schema ", " with invalid index versions '", "' - "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName(), versions}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available indices are '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{available}))).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The schema ", " was written with a newer "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()}))).append((Object)"version of GeoMesa than this client can handle. Please ensure that you are using the ").append((Object)"same GeoMesa jar versions across your entire workflow. For more information, see ").append((Object)"http://www.geomesa.org/documentation/user/installation_and_configuration.html#upgrading").toString());
            }
        }
        return var2_2;
    }

    public GeoMesaFeatureStore getFeatureSource(String typeName) {
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' has not been initialized. Please call 'createSchema' first."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
        }
        return this.config().caching() ? new CachingFeatureSource(this, sft){
            private final LoadingCache<Query, SimpleFeatureCollection> org$locationtech$geomesa$index$geotools$CachingFeatureSource$$featureCache;

            public LoadingCache<Query, SimpleFeatureCollection> org$locationtech$geomesa$index$geotools$CachingFeatureSource$$featureCache() {
                return this.org$locationtech$geomesa$index$geotools$CachingFeatureSource$$featureCache;
            }

            public void org$locationtech$geomesa$index$geotools$CachingFeatureSource$_setter_$org$locationtech$geomesa$index$geotools$CachingFeatureSource$$featureCache_$eq(LoadingCache x$1) {
                this.org$locationtech$geomesa$index$geotools$CachingFeatureSource$$featureCache = x$1;
            }

            public SimpleFeatureCollection getFeatures(Query query) {
                return CachingFeatureSource$class.getFeatures(this, query);
            }

            public int getCount(Query query) {
                return CachingFeatureSource$class.getCount(this, query);
            }
            {
                CachingFeatureSource$class.$init$(this);
            }
        } : new GeoMesaFeatureStore(this, sft, this.queryPlanner(), (Function2<Query, GeoMesaFeatureSource, GeoMesaFeatureCollection>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaDataStore $outer;

            public final GeoMesaFeatureCollection apply(Query query, GeoMesaFeatureSource source) {
                return this.$outer.createFeatureCollection(query, source);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public GeoMesaFeatureReader getFeatureReader(Query query, Transaction transaction) {
        Predef$.MODULE$.require(query.getTypeName() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Type name is required in the query";
            }
        });
        SimpleFeatureType sft = this.getSchema(query.getTypeName());
        if (sft == null) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' has not been initialized. Please call 'createSchema' first."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.getTypeName()})));
        }
        return GeoMesaFeatureReader$.MODULE$.apply(sft, query, this.queryPlanner(), this.config().queryTimeout(), this.config().audit());
    }

    @Override
    public GeoMesaFeatureWriter.FlushableFeatureWriter getFeatureWriter(String typeName, Filter filter2, Transaction transaction) {
        BoxedUnit boxedUnit;
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' has not been initialized. Please call 'createSchema' first."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
        }
        Transaction transaction2 = transaction;
        Transaction transaction3 = Transaction.AUTO_COMMIT;
        if (!(transaction2 != null ? !transaction2.equals(transaction3) : transaction3 != null)) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Ignoring transaction - not supported");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.createFeatureWriterModify(sft, (Option<Seq<GeoMesaFeatureIndex<DS, F, W>>>)None$.MODULE$, filter2);
    }

    @Override
    public GeoMesaFeatureWriter.FlushableFeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) {
        BoxedUnit boxedUnit;
        Transaction transaction2 = transaction;
        Transaction transaction3 = Transaction.AUTO_COMMIT;
        if (!(transaction2 != null ? !transaction2.equals(transaction3) : transaction3 != null)) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Ignoring transaction - not supported");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.getIndexWriterAppend(typeName, null);
    }

    public GeoMesaFeatureWriter.FlushableFeatureWriter getIndexWriterAppend(String typeName, Seq<GeoMesaFeatureIndex<DS, F, W>> indices2) {
        SimpleFeatureType sft = this.getSchema(typeName);
        if (sft == null) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' has not been initialized. Please call 'createSchema' first."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
        }
        return this.createFeatureWriterAppend(sft, Option$.MODULE$.apply(indices2));
    }

    @Override
    public void dispose() {
        CloseWithLogging$.MODULE$.apply((Object)this.stats());
        this.config().audit().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Throwable> apply(Tuple3<AuditWriter, AuditProvider, String> x0$6) {
                Tuple3<AuditWriter, AuditProvider, String> tuple3 = x0$6;
                if (tuple3 != null) {
                    AuditWriter writer2 = (AuditWriter)tuple3._1();
                    Option option = CloseWithLogging$.MODULE$.apply((Object)writer2);
                    return option;
                }
                throw new MatchError(tuple3);
            }
        });
        super.dispose();
    }

    public Seq<QueryPlan<DS, F, W>> getQueryPlan(Query query, Option<GeoMesaFeatureIndex<DS, F, W>> index, Explainer explainer) {
        Predef$.MODULE$.require(query.getTypeName() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Type name is required in the query";
            }
        });
        SimpleFeatureType sft = this.getSchema(query.getTypeName());
        if (sft == null) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' has not been initialized. Please call 'createSchema' first."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.getTypeName()})));
        }
        return this.queryPlanner().planQuery(sft, query, index, explainer);
    }

    public Option<GeoMesaFeatureIndex<DS, F, W>> getQueryPlan$default$2() {
        return None$.MODULE$;
    }

    public Explainer getQueryPlan$default$3() {
        return new ExplainLogging();
    }

    public Tuple2<String, Set<String>> getVersion() {
        return new Tuple2((Object)GeoMesaProperties$.MODULE$.ProjectVersion(), this.getIteratorVersion());
    }

    private void checkProjectVersion() {
        if (!BoxesRunTime.unboxToBoolean((Object)this.suppressVersionCheck().get()) && ((AtomicLong)GeoMesaDataStore$.MODULE$.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$projectVersionChecks().get(this.getVersionCheckKey())).getAndUpdate(GeoMesaDataStore$.MODULE$.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$updateVersionCheck()) < System.currentTimeMillis()) {
            Tuple2<String, Set<String>> tuple2 = this.getVersion();
            if (tuple2 != null) {
                Tuple2 tuple22;
                String clientVersion = (String)tuple2._1();
                Set iteratorVersions = (Set)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)clientVersion, (Object)iteratorVersions);
                String clientVersion2 = (String)tuple23._1();
                Set iteratorVersions2 = (Set)tuple23._2();
                int clientMajorVersion = SemanticVersion$.MODULE$.apply(clientVersion2).major();
                BooleanRef mismatch = BooleanRef.create((boolean)false);
                iteratorVersions2.foreach((Function1)new Serializable(this, clientVersion2, iteratorVersions2, clientMajorVersion, mismatch){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ GeoMesaDataStore $outer;
                    private final String clientVersion$1;
                    private final Set iteratorVersions$1;
                    private final int clientMajorVersion$1;
                    private final BooleanRef mismatch$1;

                    public final void apply(String version) {
                        int serverMajorVersion = SemanticVersion$.MODULE$.apply(version, true).major();
                        if (serverMajorVersion != this.clientMajorVersion$1 && BoxesRunTime.unboxToBoolean((Object)new GeoMesaSystemProperties.SystemProperty("geomesa.distributed.version.check", "true").toBoolean().get())) {
                            throw new RuntimeException(this.$outer.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$message$1(this.clientVersion$1, this.iteratorVersions$1));
                        }
                        String string = version;
                        String string2 = this.clientVersion$1;
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            this.mismatch$1.elem = true;
                        }
                    }
                    {
                        void var5_5;
                        void var3_3;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.clientVersion$1 = clientVersion$1;
                        this.iteratorVersions$1 = var3_3;
                        this.clientMajorVersion$1 = clientMajorVersion$1;
                        this.mismatch$1 = var5_5;
                    }
                });
                if (mismatch.elem) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(this.org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$message$1(clientVersion2, iteratorVersions2));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            } else {
                throw new MatchError(tuple2);
            }
        }
    }

    public final String org$locationtech$geomesa$index$geotools$GeoMesaDataStore$$message$1(String clientVersion$1, Set iteratorVersions$1) {
        return new StringBuilder().append((Object)"Configured server-side iterators do not match client version - ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client version: ", ", server versions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientVersion$1, iteratorVersions$1.mkString(", ")}))).toString();
    }

    public GeoMesaDataStore(GeoMesaDataStoreFactory.GeoMesaDataStoreConfig config) {
        this.config = config;
        super(config);
        this.suppressVersionCheck = new ThreadLocal<Object>(this){

            public boolean initialValue() {
                return false;
            }
        };
    }
}

