/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.index.attribute;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex$;
import org.locationtech.geomesa.index.conf.TableSplitter;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.ShardStrategy;
import org.locationtech.geomesa.index.index.ShardStrategy$AttributeShardStrategy$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndex;
import org.locationtech.geomesa.index.index.attribute.AttributeIndex$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndex$$anonfun$7$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKeySpace$;
import org.locationtech.geomesa.index.index.legacy.AttributeShardedIndex$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public abstract class AttributeIndex$class {
    public static Option tieredKeySpace(AttributeIndex $this, SimpleFeatureType sft) {
        return AttributeIndex$.MODULE$.TieredOptions().find((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final boolean apply(IndexKeySpace<? extends Product, ? super Object> x$1) {
                return x$1.supports(this.sft$1);
            }
            {
                this.sft$1 = sft$1;
            }
        });
    }

    public static ShardStrategy shardStrategy(AttributeIndex $this, SimpleFeatureType sft) {
        return ShardStrategy$AttributeShardStrategy$.MODULE$.apply(sft);
    }

    public static Function3 decodeRowValue(AttributeIndex $this, SimpleFeatureType sft, int index) {
        Object object;
        int shards = $this.shardStrategy(sft).shards().isEmpty() ? 0 : 1;
        int from = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? 3 + shards : 2 + shards;
        AttributeDescriptor descriptor = sft.getDescriptor(index);
        if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor))) {
            String alias = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)).getSimpleName().toLowerCase(Locale.US);
            object = new Serializable($this, alias){
                public static final long serialVersionUID = 0L;
                private final String alias$1;

                public final List<Object> apply(String encoded) {
                    return Collections.singletonList(AttributeShardedIndex$.MODULE$.typeRegistry().decode(this.alias$1, (Object)encoded));
                }
                {
                    this.alias$1 = alias$1;
                }
            };
        } else {
            String alias = descriptor.getType().getBinding().getSimpleName().toLowerCase(Locale.US);
            object = new Serializable($this, alias){
                public static final long serialVersionUID = 0L;
                private final String alias$2;

                public final Object apply(String x$2) {
                    return AttributeShardedIndex$.MODULE$.typeRegistry().decode(this.alias$2, (Object)x$2);
                }
                {
                    this.alias$2 = alias$2;
                }
            };
        }
        Object decode = object;
        return new Serializable($this, from, (Function1)decode){
            public static final long serialVersionUID = 0L;
            public final int from$1;
            public final Function1 decode$1;

            public final Try<Object> apply(byte[] row, int offset, int length) {
                return Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AttributeIndex$.anonfun.decodeRowValue.1 $outer;
                    private final byte[] row$1;
                    private final int offset$1;
                    private final int length$1;

                    public final Object apply() {
                        int valueStart = this.offset$1 + this.$outer.from$1;
                        int valueEnd = package$.MODULE$.min(Predef$.MODULE$.byteArrayOps(this.row$1).indexOf((Object)BoxesRunTime.boxToByte((byte)ByteArrays$.MODULE$.ZeroByte()), valueStart), this.offset$1 + this.length$1);
                        return this.$outer.decode$1.apply((Object)new String(this.row$1, valueStart, valueEnd - valueStart, StandardCharsets.UTF_8));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.row$1 = row$1;
                        this.offset$1 = offset$1;
                        this.length$1 = length$1;
                    }
                });
            }
            {
                void var3_3;
                this.from$1 = from$1;
                this.decode$1 = var3_3;
            }
        };
    }

    public static Function4 getIdFromRow(AttributeIndex $this, SimpleFeatureType sft) {
        Function4<byte[], Object, Object, SimpleFeature, String> idFromBytes2 = GeoMesaFeatureIndex$.MODULE$.idFromBytes(sft);
        int shards = $this.shardStrategy(sft).shards().isEmpty() ? 0 : 1;
        int from = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? 3 + shards : 2 + shards;
        int secondary = BoxesRunTime.unboxToInt((Object)$this.tieredKeySpace(sft).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(IndexKeySpace<?, ?> x$3) {
                return x$3.indexKeyByteLength();
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        return new Serializable($this, idFromBytes2, from, secondary){
            public static final long serialVersionUID = 0L;
            private final Function4 idFromBytes$1;
            private final int from$2;
            private final int secondary$1;

            public final String apply(byte[] row, int offset, int length, SimpleFeature feature) {
                int start = Predef$.MODULE$.byteArrayOps(row).indexOf((Object)BoxesRunTime.boxToByte((byte)ByteArrays$.MODULE$.ZeroByte()), this.from$2 + offset) + this.secondary$1 + 1;
                return (String)this.idFromBytes$1.apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)start), (Object)BoxesRunTime.boxToInteger((int)(length + offset - start)), (Object)feature);
            }
            {
                this.idFromBytes$1 = idFromBytes$1;
                this.from$2 = from$2;
                this.secondary$1 = secondary$1;
            }
        };
    }

    public static Seq getSplits(AttributeIndex $this, SimpleFeatureType sft) {
        byte[] sharing = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSharingBytes$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Seq indices2 = (Seq)SimpleFeatureTypes$.MODULE$.getSecondaryIndexedAttributes(sft).map((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final int apply(AttributeDescriptor d) {
                return this.sft$2.indexOf(d.getLocalName());
            }
            {
                this.sft$2 = sft$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq shards = AttributeIndex$class.nonEmpty$1($this, $this.shardStrategy(sft).shards());
        TableSplitter splitter = (TableSplitter)((Class)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSplitter$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Class<DefaultSplitter> apply() {
                return DefaultSplitter.class;
            }
        })).newInstance();
        Seq result = (Seq)indices2.flatMap((Function1)new Serializable($this, sharing, shards, splitter, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeIndex $outer;
            public final byte[] sharing$1;
            private final Seq shards$1;
            private final TableSplitter splitter$1;
            private final SimpleFeatureType sft$2;

            public final Seq<byte[]> apply(int indexOf) {
                SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                builder.setName(this.sft$2.getName());
                builder.add(this.sft$2.getDescriptor(indexOf));
                SimpleFeatureType singleAttributeType = builder.buildFeatureType();
                byte[] attribute = AttributeIndexKey$.MODULE$.indexToBytes(indexOf);
                Seq splits = AttributeIndex$class.nonEmpty$1(this.$outer, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.splitter$1.getSplits(singleAttributeType, this.$outer.name(), RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getTableSplitterOptions$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$2)))));
                return (Seq)this.shards$1.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AttributeIndex$.anonfun.7 $outer;
                    public final byte[] attribute$1;
                    private final Seq splits$1;

                    public final Seq<byte[]> apply(byte[] shard) {
                        return (Seq)this.splits$1.map((Function1)new Serializable(this, shard){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ AttributeIndex$$anonfun$7$.anonfun.apply.2 $outer;
                            private final byte[] shard$1;

                            public final byte[] apply(byte[] split) {
                                return Bytes.concat((byte[][])new byte[][]{this.$outer.org$locationtech$geomesa$index$index$attribute$AttributeIndex$$anonfun$$anonfun$$$outer().sharing$1, this.shard$1, this.$outer.attribute$1, split});
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.shard$1 = (byte[])shard$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }

                    public /* synthetic */ AttributeIndex$.anonfun.7 org$locationtech$geomesa$index$index$attribute$AttributeIndex$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.attribute$1 = attribute$1;
                        this.splits$1 = splits$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sharing$1 = (byte[])sharing$1;
                this.shards$1 = var3_3;
                this.splitter$1 = var4_4;
                this.sft$2 = var5_5;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return Predef$.MODULE$.byteArrayOps(sharing).isEmpty() || BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(sharing).head()) == (byte)0 ? (Seq)result.drop(1) : result;
    }

    public static final Seq nonEmpty$1(AttributeIndex $this, Seq bytes) {
        return bytes.nonEmpty() ? bytes : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())}));
    }

    public static void $init$(AttributeIndex $this) {
        $this.org$locationtech$geomesa$index$index$attribute$AttributeIndex$_setter_$name_$eq(AttributeIndex$.MODULE$.Name());
        $this.org$locationtech$geomesa$index$index$attribute$AttributeIndex$_setter_$keySpace_$eq(AttributeIndexKeySpace$.MODULE$);
    }
}

