/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.NullableFloat4Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.impl.AbstractLineStringVector;

public class LineStringFloatVector
extends AbstractLineStringVector {
    public static final List<Field> fields = GeometryFields.XY_FLOAT_LIST;

    public LineStringFloatVector(String name, BufferAllocator allocator, @Nullable Map<String, String> metadata) {
        super(name, allocator, metadata);
    }

    public LineStringFloatVector(String name, AbstractContainerVector container, @Nullable Map<String, String> metadata) {
        super(name, container, metadata);
    }

    public LineStringFloatVector(ListVector vector) {
        super(vector);
    }

    @Override
    protected List<Field> getFields() {
        return fields;
    }

    @Override
    protected AbstractLineStringVector.LineStringWriter createWriter(ListVector vector) {
        return new LineStringFloatWriter(vector);
    }

    @Override
    protected AbstractLineStringVector.LineStringReader createReader(ListVector vector) {
        return new LineStringFloatReader(vector);
    }

    public static class LineStringFloatReader
    extends AbstractLineStringVector.LineStringReader {
        private NullableFloat4Vector.Accessor accessor;

        public LineStringFloatReader(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalAccessor(ValueVector.Accessor accessor) {
            this.accessor = (NullableFloat4Vector.Accessor)accessor;
        }

        @Override
        protected double readOrdinal(int index) {
            return this.accessor.get(index);
        }
    }

    public static class LineStringFloatWriter
    extends AbstractLineStringVector.LineStringWriter {
        private NullableFloat4Vector.Mutator mutator;

        public LineStringFloatWriter(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalMutator(ValueVector.Mutator mutator) {
            this.mutator = (NullableFloat4Vector.Mutator)mutator;
        }

        @Override
        protected void writeOrdinal(int index, double ordinal) {
            this.mutator.setSafe(index, (float)ordinal);
        }
    }
}

