/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.NullableFloat4Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.impl.AbstractMultiLineStringVector;

public class MultiLineStringFloatVector
extends AbstractMultiLineStringVector {
    public static final List<Field> fields = GeometryFields.XY_FLOAT_LIST_2;

    public MultiLineStringFloatVector(String name, BufferAllocator allocator, @Nullable Map<String, String> metadata) {
        super(name, allocator, metadata);
    }

    public MultiLineStringFloatVector(String name, AbstractContainerVector container, @Nullable Map<String, String> metadata) {
        super(name, container, metadata);
    }

    public MultiLineStringFloatVector(ListVector vector) {
        super(vector);
    }

    @Override
    protected List<Field> getFields() {
        return fields;
    }

    @Override
    protected AbstractMultiLineStringVector.MultiLineStringWriter createWriter(ListVector vector) {
        return new MultiLineStringFloatWriter(vector);
    }

    @Override
    protected AbstractMultiLineStringVector.MultiLineStringReader createReader(ListVector vector) {
        return new MultiLineStringFloatReader(vector);
    }

    public static class MultiLineStringFloatReader
    extends AbstractMultiLineStringVector.MultiLineStringReader {
        private NullableFloat4Vector.Accessor accessor;

        public MultiLineStringFloatReader(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalAccessor(ValueVector.Accessor accessor) {
            this.accessor = (NullableFloat4Vector.Accessor)accessor;
        }

        @Override
        protected double readOrdinal(int index) {
            return this.accessor.get(index);
        }
    }

    public static class MultiLineStringFloatWriter
    extends AbstractMultiLineStringVector.MultiLineStringWriter {
        private NullableFloat4Vector.Mutator mutator;

        public MultiLineStringFloatWriter(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalMutator(ValueVector.Mutator mutator) {
            this.mutator = (NullableFloat4Vector.Mutator)mutator;
        }

        @Override
        protected void writeOrdinal(int index, double ordinal) {
            this.mutator.setSafe(index, (float)ordinal);
        }
    }
}

