/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geotools.io.TableWriter;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.MatrixParameterDescriptors;
import org.geotools.parameter.ParameterGroup;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.XArray;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class MatrixParameters
extends ParameterGroup
implements ParameterDescriptorGroup {
    private static final long serialVersionUID = -7747712999115044943L;
    private ParameterValue<Double>[][] matrixValues;
    private ParameterValue<Integer> numRow = Parameters.cast((ParameterValue)this.parameter(0), Integer.class);
    private ParameterValue<Integer> numCol = Parameters.cast((ParameterValue)this.parameter(1), Integer.class);

    public MatrixParameters(MatrixParameterDescriptors descriptor) {
        super(descriptor);
    }

    @Override
    public ParameterDescriptorGroup getDescriptor() {
        return this;
    }

    public ReferenceIdentifier getName() {
        return this.descriptor.getName();
    }

    public Collection<GenericName> getAlias() {
        return this.descriptor.getAlias();
    }

    public Set<ReferenceIdentifier> getIdentifiers() {
        return this.descriptor.getIdentifiers();
    }

    public InternationalString getRemarks() {
        return this.descriptor.getRemarks();
    }

    public int getMinimumOccurs() {
        return this.descriptor.getMinimumOccurs();
    }

    public int getMaximumOccurs() {
        return this.descriptor.getMaximumOccurs();
    }

    public GeneralParameterDescriptor descriptor(String name) throws ParameterNotFoundException {
        return ((MatrixParameterDescriptors)this.descriptor).descriptor(name, this.numRow.intValue(), this.numCol.intValue());
    }

    public ParameterValue<?> parameter(String name) throws ParameterNotFoundException {
        int split;
        MatrixParameters.ensureNonNull("name", name);
        name = name.trim();
        MatrixParameterDescriptors descriptor = (MatrixParameterDescriptors)this.descriptor;
        String prefix = descriptor.prefix;
        RuntimeException cause = null;
        if (name.regionMatches(true, 0, prefix, 0, prefix.length()) && (split = name.indexOf(descriptor.separator, prefix.length())) >= 0) {
            try {
                int row = Integer.parseInt(name.substring(prefix.length(), split));
                int col = Integer.parseInt(name.substring(split + 1));
                return this.parameter(row, col);
            }
            catch (NumberFormatException exception) {
                cause = exception;
            }
            catch (IndexOutOfBoundsException exception) {
                cause = exception;
            }
        }
        try {
            return super.parameter(name);
        }
        catch (ParameterNotFoundException exception) {
            if (cause != null) {
                try {
                    exception.initCause(cause);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            throw exception;
        }
    }

    public final ParameterValue<Double> parameter(int row, int column) throws IndexOutOfBoundsException {
        return this.parameter(row, column, this.numRow.intValue(), this.numCol.intValue());
    }

    private ParameterValue<Double> parameter(int row, int column, int numRow, int numCol) throws IndexOutOfBoundsException {
        FloatParameter param;
        ParameterValue<Double>[] rowValues;
        MatrixParameterDescriptors.checkIndice("row", row, numRow);
        MatrixParameterDescriptors.checkIndice("column", column, numCol);
        if (this.matrixValues == null) {
            this.matrixValues = new ParameterValue[numRow][];
        }
        if (row >= this.matrixValues.length) {
            this.matrixValues = (ParameterValue[][])XArray.resize(this.matrixValues, numRow);
        }
        if ((rowValues = this.matrixValues[row]) == null) {
            rowValues = new ParameterValue[numCol];
            this.matrixValues[row] = rowValues;
        }
        if (column >= rowValues.length) {
            rowValues = XArray.resize(rowValues, numCol);
            this.matrixValues[row] = rowValues;
        }
        if ((param = rowValues[column]) == null) {
            rowValues[column] = param = new FloatParameter(((MatrixParameterDescriptors)this.descriptor).descriptor(row, column, numRow, numCol));
        }
        return param;
    }

    public List<GeneralParameterDescriptor> descriptors() {
        return ((MatrixParameterDescriptors)this.descriptor).descriptors(this.numRow.intValue(), this.numCol.intValue());
    }

    @Override
    public List<GeneralParameterValue> values() {
        int numRow = this.numRow.intValue();
        int numCol = this.numCol.intValue();
        ParameterValue[] parameters = new ParameterValue[numRow * numCol + 2];
        int k = 0;
        parameters[k++] = this.numRow;
        parameters[k++] = this.numCol;
        if (this.matrixValues != null) {
            int maxRow = Math.min(numRow, this.matrixValues.length);
            for (int j = 0; j < maxRow; ++j) {
                ParameterValue<Double>[] rowValues = this.matrixValues[j];
                if (rowValues == null) continue;
                int maxCol = Math.min(numCol, rowValues.length);
                for (int i = 0; i < maxCol; ++i) {
                    ParameterValue<Double> value = rowValues[i];
                    if (value == null) continue;
                    parameters[k++] = value;
                }
            }
        }
        return UnmodifiableArrayList.wrap((GeneralParameterValue[])XArray.resize(parameters, k));
    }

    public ParameterValueGroup createValue() {
        return (ParameterValueGroup)this.descriptor.createValue();
    }

    public Matrix getMatrix() {
        int numRow = this.numRow.intValue();
        int numCol = this.numCol.intValue();
        XMatrix matrix = MatrixFactory.create(numRow, numCol);
        if (this.matrixValues != null) {
            for (int j = 0; j < numRow; ++j) {
                ParameterValue<Double>[] row = this.matrixValues[j];
                if (row == null) continue;
                for (int i = 0; i < numCol; ++i) {
                    ParameterValue<Double> element = row[i];
                    if (element == null) continue;
                    matrix.setElement(j, i, element.doubleValue());
                }
            }
        }
        return matrix;
    }

    public void setMatrix(Matrix matrix) {
        MatrixParameterDescriptors matrixDescriptor = (MatrixParameterDescriptors)this.descriptor;
        int numRow = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        this.numRow.setValue(numRow);
        this.numCol.setValue(numCol);
        for (int row = 0; row < numRow; ++row) {
            for (int col = 0; col < numCol; ++col) {
                double element = matrix.getElement(row, col);
                ParameterDescriptor<Double> descriptor = matrixDescriptor.descriptor(row, col);
                double value = (Double)descriptor.getDefaultValue();
                if (Double.doubleToLongBits(element) == Double.doubleToLongBits(value)) {
                    if (this.matrixValues == null || this.matrixValues[row] == null) continue;
                    this.matrixValues[row][col] = null;
                    continue;
                }
                if (this.matrixValues == null) {
                    this.matrixValues = new ParameterValue[numRow][];
                }
                if (this.matrixValues[row] == null) {
                    this.matrixValues[row] = new ParameterValue[numCol];
                }
                this.matrixValues[row][col] = new FloatParameter(descriptor, element);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            MatrixParameters that = (MatrixParameters)object;
            int numRow = this.numRow.intValue();
            int numCol = this.numCol.intValue();
            for (int j = 0; j < numRow; ++j) {
                for (int i = 0; i < numCol; ++i) {
                    if (Utilities.equals(this.parameter(j, i, numRow, numCol), that.parameter(j, i, numRow, numCol))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public MatrixParameters clone() {
        MatrixParameters copy = (MatrixParameters)super.clone();
        if (copy.matrixValues != null) {
            copy.numRow = (ParameterValue)copy.parameter(0);
            copy.numCol = (ParameterValue)copy.parameter(1);
            copy.matrixValues = (ParameterValue[][])copy.matrixValues.clone();
            for (int j = 0; j < copy.matrixValues.length; ++j) {
                ParameterValue<Double>[] array = copy.matrixValues[j];
                if (array == null) continue;
                array = (ParameterValue[])array.clone();
                copy.matrixValues[j] = array;
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] == null) continue;
                    array[i] = array[i].clone();
                }
            }
        }
        return copy;
    }

    @Override
    protected void write(TableWriter table) throws IOException {
        table.write(MatrixParameters.getName(this.descriptor));
        table.nextColumn();
        table.write(61);
        table.nextColumn();
        table.write(this.getMatrix().toString());
        table.nextLine();
    }
}

