/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEach
extends Instruction
implements ContextMappingFunction,
ContextSwitchingExpression {
    protected boolean containsTailCall;
    protected Operand selectOp;
    protected Operand actionOp;
    protected Operand threadsOp;

    public ForEach(Expression select, Expression action) {
        this(select, action, false, null);
    }

    public ForEach(Expression select, Expression action, boolean containsTailCall, Expression threads) {
        this.selectOp = new Operand(this, select, OperandRole.FOCUS_CONTROLLING_SELECT);
        this.actionOp = new Operand(this, action, OperandRole.FOCUS_CONTROLLED_ACTION);
        if (threads != null) {
            this.threadsOp = new Operand(this, threads, OperandRole.SINGLE_ATOMIC);
        }
        this.containsTailCall = containsTailCall && action instanceof TailCallReturner;
    }

    public Expression getSelect() {
        return this.selectOp.getChildExpression();
    }

    public void setSelect(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    public Expression getAction() {
        return this.actionOp.getChildExpression();
    }

    public void setAction(Expression action) {
        this.actionOp.setChildExpression(action);
    }

    public Expression getThreads() {
        return this.threadsOp == null ? null : this.threadsOp.getChildExpression();
    }

    public void setThreads(Expression threads) {
        if (threads != null) {
            if (this.threadsOp == null) {
                this.threadsOp = new Operand(this, threads, OperandRole.SINGLE_ATOMIC);
            } else {
                this.threadsOp.setChildExpression(threads);
            }
        }
    }

    @Override
    public Iterable<Operand> operands() {
        if (this.threadsOp == null) {
            return this.operandList(this.selectOp, this.actionOp);
        }
        return this.operandList(this.selectOp, this.actionOp, this.threadsOp);
    }

    @Override
    public int getInstructionNameCode() {
        return 155;
    }

    @Override
    public Expression getSelectExpression() {
        return this.getSelect();
    }

    public void setSelectExpression(Expression select) {
        this.setSelect(select);
    }

    public void setActionExpression(Expression action) {
        this.setAction(action);
    }

    @Override
    public Expression getActionExpression() {
        return this.getAction();
    }

    public Expression getNumberOfThreadsExpression() {
        return this.getThreads();
    }

    @Override
    public final ItemType getItemType() {
        return this.getAction().getItemType();
    }

    @Override
    public final boolean createsNewNodes() {
        int props = this.getAction().getSpecialProperties();
        return (props & 0x400000) == 0;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.selectOp.typeCheck(visitor, contextInfo);
        ItemType selectType = this.getSelect().getItemType();
        if (selectType == ErrorType.getInstance()) {
            return Literal.makeEmptySequence();
        }
        ContextItemStaticInfo cit = new ContextItemStaticInfo(this.getSelect().getItemType(), false, this.getSelect());
        this.actionOp.typeCheck(visitor, cit);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2;
        this.selectOp.optimize(visitor, contextInfo);
        ContextItemStaticInfo cit = new ContextItemStaticInfo(this.getSelect().getItemType(), false, this.getSelect());
        this.actionOp.optimize(visitor, cit);
        if (!visitor.isOptimizeForStreaming()) {
            if (Literal.isEmptySequence(this.getSelect())) {
                return this.getSelect();
            }
            if (Literal.isEmptySequence(this.getAction())) {
                return this.getAction();
            }
        }
        PromotionOffer offer = new PromotionOffer(this.getConfiguration().obtainOptimizer());
        offer.action = 10;
        offer.promoteDocumentDependent = (this.getSelect().getSpecialProperties() & 0x10000) != 0;
        offer.promoteXSLTFunctions = false;
        offer.containingExpression = this;
        offer.bindingList = new Binding[0];
        this.setAction(this.doPromotion(this.getAction(), offer));
        if (offer.containingExpression instanceof LetExpression) {
            ((LetExpression)offer.containingExpression).setEvaluationMode(4);
            offer.containingExpression = offer.containingExpression.optimize(visitor, contextInfo);
        }
        if ((e2 = offer.containingExpression) != this) {
            return e2;
        }
        if (this.threadsOp != null && !Literal.isEmptySequence(this.getThreads())) {
            return this.getConfiguration().obtainOptimizer().generateMultithreadedInstruction(this);
        }
        return this;
    }

    @Override
    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        this.setSelect(this.getSelect().unordered(retainAllNodes, forStreaming));
        this.setAction(this.getAction().unordered(retainAllNodes, forStreaming));
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.getSelect().addToPathMap(pathMap, pathMapNodeSet);
        return this.getAction().addToPathMap(pathMap, target);
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ForEach f2 = new ForEach(this.getSelect().copy(rebindings), this.getAction().copy(rebindings), this.containsTailCall, this.getThreads());
        ExpressionTool.copyLocationInfo(this, f2);
        return f2;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        p = this.getSelect().getCardinality() == 16384 ? (p |= this.getAction().getSpecialProperties()) : (p |= this.getAction().getSpecialProperties() & 0x4000000);
        return p;
    }

    @Override
    protected void promoteChildren(PromotionOffer offer) throws XPathException {
        this.setSelect(this.doPromotion(this.getSelect(), offer));
        if (offer.action == 14) {
            this.setAction(this.doPromotion(this.getAction(), offer));
        }
    }

    @Override
    public int getImplementationMethod() {
        return 30;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        this.getAction().checkPermittedContents(parentType, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        FocusTrackingIterator iter = new FocusTrackingIterator(this.getSelect().iterate(context));
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(iter);
        c2.setCurrentTemplateRule(null);
        if (this.containsTailCall) {
            if (controller.isTracing()) {
                TraceListener listener = controller.getTraceListener();
                assert (listener != null);
                Item item = iter.next();
                if (item == null) {
                    return null;
                }
                listener.startCurrentItem(item);
                TailCall tc = ((TailCallReturner)((Object)this.getAction())).processLeavingTail(c2);
                listener.endCurrentItem(item);
                return tc;
            }
            Item item = iter.next();
            if (item == null) {
                return null;
            }
            return ((TailCallReturner)((Object)this.getAction())).processLeavingTail(c2);
        }
        if (controller.isTracing()) {
            Item item;
            TraceListener listener = controller.getTraceListener();
            assert (listener != null);
            while ((item = iter.next()) != null) {
                listener.startCurrentItem(item);
                this.getAction().process(c2);
                listener.endCurrentItem(item);
            }
        } else {
            while (iter.next() != null) {
                this.getAction().process(c2);
            }
        }
        return null;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        FocusTrackingIterator master = new FocusTrackingIterator(this.getSelect().iterate(context));
        XPathContextMinor c2 = context.newMinorContext();
        c2.setCurrentIterator(master);
        return new ContextMappingIterator(this, c2);
    }

    @Override
    public SequenceIterator map(XPathContext context) throws XPathException {
        return this.getAction().iterate(context);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("forEach", this);
        this.getSelect().export(out);
        this.getAction().export(out);
        this.explainThreads(out);
        out.endElement();
    }

    protected void explainThreads(ExpressionPresenter out) throws XPathException {
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getSelect()) + " ! " + ExpressionTool.parenthesize(this.getAction());
    }

    @Override
    public String toShortString() {
        return this.getSelect().toShortString() + "!" + this.getAction().toShortString();
    }

    @Override
    public String getExpressionName() {
        return "forEach";
    }
}

