/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.basic;

import java.util.ArrayList;
import java.util.Iterator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraphable;

public class BasicEdge
extends BasicGraphable
implements Edge {
    private Node m_nodeA;
    private Node m_nodeB;

    public BasicEdge(Node nodeA, Node nodeB) {
        this.m_nodeA = nodeA;
        this.m_nodeB = nodeB;
    }

    @Override
    public Node getNodeA() {
        return this.m_nodeA;
    }

    @Override
    public Node getNodeB() {
        return this.m_nodeB;
    }

    @Override
    public Node getOtherNode(Node node) {
        if (node.equals(this.m_nodeA)) {
            return this.m_nodeB;
        }
        if (node.equals(this.m_nodeB)) {
            return this.m_nodeA;
        }
        return null;
    }

    @Override
    public Iterator getRelated() {
        ArrayList<Edge> adj = new ArrayList<Edge>();
        for (Edge e : this.m_nodeA.getEdges()) {
            switch (e.compareNodes(this)) {
                case 0: {
                    if (e.equals(this)) break;
                }
                case -1: 
                case 1: {
                    adj.add(e);
                }
            }
        }
        for (Edge e : this.m_nodeB.getEdges()) {
            switch (e.compareNodes(this)) {
                case -1: 
                case 0: {
                    break;
                }
                case 1: {
                    adj.add(e);
                }
            }
        }
        return adj.iterator();
    }

    @Override
    public void reverse() {
        Node n = this.m_nodeA;
        this.m_nodeA = this.m_nodeB;
        this.m_nodeB = n;
    }

    @Override
    public int compareNodes(Edge other) {
        if (this.m_nodeA.equals(other.getNodeA()) && this.m_nodeB.equals(other.getNodeB())) {
            return 0;
        }
        if (this.m_nodeA.equals(other.getNodeA()) && this.m_nodeB.equals(other.getNodeB()) || this.m_nodeA.equals(other.getNodeB()) && this.m_nodeB.equals(other.getNodeA())) {
            return -1;
        }
        return 1;
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.m_nodeA.getID() + "," + this.m_nodeB.getID() + ")";
    }
}

