/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.TransformerFn;
import org.locationtech.geomesa.convert.TransformerFn$;
import org.locationtech.geomesa.convert.TransformerFn$class;
import org.locationtech.geomesa.convert.TransformerFunctionFactory;
import org.locationtech.geomesa.curve.TimePeriod$;
import org.locationtech.geomesa.utils.uuid.Z3UuidGenerator$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0001-\u0011\u0011#\u00133Gk:\u001cG/[8o\r\u0006\u001cGo\u001c:z\u0015\t\u0019A!A\u0004d_:4XM\u001d;\u000b\u0005\u00151\u0011aB4f_6,7/\u0019\u0006\u0003\u000f!\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!C\u0001\u0004_J<7\u0001A\n\u0005\u00011\u0011b\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011!\u0004\u0016:b]N4wN]7fe\u001a+hn\u0019;j_:4\u0015m\u0019;pef\u0004\"a\u0006\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005ma\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003u\t1aY8n\u0013\ty\u0002DA\u0006MCjLHj\\4hS:<\u0007\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\bF\u0001$!\t\u0019\u0002\u0001C\u0003&\u0001\u0011\u0005c%A\u0005gk:\u001cG/[8ogV\tq\u0005E\u0002)W5j\u0011!\u000b\u0006\u0003U9\t!bY8mY\u0016\u001cG/[8o\u0013\ta\u0013FA\u0002TKF\u0004\"a\u0005\u0018\n\u0005=\u0012!!\u0004+sC:\u001chm\u001c:nKJ4e\u000eC\u00042\u0001\t\u0007I\u0011\u0001\u001a\u0002\u0019M$(/\u001b8he\tKH/Z:\u0016\u00035Ba\u0001\u000e\u0001!\u0002\u0013i\u0013!D:ue&twM\r\"zi\u0016\u001c\b\u0005C\u00047\u0001\t\u0007I\u0011\u0001\u001a\u0002\rU,\u0018\u000e\u001a$o\u0011\u0019A\u0004\u0001)A\u0005[\u00059Q/^5e\r:\u0004\u0003b\u0002\u001e\u0001\u0005\u0004%\tAM\u0001\u0007kVLGMW\u001a\t\rq\u0002\u0001\u0015!\u0003.\u0003\u001d)X/\u001b3[g\u0001BqA\u0010\u0001C\u0002\u0013\u0005!'\u0001\bvk&$'lM\"f]R\u0014x.\u001b3\t\r\u0001\u0003\u0001\u0015!\u0003.\u0003=)X/\u001b3[g\r+g\u000e\u001e:pS\u0012\u0004\u0003b\u0002\"\u0001\u0005\u0004%\tAM\u0001\u0007E\u0006\u001cXM\u000e\u001b\t\r\u0011\u0003\u0001\u0015!\u0003.\u0003\u001d\u0011\u0017m]37i\u0001BqA\u0012\u0001C\u0002\u0013\u0005q)A\u0002nIV*\u0012\u0001\u0013\t\u0003\u0013*k\u0011\u0001\u0001\u0004\u0005\u0017\u0002\u0001AJA\u0002N\tV\u001a2A\u0013\u0007.\u0011\u0015\t#\n\"\u0001O)\u0005A\u0005b\u0002)K\u0005\u0004%\t%U\u0001\u0006]\u0006lWm]\u000b\u0002%B\u0019\u0001fK*\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016\u0001\u00027b]\u001eT\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002[+\n11\u000b\u001e:j]\u001eDa\u0001\u0018&!\u0002\u0013\u0011\u0016A\u00028b[\u0016\u001c\b\u0005C\u0003_\u0015\u0012\u0005s)A\u0006hKRLen\u001d;b]\u000e,\u0007b\u00021K\u0005\u0004%I!Y\u0001\u0007Q\u0006\u001c\b.\u001a:\u0016\u0003\t\u0004\"a\u00196\u000e\u0003\u0011T!!\u001a4\u0002\t!\f7\u000f\u001b\u0006\u0003O\"\faaY8n[>t'BA5\u001d\u0003\u00199wn\\4mK&\u00111\u000e\u001a\u0002\r\u0011\u0006\u001c\bNR;oGRLwN\u001c\u0005\u0007[*\u0003\u000b\u0011\u00022\u0002\u000f!\f7\u000f[3sA!)qN\u0013C!a\u0006!QM^1m)\t\t(\u0010\u0006\u0002skB\u0011Qb]\u0005\u0003i:\u00111!\u00118z\u0011\u00151h\u000eq\u0001x\u0003\r\u0019G\u000f\u001f\t\u0003'aL!!\u001f\u0002\u0003#\u00153\u0018\r\\;bi&|gnQ8oi\u0016DH\u000fC\u0003|]\u0002\u0007A0\u0001\u0003be\u001e\u001c\bcA\u0007~e&\u0011aP\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003I\u0003\u0011iG-\u000e\u0011\u0007\r\u0005\u0015\u0001\u0001AA\u0004\u0005)iUO]7veNz6GM\n\u0005\u0003\u0007aQ\u0006C\u0004\"\u0003\u0007!\t!a\u0003\u0015\u0005\u00055\u0001cA%\u0002\u0004!A\u0001-a\u0001C\u0002\u0013%\u0011\rC\u0004n\u0003\u0007\u0001\u000b\u0011\u00022\t\u0013A\u000b\u0019A1A\u0005B\u0005UQCAA\f!\u0019\tI\"!\u000b\u0002.9!\u00111DA\u0013\u001d\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011\u0015\u00051AH]8pizJ\u0011aD\u0005\u0004\u0003Oq\u0011a\u00029bG.\fw-Z\u0005\u0004Y\u0005-\"bAA\u0014\u001dA!\u0011qFA\u001b\u001d\ri\u0011\u0011G\u0005\u0004\u0003gq\u0011A\u0002)sK\u0012,g-C\u0002[\u0003oQ1!a\r\u000f\u0011!a\u00161\u0001Q\u0001\n\u0005]\u0001bB8\u0002\u0004\u0011\u0005\u0013Q\b\u000b\u0005\u0003\u007f\t\u0019\u0005F\u0002s\u0003\u0003BaA^A\u001e\u0001\b9\bBB>\u0002<\u0001\u0007A\u0010C\u0005\u0002H\u0001\u0011\r\u0011\"\u0001\u0002J\u0005QQ.\u001e:nkJ\u001ctl\r\u001a\u0016\u0005\u00055\u0001\u0002CA'\u0001\u0001\u0006I!!\u0004\u0002\u00175,(/\\;sg}\u001b$\u0007\t\u0004\u0007\u0003#\u0002\u0001!a\u0015\u0003\u00155+(/\\;sg}3Dg\u0005\u0003\u0002P1i\u0003bB\u0011\u0002P\u0011\u0005\u0011q\u000b\u000b\u0003\u00033\u00022!SA(\u0011!\u0001\u0017q\nb\u0001\n\u0013\t\u0007bB7\u0002P\u0001\u0006IA\u0019\u0005\n!\u0006=#\u0019!C!\u0003+A\u0001\u0002XA(A\u0003%\u0011q\u0003\u0005\b_\u0006=C\u0011IA3)\u0011\t9'a\u001b\u0015\u0007I\fI\u0007\u0003\u0004w\u0003G\u0002\u001da\u001e\u0005\u0007w\u0006\r\u0004\u0019\u0001?\t\u0013\u0005=\u0004A1A\u0005\u0002\u0005E\u0014AC7ve6,(oM07iU\u0011\u0011\u0011\f\u0005\t\u0003k\u0002\u0001\u0015!\u0003\u0002Z\u0005YQ.\u001e:nkJ\u001ctL\u000e\u001b!\u0001")
public class IdFunctionFactory
implements TransformerFunctionFactory,
LazyLogging {
    private final TransformerFn string2Bytes;
    private final TransformerFn uuidFn;
    private final TransformerFn uuidZ3;
    private final TransformerFn uuidZ3Centroid;
    private final TransformerFn base64;
    private final MD5 md5;
    private final Murmur3_32 murmur3_32;
    private final Murmur3_64 murmur3_64;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        IdFunctionFactory idFunctionFactory = this;
        synchronized (idFunctionFactory) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Seq<TransformerFn> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFn[]{this.string2Bytes(), this.md5(), this.uuidFn(), this.uuidZ3(), this.uuidZ3Centroid(), this.base64(), this.murmur3_32(), this.murmur3_64()}));
    }

    public TransformerFn string2Bytes() {
        return this.string2Bytes;
    }

    public TransformerFn uuidFn() {
        return this.uuidFn;
    }

    public TransformerFn uuidZ3() {
        return this.uuidZ3;
    }

    public TransformerFn uuidZ3Centroid() {
        return this.uuidZ3Centroid;
    }

    public TransformerFn base64() {
        return this.base64;
    }

    public MD5 md5() {
        return this.md5;
    }

    public Murmur3_32 murmur3_32() {
        return this.murmur3_32;
    }

    public Murmur3_64 murmur3_64() {
        return this.murmur3_64;
    }

    public IdFunctionFactory() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.string2Bytes = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string2bytes", "stringToBytes"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Object[] args) {
                return ((String)args[0]).getBytes(StandardCharsets.UTF_8);
            }
        });
        this.uuidFn = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object[] args) {
                return UUID.randomUUID().toString();
            }
        });
        this.uuidZ3 = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuidZ3"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdFunctionFactory $outer;

            public final Object apply(Object[] args) {
                String string2;
                Point geom = (Point)args[0];
                Date date = (Date)args[1];
                Enumeration.Value interval = TimePeriod$.MODULE$.withName((String)args[2]);
                try {
                    string2 = Z3UuidGenerator$.MODULE$.createUuid(geom, date.getTime(), interval).toString();
                }
                catch (Throwable throwable) {
                    String string3;
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z3 values for UUID: ", " ", " ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geom, date, interval, e})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    string2 = string3 = UUID.randomUUID().toString();
                }
                return string2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.uuidZ3Centroid = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuidZ3Centroid"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdFunctionFactory $outer;

            public final Object apply(Object[] args) {
                String string2;
                Geometry geom = (Geometry)args[0];
                Date date = (Date)args[1];
                Enumeration.Value interval = TimePeriod$.MODULE$.withName((String)args[2]);
                try {
                    string2 = Z3UuidGenerator$.MODULE$.createUuid(geom, date.getTime(), interval).toString();
                }
                catch (Throwable throwable) {
                    String string3;
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid z3 values for UUID: ", " ", " ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{geom, date, interval, e})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    string2 = string3 = UUID.randomUUID().toString();
                }
                return string2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.base64 = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"base64"}), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object[] args) {
                return Base64.encodeBase64URLSafeString((byte[])((byte[])args[0]));
            }
        });
        this.md5 = new MD5();
        this.murmur3_32 = new Murmur3_32();
        this.murmur3_64 = new Murmur3_64();
    }

    public class MD5
    implements TransformerFn {
        private final Seq<String> names;
        private final HashFunction hasher;

        @Override
        public Seq<String> names() {
            return this.names;
        }

        @Override
        public MD5 getInstance() {
            return this.org$locationtech$geomesa$convert$IdFunctionFactory$MD5$$$outer().new MD5();
        }

        private HashFunction hasher() {
            return this.hasher;
        }

        @Override
        public Object eval(Object[] args, EvaluationContext ctx) {
            return this.hasher().hashBytes((byte[])args[0]).toString();
        }

        public /* synthetic */ IdFunctionFactory org$locationtech$geomesa$convert$IdFunctionFactory$MD5$$$outer() {
            return IdFunctionFactory.this;
        }

        public MD5() {
            if (IdFunctionFactory.this == null) {
                throw null;
            }
            TransformerFn$class.$init$(this);
            this.names = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"md5"}));
            this.hasher = Hashing.md5();
        }
    }

    public class Murmur3_32
    implements TransformerFn {
        private final HashFunction hasher;
        private final Seq<String> names;

        @Override
        public TransformerFn getInstance() {
            return TransformerFn$class.getInstance(this);
        }

        private HashFunction hasher() {
            return this.hasher;
        }

        @Override
        public Seq<String> names() {
            return this.names;
        }

        @Override
        public Object eval(Object[] args, EvaluationContext ctx) {
            return this.hasher().hashString((CharSequence)args[0].toString(), StandardCharsets.UTF_8);
        }

        public /* synthetic */ IdFunctionFactory org$locationtech$geomesa$convert$IdFunctionFactory$Murmur3_32$$$outer() {
            return IdFunctionFactory.this;
        }

        public Murmur3_32() {
            if (IdFunctionFactory.this == null) {
                throw null;
            }
            TransformerFn$class.$init$(this);
            this.hasher = Hashing.murmur3_32();
            this.names = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"murmur3_32"}));
        }
    }

    public class Murmur3_64
    implements TransformerFn {
        private final HashFunction hasher;
        private final Seq<String> names;

        @Override
        public TransformerFn getInstance() {
            return TransformerFn$class.getInstance(this);
        }

        private HashFunction hasher() {
            return this.hasher;
        }

        @Override
        public Seq<String> names() {
            return this.names;
        }

        @Override
        public Object eval(Object[] args, EvaluationContext ctx) {
            return BoxesRunTime.boxToLong((long)this.hasher().hashString((CharSequence)args[0].toString(), StandardCharsets.UTF_8).asLong());
        }

        public /* synthetic */ IdFunctionFactory org$locationtech$geomesa$convert$IdFunctionFactory$Murmur3_64$$$outer() {
            return IdFunctionFactory.this;
        }

        public Murmur3_64() {
            if (IdFunctionFactory.this == null) {
                throw null;
            }
            TransformerFn$class.$init$(this);
            this.hasher = Hashing.murmur3_128();
            this.names = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"murmur3_64"}));
        }
    }
}

