/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.ortholine;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import java.util.Map;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.grid.GridElement;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.ortholine.LineOrientation;
import org.geotools.grid.ortholine.OrthoLine;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OrthoLineFeatureBuilder
extends GridFeatureBuilder {
    public static final String DEFAULT_TYPE_NAME = "linegrid";
    public static final String ID_ATTRIBUTE_NAME = "id";
    public static final String LEVEL_ATTRIBUTE_NAME = "level";
    public static final String VALUE_ATTRIBUTE_NAME = "value";
    protected int id = 0;

    protected static SimpleFeatureType createType(String typeName, CoordinateReferenceSystem crs) {
        String finalName = typeName != null && typeName.trim().length() > 0 ? typeName : DEFAULT_TYPE_NAME;
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(finalName);
        tb.add("element", LineString.class, crs);
        tb.add(ID_ATTRIBUTE_NAME, Integer.class);
        tb.add(VALUE_ATTRIBUTE_NAME, Object.class);
        tb.add(LEVEL_ATTRIBUTE_NAME, Integer.class);
        return tb.buildFeatureType();
    }

    public OrthoLineFeatureBuilder() {
        this(DEFAULT_TYPE_NAME, null);
    }

    OrthoLineFeatureBuilder(String typeName) {
        this(typeName, null);
    }

    public OrthoLineFeatureBuilder(CoordinateReferenceSystem crs) {
        this(DEFAULT_TYPE_NAME, crs);
    }

    public OrthoLineFeatureBuilder(String typeName, CoordinateReferenceSystem crs) {
        super(OrthoLineFeatureBuilder.createType(typeName, crs));
    }

    @Override
    public void setAttributes(GridElement el, Map<String, Object> attributes) {
        if (!(el instanceof OrthoLine)) {
            throw new IllegalArgumentException("Expected an instance of OrthoLine");
        }
        OrthoLine orthoLine = (OrthoLine)el;
        attributes.put(ID_ATTRIBUTE_NAME, ++this.id);
        attributes.put(LEVEL_ATTRIBUTE_NAME, orthoLine.getLevel());
        Coordinate v0 = orthoLine.getVertices()[0];
        Double value = null;
        value = orthoLine.getOrientation() == LineOrientation.HORIZONTAL ? Double.valueOf(v0.y) : Double.valueOf(v0.x);
        attributes.put(VALUE_ATTRIBUTE_NAME, value);
    }
}

