/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.filter.index;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.index.SpatialIndexSupport;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Or;
import org.opengis.filter.spatial.BinarySpatialOperator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;

public abstract class SpatialIndexSupport$class {
    public static Iterator query(SpatialIndexSupport $this, Filter filter) {
        Iterator<SimpleFeature> iterator;
        Filter filter2 = filter;
        if (filter2 instanceof IncludeFilter) {
            iterator = $this.include();
        } else if (filter2 instanceof BinarySpatialOperator) {
            BinarySpatialOperator binarySpatialOperator = (BinarySpatialOperator)filter2;
            iterator = $this.spatial(binarySpatialOperator);
        } else if (filter2 instanceof And) {
            And and2 = (And)filter2;
            iterator = $this.and(and2);
        } else if (filter2 instanceof Or) {
            Or or2 = (Or)filter2;
            iterator = $this.or(or2);
        } else {
            iterator = $this.unoptimized(filter2);
        }
        return iterator;
    }

    public static Iterator include(SpatialIndexSupport $this) {
        return $this.allFeatures();
    }

    public static Iterator spatial(SpatialIndexSupport $this, BinarySpatialOperator f) {
        Iterator iterator;
        FilterValues<Geometry> geometries = FilterHelper$.MODULE$.extractGeometries((Filter)f, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType($this.sft())), false);
        if (geometries.isEmpty()) {
            iterator = $this.unoptimized((Filter)f);
        } else {
            Envelope envelope = ((Geometry)geometries.values().head()).getEnvelopeInternal();
            ((IterableLike)geometries.values().tail()).foreach((Function1)new Serializable($this, envelope){
                public static final long serialVersionUID = 0L;
                private final Envelope envelope$1;

                public final void apply(Geometry g) {
                    this.envelope$1.expandToInclude(g.getEnvelopeInternal());
                }
                {
                    this.envelope$1 = envelope$1;
                }
            });
            iterator = $this.spatialIndex().query(envelope, (Function1)new Serializable($this, f){
                public static final long serialVersionUID = 0L;
                private final BinarySpatialOperator f$1;

                public final boolean apply(Object x$1) {
                    return this.f$1.evaluate(x$1);
                }
                {
                    this.f$1 = f$1;
                }
            });
        }
        return iterator;
    }

    public static Iterator and(SpatialIndexSupport $this, And a) {
        Iterator iterator;
        FilterValues<Geometry> geometries = FilterHelper$.MODULE$.extractGeometries((Filter)a, $this.sft().getGeometryDescriptor().getLocalName(), false);
        if (geometries.isEmpty()) {
            iterator = $this.unoptimized((Filter)a);
        } else {
            Envelope envelope = ((Geometry)geometries.values().head()).getEnvelopeInternal();
            ((IterableLike)geometries.values().tail()).foreach((Function1)new Serializable($this, envelope){
                public static final long serialVersionUID = 0L;
                private final Envelope envelope$2;

                public final void apply(Geometry g) {
                    this.envelope$2.expandToInclude(g.getEnvelopeInternal());
                }
                {
                    this.envelope$2 = envelope$2;
                }
            });
            iterator = $this.spatialIndex().query(envelope, (Function1)new Serializable($this, a){
                public static final long serialVersionUID = 0L;
                private final And a$1;

                public final boolean apply(Object x$1) {
                    return this.a$1.evaluate(x$1);
                }
                {
                    this.a$1 = a$1;
                }
            });
        }
        return iterator;
    }

    public static Iterator or(SpatialIndexSupport $this, Or o) {
        return (Iterator)((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(o.getChildren()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialIndexSupport $outer;

            public final Iterator<SimpleFeature> apply(Filter filter) {
                return this.$outer.query(filter);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom())).reduceLeft((Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Iterator<SimpleFeature> apply(Iterator<SimpleFeature> x$1, Iterator<SimpleFeature> x$2) {
                return x$1.$plus$plus((Function0)new Serializable(this, x$2){
                    public static final long serialVersionUID = 0L;
                    private final Iterator x$2$1;

                    public final Iterator<SimpleFeature> apply() {
                        return this.x$2$1;
                    }
                    {
                        this.x$2$1 = x$2$1;
                    }
                });
            }
        });
    }

    public static Iterator unoptimized(SpatialIndexSupport $this, Filter f) {
        return $this.include().filter((Function1)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Filter f$2;

            public final boolean apply(Object x$1) {
                return this.f$2.evaluate(x$1);
            }
            {
                this.f$2 = f$2;
            }
        });
    }

    public static void $init$(SpatialIndexSupport $this) {
    }
}

