/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.util.Converters;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.tools.utils.DataFormats$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.converters.StringCollectionConverterFactory$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class AutoIngestDelimited$ {
    public static final AutoIngestDelimited$ MODULE$;
    private final String FormatConfig;
    private final String TypeNameConfig;

    static {
        new AutoIngestDelimited$();
    }

    public String FormatConfig() {
        return this.FormatConfig;
    }

    public String TypeNameConfig() {
        return this.TypeNameConfig;
    }

    public CSVFormat getCsvFormat(Enumeration.Value format) {
        Enumeration.Value value;
        block4: {
            CSVFormat cSVFormat;
            block3: {
                block2: {
                    value = format;
                    Enumeration.Value value2 = DataFormats$.MODULE$.Csv();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    cSVFormat = CSVFormat.DEFAULT.withQuoteMode(QuoteMode.MINIMAL);
                    break block3;
                }
                Enumeration.Value value4 = DataFormats$.MODULE$.Tsv();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                cSVFormat = CSVFormat.TDF.withQuoteMode(QuoteMode.MINIMAL);
            }
            return cSVFormat;
        }
        throw new MatchError((Object)value);
    }

    public Tuple2<SimpleFeatureType, Iterator<SimpleFeature>> createSimpleFeatures(String typeName, Iterator<CSVRecord> iter) {
        CSVRecord header = (CSVRecord)iter.next();
        String string = header.get(0);
        String string2 = "id";
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Badly formatted file detected - expected header row with attributes";
            }
        });
        String sftString = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), header.size()).map((Function1)new Serializable(header){
            public static final long serialVersionUID = 0L;
            private final CSVRecord header$1;

            public final String apply(int x$1) {
                return this.header$1.get(x$1);
            }
            {
                this.header$1 = header$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(",");
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(typeName, sftString);
        Tuple2[] converters = (Tuple2[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<Class<Object>, Hints> apply(AttributeDescriptor ad) {
                Object object;
                Hints hints2 = GeoTools.getDefaultHints();
                if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad))) {
                    object = hints2.put((Object)StringCollectionConverterFactory$.MODULE$.ListTypeKey(), (Object)RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad)));
                    return new Tuple2((Object)ad.getType().getBinding(), (Object)hints2);
                } else if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad))) {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getMapTypes$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(ad));
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    Class k = (Class)tuple22._1();
                    Class v = (Class)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)k, (Object)v);
                    Class k2 = (Class)tuple23._1();
                    Class v2 = (Class)tuple23._2();
                    hints2.put((Object)StringCollectionConverterFactory$.MODULE$.MapKeyTypeKey(), (Object)k2);
                    object = hints2.put((Object)StringCollectionConverterFactory$.MODULE$.MapValueTypeKey(), (Object)v2);
                    return new Tuple2((Object)ad.getType().getBinding(), (Object)hints2);
                } else {
                    object = BoxedUnit.UNIT;
                }
                return new Tuple2((Object)ad.getType().getBinding(), (Object)hints2);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        Iterator features = iter.map((Function1)new Serializable(sft, converters){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final Tuple2[] converters$1;

            public final ScalaSimpleFeature apply(CSVRecord record) {
                Object[] attributes = (Object[])Array$.MODULE$.ofDim(this.sft$1.getAttributeCount(), ClassTag$.MODULE$.AnyRef());
                for (int i = 1; i < record.size(); ++i) {
                    Tuple2 tuple2 = this.converters$1[i - 1];
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Class clas = (Class)tuple2._1();
                        Hints hints2 = (Hints)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)clas, (Object)hints2);
                        Class clas2 = (Class)tuple23._1();
                        Hints hints3 = (Hints)tuple23._2();
                        attributes[i - 1] = Converters.convert((Object)record.get(i), (Class)clas2, (Hints)hints3);
                        continue;
                    }
                    throw new MatchError((Object)tuple2);
                }
                return new ScalaSimpleFeature(this.sft$1, record.get(0), attributes, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
            }
            {
                this.sft$1 = sft$1;
                this.converters$1 = converters$1;
            }
        });
        return new Tuple2((Object)sft, (Object)features);
    }

    private AutoIngestDelimited$() {
        MODULE$ = this;
        this.FormatConfig = "org.locationtech.geomesa.jobs.input.delimited.format";
        this.TypeNameConfig = "org.locationtech.geomesa.jobs.input.delimited.typeName";
    }
}

