/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.ingest.AutoIngest;
import org.locationtech.geomesa.tools.ingest.ConverterIngest;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.tools.ingest.ShapefileIngest;
import org.locationtech.geomesa.tools.utils.CLArgResolver$;
import org.locationtech.geomesa.tools.utils.DataFormats$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;
import scala.util.Try$;

public abstract class IngestCommand$class {
    public static void execute(IngestCommand $this) {
        Runnable runnable;
        $this.ensureSameFs((Seq<String>)PathUtils$.MODULE$.RemotePrefixes());
        Enumeration.Value value = $this.params().fmt();
        Enumeration.Value value2 = DataFormats$.MODULE$.Shp();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            runnable = $this.createShpIngest();
        } else if ($this.params().spec() == null && $this.params().config() == null && ((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DataFormats$.MODULE$.Csv(), DataFormats$.MODULE$.Tsv(), DataFormats$.MODULE$.Avro()}))).contains((Object)$this.params().fmt())) {
            if ($this.params().featureName() == null) {
                throw new ParameterException("Feature name is required when a schema is not specified");
            }
            Command$.MODULE$.user().info("No schema or converter defined - will attempt to detect schema from input files");
            runnable = $this.createAutoIngest();
        } else {
            SimpleFeatureType simpleFeatureType;
            if ($this.params().config() == null) {
                throw new ParameterException("Converter Config argument is required");
            }
            Config converterConfig = CLArgResolver$.MODULE$.getConfig($this.params().config());
            if ($this.params().spec() == null) {
                if ($this.params().featureName() == null) {
                    throw new ParameterException("SimpleFeatureType name and/or specification argument is required");
                }
                simpleFeatureType = (SimpleFeatureType)Try$.MODULE$.apply((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IngestCommand $outer;

                    public final SimpleFeatureType apply() {
                        return (SimpleFeatureType)this.$outer.withDataStore(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ IngestCommand$.anonfun.1 $outer;

                            public final SimpleFeatureType apply(DS x$1) {
                                return x$1.getSchema(this.$outer.org$locationtech$geomesa$tools$ingest$IngestCommand$$anonfun$$$outer().params().featureName());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ IngestCommand org$locationtech$geomesa$tools$ingest$IngestCommand$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).filter((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(SimpleFeatureType x$2) {
                        return x$2 != null;
                    }
                }).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IngestCommand $outer;

                    public final Nothing$ apply() {
                        throw new ParameterException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SimpleFeatureType '", "' does not currently exist, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params().featureName()}))).append((Object)"please provide specification argument").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            } else {
                simpleFeatureType = CLArgResolver$.MODULE$.getSft($this.params().spec(), $this.params().featureName());
            }
            SimpleFeatureType sft = simpleFeatureType;
            runnable = $this.createConverterIngest(sft, converterConfig);
        }
        Runnable ingest = runnable;
        ingest.run();
    }

    public static Runnable createConverterIngest(IngestCommand $this, SimpleFeatureType sft, Config converterConfig) {
        return new ConverterIngest(sft, $this.connection(), converterConfig, (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer($this.params().files()), (Option<Enumeration.Value>)Option$.MODULE$.apply((Object)$this.params().mode()), $this.libjarsFile(), $this.libjarsPaths(), Predef$.MODULE$.Integer2int($this.params().threads()));
    }

    public static Runnable createAutoIngest(IngestCommand $this) {
        return new AutoIngest($this.params().featureName(), $this.connection(), (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer($this.params().files()), $this.params().fmt(), (Option<Enumeration.Value>)Option$.MODULE$.apply((Object)$this.params().mode()), $this.libjarsFile(), $this.libjarsPaths(), Predef$.MODULE$.Integer2int($this.params().threads()));
    }

    public static Runnable createShpIngest(IngestCommand $this) {
        return new ShapefileIngest(JavaConversions$.MODULE$.mapAsJavaMap($this.connection()), (Option<String>)Option$.MODULE$.apply((Object)$this.params().featureName()), (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer($this.params().files()), Predef$.MODULE$.Integer2int($this.params().threads()));
    }

    public static void ensureSameFs(IngestCommand $this, Seq prefixes) {
        prefixes.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IngestCommand $outer;

            public final void apply(String pre) {
                if (JavaConversions$.MODULE$.asScalaBuffer(this.$outer.params().files()).exists((Function1)new Serializable(this, pre){
                    public static final long serialVersionUID = 0L;
                    private final String pre$1;

                    public final boolean apply(String x$3) {
                        return x$3.toLowerCase().startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pre$1})));
                    }
                    {
                        this.pre$1 = pre$1;
                    }
                }) && !JavaConversions$.MODULE$.asScalaBuffer(this.$outer.params().files()).forall((Function1)new Serializable(this, pre){
                    public static final long serialVersionUID = 0L;
                    private final String pre$1;

                    public final boolean apply(String x$4) {
                        return x$4.toLowerCase().startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pre$1})));
                    }
                    {
                        this.pre$1 = pre$1;
                    }
                })) {
                    throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files must all be on the same file system: (", ") or all be local"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pre})));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void $init$(IngestCommand $this) {
        $this.org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq("ingest");
    }
}

