/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.factory.Hints;
import org.geotools.image.ImageWorker;

public enum FootprintBehavior {
    None(false),
    Cut(true),
    Transparent(true){

        @Override
        public RenderedImage postProcessMosaic(RenderedImage mosaic, ROI overallROI, RenderingHints hints) {
            ImageWorker imageWorker = new ImageWorker(mosaic);
            hints = this.prepareHints(hints);
            imageWorker.setRenderingHints(hints);
            if (!imageWorker.isColorSpaceGRAYScale() && !imageWorker.isColorSpaceRGB()) {
                imageWorker.forceColorSpaceRGB();
            }
            imageWorker.forceComponentColorModel();
            if (imageWorker.getRenderedImage().getColorModel().hasAlpha()) {
                RenderedImage alpha = new ImageWorker(imageWorker.getRenderedImage()).retainLastBand().getRenderedImage();
                RenderedImage maskedAlpha = new ImageWorker(hints).mosaic(new RenderedImage[]{alpha}, MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, new ROI[]{overallROI}, null, null).getRenderedImage();
                imageWorker.retainBands(mosaic.getColorModel().getNumColorComponents());
                imageWorker.addBand(maskedAlpha, false, true, null);
            } else {
                ImageWorker roiImageWorker = new ImageWorker((RenderedImage)overallROI.getAsImage());
                roiImageWorker.setRenderingHints(hints);
                PlanarImage alpha = roiImageWorker.forceComponentColorModel().retainFirstBand().getPlanarImage();
                if (!alpha.getBounds().equals(imageWorker.getPlanarImage().getBounds())) {
                    ImageLayout layout = new ImageLayout(mosaic.getMinX(), mosaic.getMinY(), mosaic.getWidth(), mosaic.getHeight());
                    SampleModel sampleModel = mosaic.getSampleModel();
                    layout.setTileHeight(sampleModel.getWidth()).setTileWidth(sampleModel.getHeight());
                    hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
                    alpha = new ImageWorker(hints).mosaic(new RenderedImage[]{alpha}, MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, new ROI[]{overallROI}, null, null).getRenderedOperation();
                }
                imageWorker.addBand((RenderedImage)alpha, false, true, null);
            }
            RenderedImage result = imageWorker.getRenderedImage();
            return result;
        }

        private RenderingHints prepareHints(RenderingHints hints) {
            hints = hints == null ? new Hints() : (RenderingHints)hints.clone();
            hints.remove(JAI.KEY_IMAGE_LAYOUT);
            return hints;
        }

        @Override
        public RenderedImage postProcessBlankResponse(RenderedImage finalImage, RenderingHints hints) {
            ImageWorker imageWorker = new ImageWorker(finalImage);
            hints = this.prepareHints(hints);
            imageWorker.setRenderingHints(hints);
            if (!imageWorker.isColorSpaceGRAYScale() && !imageWorker.isColorSpaceRGB()) {
                imageWorker.forceColorSpaceRGB();
            }
            imageWorker.forceComponentColorModel();
            if (!imageWorker.getRenderedImage().getColorModel().hasAlpha()) {
                ImageWorker imageWorker2 = new ImageWorker(finalImage);
                imageWorker2.setRenderingHints(hints);
                RenderedImage alpha = imageWorker2.retainFirstBand().multiplyConst(new double[]{0.0}).getRenderedImage();
                imageWorker2.dispose();
                imageWorker.addBand(alpha, false, true, null);
            }
            RenderedImage result = imageWorker.getRenderedImage();
            imageWorker.dispose();
            return result;
        }
    };

    private boolean handleFootprints;

    private FootprintBehavior(boolean handleFootprints) {
        this.handleFootprints = handleFootprints;
    }

    public boolean handleFootprints() {
        return this.handleFootprints;
    }

    public static FootprintBehavior getDefault() {
        return None;
    }

    public static String[] valuesAsStrings() {
        FootprintBehavior[] values = FootprintBehavior.values();
        String[] valuesS = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            valuesS[i] = values[i].toString();
        }
        return null;
    }

    public RenderedImage postProcessMosaic(RenderedImage mosaic, ROI overallROI, RenderingHints hints) {
        return mosaic;
    }

    public RenderedImage postProcessBlankResponse(RenderedImage finalImage, RenderingHints hints) {
        return finalImage;
    }
}

