/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.conf;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public final class ConfigLoader$
implements LazyLogging {
    public static final ConfigLoader$ MODULE$;
    private final String GEOMESA_CONFIG_FILE_PROP;
    private final String GEOMESA_CONFIG_FILE_NAME;
    private final String EmbeddedConfigFile;
    private Map<String, Tuple2<String, Object>> Config;
    private final Logger logger;
    private volatile byte bitmap$0;

    static {
        new ConfigLoader$();
    }

    private Map Config$lzycompute() {
        ConfigLoader$ configLoader$ = this;
        synchronized (configLoader$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String file = (String)Option$.MODULE$.apply((Object)System.getProperty(this.GEOMESA_CONFIG_FILE_PROP())).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return ConfigLoader$.MODULE$.GEOMESA_CONFIG_FILE_NAME();
                    }
                });
                this.Config = this.loadConfig(this.EmbeddedConfigFile()).$plus$plus(this.loadConfig(file));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
            this.EmbeddedConfigFile = null;
            return this.Config;
        }
    }

    private Logger logger$lzycompute() {
        ConfigLoader$ configLoader$ = this;
        synchronized (configLoader$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String GEOMESA_CONFIG_FILE_PROP() {
        return this.GEOMESA_CONFIG_FILE_PROP;
    }

    public String GEOMESA_CONFIG_FILE_NAME() {
        return this.GEOMESA_CONFIG_FILE_NAME;
    }

    private String EmbeddedConfigFile() {
        return this.EmbeddedConfigFile;
    }

    public Map<String, Tuple2<String, Object>> Config() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.Config$lzycompute() : this.Config;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Tuple2<String, Object>> loadConfig(String path) {
        void var3_8;
        BoxedUnit boxedUnit;
        Map config;
        Map map2;
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(path);
        if (input == null) {
            map2 = Predef$.MODULE$.Map().empty();
        } else {
            try {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading config: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                map2 = this.loadConfig(input, path);
            }
            catch (Throwable throwable) {
                Map map3;
                BoxedUnit boxedUnit3;
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option2.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading config file at: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), e);
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                map2 = config = (map3 = Predef$.MODULE$.Map().empty());
            }
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.mkString(",")})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_8;
    }

    public Map<String, Tuple2<String, Object>> loadConfig(InputStream input, String path) {
        Elem xml = (Elem)XML$.MODULE$.load(input);
        NodeSeq properties = xml.$bslash$bslash("configuration").$bslash$bslash("property");
        return ((TraversableOnce)properties.flatMap((Function1)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final Iterable<Tuple2<String, Tuple2<String, Object>>> apply(Node prop) {
                Try pair = Try$.MODULE$.apply((Function0)new Serializable(this, prop){
                    public static final long serialVersionUID = 0L;
                    private final Node prop$1;

                    public final Tuple2<String, Tuple2<String, Object>> apply() {
                        String key2 = this.prop$1.$bslash("name").text();
                        String value2 = this.prop$1.$bslash("value").text();
                        boolean isFinal = new StringOps(Predef$.MODULE$.augmentString(this.prop$1.$bslash("final").text().toString())).toBoolean();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key2), (Object)new Tuple2((Object)value2, (Object)BoxesRunTime.boxToBoolean((boolean)isFinal)));
                    }
                    {
                        this.prop$1 = prop$1;
                    }
                });
                Try try_ = pair;
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (ConfigLoader$.MODULE$.logger().underlying().isWarnEnabled()) {
                        ConfigLoader$.MODULE$.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load property from: ", "\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, prop})), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return Option$.MODULE$.option2Iterable(pair.toOption().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, Tuple2<String, Object>> x0$1) {
                        Tuple2 tuple2;
                        Tuple2<String, Tuple2<String, Object>> tuple22 = x0$1;
                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                            String v = (String)tuple2._1();
                            boolean bl = v != null && new StringOps(Predef$.MODULE$.augmentString(v)).nonEmpty();
                            return bl;
                        }
                        throw new MatchError(tuple22);
                    }
                }));
            }
            {
                this.path$1 = path$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private ConfigLoader$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.GEOMESA_CONFIG_FILE_PROP = "geomesa.config.file";
        this.GEOMESA_CONFIG_FILE_NAME = "geomesa-site.xml";
        this.EmbeddedConfigFile = "org/locationtech/geomesa/geomesa-site.xml.template";
    }
}

