/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.io;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2Utils;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZUtils;
import org.locationtech.geomesa.utils.io.PathUtils;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.HadoopDelegate;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.util.Try$;

public final class PathUtils$
implements FileSystemDelegate {
    public static final PathUtils$ MODULE$;
    private final Pattern uriRegex;
    private final boolean hadoopAvailable;
    private final LocalDelegate localDelegate;
    private final HadoopDelegate hadoopDelegate;
    private final Seq<String> RemotePrefixes;

    static {
        new PathUtils$();
    }

    private Pattern uriRegex() {
        return this.uriRegex;
    }

    private boolean hadoopAvailable() {
        return this.hadoopAvailable;
    }

    private LocalDelegate localDelegate() {
        return this.localDelegate;
    }

    private HadoopDelegate hadoopDelegate() {
        return this.hadoopDelegate;
    }

    public Seq<String> RemotePrefixes() {
        return this.RemotePrefixes;
    }

    public boolean isRemote(String path) {
        String string2 = path.toLowerCase(Locale.US);
        return this.RemotePrefixes().exists((Function1)new Serializable(string2){
            public static final long serialVersionUID = 0L;
            private final String eta$0$1$1;

            public final boolean apply(String x$1) {
                return this.eta$0$1$1.startsWith(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    @Override
    public Seq<FileSystemDelegate.FileHandle> interpretPath(String path) {
        return this.chooseDelegate(path).interpretPath(path);
    }

    public InputStream handleCompression(InputStream is, String filename) {
        return GzipUtils.isCompressedFilename((String)filename) ? new GZIPInputStream(new BufferedInputStream(is)) : (BZip2Utils.isCompressedFilename((String)filename) ? new BZip2CompressorInputStream((InputStream)new BufferedInputStream(is)) : (XZUtils.isCompressedFilename((String)filename) ? new XZCompressorInputStream((InputStream)new BufferedInputStream(is)) : new BufferedInputStream(is)));
    }

    public void deleteRecursively(Path f) {
        Files.walkFileTree(f, new PathUtils.DeleteFileVisitor());
    }

    private FileSystemDelegate chooseDelegate(String path) {
        return this.hadoopAvailable() && this.uriRegex().matcher(path).matches() ? this.hadoopDelegate() : this.localDelegate();
    }

    private PathUtils$() {
        MODULE$ = this;
        this.uriRegex = Pattern.compile("\\w+://.*");
        this.hadoopAvailable = Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<Object> apply() {
                return Class.forName("org.apache.hadoop.conf.Configuration");
            }
        }).isSuccess();
        this.localDelegate = new LocalDelegate();
        this.hadoopDelegate = this.hadoopAvailable() ? new HadoopDelegate() : null;
        InputStream is = this.getClass().getResourceAsStream("remote-prefixes.list");
        this.RemotePrefixes = (Seq)WithClose$.MODULE$.apply(Source$.MODULE$.fromInputStream(is, StandardCharsets.UTF_8.displayName()), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(BufferedSource source) {
                return source.getLines().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String s) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.toLowerCase(Locale.US)}));
                    }
                }).toList();
            }
        });
    }
}

