/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.TransformerFn;
import org.locationtech.geomesa.convert.TransformerFn$;
import org.locationtech.geomesa.convert.TransformerFn$class;
import org.locationtech.geomesa.convert.TransformerFunctionFactory;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001-\u0011qcR3p[\u0016$(/\u001f$v]\u000e$\u0018n\u001c8GC\u000e$xN]=\u000b\u0005\r!\u0011aB2p]Z,'\u000f\u001e\u0006\u0003\u000b\u0019\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\b\u0011\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005i!&/\u00198tM>\u0014X.\u001a:Gk:\u001cG/[8o\r\u0006\u001cGo\u001c:z\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0014\u0001!)1\u0004\u0001C!9\u0005Ia-\u001e8di&|gn]\u000b\u0002;A\u0019a$I\u0012\u000e\u0003}Q!\u0001\t\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002#?\t\u00191+Z9\u0013\u0007\u0011R#G\u0002\u0003&\u0001\u0001\u0019#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014BA\u0014)\u0003\u0015\t\u0007\u000f\u001d7z\u0015\tI#!A\u0007Ue\u0006t7OZ8s[\u0016\u0014hI\u001c\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nA\u0001\\1oO*\tq&\u0001\u0003kCZ\f\u0017BA\u0019-\u0005\u0019y%M[3diB\u00111cM\u0005\u0003i\t\u0011Q\u0002\u0016:b]N4wN]7fe\u001as\u0007b\u0002\u001c\u0001\u0005\u0004%IaN\u0001\u0003O\u001a,\u0012\u0001\u000f\t\u0003s\tk\u0011A\u000f\u0006\u0003wq\nAaZ3p[*\u0011QHP\u0001\u0004UR\u001c(BA A\u000391\u0018N^5eg>dW\u000f^5p]NT\u0011!Q\u0001\u0004G>l\u0017BA\";\u0005=9Um\\7fiJLh)Y2u_JL\bBB#\u0001A\u0003%\u0001(A\u0002hM\u0002Bqa\u0012\u0001C\u0002\u0013\u0005\u0001*A\u0007q_&tG\u000fU1sg\u0016\u0014hI\\\u000b\u0002\u0013J\u0019!\n\u0004\u001a\u0007\t\u0015\u0002\u0001!\u0013\u0005\u0007\u0019\u0002\u0001\u000b\u0011B%\u0002\u001dA|\u0017N\u001c;QCJ\u001cXM\u001d$oA!9a\n\u0001b\u0001\n\u0003A\u0015AE7vYRL\u0007k\\5oiB\u000b'o]3s\r:Da\u0001\u0015\u0001!\u0002\u0013I\u0015aE7vYRL\u0007k\\5oiB\u000b'o]3s\r:\u0004\u0003b\u0002*\u0001\u0005\u0004%\t\u0001S\u0001\u0013Y&tWm\u0015;sS:<\u0007+\u0019:tKJ4e\u000e\u0003\u0004U\u0001\u0001\u0006I!S\u0001\u0014Y&tWm\u0015;sS:<\u0007+\u0019:tKJ4e\u000e\t\u0005\b-\u0002\u0011\r\u0011\"\u0001I\u0003]iW\u000f\u001c;j\u0019&tWm\u0015;sS:<\u0007+\u0019:tKJ4e\u000e\u0003\u0004Y\u0001\u0001\u0006I!S\u0001\u0019[VdG/\u001b'j]\u0016\u001cFO]5oOB\u000b'o]3s\r:\u0004\u0003b\u0002.\u0001\u0005\u0004%\t\u0001S\u0001\u0010a>d\u0017pZ8o!\u0006\u00148/\u001a:G]\"1A\f\u0001Q\u0001\n%\u000b\u0001\u0003]8ms\u001e|g\u000eU1sg\u0016\u0014hI\u001c\u0011\t\u000fy\u0003!\u0019!C\u0001\u0011\u0006!R.\u001e7uSB{G._4p]B\u000b'o]3s\r:Da\u0001\u0019\u0001!\u0002\u0013I\u0015!F7vYRL\u0007k\u001c7zO>t\u0007+\u0019:tKJ4e\u000e\t\u0005\bE\u0002\u0011\r\u0011\"\u0001I\u0003A9Wm\\7fiJL\b+\u0019:tKJ4e\u000e\u0003\u0004e\u0001\u0001\u0006I!S\u0001\u0012O\u0016|W.\u001a;ssB\u000b'o]3s\r:\u0004\u0003b\u00024\u0001\u0005\u0004%\t\u0001S\u0001\u001bO\u0016|W.\u001a;ss\u000e{G\u000e\\3di&|g\u000eU1sg\u0016\u0014hI\u001c\u0005\u0007Q\u0002\u0001\u000b\u0011B%\u00027\u001d,w.\\3uef\u001cu\u000e\u001c7fGRLwN\u001c)beN,'O\u00128!\u0011\u001dQ\u0007A1A\u0005\u0002-\f1\u0003\u001d:pU\u0016\u001cGO\u0012:p[B\u000b'o]3s\r:,\u0012\u0001\u001c\n\u0004[2\u0011d\u0001B\u0013o\u00011Daa\u001c\u0001!\u0002\u0013a\u0017\u0001\u00069s_*,7\r\u001e$s_6\u0004\u0016M]:fe\u001as\u0007\u0005C\u0004r[\n\u0007I\u0011\t:\u0002\u000b9\fW.Z:\u0016\u0003M\u00042\u0001\u001e?\u007f\u001d\t)(P\u0004\u0002ws6\tqO\u0003\u0002y\u0015\u00051AH]8pizJ\u0011aD\u0005\u0003w:\tq\u0001]1dW\u0006<W-\u0003\u0002#{*\u00111P\u0004\t\u0004\u007f\u0006\u0015abA\u0007\u0002\u0002%\u0019\u00111\u0001\b\u0002\rA\u0013X\rZ3g\u0013\u0011\t9!!\u0003\u0003\rM#(/\u001b8h\u0015\r\t\u0019A\u0004")
public class GeometryFunctionFactory
implements TransformerFunctionFactory {
    private final GeometryFactory org$locationtech$geomesa$convert$GeometryFunctionFactory$$gf = JTSFactoryFinder.getGeometryFactory();
    private final TransformerFn pointParserFn = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ GeometryFunctionFactory $outer;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final Object apply(Object[] args) {
            Point point;
            int n = args.length;
            switch (n) {
                default: {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid point conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)args).toList()})));
                }
                case 2: {
                    point = this.$outer.org$locationtech$geomesa$convert$GeometryFunctionFactory$$gf().createPoint(new Coordinate(BoxesRunTime.unboxToDouble((Object)args[0]), BoxesRunTime.unboxToDouble((Object)args[1])));
                    return point;
                }
                case 1: {
                    Point point2;
                    Object object = args[0];
                    if (object instanceof Geometry) {
                        Geometry geometry = (Geometry)object;
                        point2 = (Point)geometry;
                    } else {
                        if (!(object instanceof String)) throw new MatchError(object);
                        String string2 = (String)object;
                        point2 = (Point)WKTUtils$.MODULE$.read(string2);
                    }
                    point = point2;
                }
            }
            return point;
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    });
    private final TransformerFn multiPointParserFn = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multipoint"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            block4: {
                MultiPoint multiPoint;
                block3: {
                    Object object;
                    block2: {
                        object = args[0];
                        if (!(object instanceof Geometry)) break block2;
                        Geometry geometry = (Geometry)object;
                        multiPoint = (MultiPoint)geometry;
                        break block3;
                    }
                    if (!(object instanceof String)) break block4;
                    String string2 = (String)object;
                    multiPoint = (MultiPoint)WKTUtils$.MODULE$.read(string2);
                }
                return multiPoint;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid multipoint conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)args).toList()})));
        }
    });
    private final TransformerFn lineStringParserFn = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linestring"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            block4: {
                LineString lineString;
                block3: {
                    Object object;
                    block2: {
                        object = args[0];
                        if (!(object instanceof Geometry)) break block2;
                        Geometry geometry = (Geometry)object;
                        lineString = (LineString)geometry;
                        break block3;
                    }
                    if (!(object instanceof String)) break block4;
                    String string2 = (String)object;
                    lineString = (LineString)WKTUtils$.MODULE$.read(string2);
                }
                return lineString;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid linestring conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)args).toList()})));
        }
    });
    private final TransformerFn multiLineStringParserFn = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multilinestring"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            block4: {
                MultiLineString multiLineString;
                block3: {
                    Object object;
                    block2: {
                        object = args[0];
                        if (!(object instanceof Geometry)) break block2;
                        Geometry geometry = (Geometry)object;
                        multiLineString = (MultiLineString)geometry;
                        break block3;
                    }
                    if (!(object instanceof String)) break block4;
                    String string2 = (String)object;
                    multiLineString = (MultiLineString)WKTUtils$.MODULE$.read(string2);
                }
                return multiLineString;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid multilinestring conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)args).toList()})));
        }
    });
    private final TransformerFn polygonParserFn = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"polygon"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            block4: {
                Polygon polygon;
                block3: {
                    Object object;
                    block2: {
                        object = args[0];
                        if (!(object instanceof Geometry)) break block2;
                        Geometry geometry = (Geometry)object;
                        polygon = (Polygon)geometry;
                        break block3;
                    }
                    if (!(object instanceof String)) break block4;
                    String string2 = (String)object;
                    polygon = (Polygon)WKTUtils$.MODULE$.read(string2);
                }
                return polygon;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid polygon conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)args).toList()})));
        }
    });
    private final TransformerFn multiPolygonParserFn = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multipolygon"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            block4: {
                MultiPolygon multiPolygon;
                block3: {
                    Object object;
                    block2: {
                        object = args[0];
                        if (!(object instanceof Geometry)) break block2;
                        Geometry geometry = (Geometry)object;
                        multiPolygon = (MultiPolygon)geometry;
                        break block3;
                    }
                    if (!(object instanceof String)) break block4;
                    String string2 = (String)object;
                    multiPolygon = (MultiPolygon)WKTUtils$.MODULE$.read(string2);
                }
                return multiPolygon;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid multipolygon conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)args).toList()})));
        }
    });
    private final TransformerFn geometryParserFn = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"geometry"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            block4: {
                Geometry geometry;
                block3: {
                    Object object;
                    block2: {
                        Geometry geometry2;
                        object = args[0];
                        if (!(object instanceof Geometry)) break block2;
                        geometry = geometry2 = (Geometry)object;
                        break block3;
                    }
                    if (!(object instanceof String)) break block4;
                    String string2 = (String)object;
                    geometry = WKTUtils$.MODULE$.read(string2);
                }
                return geometry;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid geometry conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)args).toList()})));
        }
    });
    private final TransformerFn geometryCollectionParserFn = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"geometrycollection"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final Object apply(Object[] args) {
            block4: {
                GeometryCollection geometryCollection;
                block3: {
                    Object object;
                    block2: {
                        object = args[0];
                        if (!(object instanceof Geometry)) break block2;
                        Geometry geometry = (Geometry)object;
                        geometryCollection = (GeometryCollection)geometry;
                        break block3;
                    }
                    if (!(object instanceof String)) break block4;
                    String string2 = (String)object;
                    geometryCollection = WKTUtils$.MODULE$.read(string2);
                }
                return geometryCollection;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid geometrycollection conversion argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps((Object)args).toList()})));
        }
    });
    private final TransformerFn projectFromParserFn = new TransformerFn(this){
        private final ConcurrentHashMap<String, MathTransform> cache;
        private final Seq<String> names;

        public TransformerFn getInstance() {
            return TransformerFn$class.getInstance(this);
        }

        private ConcurrentHashMap<String, MathTransform> cache() {
            return this.cache;
        }

        public Seq<String> names() {
            return this.names;
        }

        public Object eval(Object[] args, EvaluationContext ctx) {
            String epsg = (String)args[0];
            Geometry geom = (Geometry)args[1];
            boolean lenient = args.length > 2 ? Boolean.parseBoolean(args[2].toString()) : true;
            MathTransform transform = (MathTransform)JavaConversions$.MODULE$.mapAsScalaConcurrentMap(this.cache()).getOrElseUpdate((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{epsg, BoxesRunTime.boxToBoolean((boolean)lenient)})), (Function0)new Serializable(this, epsg, lenient){
                public static final long serialVersionUID = 0L;
                private final String epsg$1;
                private final boolean lenient$1;

                public final MathTransform apply() {
                    return CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)this.epsg$1), (CoordinateReferenceSystem)package$.MODULE$.CRS_EPSG_4326(), (boolean)this.lenient$1);
                }
                {
                    this.epsg$1 = epsg$1;
                    this.lenient$1 = lenient$1;
                }
            });
            return JTS.transform((Geometry)geom, (MathTransform)transform);
        }
        {
            TransformerFn$class.$init$(this);
            this.cache = new ConcurrentHashMap<K, V>();
            this.names = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"projectFrom"}));
        }
    };

    public Seq<Object> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFn[]{this.pointParserFn(), this.multiPointParserFn(), this.lineStringParserFn(), this.multiLineStringParserFn(), this.polygonParserFn(), this.multiPolygonParserFn(), this.geometryParserFn(), this.geometryCollectionParserFn(), this.projectFromParserFn()}));
    }

    public GeometryFactory org$locationtech$geomesa$convert$GeometryFunctionFactory$$gf() {
        return this.org$locationtech$geomesa$convert$GeometryFunctionFactory$$gf;
    }

    public TransformerFn pointParserFn() {
        return this.pointParserFn;
    }

    public TransformerFn multiPointParserFn() {
        return this.multiPointParserFn;
    }

    public TransformerFn lineStringParserFn() {
        return this.lineStringParserFn;
    }

    public TransformerFn multiLineStringParserFn() {
        return this.multiLineStringParserFn;
    }

    public TransformerFn polygonParserFn() {
        return this.polygonParserFn;
    }

    public TransformerFn multiPolygonParserFn() {
        return this.multiPolygonParserFn;
    }

    public TransformerFn geometryParserFn() {
        return this.geometryParserFn;
    }

    public TransformerFn geometryCollectionParserFn() {
        return this.geometryCollectionParserFn;
    }

    public TransformerFn projectFromParserFn() {
        return this.projectFromParserFn;
    }
}

